/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.message;

import java.text.MessageFormat;
import java.util.HashMap;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcWordUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageProcessInterface;

public class SJcMessageHandle
implements SJcMessageHandleInterface {
    private SJcMessageProcessInterface system;
    private String venderID;
    private String langType;
    private HashMap messageList = null;
    private HashMap behaviorList = null;
    private HashMap iconIDList = null;
    private HashMap measuresMessageList = null;
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger();

    @Override
    public void initialize(String venderID, String langType, SJcMessageProcessInterface system) {
        this.stdLogger.trace("Message", "SJcMessageHandle", "initialize", "start");
        this.system = system;
        this.langType = langType;
        this.venderID = venderID;
        this.messageList = system.getMessageList(venderID, langType);
        this.behaviorList = system.getBehaviorList(venderID, langType);
        this.iconIDList = system.getIconIDList(venderID, langType);
        this.measuresMessageList = system.getMeasuresMessageList(venderID, langType);
        this.stdLogger.trace("Message", "SJcMessageHandle", "initialize", "end");
    }

    @Override
    public synchronized String getMessage(String functionID, String moduleID, String msgID) {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMessage", "start");
        String result = null;
        try {
            result = (String)this.messageList.get(functionID + "/" + moduleID + "/" + msgID);
        }
        catch (ClassCastException e) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getMessage", "catchClassCastException");
        }
        if (result == null) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getMessage", "Not Found. - Key:" + functionID + "/" + moduleID + "/" + msgID);
            result = "No Message";
        }
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMessage", "end");
        return result;
    }

    @Override
    public synchronized String getMessage(String functionID, String moduleID, String msgID, String[] argument) {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMessage(argument)", "start");
        String result = (String)this.messageList.get(functionID + "/" + moduleID + "/" + msgID);
        String message = null;
        if (result != null) {
            this.stdLogger.trace("Message", "SJcMessageHandle", "getMessage(argument)", "result != null");
            MessageFormat format = new MessageFormat(result);
            Object[] parameters = this.getGuidanceArr(argument);
            message = format.format(parameters);
        }
        if (message == null) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getMessage", "Not Found. - Key:" + functionID + "/" + moduleID + "/" + msgID);
            message = "No Message";
        }
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMessage(argument)", "end");
        return message;
    }

    @Override
    public HashMap getMessageList() {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMessageList", "start");
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMessageList", "end");
        return this.messageList;
    }

    @Override
    public synchronized String getBehavior(String functionID, String moduleID, String msgID) {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getBehavior", "start");
        String result = null;
        try {
            result = (String)this.behaviorList.get(functionID + "/" + moduleID + "/" + msgID);
        }
        catch (ClassCastException e) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getBehavior", "catchClassCastException");
        }
        if (result == null) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getBehavior", "Not Found. - Key:" + functionID + "/" + moduleID + "/" + msgID);
            result = "0";
        }
        this.stdLogger.trace("Message", "SJcMessageHandle", "getBehavior", "end");
        return result;
    }

    @Override
    public HashMap getBehaviorList() {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getBehaviorList", "start");
        this.stdLogger.trace("Message", "SJcMessageHandle", "getBehaviorList", "end");
        return this.behaviorList;
    }

    @Override
    public synchronized String getIconID(String functionID, String moduleID, String msgID) {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getIconID", "start");
        String result = null;
        try {
            result = (String)this.iconIDList.get(functionID + "/" + moduleID + "/" + msgID);
        }
        catch (ClassCastException e) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getIconID", "catchClassCastException");
        }
        if (result == null) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getIconID", "Not Found. - Key:" + functionID + "/" + moduleID + "/" + msgID);
            result = "INFORMATION";
        }
        this.stdLogger.trace("Message", "SJcMessageHandle", "getIconID", "end");
        return result;
    }

    @Override
    public HashMap getIconIDList() {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getIconIDList", "start");
        this.stdLogger.trace("Message", "SJcMessageHandle", "getIconIDList", "end");
        return this.iconIDList;
    }

    @Override
    public synchronized String getMeasuresMessage(String functionID, String moduleID, String msgID) {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMeasuresMessage", "start");
        String result = null;
        try {
            result = (String)this.measuresMessageList.get(functionID + "/" + moduleID + "/" + msgID);
        }
        catch (ClassCastException e) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getMeasuresMessage", "catchClassCastException");
        }
        if (result == null) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getMeasuresMessage", "Not Found. - Key:" + functionID + "/" + moduleID + "/" + msgID);
            result = "No Message";
        }
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMeasuresMessage", "end");
        return result;
    }

    @Override
    public synchronized String getMeasuresMessage(String functionID, String moduleID, String msgID, String[] argument) {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMeasuresMessage(argument)", "start");
        String result = (String)this.measuresMessageList.get(functionID + "/" + moduleID + "/" + msgID);
        String message = null;
        if (result != null) {
            this.stdLogger.trace("Message", "SJcMessageHandle", "getMeasuresMessage(argument)", "result != null");
            MessageFormat format = new MessageFormat(result);
            Object[] parameters = this.getGuidanceArr(argument);
            message = format.format(parameters);
        }
        if (message == null) {
            this.stdLogger.error("Message", "SJcMessageHandle", "getMeasuresMessage(argument)", "Not Found. - Key:" + functionID + "/" + moduleID + "/" + msgID);
            message = "No Message";
        }
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMeasuresMessage(argument)", "end");
        return message;
    }

    @Override
    public HashMap getMeasuresMessageList() {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMeasuresMessageList", "start");
        this.stdLogger.trace("Message", "SJcMessageHandle", "getMeasuresMessageList", "end");
        return this.measuresMessageList;
    }

    private String[] getGuidanceArr(String[] argument) {
        this.stdLogger.trace("Message", "SJcMessageHandle", "getGuidanceArr", "start");
        String[] guidArr = new String[argument.length];
        SJcGuidanceHandleInterface guidanceIF = SJcWordUty.getGuidanceInfo(this.langType);
        HashMap guidanceList = guidanceIF.getGuidanceList();
        for (int i = 0; i < argument.length; ++i) {
            String guid = (String)guidanceList.get(argument[i]);
            if (null == guid) {
                this.stdLogger.trace("Message", "SJcMessageHandle", "getGuidanceArr", "Not Found. - Key:" + argument[i]);
                guidArr[i] = argument[i];
                continue;
            }
            guidArr[i] = guid;
        }
        this.stdLogger.trace("Message", "SJcMessageHandle", "getGuidanceArr", "end");
        return guidArr;
    }
}

