/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.serverux.data.ChangeDataString;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.controller.com.comparator.SJctrFreeIndexComparator;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.com.SJctrSSIDDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrFreeDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrFreeErrorData;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.group.SJmoPoolTieringPolicy;
import sanproject.sn2.model.data.group.SJmoPoolTieringPolicyIndex;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.model.data.volume.SJmoThinProvisioningVolumesStatus;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;
import sanproject.sn2.model.data.volume.SJmoVdevLdevInfo;

public class SJctrComCVSUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public static final int GAIBU_RAIDLEVEL = 0;
    public static final int VVOL_RAIDLEVEL = 1;
    public static final int SLOT_OPENV = 64;
    public static final long MIN_OPEN_OPENV = 96000L;
    public static final long MIN_OPEN_NOT_OPENV = 72000L;
    public static final int DRIVETYPE_SAS = 32768;
    public static final int DRIVETYPE_SATA = 16384;
    public static final int DRIVETYPE_SSD = 8192;
    public static final int DRIVETYPE_EXTERNAL = 2048;
    public static final int DRIVETYPE_EXTERNAL_HIGH = 1024;
    public static final int DRIVETYPE_EXTERNAL_LOW = 512;
    public static final int DRIVERPM_10000 = 128;
    public static final int DRIVERPM_15000 = 64;
    public static final int DRIVERPM_7200 = 32;
    public static final String GUID_SAS = "SAS";
    public static final String GUID_SATA = "SATA";
    public static final String GUID_SSD = "SSD";
    public static final String GUID_MIXED = "MIXED";
    public static final String GUID_EXTARNAL_HIGH = "EXT_STORAGE_HIGH";
    public static final String GUID_EXTARNAL_MID = "EXT_STORAGE_MID";
    public static final String GUID_EXTARNAL_LOW = "EXT_STORAGE_LOW";
    public static final String STRING_10K = "10K";
    public static final String STRING_15K = "15K";
    public static final String STRING_7_2K = "7.2K";
    public static final int RAIDLV_1_2D2D = 32768;
    public static final int RAIDLV_1_4D4D = 16384;
    public static final int RAIDLV_5_3D1P = 2048;
    public static final int RAIDLV_5_7D1P = 1024;
    public static final int RAIDLV_6_6D2P = 128;
    public static final int RAIDLV_6_14D2P = 64;
    public static final int RAIDLV_EXT = 8;
    public static final int RAIDLV_5_4D1P = 512;
    public static final int RAIDLV_5_6D1P = 256;
    public static final int RAIDLV_6_12D2P = 16;
    public static final String STRING_1_2D2D = "1(2D+2D)";
    public static final String STRING_1_4D4D = "1(4D+4D)";
    public static final String STRING_5_3D1P = "5(3D+1P)";
    public static final String STRING_5_7D1P = "5(7D+1P)";
    public static final String STRING_6_6D2P = "6(6D+2P)";
    public static final String STRING_6_14D2P = "6(14D+2P)";
    public static final String STRING_5_4D1P = "5(4D+1P)";
    public static final String STRING_5_5D1P = "5(5D+1P)";
    public static final String STRING_5_6D1P = "5(6D+1P)";
    public static final String STRING_5_8D1P = "5(8D+1P)";
    public static final String STRING_6_8D2P = "6(8D+2P)";
    public static final String STRING_6_10D2P = "6(10D+2P)";
    public static final String STRING_6_12D2P = "6(12D+2P)";
    public static final String STRING_5_2D1P = "5(2D+1P)";
    public static final String STRING_6_4D2P = "6(4D+2P)";
    public static final int[] INT_RAIDLEVEL = new int[]{0, 8194, 8197, 8198, 8199, 8200, 8196, 8201, 8202, 8203, 8204, 8205, 8206, 8207, 8208};
    public static final int BASIC_VOLUME = 0;
    public static final int EXTERNAL_VOLUME = 1;
    public static final int QS_VOLUME = 2;
    public static final int HDP_VOLUME = 3;
    public static final int FICONDM_VOLUME = 4;
    public static final int ALU_VOLUME = 5;
    public static final long CVDEVLBA_3TB = 0x180000000L;
    public static final long CVDEVLBA_4TB = 0x200000000L;
    public static final int MIN_EXTERNALID = 101;
    public static final int MAX_EXTERNALID = 16484;
    public static final short SHORT_TIERALL = 0;
    public static final short SHORT_TIERLV1 = 1;
    public static final short SHORT_TIERLV2 = 2;
    public static final short SHORT_TIERLV3 = 3;
    public static final short SHORT_TIERLV4 = 4;
    public static final short SHORT_TIERLV5 = 5;
    public static final int INT_PBTSM = 64;
    public static final int INT_NONTIERREL = 128;
    public static final short SHORT_MIDDLE = 0;
    public static final short SHORT_HIGH = 1;
    public static final short SHORT_LOW = 2;
    public static final short RELPRIO_DEF = 0;
    public static final short RELPRIO_PRIORITIZE = 1;
    public static final String STR_14D2P = "14D+2P";
    public static final String STR_4D1P = "4D+1P";
    public static final String STR_5D1P = "5D+1P";
    public static final String STR_6D1P = "6D+1P";
    public static final String STR_8D1P = "8D+1P";
    public static final String STR_8D2P = "8D+2P";
    public static final String STR_10D2P = "10D+2P";
    public static final String STR_12D2P = "12D+2P";
    public static final String STR_2D1P = "2D+1P";
    public static final String STR_4D2P = "4D+2P";
    public static int CTRL_CYL_6588_3 = 16;
    public static int CTRL_CYL_6588_9 = 25;
    public static int CTRL_CYL_6588_L = 23;
    public static int USER_MAX_6588_3 = 3436;
    public static int USER_MIN_6588_9 = 3437;
    public static int USER_MAX_6588_9 = 10017;
    public static int USER_MIN_6588_L = 10018;
    public static int TOTAL_MAX_6588_3 = USER_MAX_6588_3 + CTRL_CYL_6588_3;
    public static int TOTAL_MIN_6588_9 = USER_MIN_6588_9 + CTRL_CYL_6588_9;
    public static int TOTAL_MAX_6588_9 = USER_MAX_6588_9 + CTRL_CYL_6588_9;
    public static int TOTAL_MIN_6588_L = USER_MIN_6588_L + CTRL_CYL_6588_L;
    public static final long REC_FA_ON = 0x10000000L;
    public static final SJctrFreeIndexComparator FREE_COMPARATOR = new SJctrFreeIndexComparator();
    public static final String KEY_TABLE = "COM_TABLE";
    public static final int INT_EMUFLG_OPENV = 4;
    public static final String STR_SLASH = "/";
    public static final String INVALID_DISPLAY2 = "?/?";
    public static final int DRIVERPM_K = 1000;
    public static final String STR_DRIVERPM_K = "k";
    public static final int CHANGE_LBA_KB = 2;
    public static final String REQ_KEY_LDEV = "MNTcheckLdevs";
    public static final String REQ_KEY_PG = "MNTcheckParityGroups";
    public static final String REQ_KEY_DRIVE = "MNTcheckDrives";
    public static final int DEDUP_ENABLED = 1;
    public static final int DEDUP_DISABLED = 2;

    public SJctrComCVSUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public String getRAIDLevelName(int iRaidLevel) {
        String rtn = "-";
        if (iRaidLevel != 0 && iRaidLevel != 1) {
            rtn = this.dataChange.getRAIDLevelName(iRaidLevel);
        }
        return rtn;
    }

    public boolean isMainframe(String sEmu) {
        boolean rtn = false;
        if (this.getEmuFlg(sEmu) != 3) {
            rtn = true;
        }
        return rtn;
    }

    public boolean isSimpleMainframe(String sEmu) {
        boolean rtn = false;
        if (this.getEmuFlg(sEmu) == 1) {
            rtn = true;
        }
        return rtn;
    }

    public boolean isNewCGFormat(int iEmuType) {
        String sEmu;
        boolean rtn = false;
        if (this.isCGFormat(iEmuType) && !(sEmu = this.getEmulationTypeName(iEmuType)).equals("3390-A")) {
            rtn = true;
        }
        return rtn;
    }

    public boolean isOpen(String sEmu) {
        boolean rtn = false;
        if (this.getEmuFlg(sEmu) == 3) {
            rtn = true;
        }
        return rtn;
    }

    public String getEmulationTypeName(int iEmu) {
        return this.dataChange.getEmulationTypeName(iEmu);
    }

    public String[] getEmuTypeRestrict(String sBaseEmu) {
        int iBaseEmuType = 1;
        return this.dataChange.getEmuTypeRestrict(sBaseEmu, iBaseEmuType);
    }

    public int getEmuFlg(String sBaseEmu) {
        return this.dataChange.getEmuFlg(sBaseEmu);
    }

    public int getEmuFlgEx(String sBaseEmu) {
        int rtn = this.dataChange.getEmuFlg(sBaseEmu);
        if (sBaseEmu.equals("OPEN-V")) {
            rtn = 4;
        }
        return rtn;
    }

    public ChangeDataString[] getEmulationIDData() {
        return this.dataChange.getEmulationIDData();
    }

    public int getEmuSlotSize(String sEmu) {
        return this.dataChange.getEmuSlotSize(sEmu);
    }

    public int getControlCyl(String sEmu) {
        return this.dataChange.getControlCyl(sEmu);
    }

    public int getEmu(String strEmuType) {
        int rtn = 0;
        ChangeDataString[] wkEmu = this.dataChange.getEmulationIDData();
        for (int i = 0; i < wkEmu.length; ++i) {
            if (!wkEmu[i].strChangeData1.equals(strEmuType)) continue;
            rtn = wkEmu[i].nMibData;
        }
        return rtn;
    }

    public int getEmuTypeGroup(String sEmu) {
        int rtn = this.dataChange.getEmuGroup(sEmu);
        return rtn;
    }

    public long getMaxCapacity(int iEmuType) {
        long lMaxCapacity = 0L;
        String sEmu = this.getEmulationTypeName(iEmuType);
        lMaxCapacity = this.dataChange.getMaxCapacity(this.getEmulationTypeName(iEmuType));
        lMaxCapacity = this.isOpen(sEmu) ? (lMaxCapacity *= 2L) : lMaxCapacity * 15L * (long)this.getSlotSize(iEmuType) * 2L;
        return lMaxCapacity;
    }

    public int getSlotSize(int iEmuType) {
        int iSlotSize = 0;
        String sEmu = this.getEmulationTypeName(iEmuType);
        iSlotSize = this.getEmuSlotSize(sEmu);
        return iSlotSize;
    }

    public int getBoundary_HDP(int iEmuType, int iRaidLevel, boolean bEnhanced) {
        int iBoundary = 0;
        iBoundary = iRaidLevel == 1 ? 1 : (this.isCGFormat(iEmuType) ? (this.isNewCGFormat(iEmuType) ? 672 : 16800) : this.getBoundary(iEmuType, iRaidLevel, bEnhanced));
        return iBoundary;
    }

    public int getBoundary(int iEmuType, int iRaidLevel, boolean bEnhanced) {
        int iBoundary = 0;
        if (iRaidLevel == 0) {
            iBoundary = 1;
        } else {
            String RaidLevel = this.getRAIDLevelName(iRaidLevel);
            if (bEnhanced) {
                if (this.getEmulationTypeName(iEmuType).equals("OPEN-V")) {
                    if (RaidLevel.indexOf("2D+2D") != -1) {
                        iBoundary = 8;
                    } else if (RaidLevel.indexOf("3D+1P") != -1) {
                        iBoundary = 24;
                    } else if (RaidLevel.indexOf("7D+1P") != -1) {
                        iBoundary = 112;
                    } else if (RaidLevel.indexOf("6D+2P") != -1) {
                        iBoundary = 96;
                    } else if (RaidLevel.indexOf(STR_14D2P) != -1) {
                        iBoundary = 448;
                    }
                } else if (RaidLevel.indexOf("2D+2D") != -1) {
                    iBoundary = 32;
                } else if (RaidLevel.indexOf("3D+1P") != -1) {
                    iBoundary = 96;
                } else if (RaidLevel.indexOf("7D+1P") != -1) {
                    iBoundary = 448;
                } else if (RaidLevel.indexOf("6D+2P") != -1) {
                    iBoundary = 384;
                } else if (RaidLevel.indexOf(STR_14D2P) != -1) {
                    iBoundary = 1792;
                }
            } else if (this.getEmulationTypeName(iEmuType).equals("OPEN-V")) {
                if (RaidLevel.indexOf("2D+2D") != -1) {
                    iBoundary = 4;
                } else if (RaidLevel.indexOf("3D+1P") != -1) {
                    iBoundary = 6;
                } else if (RaidLevel.indexOf("7D+1P") != -1) {
                    iBoundary = 14;
                } else if (RaidLevel.indexOf("6D+2P") != -1) {
                    iBoundary = 12;
                } else if (RaidLevel.indexOf(STR_14D2P) != -1) {
                    iBoundary = 28;
                } else if (RaidLevel.indexOf(STR_2D1P) != -1) {
                    iBoundary = 4;
                } else if (RaidLevel.indexOf(STR_4D1P) != -1) {
                    iBoundary = 8;
                } else if (RaidLevel.indexOf(STR_5D1P) != -1) {
                    iBoundary = 10;
                } else if (RaidLevel.indexOf(STR_6D1P) != -1) {
                    iBoundary = 12;
                } else if (RaidLevel.indexOf(STR_8D1P) != -1) {
                    iBoundary = 16;
                } else if (RaidLevel.indexOf(STR_4D2P) != -1) {
                    iBoundary = 8;
                } else if (RaidLevel.indexOf(STR_8D2P) != -1) {
                    iBoundary = 16;
                } else if (RaidLevel.indexOf(STR_10D2P) != -1) {
                    iBoundary = 20;
                } else if (RaidLevel.indexOf(STR_12D2P) != -1) {
                    iBoundary = 24;
                }
            } else if (RaidLevel.indexOf("2D+2D") != -1) {
                iBoundary = 16;
            } else if (RaidLevel.indexOf("3D+1P") != -1) {
                iBoundary = 24;
            } else if (RaidLevel.indexOf("7D+1P") != -1) {
                iBoundary = 56;
            } else if (RaidLevel.indexOf("6D+2P") != -1) {
                iBoundary = 48;
            } else if (RaidLevel.indexOf(STR_14D2P) != -1) {
                iBoundary = 112;
            }
        }
        return iBoundary;
    }

    public int getCtlSize(int iEmuType, long lSize, long wkCtrlSize, boolean bSizeType) {
        int iCtrlSize = 0;
        String sEmu = this.getEmulationTypeName(iEmuType);
        iCtrlSize = this.getControlCyl(sEmu);
        if (this.isOpen(sEmu)) {
            iCtrlSize *= 2;
        } else if (sEmu.equals("6588-A")) {
            int wkCtrCyl = 1;
            if (bSizeType) {
                if (lSize <= (long)(USER_MAX_6588_3 * 15 * this.getSlotSize(iEmuType) * 2)) {
                    wkCtrCyl = CTRL_CYL_6588_3;
                } else if (lSize >= (long)(USER_MIN_6588_9 * 15 * this.getSlotSize(iEmuType) * 2) && lSize <= (long)(USER_MAX_6588_9 * 15 * this.getSlotSize(iEmuType) * 2)) {
                    wkCtrCyl = CTRL_CYL_6588_9;
                } else if (lSize >= (long)(USER_MIN_6588_L * 15 * this.getSlotSize(iEmuType) * 2)) {
                    wkCtrCyl = CTRL_CYL_6588_L;
                }
            } else if ((lSize -= wkCtrlSize) <= (long)(TOTAL_MAX_6588_3 * 15 * this.getSlotSize(iEmuType) * 2)) {
                wkCtrCyl = CTRL_CYL_6588_3;
            } else if (lSize >= (long)(TOTAL_MIN_6588_9 * 15 * this.getSlotSize(iEmuType) * 2) && lSize <= (long)(TOTAL_MAX_6588_9 * 15 * this.getSlotSize(iEmuType) * 2)) {
                wkCtrCyl = CTRL_CYL_6588_9;
            } else if (lSize >= (long)(TOTAL_MIN_6588_L * 15 * this.getSlotSize(iEmuType) * 2)) {
                wkCtrCyl = CTRL_CYL_6588_L;
            }
            iCtrlSize = wkCtrCyl * 15 * this.getSlotSize(iEmuType) * 2;
        } else {
            iCtrlSize = iCtrlSize * 15 * this.getSlotSize(iEmuType) * 2;
        }
        return iCtrlSize;
    }

    private long getCtlSize(long lSize, int iEmuType, boolean bSizeType) {
        long iCtrlSize = 0L;
        long wkSize = lSize;
        if (this.isCGFormat(iEmuType)) {
            int wkCyl = 0;
            if (bSizeType) {
                wkCyl = 1113;
                if (this.isNewCGFormat(iEmuType)) {
                    lSize += (long)this.getCtlSize(iEmuType, wkSize, iCtrlSize, bSizeType);
                }
            } else {
                wkCyl = 1120;
            }
            long wkCylLBA = wkCyl * this.getSlotSize(iEmuType) * 15 * 2;
            long wkCtrlCylNum = lSize / wkCylLBA;
            if (lSize % wkCylLBA > 0L) {
                ++wkCtrlCylNum;
            }
            iCtrlSize = wkCtrlCylNum * (long)(7 * this.getSlotSize(iEmuType) * 15 * 2);
            if (this.isNewCGFormat(iEmuType)) {
                iCtrlSize += (long)this.getCtlSize(iEmuType, wkSize, iCtrlSize, bSizeType);
            }
        } else {
            iCtrlSize = this.getCtlSize(iEmuType, wkSize, iCtrlSize, bSizeType);
        }
        return iCtrlSize;
    }

    public long[] getCapacity(Double lCap, String sType, int iEmuType, int iRaidLevel, boolean bEnhanced, boolean bOffset, boolean bHDP) {
        long[] lLBA = new long[3];
        String sEmu = this.getEmulationTypeName(iEmuType);
        lLBA[0] = this.getMAXLBA(lCap, sType, iEmuType, bOffset);
        lLBA[1] = this.chgSlot_LBA(lLBA[0], this.getSlotSize(iEmuType), iEmuType);
        long wkLDEVSize = lLBA[1] + this.getCtlSize(lLBA[1], iEmuType, true);
        long wkSlotNum = this.chgSlot_Slot(wkLDEVSize, this.getSlotSize(iEmuType));
        long wkBoundary = wkSlotNum / (long)this.getBoundary_HDP(iEmuType, iRaidLevel, bEnhanced);
        if (wkSlotNum % (long)this.getBoundary_HDP(iEmuType, iRaidLevel, bEnhanced) > 0L) {
            ++wkBoundary;
        }
        lLBA[2] = wkBoundary * (long)this.getBoundary_HDP(iEmuType, iRaidLevel, bEnhanced) * (long)this.getSlotSize(iEmuType) * 2L;
        if (bHDP && this.isOpen(this.getEmulationTypeName(iEmuType))) {
            long wkVMANum = lLBA[1] / 6442082304L;
            if (lLBA[1] % 6442082304L > 0L) {
                ++wkVMANum;
            }
            long wkVMASize = wkVMANum * 344064L;
            lLBA[2] = lLBA[1] + wkVMASize;
        }
        return lLBA;
    }

    public long getMAXLBA(Double lCap, String sType, int iEmuType, boolean bOffset) {
        long rtn = 0L;
        String sEmu = this.getEmulationTypeName(iEmuType);
        if (sType.equals("TB")) {
            Double wkCap1 = lCap * 1024.0 * 1024.0 * 1024.0 * 2.0;
            Long wkLCap = wkCap1.longValue();
            Double wkCap2 = wkLCap.doubleValue();
            if (wkCap1 % wkCap2 > 0.0) {
                wkLCap = wkLCap + 1L;
            }
            long wkLBA = wkLCap;
            rtn = this.getOffsetMaxLba(wkLBA, iEmuType, bOffset);
        } else if (sType.equals("GB")) {
            Double wkCap1 = lCap * 1024.0 * 1024.0 * 2.0;
            Long wkLCap = wkCap1.longValue();
            Double wkCap2 = wkLCap.doubleValue();
            if (wkCap1 % wkCap2 > 0.0) {
                wkLCap = wkLCap + 1L;
            }
            long wkLBA = wkLCap;
            rtn = this.getOffsetMaxLba(wkLBA, iEmuType, bOffset);
        } else if (sType.equals("MB")) {
            Double wkCap1 = lCap * 1024.0 * 2.0;
            Long wkLCap = wkCap1.longValue();
            Double wkCap2 = wkLCap.doubleValue();
            if (wkCap1 % wkCap2 > 0.0) {
                wkLCap = wkLCap + 1L;
            }
            long wkLBA = wkLCap;
            rtn = this.getOffsetMaxLba(wkLBA, iEmuType, bOffset);
        } else if (sType.equals("CYL")) {
            Long wkLCap = lCap.longValue();
            int wkSlot = this.getSlotSize(iEmuType);
            if (sEmu.equals("OPEN-V")) {
                wkSlot = 64;
            }
            rtn = wkLCap * (long)wkSlot * 15L * 2L;
            if (this.getEmulationTypeName(iEmuType).equals("3390-V")) {
                long wkNum = rtn / 77952L;
                if (rtn % 77952L > 0L) {
                    ++wkNum;
                }
                rtn = wkNum * 77952L;
            }
            if (this.getEmulationTypeName(iEmuType).equals("3390-A") && rtn > 114004800L) {
                long lSize = 33390 * wkSlot;
                long wkNum = rtn / lSize;
                if (rtn % lSize > 0L) {
                    ++wkNum;
                }
                rtn = wkNum * lSize;
            }
        } else {
            long wkLBA = lCap.longValue();
            rtn = this.getEmulationTypeName(iEmuType).equals("3390-V") && wkLBA == 77952L ? wkLBA : this.getOffsetMaxLba(wkLBA, iEmuType, bOffset);
        }
        return rtn;
    }

    private long getOffsetMaxLba(long lLBA, int iEmuType, boolean bOffset) {
        long rtn = lLBA;
        if (bOffset) {
            int wkSlot = this.getSlotSize(iEmuType);
            String sEmu = this.getEmulationTypeName(iEmuType);
            if (sEmu.equals("OPEN-V")) {
                wkSlot = 64;
            }
            rtn = this.chgSlot_LBA(rtn, wkSlot);
        }
        return rtn;
    }

    public long getVMASize(int iEmuType, int iRaidLevel) {
        long lVMASize = 0L;
        if (iRaidLevel == 0 || iRaidLevel == 1) {
            lVMASize = 1L;
        } else {
            String RaidLevel = this.getRAIDLevelName(iRaidLevel);
            if (this.getEmulationTypeName(iEmuType).equals("OPEN-V")) {
                if (RaidLevel.indexOf("2D+2D") != -1) {
                    lVMASize = 122880L;
                } else if (RaidLevel.indexOf("3D+1P") != -1) {
                    lVMASize = 552960L;
                } else if (RaidLevel.indexOf("7D+1P") != -1) {
                    lVMASize = 3010560L;
                } else if (RaidLevel.indexOf("6D+2P") != -1) {
                    lVMASize = 2211840L;
                } else if (RaidLevel.indexOf(STR_14D2P) != -1) {
                    lVMASize = 12042240L;
                }
            } else if (RaidLevel.indexOf("2D+2D") != -1) {
                lVMASize = 445440L;
            } else if (RaidLevel.indexOf("3D+1P") != -1) {
                lVMASize = 2004480L;
            } else if (RaidLevel.indexOf("7D+1P") != -1) {
                lVMASize = 10913280L;
            } else if (RaidLevel.indexOf("6D+2P") != -1) {
                lVMASize = 8017920L;
            } else if (RaidLevel.indexOf(STR_14D2P) != -1) {
                lVMASize = 43653120L;
            }
        }
        return lVMASize;
    }

    public long getRemUserSizeTse(long lFree, int iEmuType, int iRaidLevel, int iNum, boolean bEnhanced, boolean bTse) {
        long lCapacity = 0L;
        if (bTse) {
            long wkUserLBATse = 113526L * (long)this.getSlotSize(iEmuType) * 15L * 2L;
            long wkTotalLBATse = 114240L * (long)this.getSlotSize(iEmuType) * 15L * 2L;
            if (lFree <= wkTotalLBATse) {
                long lSize;
                long wkNum;
                lCapacity = lFree - (wkTotalLBATse - wkUserLBATse);
                if (lCapacity > 114004800L && (lCapacity = (wkNum = lCapacity / (lSize = (long)(1113 * this.getSlotSize(iEmuType) * 15 * 2))) * lSize) < 114004800L) {
                    lCapacity = 114004800L;
                }
            } else {
                lCapacity = this.getRemUserSize(lFree, iEmuType, iRaidLevel, iNum, bEnhanced);
            }
        } else if (this.isOpen(this.getEmulationTypeName(iEmuType))) {
            long wkVMANum = lFree / 6442426368L;
            if (lFree % 6442426368L > 0L) {
                ++wkVMANum;
            }
            long wkVMASize = wkVMANum * 344064L;
            lCapacity = lFree - wkVMASize;
            long wkCap = lCapacity / 2L;
            long wkSlot = wkCap / (long)this.getSlotSize(iEmuType);
            lCapacity = wkSlot * (long)this.getSlotSize(iEmuType) * 2L;
        } else {
            lCapacity = this.getRemUserSize(lFree, iEmuType, iRaidLevel, iNum, bEnhanced);
        }
        return lCapacity;
    }

    public long getRemUserSize(long lFree, int iEmuType, int iRaidLevel, int iNum, boolean bEnhanced) {
        long lSize;
        long wkNum;
        long lCapacity = 0L;
        long wkFree = lFree / (long)iNum;
        long wkKB = wkFree / 2L;
        long wkSlotNum = wkKB / (long)this.getSlotSize(iEmuType);
        if (bEnhanced) {
            long wkVMABound = wkSlotNum / (long)this.getBoundary(iEmuType, iRaidLevel, bEnhanced);
            wkSlotNum = wkVMABound * (long)this.getBoundary(iEmuType, iRaidLevel, bEnhanced);
            BigDecimal bd1 = new BigDecimal(this.getBoundary(iEmuType, iRaidLevel, bEnhanced));
            BigDecimal bd2 = new BigDecimal(this.getVMASize(iEmuType, iRaidLevel));
            BigDecimal bd3 = bd1.divide(bd2, 16, 1);
            double wkDecimal = 1.0 + bd3.doubleValue();
            BigDecimal bd4 = new BigDecimal(wkSlotNum);
            BigDecimal bd5 = new BigDecimal(wkDecimal);
            BigDecimal bd6 = bd4.divide(bd5, 100, 1);
            wkSlotNum = bd6.longValue();
        }
        long wkBound = wkSlotNum / (long)this.getBoundary_HDP(iEmuType, iRaidLevel, bEnhanced);
        long wkTotalLBA = wkBound * 2L * (long)this.getSlotSize(iEmuType) * (long)this.getBoundary_HDP(iEmuType, iRaidLevel, bEnhanced);
        long wkLDEVSize = wkTotalLBA - this.getCtlSize(wkTotalLBA, iEmuType, false);
        int wkSlot = this.getSlotSize(iEmuType);
        long wkHosei_KB = wkLDEVSize / 2L;
        long wkHosei_SL = wkHosei_KB / (long)wkSlot;
        if (!this.getEmulationTypeName(iEmuType).equals("OPEN-V") && !this.getEmulationTypeName(iEmuType).equals("3390-V")) {
            long wkHosei_15 = wkHosei_SL / 15L;
            wkHosei_SL = wkHosei_15 * 15L;
        }
        lCapacity = wkHosei_SL * 2L * (long)wkSlot;
        if (this.getEmulationTypeName(iEmuType).equals("3390-V")) {
            long wkNum2 = lCapacity / 77952L;
            lCapacity = wkNum2 * 77952L;
        }
        if (this.getEmulationTypeName(iEmuType).equals("3390-A") && lCapacity > 114004800L && (lCapacity = (wkNum = lCapacity / (lSize = (long)(1113 * wkSlot * 15 * 2))) * lSize) < 114004800L) {
            lCapacity = 114004800L;
        }
        if (this.getEmulationTypeName(iEmuType).equals("6588-A") && lCapacity > 57002400L) {
            lCapacity = 57002400L;
        }
        return lCapacity;
    }

    public long chgSlot_LBA(long wkLBA, int wkSlot, int iEmuType) {
        long rtn = 0L;
        long lSlot = this.chgSlot_Slot(wkLBA, wkSlot);
        if (!this.getEmulationTypeName(iEmuType).equals("OPEN-V") && !this.getEmulationTypeName(iEmuType).equals("3390-V")) {
            long lCyl = lSlot / 15L;
            if (lSlot % 15L > 0L) {
                ++lCyl;
            }
            lSlot = lCyl * 15L;
        }
        rtn = lSlot * (long)wkSlot * 2L;
        return rtn;
    }

    public long chgSlot_LBA(long wkLBA, int wkSlot) {
        long rtn = 0L;
        long lSlot = this.chgSlot_Slot(wkLBA, wkSlot);
        long lCyl = lSlot / 15L;
        if (lSlot % 15L > 0L) {
            ++lCyl;
        }
        rtn = lCyl * 15L * (long)wkSlot * 2L;
        return rtn;
    }

    public long chgSlot_Slot(long wkLBA, int wkSlot) {
        long rtn = 0L;
        long wkKB = wkLBA / 2L;
        if (wkLBA % 2L > 0L) {
            ++wkKB;
        }
        rtn = wkKB / (long)wkSlot;
        if (wkKB % (long)wkSlot > 0L) {
            ++rtn;
        }
        return rtn;
    }

    public int getMaxNum(List FreeList, String strEmuType) {
        int iEmuType = this.getEmu(strEmuType);
        int rtn = 2048;
        for (int i = 0; i < FreeList.size(); ++i) {
            String[] sEmu;
            SJctrFreeDetail free = (SJctrFreeDetail)FreeList.get(i);
            int iRaidLevel = free.getPGDetail().getRaidLevel();
            String sRaidLevel = this.getRAIDLevelName(iRaidLevel);
            int wkNum = this.getRemNumRaidLevel(iRaidLevel) - free.getPGDetail().getLDEVNum();
            if (wkNum == 0) {
                FreeList.remove(i);
                --i;
                continue;
            }
            if (rtn > wkNum) {
                rtn = wkNum;
            }
            if ((sEmu = this.getEmuTypeRestrict(strEmuType)) == null) {
                rtn = -1;
                break;
            }
            long wkCapNum = 0L;
            for (int iCntEmu = 0; iCntEmu < sEmu.length; ++iCntEmu) {
                long iMinLBA = this.getMinSizeVirtMode(sEmu[iCntEmu], free.getPGDetail().getBVirtMode());
                int iEmu = this.getEmu(sEmu[iCntEmu]);
                long[] cap = this.getCapacity(Double.parseDouble(Long.toString(iMinLBA)), "LBA", iEmu, iRaidLevel, free.getPGDetail().isEnhanced(), false, false);
                wkCapNum = free.getRemainingTotalLBA() / cap[2];
                if (wkCapNum > 0L) break;
            }
            if (wkCapNum == 0L) {
                FreeList.remove(i);
                --i;
                continue;
            }
            if ((long)rtn <= wkCapNum) continue;
            rtn = (int)wkCapNum;
        }
        if (FreeList.size() == 0) {
            rtn = 0;
        }
        return rtn;
    }

    public long getMinSizeVirtMode(String strEmuType, boolean bVirtMode) {
        long lMin = bVirtMode ? 0x1000000L : this.getMinSize(strEmuType);
        return lMin;
    }

    public long getMinSize(String strEmuType) {
        long lMin = 0L;
        int iEmuType = this.getEmu(strEmuType);
        if (strEmuType.equals("OPEN-V")) {
            lMin = 96000L;
        } else if (this.isOpen(strEmuType)) {
            lMin = 72000L;
        } else if (strEmuType.equals("3390-V")) {
            lMin = 77952L;
        } else {
            int wkSlot = this.getSlotSize(iEmuType);
            lMin = 1 * wkSlot * 15 * 2;
        }
        return lMin;
    }

    public void removeFreeList(List PGList) {
        for (int i = 0; i < PGList.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)PGList.get(i);
            ArrayList wkFreeList = pg.getAllFreeData();
            this.getMaxNum(wkFreeList, this.getEmulationTypeName(pg.getBaseEmulationType()));
        }
    }

    public int isPgScatteredInfo(SJmoPgIndex pg, List<SJmoPgScatteredInfo> PgScList) {
        int rtn = 0;
        for (int i = 0; i < PgScList.size(); ++i) {
            SJmoPgScatteredInfo pgSc = PgScList.get(i);
            if (pg.getFB4() == pgSc.getFB4() && pg.getPG() == pgSc.getPG()) {
                rtn = 1;
                break;
            }
            ArrayList pglist = pgSc.getAlPgIndex();
            for (int j = 0; j < pglist.size(); ++j) {
                SJmoPgIndex wkPgSc = (SJmoPgIndex)pglist.get(j);
                if (pg.getFB4() != wkPgSc.getFB4() || pg.getPG() != wkPgSc.getPG()) continue;
                rtn = 2;
                break;
            }
            if (rtn != 0) break;
        }
        return rtn;
    }

    public String toLdkcDisplay(SJmoSsidDetail ssiddetail) {
        StringBuilder buf = new StringBuilder();
        buf.append(SJctrComUtility.toHexString(ssiddetail.getLDKC(), 2, true));
        return buf.toString();
    }

    public String toCuDisplay(SJmoSsidDetail ssiddetail) {
        StringBuilder buf = new StringBuilder();
        buf.append(SJctrComUtility.toHexString(ssiddetail.getCU(), 2, true));
        return buf.toString();
    }

    public String toLdevBoundaryDisplay(SJmoSsidDetail ssiddetail) {
        String SEPARATOR = "-";
        StringBuilder buf = new StringBuilder();
        buf.append(SJctrComUtility.toHexString(ssiddetail.getStartLDEV(), 2, true));
        buf.append("-");
        buf.append(SJctrComUtility.toHexString(ssiddetail.getEndLDEV(), 2, true));
        return buf.toString();
    }

    public String toSsidDisplay(SJmoSsidDetail ssiddetail) {
        StringBuilder buf = new StringBuilder();
        if (ssiddetail.getSSID() != 0) {
            buf.append(SJctrComUtility.toHexString(ssiddetail.getSSID(), 4, true));
        } else {
            buf.append("");
        }
        return buf.toString();
    }

    public String toNewSSIDDisplay(SJctrSSIDDetail ssiddetail) {
        StringBuilder buf = new StringBuilder();
        buf.append(ssiddetail.getNewSSID());
        return buf.toString();
    }

    public String toEmuDisplay(SJmoPgDetail pgDetail) {
        String ret = "?";
        if (pgDetail != null) {
            ret = this.getEmulationTypeName(pgDetail.getBaseEmulationType());
        }
        return ret;
    }

    public String toDriveTypeDisplay(SJmoPoolDetail pool) {
        String NON_DATA;
        String strDriveType = NON_DATA = "?";
        int iDriveType = pool.getDriveAttribute();
        if ((iDriveType & 0x8000) == 32768) {
            strDriveType = this.guidanceHandle.getGuidance(GUID_SAS);
        }
        if ((iDriveType & 0x4000) == 16384) {
            strDriveType = !strDriveType.equals(NON_DATA) ? this.guidanceHandle.getGuidance(GUID_MIXED) : this.guidanceHandle.getGuidance(GUID_SATA);
        }
        if ((iDriveType & 0x2000) == 8192) {
            strDriveType = !strDriveType.equals(NON_DATA) ? this.guidanceHandle.getGuidance(GUID_MIXED) : this.guidanceHandle.getGuidance(GUID_SSD);
        }
        if ((iDriveType & 0x800) == 2048) {
            strDriveType = !strDriveType.equals(NON_DATA) ? this.guidanceHandle.getGuidance(GUID_MIXED) : this.guidanceHandle.getGuidance(GUID_EXTARNAL_MID);
        }
        if ((iDriveType & 0x200) == 512) {
            strDriveType = !strDriveType.equals(NON_DATA) ? this.guidanceHandle.getGuidance(GUID_MIXED) : this.guidanceHandle.getGuidance(GUID_EXTARNAL_LOW);
        }
        if ((iDriveType & 0x400) == 1024) {
            strDriveType = !strDriveType.equals(NON_DATA) ? this.guidanceHandle.getGuidance(GUID_MIXED) : this.guidanceHandle.getGuidance(GUID_EXTARNAL_HIGH);
        }
        String strPrm = "/-";
        if ((iDriveType & 0x80) == 128) {
            strPrm = "/10K";
        }
        if ((iDriveType & 0x40) == 64) {
            strPrm = !strPrm.equals("/-") ? this.guidanceHandle.getGuidance(GUID_MIXED) : "/15K";
        }
        if ((iDriveType & 0x20) == 32) {
            strPrm = !strPrm.equals("/-") ? this.guidanceHandle.getGuidance(GUID_MIXED) : "/7.2K";
        }
        String rtn = "";
        rtn = strDriveType.equals(this.guidanceHandle.getGuidance(GUID_MIXED)) || strPrm.equals(this.guidanceHandle.getGuidance(GUID_MIXED)) ? this.guidanceHandle.getGuidance(GUID_MIXED) : (strDriveType.equals(this.guidanceHandle.getGuidance(GUID_EXTARNAL_HIGH)) || strDriveType.equals(this.guidanceHandle.getGuidance(GUID_EXTARNAL_MID)) || strDriveType.equals(this.guidanceHandle.getGuidance(GUID_EXTARNAL_LOW)) ? strDriveType + "/-" : strDriveType + strPrm);
        return rtn;
    }

    public String toRaidLevelDisplay(SJmoPoolDetail pool) {
        String NO_DATA;
        String rtn = NO_DATA = "?(?)";
        int iRaidLevel = pool.getRaidLevel();
        rtn = this.getRaidLevelDisplay(iRaidLevel);
        return rtn;
    }

    String getRaidLevelDisplay(int iRaidLevel) {
        String NO_DATA;
        String rtn = NO_DATA = "?(?)";
        if ((iRaidLevel & 0x8000) == 32768) {
            rtn = rtn == NO_DATA ? STRING_1_2D2D : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        if ((iRaidLevel & 0x4000) == 16384) {
            rtn = rtn == NO_DATA ? STRING_1_4D4D : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        if ((iRaidLevel & 0x800) == 2048) {
            rtn = rtn == NO_DATA ? STRING_5_3D1P : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        if ((iRaidLevel & 0x400) == 1024) {
            rtn = rtn == NO_DATA ? STRING_5_7D1P : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        if ((iRaidLevel & 0x80) == 128) {
            rtn = rtn == NO_DATA ? STRING_6_6D2P : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        if ((iRaidLevel & 0x40) == 64) {
            rtn = rtn == NO_DATA ? STRING_6_14D2P : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        if ((iRaidLevel & 0x200) == 512) {
            rtn = rtn == NO_DATA ? STRING_5_4D1P : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        if ((iRaidLevel & 0x100) == 256) {
            rtn = rtn == NO_DATA ? STRING_5_6D1P : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        if ((iRaidLevel & 0x10) == 16) {
            rtn = rtn == NO_DATA ? STRING_6_12D2P : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        if ((iRaidLevel & 8) == 8) {
            rtn = rtn == NO_DATA ? "-" : this.guidanceHandle.getGuidance(GUID_MIXED);
        }
        return rtn;
    }

    public int getRaidLevel(String strRaidLevel) {
        int rtn = 0;
        if (strRaidLevel.equals(this.guidanceHandle.getGuidance(GUID_MIXED))) {
            rtn = -1;
        }
        for (int i = 0; i < INT_RAIDLEVEL.length; ++i) {
            if (!this.getRAIDLevelName(INT_RAIDLEVEL[i]).equals(strRaidLevel)) continue;
            rtn = INT_RAIDLEVEL[i];
        }
        return rtn;
    }

    public boolean chkLUPath(SJmoLdevDetail ldev, List LdevDetailList, List ldevLuseList) {
        boolean rtn = false;
        if (ldev.getILUPathNumber() > 0) {
            rtn = true;
        } else if (ldev.getByVolumeFlag() != 3) {
            rtn = true;
        } else if (ldev.getbPoolVol()) {
            rtn = true;
        } else if (ldev.getbJNLVolume()) {
            rtn = true;
        } else if (ldev.getbHIHSMReserve()) {
            rtn = true;
        } else if (ldev.getbSystemDisk()) {
            rtn = true;
        } else if (ldev.getBLockVolume()) {
            rtn = true;
        } else if (ldev.getSLUSEEmlCount() == 0 && LdevDetailList != null && ldevLuseList != null) {
            for (int i = 0; i < ldevLuseList.size(); ++i) {
                SJmoLdevDetail topLdevDetail;
                int topIndex;
                SJmoLdevLuseInfo luse = (SJmoLdevLuseInfo)ldevLuseList.get(i);
                ArrayList luseList = luse.getAlLUSELdevIndex();
                int menLdevIndex = Collections.binarySearch(luseList, ldev);
                if (menLdevIndex < 0 || (topIndex = Collections.binarySearch(LdevDetailList, luse)) < 0 || (topLdevDetail = (SJmoLdevDetail)LdevDetailList.get(topIndex)).getILUPathNumber() <= 0) continue;
                return true;
            }
        }
        return rtn;
    }

    public int getRemNumRaidLevel(int iRaidLevel) {
        String sRaidLevel = this.getRAIDLevelName(iRaidLevel);
        int rtn = 0;
        rtn = SJctrDataController.isHM() ? 2048 : (sRaidLevel.equals("-") ? 2048 : (sRaidLevel.indexOf("7D+1P") == -1 && sRaidLevel.indexOf("6D+2P") == -1 && sRaidLevel.indexOf(STR_14D2P) == -1 ? 1024 : 2048));
        return rtn;
    }

    public SJctrFreeErrorData getRemainingFreeListData(List wkFreeList) {
        ArrayList FreeList = new ArrayList();
        for (int i = 0; i < wkFreeList.size(); ++i) {
            FreeList.add(wkFreeList.get(i));
        }
        Collections.sort(FreeList, FREE_COMPARATOR);
        SJctrFreeErrorData rtn = new SJctrFreeErrorData();
        if (FreeList.size() > 0) {
            rtn.setRemainingNum(2048);
            SJctrFreeDetail Startfree = (SJctrFreeDetail)FreeList.get(0);
            SJctrPGDetail startPg = Startfree.getPGDetail();
            int iRem_PG = this.getRemNumRaidLevel(startPg.getRaidLevel()) - startPg.getLDEVNum();
            int iFreeNum = 0;
            ArrayList<SJctrFreeDetail> freeList = new ArrayList<SJctrFreeDetail>();
            for (int i = 0; i < FreeList.size(); ++i) {
                int wkRem;
                SJctrFreeDetail free = (SJctrFreeDetail)FreeList.get(i);
                SJctrPGDetail pg = free.getPGDetail();
                if (startPg.getFB4() == pg.getFB4() && startPg.getPG() == pg.getPG()) {
                    ++iFreeNum;
                    freeList.add(free);
                } else {
                    wkRem = iRem_PG / iFreeNum;
                    if (rtn.getRemainingNum() > wkRem) {
                        rtn.setRemainingNum(wkRem);
                    }
                    if (wkRem <= 0) {
                        rtn.addFreeErrorList(freeList);
                    }
                    Startfree = (SJctrFreeDetail)FreeList.get(i);
                    startPg = Startfree.getPGDetail();
                    iRem_PG = this.getRemNumRaidLevel(startPg.getRaidLevel()) - startPg.getLDEVNum();
                    iFreeNum = 1;
                    freeList = new ArrayList();
                    freeList.add(Startfree);
                }
                if (i != FreeList.size() - 1) continue;
                wkRem = iRem_PG / iFreeNum;
                if (rtn.getRemainingNum() > wkRem) {
                    rtn.setRemainingNum(wkRem);
                }
                if (wkRem > 0) continue;
                rtn.addFreeErrorList(freeList);
            }
        }
        return rtn;
    }

    public void removeRscPGList(ArrayList<SJctrPGDetail> PGArry) {
        for (SJctrPGDetail PGDetail : PGArry) {
            ArrayList FreeArry = PGDetail.getAllFreeData();
            this.removeRscVdevList(FreeArry);
        }
    }

    public int removeRscVdevList(ArrayList<SJctrFreeDetail> FreeArry) {
        for (int i = 0; i < FreeArry.size(); ++i) {
            SJctrFreeDetail FreeDetail = FreeArry.get(i);
            if (!this.chkRscVdevInfo(FreeDetail)) continue;
            FreeArry.remove(i);
            --i;
        }
        return FreeArry.size();
    }

    private boolean chkRscVdevInfo(SJctrFreeDetail FreeDetail) {
        boolean bResult = false;
        SJctrPGDetail PGDetail = FreeDetail.getPGDetail();
        ArrayList VdevDetailArry = PGDetail.getVDEVLDEVList();
        ArrayList RecVdevInfoArry = PGDetail.getRscVdevInfo();
        long lStartLba = FreeDetail.getVDEDVLDEVInf().getLStartLba();
        long lTotalLba = lStartLba + FreeDetail.getVDEDVLDEVInf().getLTotalLbaSize();
        for (SJmoVdevDetail Vdev : VdevDetailArry) {
            int index = Collections.binarySearch(RecVdevInfoArry, Vdev);
            if (index < 0) continue;
            SJmoVdevDetail VdevDetail = (SJmoVdevDetail)RecVdevInfoArry.get(index);
            ArrayList VdevLdevList = VdevDetail.getAlVdevLdev();
            for (SJmoVdevLdevInfo VdevLdev : VdevLdevList) {
                if (VdevLdev.getLStartLba() < lStartLba || VdevLdev.getLStartLba() > lTotalLba) continue;
                bResult = true;
                return bResult;
            }
        }
        return bResult;
    }

    public ArrayList getFilterFreeList(SJctrPGDetail pg, int iEmu) {
        ArrayList<SJctrFreeDetail> rtn = new ArrayList<SJctrFreeDetail>();
        for (int i = 0; i < pg.getAllFreeData().size(); ++i) {
            long wkMinSize;
            SJctrFreeDetail free = (SJctrFreeDetail)pg.getAllFreeData().get(i);
            long wkUserSize = this.getRemUserSize(free.getRemainingTotalLBA(), iEmu, pg.getRaidLevel(), 1, pg.isEnhanced());
            if (this.isExternal(free.getFB4()) && this.getEmulationTypeName(iEmu).equals("OPEN-V") && free.isBLastFlg()) {
                wkUserSize = free.getRemainingExternalTotalLBA();
            }
            if (wkUserSize < (wkMinSize = this.getMinSizeVirtMode(this.getEmulationTypeName(iEmu), pg.getBVirtMode()))) continue;
            rtn.add(free);
        }
        return rtn;
    }

    public boolean isExternal(int iFB4) {
        boolean rtn = false;
        if (iFB4 >= 101 && iFB4 <= 101) {
            rtn = true;
        }
        return rtn;
    }

    public String getTierLevelDisplay(SJmoLdevDetail ldev, SJmoHDPRelation hdp, ArrayList policyList) {
        int rtnNo = -1;
        String rtn = SJctrPoolUtility.HAIFUN_STR;
        if (ldev.getByVolumeType() == 3) {
            if (hdp == null) {
                return rtn;
            }
            if ((hdp.getITierControlFlag() & 0x40) != 0) {
                SJmoPoolTieringPolicyIndex policyIndex = new SJmoPoolTieringPolicyIndex();
                policyIndex.setPolicyId(hdp.getSTierLevel());
                rtnNo = Collections.binarySearch(policyList, policyIndex);
                if (rtnNo >= 0) {
                    SJmoPoolTieringPolicy policy = (SJmoPoolTieringPolicy)policyList.get(rtnNo);
                    String name = policy.getStrPolicyName();
                    short id = policy.getPolicyId();
                    rtn = SJctrPoolUtility.toTieringPolicyNameDisplay(id, name);
                } else {
                    rtn = "?";
                }
            }
        }
        return rtn;
    }

    public String getTierLevelDisplay(short sTierLevel) {
        String rtn = "-";
        switch (sTierLevel) {
            case 0: {
                rtn = this.guidanceHandle.getGuidance("TIERALL");
                break;
            }
            case 1: {
                rtn = this.guidanceHandle.getGuidance("TIERLV1");
                break;
            }
            case 2: {
                rtn = this.guidanceHandle.getGuidance("TIERLV2");
                break;
            }
            case 3: {
                rtn = this.guidanceHandle.getGuidance("TIERLV3");
                break;
            }
            case 4: {
                rtn = this.guidanceHandle.getGuidance("TIERLV4");
                break;
            }
            case 5: {
                rtn = this.guidanceHandle.getGuidance("TIERLV5");
            }
        }
        return rtn;
    }

    public short getTierLevel(String strTierLevel) {
        int rtn = -1;
        if (strTierLevel.equals(this.guidanceHandle.getGuidance("TIERALL"))) {
            rtn = 0;
        } else if (strTierLevel.equals(this.guidanceHandle.getGuidance("TIERLV1"))) {
            rtn = 1;
        } else if (strTierLevel.equals(this.guidanceHandle.getGuidance("TIERLV2"))) {
            rtn = 2;
        } else if (strTierLevel.equals(this.guidanceHandle.getGuidance("TIERLV3"))) {
            rtn = 3;
        } else if (strTierLevel.equals(this.guidanceHandle.getGuidance("TIERLV4"))) {
            rtn = 4;
        } else if (strTierLevel.equals(this.guidanceHandle.getGuidance("TIERLV5"))) {
            rtn = 5;
        }
        return (short)rtn;
    }

    public String getTseAttributeDisplay(SJmoLdevDetail ldev) {
        String rtn = "-";
        if (ldev.getbTseVol()) {
            rtn = this.guidanceHandle.getGuidance("TSE");
        }
        return rtn;
    }

    public static void setQSPoolData(List LDEVQsRelationList, List PoolNameList, ArrayList originLdevDtList) {
        if (LDEVQsRelationList != null && originLdevDtList != null) {
            for (int i = 0; i < originLdevDtList.size(); ++i) {
                int poolIndex;
                SJctrLDEVDetail LDEVInf = (SJctrLDEVDetail)originLdevDtList.get(i);
                int index_QS = Collections.binarySearch(LDEVQsRelationList, LDEVInf);
                if (index_QS < 0) continue;
                SJmoLocalReplicationPairVolInfo ldev_QS = (SJmoLocalReplicationPairVolInfo)LDEVQsRelationList.get(index_QS);
                if (!ldev_QS.isBCascade()) {
                    LDEVInf.setIRelationPoolID(ldev_QS.getISVolPoolId());
                }
                SJmoPoolIndex pool = new SJmoPoolIndex();
                pool.setPoolId(LDEVInf.getIRelationPoolID());
                if (PoolNameList == null || (poolIndex = Collections.binarySearch(PoolNameList, pool)) < 0) continue;
                SJmoPoolNameInfo poolNameInfo = (SJmoPoolNameInfo)PoolNameList.get(poolIndex);
                LDEVInf.setStrPoolName(poolNameInfo.getStrName());
            }
        }
    }

    public String getTierRelocationDisplay(SJmoLdevDetail ldev, SJmoHDPRelation hdp) {
        String rtn = "-";
        if (ldev.getByVolumeType() == 3) {
            if (hdp == null) {
                return rtn;
            }
            if ((hdp.getITierControlFlag() & 0x40) != 0) {
                rtn = (hdp.getITierControlFlag() & 0x80) != 0 ? this.guidanceHandle.getGuidance("DISABLED") : this.guidanceHandle.getGuidance("ENABLED");
            }
        }
        return rtn;
    }

    public String getNewPageAssignmentDisplay(SJmoLdevDetail ldev, SJmoHDPRelation hdp) {
        String rtn = "-";
        if (ldev.getByVolumeType() == 3) {
            if (hdp == null) {
                return rtn;
            }
            if ((hdp.getITierControlFlag() & 0x40) != 0) {
                rtn = this.getNewPageAssignmentDisplay(hdp.getsNewPageAssignmentTier());
            }
        }
        return rtn;
    }

    public String getNewPageAssignmentDisplay(short sNewPageAssignment) {
        String rtn = "-";
        switch (sNewPageAssignment) {
            case 0: {
                rtn = this.guidanceHandle.getGuidance("MIDDLE");
                break;
            }
            case 1: {
                rtn = this.guidanceHandle.getGuidance("HIGH");
                break;
            }
            case 2: {
                rtn = this.guidanceHandle.getGuidance("LOW");
            }
        }
        return rtn;
    }

    public String getRelocationPriorityDisplay(SJmoLdevDetail ldev, SJmoHDPRelation hdp) {
        String rtn = "-";
        if (ldev.getByVolumeType() == 3) {
            if (hdp == null) {
                return rtn;
            }
            if ((hdp.getITierControlFlag() & 0x40) != 0 && (hdp.getITierControlFlag() & 0x80) == 0) {
                rtn = this.getRelocationPriority2Display(hdp.getsRelocationPriority());
            }
        }
        return rtn;
    }

    public String getRelocationPriorityDisplay(short sRelocationPrio) {
        String rtn = "-";
        switch (sRelocationPrio) {
            case 0: {
                rtn = "";
                break;
            }
            case 1: {
                rtn = this.guidanceHandle.getGuidance("PRIORITIZE");
            }
        }
        return rtn;
    }

    public String getRelocationPriority2Display(short sRelocationPrio) {
        String rtn = "-";
        switch (sRelocationPrio) {
            case 0: {
                rtn = "";
                break;
            }
            case 1: {
                rtn = this.guidanceHandle.getGuidance("PRIORITIZED");
            }
        }
        return rtn;
    }

    public void chkPgEncTableInit(List<?> pgList, SJctrTableDataModel table) {
        table.setOpenVolumeFlg(false);
        table.setMainframeVolumeFlg(false);
        for (int i = 0; i < pgList.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)pgList.get(i);
            if (this.isOpen(this.getEmulationTypeName(pg.getBaseEmulationType()))) {
                table.setOpenVolumeFlg(true);
                continue;
            }
            table.setMainframeVolumeFlg(true);
        }
    }

    public static int getFormatLeadTime(List<SJctrLDEVDetail> LDEVList) {
        int rtn = 0;
        if (LDEVList != null && LDEVList.size() > 0) {
            long lSize = 0L;
            for (int i = 0; i < LDEVList.size(); ++i) {
                SJctrLDEVDetail detail = LDEVList.get(i);
                lSize += detail.getLLDEVLBASize();
            }
            long wkKB = lSize / 2L;
            if (lSize % 2L > 0L) {
                ++wkKB;
            }
            long wkMB = wkKB / 1024L;
            if (wkKB % 1024L > 0L) {
                ++wkMB;
            }
            long wkGB = wkMB / 1024L;
            if (wkMB % 1024L > 0L) {
                ++wkGB;
            }
            long wkTime = wkGB / 2L;
            if (wkGB % 2L > 0L) {
                ++wkTime;
            }
            if (wkTime > 500L) {
                wkTime = 500L;
            }
            rtn = (int)(wkTime * 60L);
        }
        if (rtn <= 0) {
            rtn = 1;
        }
        SJctrLogUty.error("[COM_CVS]", "getFormatLeadTime()", "TIME:" + rtn);
        return rtn;
    }

    public static int getPGFormatLeadTime(List<SJctrPGDetail> PGList) {
        int rtn = 0;
        if (PGList != null && PGList.size() > 0) {
            long lSize = 0L;
            for (int i = 0; i < PGList.size(); ++i) {
                SJctrPGDetail detail = PGList.get(i);
                lSize += detail.getPGLBASize();
            }
            long wkKB = lSize / 2L;
            if (lSize % 2L > 0L) {
                ++wkKB;
            }
            long wkMB = wkKB / 1024L;
            if (wkKB % 1024L > 0L) {
                ++wkMB;
            }
            long wkGB = wkMB / 1024L;
            if (wkMB % 1024L > 0L) {
                ++wkGB;
            }
            long wkTime = wkGB / 2L;
            if (wkGB % 2L > 0L) {
                ++wkTime;
            }
            if (wkTime > 500L) {
                wkTime = 500L;
            }
            rtn = (int)(wkTime * 60L);
        }
        if (rtn <= 0) {
            rtn = 1;
        }
        SJctrLogUty.error("[COM_CVS]", "getPGFormatLeadTime()", "TIME:" + rtn);
        return rtn;
    }

    public boolean isCGFormat(int iEmuType) {
        boolean rtn = false;
        String strEmu = this.getEmulationTypeName(iEmuType);
        if (this.isSimpleMainframe(strEmu) && !strEmu.equals("3390-V")) {
            rtn = true;
        }
        return rtn;
    }

    public static ArrayList<SJctrErrorColumnData> getLdevPgErrColumn(ArrayList<SJctrErrorColumnData> errColumnList, List<SJmoPgScatteredInfo> pgList, List ldevDtlList) {
        int i;
        ArrayList<SJctrErrorColumnData> rtn = new ArrayList();
        SJctrErrorColumnData errColumn = errColumnList.get(0);
        ArrayList<SJmoPgIndex> wkPgList = new ArrayList<SJmoPgIndex>();
        for (i = 0; i < errColumnList.size(); ++i) {
            SJmoLdevIndex errldev;
            int idx;
            if (!(errColumnList.get(i).getKeyObj() instanceof SJmoLdevIndex) || (idx = Collections.binarySearch(ldevDtlList, errldev = (SJmoLdevIndex)errColumnList.get(i).getKeyObj())) < 0) continue;
            SJmoLdevDetail ldev = (SJmoLdevDetail)ldevDtlList.get(idx);
            SJmoPgIndex pg = new SJmoPgIndex();
            pg.setFB4(ldev.getIFB4());
            pg.setPG(ldev.getIPG());
            SJmoPgIndex wkPg = SJctrComCVSUtility.getTopScatteredPG(pgList, pg);
            int idx_Pg = Collections.binarySearch(wkPgList, wkPg);
            if (idx_Pg >= 0) continue;
            wkPgList.add(wkPg);
            Collections.sort(wkPgList);
        }
        if (wkPgList.size() == 0) {
            rtn = errColumnList;
        } else {
            for (i = 0; i < wkPgList.size(); ++i) {
                SJctrErrorColumnData err = new SJctrErrorColumnData((Comparable)((SJmoPgIndex)wkPgList.get(i)), errColumn.getError());
                rtn.add(err);
            }
        }
        return rtn;
    }

    public static SJmoPgIndex getTopScatteredPG(List<SJmoPgScatteredInfo> pgList, SJmoPgIndex pg) {
        SJmoPgIndex rtn = pg;
        if (pgList != null && pgList.size() > 0) {
            int pgIndex = Collections.binarySearch(pgList, pg);
            if (pgIndex >= 0) {
                rtn = pg;
            }
            boolean bTarget = false;
            for (int i = 0; i < pgList.size(); ++i) {
                SJmoPgScatteredInfo scPg = pgList.get(i);
                ArrayList pgSet = scPg.getAlPgIndex();
                for (int j = 0; j < pgSet.size(); ++j) {
                    SJmoPgIndex wkPg = (SJmoPgIndex)pgSet.get(j);
                    if (wkPg.getFB4() != pg.getFB4() || wkPg.getPG() != pg.getPG()) continue;
                    rtn = scPg;
                    bTarget = true;
                    break;
                }
                if (bTarget) break;
            }
        }
        return rtn;
    }

    public static boolean isParentPG(SJctrWizardWindowDC wiz) {
        SJctrTableDataModel table;
        boolean rtn = false;
        if (wiz != null && (table = (SJctrTableDataModel)wiz.getParentDC().getDataObjectModel(KEY_TABLE)).getPrimaryColumn().equals("COM_COL_ARYGRP")) {
            rtn = true;
        }
        return rtn;
    }

    public String toLDEVDriveTypeRPMDisplay(SJmoLdevDetail ldev, List<SJmoPgDetail> pgList, List<SJmoPoolDetail> poolList, List<SJmoHDPRelation> hdpVolList) {
        String strRet = INVALID_DISPLAY2;
        if (ldev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toLDEVDriveTypeRPMDisplay ", "LDEV Detail = null");
            return strRet;
        }
        switch (ldev.getByVolumeType()) {
            case 0: {
                strRet = this.toInternalVolDriveTypeRPMDisplay(ldev, pgList);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                strRet = "-";
                break;
            }
            case 3: {
                strRet = this.toDPVolDriveTypeRPMDisplay(ldev, poolList, hdpVolList);
                break;
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toLDEVDriveTypeRPMDisplay", "VolType invalid:" + ldev.getByVolumeType());
            }
        }
        return strRet;
    }

    private String toInternalVolDriveTypeRPMDisplay(SJmoLdevDetail ldev, List<SJmoPgDetail> pgList) {
        String strDriveRpmRet = INVALID_DISPLAY2;
        if (ldev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toInternalVolDriveTypeRPMDisplay", "LDEV Detail = null");
            return strDriveRpmRet;
        }
        if (pgList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toInternalVolDriveTypeRPMDisplay", "PGDetail List = null");
            return strDriveRpmRet;
        }
        int index = Collections.binarySearch(pgList, ldev, new SJctrArrayGroupIndexComparator());
        if (index < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toInternalVolDriveTypeRPMDisplay", "PGDetail nothing");
            return strDriveRpmRet;
        }
        SJmoPgDetail pgDtl = pgList.get(index);
        strDriveRpmRet = this.toInternalPGDriveTypeRPMDisplay(pgDtl);
        return strDriveRpmRet;
    }

    private String toInternalPGDriveTypeRPMDisplay(SJmoPgDetail pgDtl) {
        StringBuffer strDrive = new StringBuffer();
        if (pgDtl == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toInternalPGDriveTypeRPMDisplay", "PG Detail = null");
            return strDrive.append(INVALID_DISPLAY2).toString();
        }
        switch (pgDtl.getDriveType()) {
            case 0: {
                strDrive.append(this.guidanceHandle.getGuidance(GUID_SAS));
                strDrive.append(STR_SLASH);
                strDrive.append(this.toHDDRPMDisplay(pgDtl.getHDDrpm()));
                break;
            }
            case 1: {
                strDrive.append(this.guidanceHandle.getGuidance(GUID_SATA));
                strDrive.append(STR_SLASH);
                strDrive.append(this.toHDDRPMDisplay(pgDtl.getHDDrpm()));
                break;
            }
            case 5: 
            case 9: {
                strDrive.append(this.guidanceHandle.getGuidance(GUID_SSD));
                break;
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toInternalPGDriveTypeRPMDisplay", "DriveType invalid:" + pgDtl.getDriveType());
                strDrive.append(INVALID_DISPLAY2);
            }
        }
        return strDrive.toString();
    }

    private String toHDDRPMDisplay(int iHDDRpmValue) {
        StringBuffer strHddRpm = new StringBuffer();
        if (iHDDRpmValue == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toHDDRPMDisplay", "iHDDRpmValue = " + iHDDRpmValue);
            return strHddRpm.append("?").toString();
        }
        if (iHDDRpmValue % 1000 != 0) {
            strHddRpm.append((double)iHDDRpmValue / 1000.0);
        } else {
            strHddRpm.append(iHDDRpmValue / 1000);
        }
        strHddRpm.append(STR_DRIVERPM_K);
        return strHddRpm.toString();
    }

    private String toDPVolDriveTypeRPMDisplay(SJmoLdevDetail ldev, List<SJmoPoolDetail> poolList, List<SJmoHDPRelation> hdpVolList) {
        String strRet = "?";
        if (ldev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDPVolDriveTypeRPMDisplay", "LDEV Detail = null");
            return strRet;
        }
        if (poolList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDPVolDriveTypeRPMDisplay", "Pool List = null");
            return strRet;
        }
        if (hdpVolList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDPVolDriveTypeRPMDisplay", "DPVol List = null");
            return strRet;
        }
        int ihdpIndex = Collections.binarySearch(hdpVolList, ldev);
        if (ihdpIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDPVolDriveTypeRPMDisplay", "HDP Info nothing");
            return strRet;
        }
        SJmoHDPRelation dpVol = hdpVolList.get(ihdpIndex);
        SJmoPoolIndex compPoolIdx = new SJmoPoolIndex();
        compPoolIdx.setPoolId(dpVol.getIPoolId());
        int iPoolIndex = Collections.binarySearch(poolList, compPoolIdx);
        if (iPoolIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDPVolDriveTypeRPMDisplay", "Pool Dtl nothing");
            return strRet;
        }
        SJmoPoolDetail poolDtl = poolList.get(iPoolIndex);
        strRet = this.toDriveTypeDisplay(poolDtl);
        return strRet;
    }

    public static long getAddLdevPages(SJmoLdevDetail ldev, long lPageSize, SJctrComUtility comUtil, boolean bCeil) {
        long pageSizeBlock = comUtil.getCapacityUtility().valueOf(lPageSize, SJctrCapacityUtility.UNIT.KB);
        double dLdevUsedPgae = (double)ldev.getLLDEVLBASize() / (double)pageSizeBlock;
        dLdevUsedPgae = bCeil ? Math.ceil(dLdevUsedPgae) : Math.floor(dLdevUsedPgae);
        return (long)dLdevUsedPgae;
    }

    public String getFullAllocationDisplay(SJmoLdevDetail ldev, SJmoHDPRelation hdp) {
        String rtn = "?";
        if (ldev != null) {
            rtn = "-";
            if (hdp != null && ldev.getbAouVvol()) {
                if (ldev.getIEmulationType() == 32922) {
                    return rtn;
                }
                rtn = (hdp.getLSwapControlFlg() & 0x10000000L) != 0L ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
            }
        }
        return rtn;
    }

    public String getALUAModeDisplay(SJmoLdevDetail ldev) {
        String rtn = "?";
        if (ldev != null) {
            rtn = "-";
            if (ldev.getByVolumeFlag() != 1) {
                rtn = this.guidanceHandle.getGuidance("DISABLED");
                if (ldev.getBAluaMode()) {
                    rtn = this.guidanceHandle.getGuidance("ENABLED");
                }
            }
        }
        return rtn;
    }

    public static ArrayList chkLdevList(SJctrDataController dc, List ldevList, int iOperation) {
        SJctrLogUty.info("[FORCIBLY]", "chkLdevList()", "Start");
        ArrayList<int[]> list = new ArrayList<int[]>();
        if (ldevList.size() == 0) {
            return list;
        }
        for (int i = 0; i < ldevList.size(); ++i) {
            SJmoLdevIndex ldev = (SJmoLdevIndex)ldevList.get(i);
            int[] id = new int[]{ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev()};
            list.add(id);
        }
        SanRequest request = SJctrComCVSUtility.createRequestData(REQ_KEY_LDEV, "Ldevs", list);
        SJctrLogUty.info("[FORCIBLY]", "chkLdevList()", "End");
        return SJctrComCVSUtility.getChkForciblyError(dc, request, iOperation);
    }

    public static ArrayList chkPgList(SJctrDataController dc, List PgList, int iOperation) {
        SJctrLogUty.info("[FORCIBLY]", "chkPgList()", "Start");
        ArrayList<int[]> list = new ArrayList<int[]>();
        if (PgList.size() == 0) {
            return list;
        }
        for (int i = 0; i < PgList.size(); ++i) {
            SJmoPgIndex pgid = (SJmoPgIndex)PgList.get(i);
            int[] id = new int[]{pgid.getFB4(), pgid.getPG()};
            list.add(id);
        }
        SanRequest request = SJctrComCVSUtility.createRequestData(REQ_KEY_PG, "ParityGroups", list);
        SJctrLogUty.info("[FORCIBLY]", "chkPgList()", "End");
        return SJctrComCVSUtility.getChkForciblyError(dc, request, iOperation);
    }

    public static ArrayList chkDriveList(SJctrDataController dc, List<SJmoPdevDetail> allPdevList, int iOperation) {
        SJctrLogUty.info("[FORCIBLY]", "chkDriveList()", "Start");
        ArrayList<int[]> list = new ArrayList<int[]>();
        if (allPdevList.size() == 0) {
            return list;
        }
        for (SJmoPdevDetail pdev : allPdevList) {
            int[] id = new int[]{pdev.getCDEV(), pdev.getRDEV()};
            list.add(id);
        }
        SanRequest request = SJctrComCVSUtility.createRequestData(REQ_KEY_DRIVE, "Drives", list);
        SJctrLogUty.info("[FORCIBLY]", "chkDriveList()", "End");
        return SJctrComCVSUtility.getChkForciblyError(dc, request, iOperation);
    }

    private static SanRequest createRequestData(String newKey, String key, List List2) {
        SanRequest request = null;
        try {
            SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
            request = agent.newRequest(newKey);
            String strPrint = "";
            SanList repLdevList = request.newList(key);
            for (int i = 0; i < List2.size(); ++i) {
                SanObject Parameter2 = repLdevList.addObj();
                int[] id = (int[])List2.get(i);
                Parameter2.putIntArray("Id", id);
                strPrint = strPrint + SJctrComCVSUtility.showLog(id) + ":";
            }
            SJctrLogUty.info("[FORCIBLY]", "createRequestData()", strPrint);
        }
        catch (SanDataException ex) {
            SJctrLogUty.error("[FORCIBLY]", "createRequestData()", "SanDataException");
            SJctrLdevUtility.SJctrErrorDialog(105171);
        }
        return request;
    }

    private static String showLog(int[] iData) {
        String strPrint = "";
        for (int i = 0; i < iData.length; ++i) {
            strPrint = strPrint + iData[i] + ",";
        }
        return strPrint;
    }

    public static boolean chkMsg(SJctrComUtility comUty, SJctrError err, List<?> errList) {
        boolean rtn = true;
        String strMsg = SJctrComCVSUtility.getToDispMessage(comUty, true, err);
        String strMesuars = SJctrComCVSUtility.getToDispMessage(comUty, false, err);
        for (int i = 0; i < errList.size(); ++i) {
            SJctrError err2 = (SJctrError)errList.get(i);
            String strMsg2 = SJctrComCVSUtility.getToDispMessage(comUty, true, err2);
            String strMesuars2 = SJctrComCVSUtility.getToDispMessage(comUty, false, err2);
            if (!strMsg.equals(strMsg2) || !strMesuars.equals(strMesuars2)) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    private static String getToDispMessage(SJctrComUtility comUty, boolean bMsg, SJctrError error) {
        String rtn = "";
        rtn = bMsg ? comUty.getCVSUtility().getMessageInf().getMessage(SJctrComUtility.toPaddingZeroString(error.getFunc(), 3), SJctrComUtility.toPaddingZeroString(error.getModule(), 2), Integer.toString(error.getError())) : comUty.getCVSUtility().getMessageInf().getMeasuresMessage(SJctrComUtility.toPaddingZeroString(error.getFunc(), 3), SJctrComUtility.toPaddingZeroString(error.getModule(), 2), Integer.toString(error.getError()));
        return rtn;
    }

    private static ArrayList getChkForciblyError(SJctrDataController dc, SanRequest request, int iOperation) {
        SJctrLogUty.info("[FORCIBLY]", "getChkForciblyError()", "[LOCKID=" + dc.getOwner().getLockId() + "][OPEID=" + iOperation + "]");
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        try {
            SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
            request.putInt("OperationCode", iOperation);
            SanResponse responseData = agent.getDataInf(request, true, dc.getOwner().getLockId());
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(responseData);
            if (errorInfo.hasLowerNodeError() || errorInfo.isOverAll()) {
                SJctrError error = errorInfo.createError();
                SJcException exp = error.createException();
                throw exp;
            }
            if (responseData.getMember("PreCheckResults") == null) {
                return new ArrayList();
            }
            SanList errList = responseData.getList("PreCheckResults");
            if (errList != null && errList.size() > 0) {
                SJctrError errMsg;
                int i;
                ArrayList<SJctrError> errorList = new ArrayList<SJctrError>();
                for (int i2 = 0; i2 < errList.size(); ++i2) {
                    SanObject errObj = errList.getObj(i2);
                    int[] messageId = errObj.getIntArray("MessageId");
                    int func = messageId[0] / 100;
                    int module = messageId[0] % 100;
                    int err = messageId[1];
                    errorList.add(new SJctrError(func, module, err));
                }
                ArrayList<SJctrError> wkErrList = new ArrayList<SJctrError>();
                for (i = 0; i < errorList.size(); ++i) {
                    errMsg = (SJctrError)errorList.get(i);
                    if (!SJctrComCVSUtility.chkMsg(dc.getComUtility(), errMsg, wkErrList)) continue;
                    wkErrList.add(errMsg);
                }
                for (i = 0; i < wkErrList.size(); ++i) {
                    errMsg = (SJctrError)wkErrList.get(i);
                    SJctrErrorColumnData errColumn = new SJctrErrorColumnData((Comparable)((Object)SJctrComCVSUtility.getErrKeyObj(dc.getComUtility(), errMsg)), errMsg);
                    errColumnList.add(errColumn);
                }
            }
        }
        catch (SanDataException ex) {
            SJctrLogUty.error("[FORCIBLY]", "getChkForciblyError()", "SanDataException");
            SJctrLdevUtility.SJctrErrorDialog(105171);
        }
        return errColumnList;
    }

    public SJcMessageHandleInterface getMessageInf() {
        return this.messageHandle;
    }

    public static String getErrKeyObj(SJctrComUtility comUty, SJctrError error) {
        int func = error.getFunc();
        int module = error.getModule();
        int msg = error.getMsg();
        StringBuilder sb = new StringBuilder();
        return SJctrComUtility.toPaddingZeroString(func, 3) + SJctrComUtility.toPaddingZeroString(module, 2) + SJctrComUtility.toPaddingZeroString(msg, 6);
    }

    public String toDataSavingDisplay(SJctrLDEVDetail ldev, boolean flg) {
        String rtn = "?";
        if (ldev != null) {
            rtn = "-";
            if (ldev.getByVolumeType() != 3) {
                return rtn;
            }
            if (ldev.getSDataSaving() == 0) {
                rtn = this.guidanceHandle.getGuidance("DISABLED");
            } else if (ldev.getSDataSaving() == 1) {
                rtn = this.guidanceHandle.getGuidance("COMPRESS");
            } else if (ldev.getSDataSaving() == 2) {
                rtn = this.guidanceHandle.getGuidance("DEDUPLICATION_AND_COMPRESSION");
            }
        }
        return rtn;
    }

    public String toDataSavingModeDisplay(SJctrLDEVDetail ldev) {
        String rtn = "?";
        if (ldev != null) {
            rtn = "-";
            if (ldev.getSDataSavingMode() == 0) {
                rtn = this.guidanceHandle.getGuidance("CAPACITY_PRIORITY");
            } else if (ldev.getSDataSavingMode() == 1) {
                rtn = this.guidanceHandle.getGuidance("PERFORMANCE_PRIORITY");
            }
        }
        return rtn;
    }

    public String toDeduplicationDataDisplay(SJctrLDEVDetail ldev) {
        if (ldev == null) {
            return "?";
        }
        if (ldev.getIDeduplicationData() == 1) {
            return this.guidanceHandle.getGuidance("ENABLED");
        }
        if (ldev.getIDeduplicationData() == 2) {
            return this.guidanceHandle.getGuidance("DISABLED");
        }
        return "-";
    }

    public static boolean isDRDVol(SJmoLdevDetail ldevDetail, List<SJmoHDPRelation> hdpRelationList, List<SJmoThinProvisioningVolumesStatus> dpVolStatusList) {
        boolean rtn = false;
        if (ldevDetail != null) {
            int dpVolStatusIndex;
            SJctrLDEVDetail ldev = new SJctrLDEVDetail();
            int relationIndex = Collections.binarySearch(hdpRelationList, ldevDetail);
            if (relationIndex >= 0) {
                SJmoHDPRelation hdpRelation = hdpRelationList.get(relationIndex);
                ldev.setRelationData(hdpRelation);
            }
            if ((dpVolStatusIndex = Collections.binarySearch(dpVolStatusList, ldevDetail)) >= 0) {
                SJmoThinProvisioningVolumesStatus dpVolStatus = dpVolStatusList.get(dpVolStatusIndex);
                ldev.setDPVolStatus(dpVolStatus);
            }
            if (ldevDetail.getByVolumeType() == 3 && (ldev.getSDataSaving() != 0 || ldev.getIDataSavingStatus() != 0)) {
                rtn = true;
            }
        }
        return rtn;
    }

    public static boolean chkPoolRlationDRD(List<SJmoPoolIndex> poolList, List<SJmoHDPRelationByPool> hdpRelationPoolList, List<SJmoHDPRelation> hdpRelationList, List<SJmoThinProvisioningVolumesStatus> dpVolStatusList, List<SJmoLdevDetail> ldevList) {
        boolean rtn = false;
        for (int i = 0; i < poolList.size(); ++i) {
            SJmoPoolIndex pool = poolList.get(i);
            int index = Collections.binarySearch(hdpRelationPoolList, pool);
            if (index < 0) continue;
            SJmoHDPRelationByPool poolRelation = hdpRelationPoolList.get(index);
            ArrayList hdpLdevList = poolRelation.getAlDPVOLInfo();
            for (int j = 0; j < hdpLdevList.size(); ++j) {
                SJmoLdevDetail ldevDetail;
                SJmoLdevIndex ldev = (SJmoLdevIndex)hdpLdevList.get(j);
                int ldevIndex = Collections.binarySearch(ldevList, ldev);
                if (ldevIndex < 0 || !SJctrComCVSUtility.isDRDVol(ldevDetail = ldevList.get(ldevIndex), hdpRelationList, dpVolStatusList)) continue;
                rtn = true;
            }
        }
        return rtn;
    }

    public static int getInitializeLeadTime(SJmoPoolDetail poolDtl) {
        long lPoolPages;
        int rtn = 0;
        long lPageSize = poolDtl.getPageSize();
        long lPoolCapa = lPageSize * (lPoolPages = poolDtl.getPoolPages());
        long poolCapacity = lPoolCapa / 1024L;
        rtn = (int)(poolCapacity / 120000L);
        if (rtn <= 0) {
            rtn = 1;
        }
        return rtn;
    }
}

