/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.io.Serializable;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;

public class SJctrError
implements Serializable {
    private static final long serialVersionUID = 5308299105552911595L;
    private int mFunc;
    private int mModule;
    private int mError;
    private String[] mMsgArgument = null;
    private String[] mMeansureArgument = null;
    @Deprecated
    public static final int FUNC_SN = 200;
    public static final int FUNC_SN2_CMN = 201;
    public static final int MODULE_CTR = 22;
    public static final int ERR_PRE = -1;
    public static final int ERR_NORMAL = 0;
    public static final int ERR_UNKNOWN = 106004;
    private static final int MSG_PRE = 109002;
    private static final int MSG_NORMAL = 109001;

    public SJctrError(int func, int module, int error) {
        this.mFunc = func;
        this.mModule = module;
        this.mError = error;
    }

    public int getFunc() {
        return this.mFunc;
    }

    public void setFunc(int func) {
        this.mFunc = func;
    }

    public int getModule() {
        return this.mModule;
    }

    public void setModule(int module) {
        this.mModule = module;
    }

    public int getError() {
        return this.mError;
    }

    public int getMsg() {
        return SJctrError.errorToMsg(this.mError);
    }

    public void setError(int error) {
        this.mError = error;
    }

    public String[] getMsgArgument() {
        return this.mMsgArgument;
    }

    public void setMsgArgument(String[] msgArgument) {
        this.mMsgArgument = msgArgument;
    }

    public String[] getMeansureArgument() {
        return this.mMeansureArgument;
    }

    public void setMeansureArgument(String[] meansureArgument) {
        this.mMeansureArgument = meansureArgument;
    }

    public SJcException createException() {
        String func = Integer.toString(this.mFunc);
        String module = Integer.toString(this.mModule);
        String msg = Integer.toString(SJctrError.errorToMsg(this.mError));
        SJcException result = new SJcException(func, module, msg, this.mMsgArgument, this.mMeansureArgument);
        return result;
    }

    public static SJctrError parseError(Exception exp) {
        SJctrError result;
        if (exp instanceof SJcException && ((SJcException)exp).getMsg() != null) {
            SJcException sjcExp = (SJcException)exp;
            SJcMessage message = sjcExp.getMsg();
            int func = Integer.valueOf(message.getFunctionID());
            int module = Integer.valueOf(message.getModuleID());
            int msg = Integer.valueOf(message.getMsgID());
            int error = SJctrError.msgToError(msg);
            result = new SJctrError(func, module, error);
            result.setMsgArgument(message.getMsg_argument());
            result.setMeansureArgument(message.getMeansure_argument());
        } else {
            result = new SJctrError(201, 22, 106004);
        }
        return result;
    }

    private static int errorToMsg(int error) {
        int result = error;
        switch (result) {
            case -1: {
                result = 109002;
                break;
            }
            case 0: {
                result = 109001;
            }
        }
        return result;
    }

    private static int msgToError(int msg) {
        int result = msg;
        switch (result) {
            case 109002: {
                result = -1;
                break;
            }
            case 109001: {
                result = 0;
            }
        }
        return result;
    }
}

