/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;

public class SJctrErrorDataController
extends SJctrDialogDataController {
    protected static final int DISP_ID = 0x3100001;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_CLOSE = "COM_CLOSE";
    public static final SJctrErrorColumnDataComparator DEFAULT_COMPARATOR = new SJctrErrorColumnDataComparator();
    public static final int ERR_GENERAL_INFOMATION1 = 106056;
    public static final int ERR_GENERAL_INFOMATION2 = 106057;
    public static final int ERR_GENERAL_INFOMATION3 = 106058;
    public static final int ERR_GENERAL_INFOMATION4 = 106059;
    public static final int ERR_GENERAL_INFOMATION5 = 106060;
    public static final int ERR_GENERAL_INFOMATION6 = 106061;
    public static final int ERR_GENERAL_INFOMATION7 = 106039;
    public static final int VIEW_ERR_LV1 = 1;
    public static final int VIEW_ERR_LV2 = 2;
    public static final int VIEW_ERR_LV3 = 3;
    public static final int VIEW_ERR_LV4 = 4;
    public static final int VIEW_ERR_LV5 = 5;
    public static final int VIEW_ERR_LV6 = 6;
    public static final int VIEW_ERR_LV7 = 7;

    public SJctrErrorDataController() throws SJcException {
        super(0x3100001);
    }

    public void setParameter(Object ... args) {
        SJctrTableDataModel table = null;
        table = (SJctrTableDataModel)args[0];
        if (table == null) {
            throw new NullPointerException();
        }
        List errDataList = null;
        if (args.length > 1) {
            errDataList = (List)args[1];
        }
        Comparator comp = DEFAULT_COMPARATOR;
        if (args.length > 2) {
            comp = (Comparator)args[2];
        }
        this.initDataModel(table, errDataList, comp);
    }

    private void initDataModel(SJctrTableDataModel table, List<SJctrErrorColumnData> list, Comparator comp) {
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_TABLE, errTable);
        errTable.initialize(table, list, comp);
        SJctrButtonDataModel closeButton = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        logUty.putlog("selectChanged", "close");
                        this.fireMessageEvent((SJctrNotifyState)SJctrWizardDataController.WIZ_MSG.CLOSE);
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_CLOSE, closeButton);
    }

    public SJctrError getRepresentativeError(List<SJctrErrorColumnData> errColList) {
        return this.getRepresentativeError(errColList, 7);
    }

    public SJctrError getRepresentativeError(List<SJctrErrorColumnData> errColList, int viewLv) {
        SJctrError retErr;
        if (errColList == null) {
            retErr = new SJctrError(201, 22, 106004);
            SJctrLogUty.warn(((Object)((Object)this)).getClass().getSimpleName(), "getRepresentativeError", "Input Null pointer!!");
        } else {
            retErr = new SJctrError(201, 22, 0);
            HashMap<Integer, SJctrError> errMap = new HashMap<Integer, SJctrError>();
            for (SJctrErrorColumnData errCol : errColList) {
                SJctrError err = errCol.getError();
                if (err == null || err.getError() == 0) continue;
                errMap.put(err.getError(), err);
                if (errMap.size() < 2) continue;
                break;
            }
            if (errMap.size() == 1) {
                Set ent = errMap.entrySet();
                Iterator ite = ent.iterator();
                Map.Entry errEnt = ite.next();
                retErr = (SJctrError)errEnt.getValue();
            } else if (errMap.size() >= 2) {
                int errorCode;
                switch (viewLv) {
                    case 1: {
                        errorCode = 106056;
                        break;
                    }
                    case 2: {
                        errorCode = 106057;
                        break;
                    }
                    case 3: {
                        errorCode = 106058;
                        break;
                    }
                    case 4: {
                        errorCode = 106059;
                        break;
                    }
                    case 5: {
                        errorCode = 106060;
                        break;
                    }
                    case 6: {
                        errorCode = 106061;
                        break;
                    }
                    case 7: {
                        errorCode = 106039;
                        break;
                    }
                    default: {
                        errorCode = 106004;
                    }
                }
                retErr = new SJctrError(201, 22, errorCode);
            }
        }
        return retErr;
    }
}

