/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;

public abstract class SJctrIpAddrUtility {
    public static final int FUNC_CODE_CMN = 201;
    public static final int MODULE_CODE_CTR = 22;
    Pattern mRegex;

    SJctrIpAddrUtility(Pattern regex) {
        this.mRegex = regex;
    }

    public boolean chkRegex(String adr) {
        Matcher m = this.mRegex.matcher(adr);
        return m.matches();
    }

    public abstract String toRegular(String var1) throws SJcException;

    public abstract void chkAdr(String var1) throws SJcException;

    public abstract String toRegularWithUsableCheck(String var1) throws SJcException;

    public static class IPv6
    extends SJctrIpAddrUtility {
        private static final String REGEX_STR = "^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$";
        public static final Pattern REGEX = Pattern.compile("^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$");
        public static final String DELIMITER_IPv6 = ":";
        public static final String DELIMITER_IPv4 = ".";
        public static final String REGEX_DELIMITER = "[:\\.]";
        public static final int MSG_INVALID_ADR = 105370;

        public IPv6() {
            super(REGEX);
        }

        @Override
        public String toRegular(String adr) throws SJcException {
            if (!this.chkRegex(adr)) {
                SJctrError err = new SJctrError(201, 22, 105370);
                SJcException exp = err.createException();
                throw exp;
            }
            StringBuffer regstr = new StringBuffer();
            try {
                StringTokenizer st = new StringTokenizer(adr, ":.", true);
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    String chkstr = str.replaceAll(REGEX_DELIMITER, "");
                    if (chkstr.length() > 0) {
                        int val = Integer.parseInt(chkstr, 16);
                        regstr.append(Integer.toHexString(val));
                        continue;
                    }
                    regstr.append(str);
                }
            }
            catch (Exception e) {
                SJctrError err = new SJctrError(201, 22, 105370);
                SJcException exp = err.createException();
                throw exp;
            }
            return regstr.toString();
        }

        @Override
        public void chkAdr(String adr) throws SJcException {
            boolean result = false;
            if (!this.chkRegex(adr)) {
                SJctrError err = new SJctrError(201, 22, 105370);
                SJcException exp = err.createException();
                throw exp;
            }
            try {
                int chksum = 0;
                StringTokenizer st = new StringTokenizer(adr, ":.", true);
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    String chkstr = str.replaceAll(REGEX_DELIMITER, "");
                    if (chkstr.length() == 0) continue;
                    int val = Integer.parseInt(chkstr, 16);
                    chksum += val;
                }
                result = chksum > 0;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!result) {
                SJctrError err = new SJctrError(201, 22, 105370);
                SJcException exp = err.createException();
                throw exp;
            }
        }

        @Override
        public String toRegularWithUsableCheck(String adr) throws SJcException {
            if (!this.chkRegex(adr)) {
                SJctrError err = new SJctrError(201, 22, 105370);
                SJcException exp = err.createException();
                throw exp;
            }
            int chksum = 0;
            StringBuffer regstr = new StringBuffer();
            try {
                StringTokenizer st = new StringTokenizer(adr, ":.", true);
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    String chkstr = str.replaceAll(REGEX_DELIMITER, "");
                    if (chkstr.length() > 0) {
                        int val = Integer.parseInt(chkstr, 16);
                        regstr.append(Integer.toHexString(val));
                        chksum += val;
                        continue;
                    }
                    regstr.append(str);
                }
            }
            catch (Exception e) {
                SJctrError err = new SJctrError(201, 22, 105370);
                SJcException exp = err.createException();
                throw exp;
            }
            if (chksum == 0) {
                SJctrError err = new SJctrError(201, 22, 105370);
                SJcException exp = err.createException();
                throw exp;
            }
            return regstr.toString();
        }
    }

    public static class IPv4
    extends SJctrIpAddrUtility {
        private static final String Partial_Basic_IPv4 = "25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d";
        private static final String REGEX_STR = "(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}";
        public static final Pattern REGEX = Pattern.compile("(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}");
        public static final String DELIMITER = ".";
        public static final int MSG_INVALID_ADR = 105369;

        public IPv4() {
            super(REGEX);
        }

        @Override
        public String toRegular(String adr) throws SJcException {
            if (!this.chkRegex(adr)) {
                SJctrError err = new SJctrError(201, 22, 105369);
                SJcException exp = err.createException();
                throw exp;
            }
            StringBuffer regstr = new StringBuffer();
            try {
                StringTokenizer st = new StringTokenizer(adr, DELIMITER);
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    if (str.length() > 0) {
                        int val = Integer.parseInt(str);
                        regstr.append(Integer.toString(val));
                    }
                    if (!st.hasMoreTokens()) continue;
                    regstr.append(DELIMITER);
                }
            }
            catch (Exception e) {
                SJctrError err = new SJctrError(201, 22, 105369);
                SJcException exp = err.createException();
                throw exp;
            }
            return regstr.toString();
        }

        @Override
        public void chkAdr(String adr) {
            boolean result = false;
            if (!this.chkRegex(adr)) {
                SJctrError err = new SJctrError(201, 22, 105369);
                SJcException exp = err.createException();
                throw exp;
            }
            try {
                int classA = 0;
                StringTokenizer st = new StringTokenizer(adr, DELIMITER);
                if (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    classA = Integer.parseInt(str);
                }
                result = classA > 0;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!result) {
                SJctrError err = new SJctrError(201, 22, 105369);
                SJcException exp = err.createException();
                throw exp;
            }
        }

        @Override
        public String toRegularWithUsableCheck(String adr) throws SJcException {
            String regstr = this.toRegular(adr);
            this.chkAdr(regstr);
            return regstr;
        }
    }
}

