/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;

public class SJctrHostNumColumnFromPortHostGroupTableKey
extends SJctrColumn {
    public SJctrHostNumColumnFromPortHostGroupTableKey(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("NUM_OF_HOST"));
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortHostGroupInfo.class);
        list.add(SJmoGetPortIscsiTargetInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> list = new ArrayList<Object>();
        SJctrPortHostGroupTableKey ptHginfo = (SJctrPortHostGroupTableKey)index;
        if (ptHginfo.isFibre()) {
            list.add(ptHginfo.getHostGroupInfo());
        } else {
            list.add(ptHginfo.getIscsiTargetInfo());
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRet = "?";
        SJctrPortUtility portUtil = this.getTable().getComUtility().getPortUtility();
        if (dataList.get(0) instanceof SJmoHostGroupInfo) {
            SJmoHostGroupInfo hostGroupInfo = (SJmoHostGroupInfo)dataList.get(0);
            strRet = portUtil.toHostNumDisplay(hostGroupInfo);
        } else if (dataList.get(0) instanceof SJmoIscsiTargetInfo) {
            SJmoIscsiTargetInfo iscsiTargetInfo = (SJmoIscsiTargetInfo)dataList.get(0);
            strRet = portUtil.toHostNumDisplay(iscsiTargetInfo);
        }
        return strRet;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        SJctrPortHostGroupTableKey ptHginfo = (SJctrPortHostGroupTableKey)this.getPrimaryKeyObject(dat);
        if (ptHginfo.isFibre()) {
            SJmoHostGroupInfo hgInfo = ptHginfo.getHostGroupInfo();
            num = hgInfo.getAlHostGroupWwn().size();
        } else {
            SJmoIscsiTargetInfo hgInfo = ptHginfo.getIscsiTargetInfo();
            num = hgInfo.getAlIscsiName().size();
        }
        return num;
    }
}

