/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrPoolEnlargementFactorFromPoolDetail
extends SJctrColumn {
    public SJctrPoolEnlargementFactorFromPoolDetail(String key) {
        super(key);
        this.setPartsId("CAP_EXP_RATE");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJmoGetPoolDetail.class);
        return alList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList != null && !dataList.isEmpty()) {
            Object obj = dataList.get(0);
            if (obj != null && obj instanceof SJmoPoolDetail) {
                SJmoPoolDetail poolDtl = (SJmoPoolDetail)obj;
                SJctrComUtility comUtl = this.getTable().getComUtility();
                SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
                String strClmUnit = this.getTable().getUnitMenu();
                strRtn = poolUtl.toPoolCurrentEnlargementFactor(poolDtl, comUtl, strClmUnit);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "obj = " + obj);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList = " + dataList);
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        String strClmUnit;
        long lCrntEnlFact = 0L;
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        SJctrComUtility comUtl = this.getTable().getComUtility();
        SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
        String strEnlFact = poolUtl.toPoolCurrentEnlargementFactor(poolDtl, comUtl, strClmUnit = this.getTable().getUnitMenu());
        if (strEnlFact.equals("?")) {
            lCrntEnlFact = -2L;
        } else if (strEnlFact.equals(SJctrPoolUtility.HAIFUN_STR)) {
            lCrntEnlFact = SJctrPoolUtility.HAIFUN_NUM;
        } else {
            try {
                lCrntEnlFact = Long.parseLong(strEnlFact);
            }
            catch (NumberFormatException e) {
                lCrntEnlFact = -2L;
            }
        }
        return lCrntEnlFact;
    }
}

