/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrPoolTotalCapacityColumnFromPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrPoolUsedCapacityColumnFromPoolDetail
extends SJctrPoolTotalCapacityColumnFromPoolDetail {
    public SJctrPoolUsedCapacityColumnFromPoolDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("USED_CAPA"));
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        SJmoPoolDetail poolDetail = null;
        String strCapaUnit = "";
        SJctrComUtility comUtil = null;
        if (null != dataList && 0 != dataList.size()) {
            poolDetail = (SJmoPoolDetail)dataList.get(0);
            strCapaUnit = this.getUnitSelect();
            comUtil = this.getTable().getComUtility();
            strRtn = comUtil.getPoolUtility().toPoolUsedCapacityDisplay(poolDetail, strCapaUnit, comUtil);
        }
        return strRtn;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJctrCapacityUtility.UNIT poolCapaUnit = SJctrCapacityUtility.UNIT.KB;
        int iEmulation = 625;
        long lPoolPages = 0L;
        long lPoolPageSize = 0L;
        long lPoolCapa = 0L;
        long lPoolBlock = 0L;
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        iEmulation = poolDetail.getEmulationType();
        String strClmUnit = this.getUnitSelect();
        SJctrCapacityUtility.UNIT clmUnit = SJctrCapacityUtility.UNIT.valueOf(strClmUnit);
        if (iEmulation != 0 || !clmUnit.equals((Object)SJctrCapacityUtility.UNIT.CYL)) {
            lPoolPages = poolDetail.getPoolUsedPages();
            lPoolPageSize = poolDetail.getPageSize();
            lPoolCapa = lPoolPages * lPoolPageSize;
            lPoolBlock = this.getTable().getComUtility().getCapacityUtility().valueOf(lPoolCapa, poolCapaUnit, iEmulation);
        } else {
            lPoolBlock = SJctrPoolUtility.HAIFUN_NUM;
        }
        return lPoolBlock;
    }

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        long retValue = poolDetail.getPoolUsedPages();
        return retValue;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        int emuType = poolDetail.getEmulationType();
        SJctrComUtility comUtl = this.getTable().getComUtility();
        SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
        emuType = poolUtl.changeEmulationType(emuType);
        long block = this.getNumber(dat);
        SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
        long cylinder = capaUtil.toCylValue(block, emuType);
        return cylinder;
    }
}

