/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolLdevDetail;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrShrinkableFromPoolLdevDetailColumn
extends SJctrColumn {
    SJctrPoolUtility poolUtil;
    List<SJmoLdevDetail> ssdList = null;
    List<SJmoLdevDetail> notDmVolList = null;
    List<SJmoLdevDetail> ldevDetailList = null;
    List<SJmoVdevDetail> vdevDetailList = null;
    List<SJmoPgDetail> pgDetailList = null;

    public SJctrShrinkableFromPoolLdevDetailColumn(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("SHRINKABLE"));
        this.poolUtil = util.getPoolUtility();
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        alList.add(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (null != index && null != modelData && index instanceof SJctrPoolLdevDetail) {
            SJctrPoolLdevDetail idxPoolLdevDtl = (SJctrPoolLdevDetail)index;
            retList.add(idxPoolLdevDtl);
            SJmoPoolDetail poolDetail = idxPoolLdevDtl.getPoolDetail();
            List<?> poolVolDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
            int iPoolVolDtlIdx = Collections.binarySearch(poolVolDetailList, poolDetail);
            if (0 <= iPoolVolDtlIdx) {
                SJmoPoolVolDetail poolVolDtl = (SJmoPoolVolDetail)poolVolDetailList.get(iPoolVolDtlIdx);
                retList.add(poolVolDtl);
                this.ldevDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
                if (this.ldevDetailList == null || this.ldevDetailList.isEmpty()) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoLdevDetail List is null or size 0");
                }
                if (this.ssdList == null) {
                    this.ssdList = Collections.emptyList();
                    if (poolDetail.getPoolKind() == 2 && 144 == (poolDetail.getITierControlInfo() & 0x90)) {
                        this.ssdList = this.poolUtil.serchSSDVol(poolVolDtl.getAlPoolInfo(), this.ldevDetailList);
                    }
                }
                if (this.notDmVolList == null) {
                    boolean directMappingFlg;
                    this.notDmVolList = Collections.emptyList();
                    boolean bl = directMappingFlg = 0L != (poolDetail.getLPoolOptionFlag() & 0x20000000L);
                    if (directMappingFlg) {
                        this.notDmVolList = this.poolUtil.serchNotDmVol(poolVolDtl.getAlPoolInfo(), this.ldevDetailList);
                    }
                }
                this.vdevDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
                if (this.vdevDetailList == null || this.vdevDetailList.isEmpty()) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoVdevDetail List is null or size 0");
                }
                this.pgDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
                if (this.pgDetailList == null || this.pgDetailList.isEmpty()) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "pgDetailList List is null or size 0");
                }
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoPoolVolDetail is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "Parameter is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "";
        if (null != dataList && 0 != dataList.size()) {
            Object obj = dataList.get(0);
            Object obj2 = dataList.get(1);
            if (obj instanceof SJctrPoolLdevDetail && obj2 instanceof SJmoPoolVolDetail) {
                SJctrPoolLdevDetail poolLdevDtl = (SJctrPoolLdevDetail)obj;
                SJmoPoolVolDetail poolVolDtl = (SJmoPoolVolDetail)obj2;
                SJmoPoolDetail poolDtl = poolLdevDtl.getPoolDetail();
                SJmoPoolVolInfo poolVolInf = poolLdevDtl.getPoolVolInfo();
                SJmoLdevDetail checkLdevDetail = poolLdevDtl.getLdevDetail();
                strRtn = this.poolUtil.toPoolVolShrinkableDisplay(poolDtl, poolVolInf, poolVolDtl.getAlPoolInfo(), checkLdevDetail, this.ssdList, this.notDmVolList, this.ldevDetailList, this.vdevDetailList, this.pgDetailList);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is class error");
                strRtn = "?";
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
            strRtn = "?";
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 3;
    }
}

