/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoTierInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrVVolTier1UsedCapacityColumnFromLdevDetail
extends SJctrCapacityColumn {
    protected Map<Object, Object> modelDataMap = null;
    protected int tierNum = 0;

    public SJctrVVolTier1UsedCapacityColumnFromLdevDetail(String key) {
        super(key);
        this.setPartsId("TIER1");
        this.tierNum = 1;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        boolean tierFlg;
        ArrayList<Object> retList = new ArrayList<Object>();
        if (this.modelDataMap == null) {
            this.modelDataMap = new HashMap<Object, Object>(this.getTable().getRowCount());
        }
        if (index == null || !(index instanceof SJmoLdevDetail)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index is null or Class Error");
            return retList;
        }
        SJmoLdevDetail ldevDtl = (SJmoLdevDetail)index;
        List<?> hdpRelList = modelData.get(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
        int iHdpRelIdx = Collections.binarySearch(hdpRelList, ldevDtl);
        if (iHdpRelIdx < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "SJmoHDPRelation is Not Found");
            return retList;
        }
        SJmoHDPRelation hdpRel = (SJmoHDPRelation)hdpRelList.get(iHdpRelIdx);
        List<?> poolDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        SJmoPoolIndex poolIdx = new SJmoPoolIndex();
        poolIdx.setPoolId(hdpRel.getIPoolId());
        int poolDetailIndex = Collections.binarySearch(poolDetailList, poolIdx);
        if (poolDetailIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "poolDetail is Not Found");
            return retList;
        }
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)poolDetailList.get(poolDetailIndex);
        boolean bl = tierFlg = 0 != (poolDetail.getITierControlInfo() & 0x80);
        if (tierFlg) {
            retList.add(hdpRel);
            this.modelDataMap.put(index, hdpRel);
        } else {
            retList.add(ldevDtl);
            this.modelDataMap.put(index, ldevDtl);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList != null && !dataList.isEmpty()) {
            Object toDispData = dataList.get(0);
            if (toDispData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelation = (SJmoHDPRelation)toDispData;
                String strCapaUnit = this.getUnitSelect();
                SJctrComUtility comUtil = this.getTable().getComUtility();
                strRtn = comUtil.getPoolUtility().toLUNTierUsedCapacityDisplay(hdpRelation, this.tierNum, strCapaUnit, comUtil);
            } else if (toDispData instanceof SJmoLdevDetail) {
                strRtn = SJctrPoolUtility.HAIFUN_STR;
            }
        }
        return strRtn;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lRtn = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelationData = (SJmoHDPRelation)modelData;
                long lPageSize = hdpRelationData.getLPageCapa();
                ArrayList tierInfoList = hdpRelationData.getAlDpVolTierInfo();
                for (SJmoTierInfo tierInfo : tierInfoList) {
                    lRtn = SJctrPoolUtility.HAIFUN_NUM;
                    if (tierInfo.getSTierNum() != this.tierNum) continue;
                    long lTierUse = tierInfo.getLUseTier();
                    long lTierUseCapa = lPageSize * lTierUse;
                    lRtn = this.getTable().getComUtility().getCapacityUtility().valueOf(lTierUseCapa, SJctrCapacityUtility.UNIT.KB);
                    break;
                }
            } else if (modelData instanceof SJmoLdevDetail) {
                lRtn = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return lRtn;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        long lRtn = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)modelData;
                ArrayList tierInfoList = hdpRelData.getAlDpVolTierInfo();
                for (SJmoTierInfo tierInfo : tierInfoList) {
                    lRtn = SJctrPoolUtility.HAIFUN_NUM;
                    if (tierInfo.getSTierNum() != this.tierNum) continue;
                    lRtn = tierInfo.getLUseTier();
                    break;
                }
            } else if (modelData instanceof SJmoLdevDetail) {
                lRtn = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return lRtn;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        long cylinder = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)modelData;
                int emuType = hdpRelData.getIEmulationType();
                SJctrComUtility comUtil = this.getTable().getComUtility();
                int ldevEmuType = comUtil.getPoolUtility().changeEmulationType(emuType);
                if (ldevEmuType != -1) {
                    long block = this.getNumber(dat);
                    SJctrCapacityUtility capaUtil = comUtil.getCapacityUtility();
                    cylinder = capaUtil.toCylValue(block, ldevEmuType);
                }
            } else if (modelData instanceof SJmoLdevDetail) {
                cylinder = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return cylinder;
    }
}

