/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrVirtualStorageSystemColumnFromPortIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrVirtualStorageSystemColumnFromPortHostGroupTableKey
extends SJctrVirtualStorageSystemColumnFromPortIndex {
    public static final String GUID_MDL_SN = "MODEL_SN";

    public SJctrVirtualStorageSystemColumnFromPortHostGroupTableKey(String key) {
        super(key);
        this.setPartsId(GUID_MDL_SN);
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList list = (ArrayList)super.getNeedModelKind();
        list.add(SJmoGetPortAttributeInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        SJctrPortHostGroupTableKey portHGTableKey = (SJctrPortHostGroupTableKey)index;
        SJmoHostGroupInfo hgInfo = portHGTableKey.getHostGroupInfo();
        SJmoIscsiTargetInfo itInfo = portHGTableKey.getIscsiTargetInfo();
        ArrayList<Boolean> ret = new ArrayList<Boolean>();
        boolean bInitiator = false;
        List<?> portAttrList = basicData.get(SJmoGetPortAttributeInfo.class);
        if (portAttrList != null && !portAttrList.isEmpty()) {
            SJmoPortAttributeInfo portAttr;
            int search = -1;
            search = portHGTableKey.isFibre() ? Collections.binarySearch(portAttrList, portHGTableKey.getPortHostGroupInfo()) : Collections.binarySearch(portAttrList, portHGTableKey.getPortIscsiTargetInfo());
            if (search >= 0 && (portAttr = (SJmoPortAttributeInfo)portAttrList.get(search)).getByPortKind() == 5) {
                bInitiator = true;
            }
        }
        SJmoHUVMVirtualDkc vDKCInfo = null;
        if (!bInitiator) {
            SJctrDataController dc = this.getTable().getDataController();
            SJctrUserController uc = dc.getOwner();
            List<?> allRsgsList = basicData.get(SJmoGetRSGgetAllRsgs.class);
            if (allRsgsList == null || allRsgsList.size() <= 0) {
                return ret;
            }
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)allRsgsList.get(0));
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            if (portHGTableKey.isFibre()) {
                hgIndex.setSPort(hgInfo.getSPort());
                hgIndex.setSHostGroup(hgInfo.getSHostGroup());
            } else {
                hgIndex.setSPort(itInfo.getSPort());
                hgIndex.setSHostGroup(itInfo.getSIscsiTarget());
            }
            SJmoRSGgetRsg rsg = rsgUtil.getRsgFromHg(hgIndex);
            if (rsg == null) {
                return ret;
            }
            SJmoHUVMvboxIndex targetIndex = rsg.getRsgInfo().getVboxIndex();
            List<?> VboxList = basicData.get(SJmoGetHUVMVirtualDkc.class);
            if (targetIndex == null || VboxList == null || VboxList.size() <= 0) {
                return ret;
            }
            int vBoxIndex = Collections.binarySearch(VboxList, targetIndex);
            if (vBoxIndex >= 0) {
                vDKCInfo = (SJmoHUVMVirtualDkc)VboxList.get(vBoxIndex);
            }
        }
        ret.add(bInitiator);
        ret.add((Boolean)vDKCInfo);
        return ret;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoHUVMVirtualDkc vDKCInfo = null;
        if (!dataList.isEmpty() && dataList.size() == 2) {
            boolean bInitiator = (Boolean)dataList.get(0);
            if (bInitiator) {
                return SJctrPortUtility.STR_HYPHEN;
            }
            vDKCInfo = (SJmoHUVMVirtualDkc)dataList.get(1);
        }
        SJctrRsgUtility rsgUtil = this.getTable().getComUtility().getRsgUtility();
        return rsgUtil.toDispStringVssModelSerialNo(vDKCInfo);
    }
}

