/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortFcoeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortFcoeInfo;

public class SJctrVpIndexColumnFromPortFcoeInfo
extends SJctrColumn {
    private static final int FCOE_INFO_LIST_ZERO = 0;
    private static final int FAILD_NUMBER = -1;
    protected HashMap<String, Integer> vpIndexNumMap = null;

    public SJctrVpIndexColumnFromPortFcoeInfo(String key) {
        super(key);
        if (SJctrDataController.isHM()) {
            this.setSupportColumn(false);
        }
        this.setSupportColumn(false);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("VP_INDEX"));
    }

    @Override
    public int getFilterType() {
        return 3;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortFcoeInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        int fcoeIndex;
        SJmoPortDetail ptDetail = (SJmoPortDetail)index;
        SJmoPortFcoeInfo fcoeInfo = null;
        List<?> ptFcoeList = modelData.get(SJmoGetPortFcoeInfo.class);
        if (ptFcoeList.size() != 0 && (fcoeIndex = Collections.binarySearch(ptFcoeList, ptDetail)) >= 0) {
            fcoeInfo = (SJmoPortFcoeInfo)ptFcoeList.get(fcoeIndex);
        }
        ArrayList<SJmoPortFcoeInfo> list = new ArrayList<SJmoPortFcoeInfo>();
        list.add(fcoeInfo);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoPortFcoeInfo fcoeInfo = (SJmoPortFcoeInfo)dataList.get(0);
        SJctrPortUtility util = this.getTable().getComUtility().getPortUtility();
        String vpIndex = util.toVpIndexDisplay(fcoeInfo);
        if (this.vpIndexNumMap == null) {
            this.vpIndexNumMap = new HashMap(this.getTable().getRowCount());
        }
        boolean mapPutFlg = !vpIndex.equals(SJctrPortUtility.STR_HYPHEN);
        mapPutFlg &= !vpIndex.equals("?");
        if (mapPutFlg &= !vpIndex.equals("")) {
            this.vpIndexNumMap.put(vpIndex, Integer.parseInt(vpIndex));
        }
        return vpIndex;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        String strNum = this.getString(dat);
        boolean numFlg = strNum.length() != 0;
        numFlg &= !strNum.equals(SJctrPortUtility.STR_HYPHEN);
        numFlg &= !strNum.equals("?");
        if (numFlg &= !strNum.equals("")) {
            num = this.vpIndexNumMap.get(strNum);
        }
        return num;
    }
}

