/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.cvs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrDataDirectMappedParityGroupIdColumnFromLdevDetail
extends SJctrColumn {
    private Map<Class<?>, List<?>> _modelData;

    public SJctrDataDirectMappedParityGroupIdColumnFromLdevDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("AG_ID"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetLdevDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoLdevDetail> list = new ArrayList<SJmoLdevDetail>();
        this._modelData = modelData;
        SJmoLdevDetail ldev = (SJmoLdevDetail)index;
        if (ldev.getBDM() && ldev.getbVvol() && ldev.getbAouVvol()) {
            SJmoLdevIndex cnctLdevIndex = ldev.getCnctLDEVIndex();
            List<?> ldevList = modelData.get(SJmoGetLdevDetail.class);
            int ldevIndex = Collections.binarySearch(ldevList, cnctLdevIndex);
            if (ldevIndex >= 0) {
                SJmoLdevDetail cnctLdev = (SJmoLdevDetail)ldevList.get(ldevIndex);
                list.add(cnctLdev);
            }
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String disp = "-";
        if (dataList != null && dataList.size() > 0) {
            SJmoLdevDetail ldev = (SJmoLdevDetail)dataList.get(0);
            SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
            disp = util.toArrayGroupDisplay(ldev.getIFB4(), ldev.getIPG());
        }
        return disp;
    }

    @Override
    public int getSortType() {
        return 3;
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return new SJctrArrayGroupIndexComparator();
    }

    @Override
    protected Object getObject(Map<String, Object> dat) {
        SJmoLdevIndex cnctLdevIndex;
        int ldevIndex;
        SJmoLdevDetail ret = null;
        SJmoLdevDetail ldev = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        List<?> ldevList = this._modelData.get(SJmoGetLdevDetail.class);
        if (ldev.getBDM() && ldev.getbVvol() && ldev.getbAouVvol() && (ldevIndex = Collections.binarySearch(ldevList, cnctLdevIndex = ldev.getCnctLDEVIndex())) >= 0) {
            ret = (SJmoLdevDetail)ldevList.get(ldevIndex);
        }
        if (ret == null) {
            ret = new SJmoLdevDetail();
        }
        return ret;
    }
}

