/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.password;

import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.password.SJctrPassDef;
import sanproject.sn2.controller.com.password.SJctrPassFileManage;
import sanproject.sn2.controller.com.password.SJctrPassInfo;

public class SJctrPassUtility
implements SJctrPassDef {
    public static SJctrPassInfo getPassInf(String strFileName) {
        SJctrPassFileManage file = new SJctrPassFileManage(strFileName);
        SJctrPassInfo rtn = new SJctrPassInfo();
        try {
            file.read();
            rtn.createPassInfData(file);
        }
        catch (Exception ex) {
            SJctrLogUty.error("SJctrPassUtility", "getPassInf", "Read NG!");
        }
        return rtn;
    }

    public static void writePassInf(String strFileName, SJctrPassInfo pass) throws SJcException {
        SJctrPassFileManage file = new SJctrPassFileManage(strFileName);
        pass.createFileData(file);
        try {
            file.write();
        }
        catch (Exception ex) {
            if (ex instanceof SJcException) {
                throw (SJcException)ex;
            }
            SJctrPassUtility.createErrorDialog(105479);
        }
    }

    public static void chkPass(String strFileName, String strPass, int iMax) throws SJcException {
        SJctrPassInfo pass = SJctrPassUtility.getPassInf(strFileName);
        SJctrPassUtility.chkPass(pass, strPass, iMax);
    }

    public static void chkPass(SJctrPassInfo pass, String strPass, int iMax) throws SJcException {
        if (strPass.length() < pass.getITotallen() || strPass.length() > iMax) {
            SJctrPassUtility.createErrorDialog(105477);
        }
        if (pass.isFile()) {
            SJctrPassUtility.chkLength(strPass, "[^0-9]", pass.getINum());
            SJctrPassUtility.chkLength(strPass, "[^A-Z]", pass.getIUpper());
            SJctrPassUtility.chkLength(strPass, "[^a-z]", pass.getILower());
            SJctrPassUtility.chkLength(strPass, "[0-9A-Za-z]", pass.getISymbol());
        }
    }

    private static void chkLength(String strPass, String strChk, int iLength) {
        String wkNum;
        if (iLength > 0 && (wkNum = strPass.replaceAll(strChk, "")).length() < iLength) {
            SJctrPassUtility.createErrorDialog(105478);
        }
    }

    private static void createErrorDialog(int iError) {
        SJctrError error = new SJctrError(201, 22, iError);
        SJcException ex = error.createException();
        throw ex;
    }

    public static String toDispPolicyLabel(String strFileName, SJctrComUtility comUty, int iMax) {
        SJctrPassInfo pass = SJctrPassUtility.getPassInf(strFileName);
        return SJctrPassUtility.toDispPolicyLabel(pass, comUty, iMax);
    }

    public static String toDispPolicyLabel(SJctrPassInfo pass, SJctrComUtility comUty, int iMax) {
        String rtn = "";
        if (pass.isPolicy()) {
            rtn = pass.getITotallen() + "-" + iMax + comUty.getGuidance("CHARACTERS_WITH");
            rtn = SJctrPassUtility.addPrintData(pass.getINum(), rtn, comUty.getGuidance("PASSWORD_LABEL_NUMERIC"));
            rtn = SJctrPassUtility.addPrintData(pass.getIUpper(), rtn, comUty.getGuidance("PASSWORD_LABEL_UPPERCASE"));
            rtn = SJctrPassUtility.addPrintData(pass.getILower(), rtn, comUty.getGuidance("PASSWORD_LABEL_LOWERCASE"));
            rtn = SJctrPassUtility.addPrintData(pass.getISymbol(), rtn, comUty.getGuidance("PASSWORD_LABEL_SYMBOL"));
        } else {
            String wkFmTo = pass.getITotallen() + "-" + iMax;
            String wkDisp = wkFmTo + comUty.getGuidance("CHARACTERS");
            rtn = "(" + wkDisp + ")";
        }
        return rtn;
    }

    private static String addPrintData(int iNum, String strData, String strCara) {
        String rtn = strData;
        if (iNum > 0) {
            rtn = rtn + "\n" + "-" + " " + iNum + strCara;
        }
        return rtn;
    }
}

