/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.tools.account;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Properties;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.account.SJcRoleInfoContainer;
import sanproject.sn2.com.utility.account.SJcUserGroupInfoContainer;
import sanproject.sn2.com.utility.account.SJcUserInfoContainer;

public class CreateAccount {
    private static final String FILE_PROP_USER = "UserInfo.properties";
    private static final String FILE_PROP_GROUP = "GroupInfo.properties";
    private static final String FILE_PROP_ROLE = "RoleInfo.properties";

    public static void main(String[] args) {
        System.setProperty("SN_DataPath", SJcEnvUty.getSnBasePath() + "san\\SN2\\SN2Files");
        System.setProperty("SN_EnvFile", SJcEnvUty.getSnBasePath() + "san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_Startup.properties");
        System.setProperty("SN_EnvFileV", SJcEnvUty.getSnBasePath() + "san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_StartupV.properties");
        if (args.length != 1 || args[0] == "") {
            System.out.println("Parameter is Invalid.");
            return;
        }
        CreateAccount.createUser(args[0]);
        CreateAccount.createGroup(args[0]);
        CreateAccount.createRole(args[0]);
        System.out.println("normal end.");
    }

    private static void createUser(String szDirectory) {
        try {
            HashMap<String, SJcUserInfoContainer> mpData = new HashMap<String, SJcUserInfoContainer>();
            Properties prop = new Properties();
            prop.load(new FileInputStream(szDirectory + "\\" + FILE_PROP_USER));
            String list = prop.getProperty("List");
            if (CreateAccount.isEmpty(list)) {
                throw new Exception();
            }
            String[] arylist = list.split(",");
            for (int i = 0; i < arylist.length; ++i) {
                try {
                    String Key2 = arylist[i] + ".";
                    String name = prop.getProperty(Key2 + "Name");
                    String type = prop.getProperty(Key2 + "Type");
                    String auth = prop.getProperty(Key2 + "AuthPattern");
                    String pass = prop.getProperty(Key2 + "Password");
                    String group = prop.getProperty(Key2 + "UserGroup");
                    String enable = prop.getProperty(Key2 + "Enable");
                    if (CreateAccount.isEmpty(name) || CreateAccount.isEmpty(type) || CreateAccount.isEmpty(auth) || CreateAccount.isEmpty(pass) || CreateAccount.isEmpty(group) || CreateAccount.isEmpty(enable)) {
                        new Exception();
                    }
                    String[] arygroup = group.split(",");
                    String hashpass = "";
                    if (auth.equals("1")) {
                        hashpass = SJcSecureUty.getHashValueStringHex(pass);
                    }
                    SJcUserInfoContainer clsData = new SJcUserInfoContainer();
                    clsData.setUserName(name);
                    clsData.setType(type);
                    clsData.setAuthPtn(auth);
                    clsData.setPassword(hashpass);
                    clsData.setGrpName(arygroup);
                    clsData.setEnable(enable);
                    mpData.put(name, clsData);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("[USER]Insert Error. (" + arylist[i] + ")");
                }
            }
            CreateAccount.saveFile(szDirectory, "UserInfo", mpData);
        }
        catch (Exception ex) {
            System.out.println("UserInfo not Creating.");
        }
    }

    private static void createGroup(String szDirectory) {
        try {
            HashMap<String, SJcUserGroupInfoContainer> mpData = new HashMap<String, SJcUserGroupInfoContainer>();
            Properties prop = new Properties();
            prop.load(new FileInputStream(szDirectory + "\\" + FILE_PROP_GROUP));
            String list = prop.getProperty("List");
            if (CreateAccount.isEmpty(list)) {
                throw new Exception();
            }
            String[] arylist = list.split(",");
            for (int i = 0; i < arylist.length; ++i) {
                try {
                    String Key2 = arylist[i] + ".";
                    String name = prop.getProperty(Key2 + "Name");
                    String type = prop.getProperty(Key2 + "Type");
                    String role = prop.getProperty(Key2 + "Role");
                    String resource = prop.getProperty(Key2 + "Resource");
                    String resourceID = prop.getProperty(Key2 + "ResourceID");
                    String allresource = prop.getProperty(Key2 + "AllResource");
                    if (CreateAccount.isEmpty(name) || CreateAccount.isEmpty(type) || CreateAccount.isEmpty(role)) {
                        new Exception();
                    }
                    String[] aryrole = role.split(",");
                    boolean allflg = false;
                    if (allresource.equals("1")) {
                        allflg = true;
                    }
                    SJcUserGroupInfoContainer clsData = new SJcUserGroupInfoContainer();
                    clsData.setGroupName(name);
                    clsData.setType(type);
                    clsData.setRoleName(aryrole);
                    clsData.setAllRsrcGroup(allflg);
                    if (!CreateAccount.isEmpty(resource)) {
                        String[] aryresource = resource.split(",");
                        clsData.setRsrcName(aryresource);
                    }
                    boolean[] bRsrcGpID = new boolean[1024];
                    if (!resourceID.isEmpty()) {
                        String[] aryresource = resourceID.split(",");
                        for (int j = 0; j < aryresource.length; ++j) {
                            bRsrcGpID[Integer.parseInt((String)aryresource[j])] = true;
                        }
                    }
                    clsData.setRsrcGroupMap(bRsrcGpID);
                    mpData.put(name, clsData);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("[GROUP]Insert Error. (" + arylist[i] + ")");
                }
            }
            CreateAccount.saveFile(szDirectory, "GroupInfo", mpData);
        }
        catch (Exception ex) {
            System.out.println("GroupInfo not Creating.");
        }
    }

    private static void createRole(String szDirectory) {
        try {
            HashMap<String, SJcRoleInfoContainer> mpData = new HashMap<String, SJcRoleInfoContainer>();
            Properties prop = new Properties();
            prop.load(new FileInputStream(szDirectory + "\\" + FILE_PROP_ROLE));
            String list = prop.getProperty("List");
            if (CreateAccount.isEmpty(list)) {
                throw new Exception();
            }
            String[] arylist = list.split(",");
            for (int i = 0; i < arylist.length; ++i) {
                try {
                    String Key2 = arylist[i] + ".";
                    String name = prop.getProperty(Key2 + "Name");
                    String type = prop.getProperty(Key2 + "Type");
                    String bitmap = prop.getProperty(Key2 + "authorityBitMap");
                    if (CreateAccount.isEmpty(name) || CreateAccount.isEmpty(type) || CreateAccount.isEmpty(bitmap)) {
                        new Exception();
                    }
                    SJcRoleInfoContainer clsData = new SJcRoleInfoContainer();
                    clsData.setRoleName(name);
                    clsData.setType(type);
                    clsData.setBitmap(bitmap);
                    mpData.put(name, clsData);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("[ROLE]Insert Error. (" + arylist[i] + ")");
                }
            }
            CreateAccount.saveFile(szDirectory, "RoleInfo", mpData);
        }
        catch (Exception ex) {
            System.out.println("RoleInfo not Creating.");
        }
    }

    private static void saveFile(String dir, String file, HashMap mp) throws Exception {
        String path = dir + "\\" + file;
        FileOutputStream outFile = new FileOutputStream(path);
        ObjectOutputStream outObject = new ObjectOutputStream(outFile);
        outObject.writeObject(mp);
        outObject.close();
        outFile.close();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.equals("");
    }
}

