/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldap;

import java.io.IOException;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import sanproject.sn2.base.authentication.module.external.common.SJbaseCustomSocketFactory;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseLdapBind {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseLdapBind";
    private static final String[][] escape = new String[][]{{"\\", "\\5c"}, {"*", "\\2a"}, {"(", "\\28"}, {")", "\\29"}};

    public SJbaseExternalAccountInfo execute(SJbaseLdapConfiguration ldapConf, String userId, String password) throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String userDN;
        String method = "execute";
        logger.info(module, method, "", "start");
        SJbaseExternalAccountInfo account = null;
        Context ldapContext = null;
        String searchUserDN = ldapConf.getSearchUserDN();
        String searchDN = ldapConf.getSearchDN();
        String userAttr = ldapConf.getUserAttr();
        try {
            if (searchUserDN == "") {
                userDN = userAttr + "=" + userId + "," + searchDN;
                logger.info(module, method, "", "search user is not registered userDN=" + userDN);
            } else {
                try {
                    logger.info(module, method, "", "search user is registerd searchDN=" + searchUserDN);
                    ldapContext = this.bindAuthentication(ldapConf, searchUserDN, ldapConf.getSearchUserPassword());
                }
                catch (AuthenticationException e) {
                    logger.error(module, method, "authenticate the search user", "authentication error", e);
                    SJbaseExAuthenticationException ex = new SJbaseExAuthenticationException();
                    ex.setErrCode(1);
                    throw ex;
                }
                try {
                    SearchControls scon = new SearchControls();
                    scon.setSearchScope(2);
                    String escapedUserId = SJbaseLdapBind.escapeGroupStr(userId);
                    userAttr = SJbaseLdapBind.escapeGroupStr(userAttr);
                    String filterStr = "(" + userAttr + "=" + escapedUserId + ")";
                    logger.info(module, method, "search the DN of login user", "filterStr:" + filterStr);
                    NamingEnumeration<SearchResult> resultEnu = ldapContext.search(searchDN, filterStr, scon);
                    if (!resultEnu.hasMore()) {
                        logger.error(module, method, "search the DN of login user", "failed");
                        SJbaseExAuthenticationException ex = new SJbaseExAuthenticationException();
                        ex.setErrCode(3);
                        throw ex;
                    }
                    SearchResult resultItem = resultEnu.next();
                    userDN = resultItem.getNameInNamespace();
                    logger.info(module, method, "search the DN of login user", "succeeded:" + userDN);
                }
                catch (NamingException e) {
                    logger.error(module, method, "search the DN of login user", e.toString(true));
                    SJbaseExAuthenticationException ex = new SJbaseExAuthenticationException();
                    ex.setErrCode(2);
                    throw ex;
                }
            }
            logger.info(module, method, "launch the bind operation ", userDN);
            ldapContext = this.bindAuthentication(ldapConf, userDN, password);
        }
        catch (SJbaseExAuthenticationException e) {
            throw e;
        }
        catch (SJbaseExCommunicationException e) {
            throw e;
        }
        catch (AuthenticationException e) {
            logger.error(module, method, "try the bind operation", "failed 3", e);
            throw new SJbaseExAuthenticationException();
        }
        catch (NamingException e) {
            Throwable ex = e.getRootCause();
            if (ex instanceof SSLHandshakeException) {
                logger.error(module, method, "try the get ticket operation", "failed", ex);
                SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
                et.setErrCode(4);
                throw et;
            }
            logger.error(module, method, "try the bind operation", "failed 4", e);
            throw new SJbaseExCommunicationException();
        }
        catch (Exception e) {
            logger.error(module, method, "try the bind operation", "failed 5", e);
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        finally {
            if (ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {}
                ldapContext = null;
            }
        }
        logger.info(module, method, "authenticate the login user", "succeeded");
        account = new SJbaseExternalAccountInfo(userId);
        account.setAuthServerInfo(userDN);
        logger.info(module, method, "", "end");
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext bindAuthentication(SJbaseLdapConfiguration ldapConf, String userDN, String userPwd) throws IOException, NamingException {
        String method = "bindAuthentication";
        logger.info(module, method, "", "start");
        Context ldapContext = null;
        boolean authSuccess = false;
        if (userDN == null || userDN.length() == 0) {
            logger.error(module, method, "check the DN", "invalid");
            throw new AuthenticationException();
        }
        if (userPwd == null) {
            logger.error(module, method, "check the password", "invalid");
            throw new AuthenticationException();
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", ldapConf.getUrl());
            int timeout = ldapConf.getTimeout();
            String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
            String systemPath = SJcFileUty.concatFolderPath(dataPath, "base\\setting\\extAuth\\");
            String keystoreFileName = SJcFileUty.concatFolderPath(systemPath, "ExternalAuth.keystore");
            logger.info(module, method, "keystoreFileName=", keystoreFileName);
            System.setProperty("KEY_SNBASE_KEYSTORE", keystoreFileName);
            if (timeout != 0) {
                logger.info(module, method, "set  timeout", Integer.toString(timeout));
                env.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(timeout * 1000));
            }
            if (ldapConf.getProtocol().compareToIgnoreCase("ldaps") == 0) {
                logger.info(module, method, "check ldap protocol", "ldaps");
                env.put("java.naming.security.protocol", "ssl");
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", userDN);
                env.put("java.naming.security.credentials", userPwd);
                env.put("java.naming.ldap.factory.socket", "sanproject.sn2.base.authentication.module.external.common.SJbaseCustomSocketFactory");
                ldapContext = new InitialLdapContext(env, null);
            } else {
                ldapContext = new InitialLdapContext(env, null);
                if (ldapConf.getProtocol().equalsIgnoreCase("starttls")) {
                    logger.info(module, method, "check ldap protocol", "starttls");
                    StartTlsResponse tls = (StartTlsResponse)ldapContext.extendedOperation(new StartTlsRequest());
                    SSLSocketFactory sslSocketFactory = SJbaseCustomSocketFactory.getDefault();
                    logger.info(module, method, "try the TLS negotiation", "");
                    tls.negotiate(sslSocketFactory);
                }
                ldapContext.addToEnvironment("java.naming.security.authentication", "simple");
                ldapContext.addToEnvironment("java.naming.security.principal", userDN);
                ldapContext.addToEnvironment("java.naming.security.credentials", userPwd);
                logger.info(module, method, "try the reconnection", "");
                ldapContext.reconnect(null);
            }
            authSuccess = true;
        }
        finally {
            if (!authSuccess && ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {}
                ldapContext = null;
            }
        }
        logger.info(module, method, "", "end");
        return ldapContext;
    }

    public static String escapeGroupStr(String str) {
        String result = null;
        if (str != null) {
            result = str;
            for (int i = 0; i < escape.length; ++i) {
                result = result.replace(escape[i][0], escape[i][1]);
            }
        }
        return result;
    }
}

