/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.util.HashMap;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalConst;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseRadiusConfigurationFactory
extends SJbaseConfigurationFactory
implements SJbaseExternalConst {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseRadiusConfigurationFactory";
    public static final String PROTOCOL = "protocol";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String RETRY_TIMES = "retry.times";
    public static final String TIMEOUT = "timeout";
    public static final String RADIUS_BASE = "auth.radius";
    public static final String RADIUS_ATTR = "attr";
    public static final String RADIUS_SECRET = "secret";
    public static final String GRP_MAPPING = "auth.group.mapping";

    public SJbaseRadiusConfigurationFactory() {
    }

    public SJbaseRadiusConfigurationFactory(Properties properties) {
        super(properties);
    }

    public SJbaseRadiusConfiguration[] getConfigurations() {
        SJbaseRadiusConfiguration[] configs;
        String method = "getConfigurations";
        logger.info(module, method, "", "start");
        if (this.properties == null) {
            logger.info(module, method, "check the configuration file object ", "object does not exist");
            configs = new SJbaseRadiusConfiguration[]{};
        } else {
            String serverList = this.properties.getProperty("auth.server.name");
            if (serverList == null || serverList.length() == 0) {
                logger.info(module, method, "check the server name", "invlaid");
                configs = new SJbaseRadiusConfiguration[]{};
            } else {
                String[] serverListArry = serverList.split(",");
                configs = new SJbaseRadiusConfiguration[serverListArry.length];
                for (int i = 0; i < serverListArry.length; ++i) {
                    String tmpServerName = serverListArry[i];
                    logger.info(module, method, "start to construct the configuration object", tmpServerName + ":[" + i + "]");
                    SJbaseRadiusConfiguration tmpConf = new SJbaseRadiusConfiguration();
                    this.setServerName(tmpConf, tmpServerName);
                    this.setRadiusProtocol(tmpConf, tmpServerName);
                    this.setHost(tmpConf, tmpServerName);
                    this.setPort(tmpConf, tmpServerName);
                    this.setTimeout(tmpConf, tmpServerName);
                    this.setRetryTimes(tmpConf, tmpServerName);
                    this.setRadiusAttributes(tmpConf, tmpServerName);
                    this.setRadiusSecret(tmpConf, tmpServerName);
                    this.setGrpMapping(tmpConf, tmpServerName);
                    configs[i] = tmpConf;
                }
            }
        }
        logger.info(module, method, "", "end");
        return configs;
    }

    public void setServerName(SJbaseRadiusConfiguration conf, String serverName) {
        String method = "setServerName";
        logger.info(module, method, "", "start");
        if (serverName == null || serverName.length() == 0) {
            logger.info(module, method, "the value is invalid", "server name");
            conf.setServerErrCode(10);
        } else {
            conf.setServerName(serverName);
        }
    }

    public void setRadiusSecret(SJbaseRadiusConfiguration conf, String serverName) {
        String method = "setRadiusSecret";
        logger.info(module, method, "", "start");
        String tmpSecret = this.properties.getProperty("auth.radius." + serverName + "." + RADIUS_SECRET);
        if (tmpSecret == null || tmpSecret.length() == 0) {
            logger.info(module, method, "the value is invalid", RADIUS_SECRET);
            conf.setServerErrCode(10);
        } else {
            conf.setSecret(tmpSecret.getBytes());
        }
        logger.info(module, method, "", "end");
    }

    public void setRadiusProtocol(SJbaseRadiusConfiguration conf, String serverName) {
        String method = "setRadiusProtocol";
        logger.info(module, method, "", "start");
        String tmpProtocol = this.properties.getProperty("auth.radius." + serverName + "." + PROTOCOL);
        if (tmpProtocol != null && (tmpProtocol.equalsIgnoreCase("PAP") || tmpProtocol.equalsIgnoreCase("CHAP"))) {
            conf.setProtocol(tmpProtocol);
        } else {
            logger.info(module, method, "the value is invalid", PROTOCOL);
            conf.setServerErrCode(10);
        }
        logger.info(module, method, "", "end");
    }

    public void setHost(SJbaseRadiusConfiguration conf, String serverName) {
        String method = "setHost";
        logger.info(module, method, "", "start");
        String tmpHost = this.properties.getProperty("auth.radius." + serverName + "." + HOST);
        if (tmpHost == null || tmpHost.length() == 0) {
            logger.info(module, method, "the value is invalid", "host name");
            conf.setServerErrCode(10);
        } else {
            conf.setHost(tmpHost);
        }
        logger.info(module, method, "", "end");
    }

    public void setPort(SJbaseRadiusConfiguration conf, String serverName) {
        int tmpPort;
        String method = "setPort";
        logger.info(module, method, "", "start");
        try {
            tmpPort = Integer.parseInt(this.properties.getProperty("auth.radius." + serverName + "." + PORT));
            if (tmpPort < 1 || tmpPort > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "port number");
            tmpPort = 1812;
        }
        logger.info(module, method, "", "end");
        conf.setPort(tmpPort);
    }

    public void setTimeout(SJbaseRadiusConfiguration conf, String serverName) {
        String method = "setTimeout";
        logger.info(module, method, "", "start");
        int tmpTimeout = 10;
        try {
            tmpTimeout = Integer.parseInt(this.properties.getProperty("auth.radius." + serverName + "." + TIMEOUT));
            if (tmpTimeout < 1 || tmpTimeout > 120) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", TIMEOUT);
            tmpTimeout = 10;
        }
        conf.setTimeout(tmpTimeout);
        logger.info(module, method, "", "end");
    }

    public void setRetryTimes(SJbaseRadiusConfiguration conf, String serverName) {
        String method = "setRetryTimes";
        logger.info(module, method, "", "start");
        int tmpRetryTimes = 3;
        try {
            tmpRetryTimes = Integer.parseInt(this.properties.getProperty("auth.radius." + serverName + "." + RETRY_TIMES));
            if (tmpRetryTimes < 0 || tmpRetryTimes > 50) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "retry times");
            tmpRetryTimes = 3;
        }
        conf.setRetryTimes(tmpRetryTimes);
        logger.info(module, method, "", "end");
    }

    public void setRadiusAttributes(SJbaseRadiusConfiguration conf, String serverName) {
        String method = "setRadiusAttributes";
        logger.info(module, method, "", "start");
        HashMap<String, String> tmpAttributes = new HashMap<String, String>();
        for (int j = 0; j < RADIUS_ATTRS.length; ++j) {
            String tmpValue = this.properties.getProperty("auth.radius." + serverName + "." + RADIUS_ATTR + "." + RADIUS_ATTRS[j]);
            if (tmpValue == null || tmpValue.length() <= 0) continue;
            tmpAttributes.put(RADIUS_ATTRS[j], tmpValue);
        }
        conf.setAttributes(tmpAttributes);
        logger.info(module, method, "", "end");
    }

    public void setGrpMapping(SJbaseRadiusConfiguration conf, String serverName) {
        String method = "setGrpMapping";
        logger.info(module, method, "", "start");
        String tmpGrpMapping = this.properties.getProperty(GRP_MAPPING);
        if (tmpGrpMapping == null || tmpGrpMapping.length() == 0) {
            logger.info(module, method, "the value is invalid", "GroupMapping");
            conf.setGrpMapping("false");
        } else {
            conf.setGrpMapping(tmpGrpMapping);
        }
        logger.info(module, method, "", "end");
    }
}

