/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadUtils;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusAttribute;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseUnsupportedAttributeException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseRadiusPacket {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseRadiusPacket";
    public static final int ACCESS_REQUEST = 1;
    public static final int ACCESS_ACCEPT = 2;
    public static final int ACCESS_REJECT = 3;
    public static final int ACCESS_CHALLENGE = 11;
    public static final int MIN_LENGTH = 20;
    public static final int MAX_LENGTH = 4096;
    protected int code;
    protected byte id;
    protected int length = 20;
    protected byte[] authenticator;
    protected List<SJbaseRadiusAttribute> attrList = new LinkedList<SJbaseRadiusAttribute>();
    protected Map<String, List<SJbaseRadiusAttribute>> attrMap = new HashMap<String, List<SJbaseRadiusAttribute>>();

    protected SJbaseRadiusPacket() {
    }

    public SJbaseRadiusPacket(int code) {
        this.code = code;
        this.id = SJbaseRadUtils.generateId();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public byte[] getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(byte[] authenticator) {
        this.authenticator = authenticator;
    }

    public void putAttribute(SJbaseRadiusAttribute attr) {
        this.attrList.add(attr);
        List<SJbaseRadiusAttribute> attrSubList = this.attrMap.get(attr.getName());
        if (attrSubList == null) {
            attrSubList = new ArrayList<SJbaseRadiusAttribute>();
        }
        attrSubList.add(attr);
        this.attrMap.put(attr.getName(), attrSubList);
        this.length += attr.getLength();
    }

    public void putAttributes(Map<String, String> attributes) {
        String method = "putAttributes";
        logger.info(module, method, "", "start");
        for (String name : attributes.keySet()) {
            String value = attributes.get(name);
            try {
                this.putAttribute(SJbaseRadiusAttribute.create(name, value));
            }
            catch (SJbaseUnsupportedAttributeException e) {
                logger.info(module, method, "", "", e);
            }
        }
        logger.info(module, method, "", "end");
    }

    public SJbaseRadiusAttribute getAttribute(String name) {
        SJbaseRadiusAttribute[] attrAry = this.getAttributes(name);
        SJbaseRadiusAttribute attr = null;
        if (attrAry.length != 0) {
            attr = attrAry[0];
        }
        return attr;
    }

    public SJbaseRadiusAttribute[] getAttributes(String name) {
        List<SJbaseRadiusAttribute> attrSubList = this.attrMap.get(name);
        SJbaseRadiusAttribute[] attrAry = attrSubList == null ? new SJbaseRadiusAttribute[]{} : attrSubList.toArray(new SJbaseRadiusAttribute[0]);
        return attrAry;
    }

    public SJbaseRadiusAttribute[] getAttributes() {
        return this.attrList.toArray(new SJbaseRadiusAttribute[0]);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public byte[] toBytes() {
        String method = "toBytes";
        logger.info(module, method, "", "start");
        ByteBuffer packet = ByteBuffer.allocate(this.length);
        packet.put((byte)this.code);
        packet.put(this.id);
        packet.putShort((short)this.length);
        packet.put(this.authenticator);
        Iterator<SJbaseRadiusAttribute> attrIte = this.attrList.iterator();
        while (attrIte.hasNext()) {
            packet.put(attrIte.next().toBytes());
        }
        logger.info(module, method, "", "end");
        return packet.array();
    }
}

