/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadUtils;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusAttribute;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseUserPasswordAttr
extends SJbaseRadiusAttribute {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseUserPasswordAttr";
    public static final int TYPE = 2;

    private SJbaseUserPasswordAttr(int type, byte[] value) {
        super(type, value);
    }

    public static SJbaseRadiusAttribute create(byte[] password, byte[] secret, byte[] authenticator) {
        byte[] value;
        String method = "create";
        logger.info(module, method, "", "start");
        int sets = (password.length - 1) / 16 + 1;
        if (password.length < 129) {
            value = new byte[sets * 16];
            System.arraycopy(password, 0, value, 0, password.length);
            for (int i = password.length; i < value.length; ++i) {
                value[i] = 0;
            }
        } else {
            value = new byte[128];
            System.arraycopy(password, 0, value, 0, 128);
            sets = 8;
        }
        byte[] md5input = new byte[secret.length + 16];
        System.arraycopy(secret, 0, md5input, 0, secret.length);
        System.arraycopy(authenticator, 0, md5input, secret.length, 16);
        byte[] md5output = SJbaseRadUtils.createMD5(md5input);
        for (int i = 0; i < 16; ++i) {
            value[i] = (byte)(value[i] ^ md5output[i]);
        }
        for (int j = 1; j < sets; ++j) {
            System.arraycopy(value, (j - 1) * 16, md5input, secret.length, 16);
            md5output = SJbaseRadUtils.createMD5(md5input);
            for (int i = 0; i < 16; ++i) {
                int k = j * 16 + i;
                value[k] = (byte)(value[k] ^ md5output[i]);
            }
        }
        logger.info(module, method, "", "end");
        return new SJbaseUserPasswordAttr(2, value);
    }
}

