/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.io.File;
import java.security.KeyStore;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import sanproject.sn2.base.authentication.def.SJbaseHcsConst;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSExpirationCheckTrustManager;
import sanproject.sn2.base.authentication.plugin.def.SJbaseHcsPrincipalMapKey;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.tools.SetExAuthKeyStoreUty;

public class SJbaseHCSHttpsManager {
    private static final String LOG_FUNCTION = "HCS";
    private static final String LOG_TITLE = SJbaseHCSHttpsManager.class.getSimpleName();
    private boolean existAliasHCS = false;
    private String taretKeyStoreName = "";
    private static final SJcLoggerInterface LOGGER = SJcLogUty.getLogger("SN_HCS.log");

    public void init() throws Exception {
        this.initHttpsURLConnection();
    }

    private void initHttpsURLConnection() throws Exception {
        String LOG_SUBTITLE = "initHttpsURLConnection";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "initHttpsURLConnection", "Start.");
        try {
            TrustManager[] trustManager;
            KeyManager[] keyManager;
            block9: {
                keyManager = null;
                trustManager = null;
                if (SJcFileUty.existsAbsolutePath(SJbaseHCSHttpsManager.getKeyStoreName())) {
                    KeyStore keyStore = null;
                    try {
                        keyStore = SetExAuthKeyStoreUty.readKeyStore((String)SJbaseHCSHttpsManager.getKeyStoreName());
                        if (null == keyStore) {
                            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "initHttpsURLConnection", "Cannot read KeyStore.");
                            this.setExistAliasHCS(false);
                            break block9;
                        }
                        this.setExistAliasHCS(SetExAuthKeyStoreUty.containsAlias((KeyStore)keyStore));
                    }
                    catch (Exception ex) {
                        LOGGER.error(LOG_FUNCTION, LOG_TITLE, "initHttpsURLConnection", "Cannot read KeyStore.", ex);
                        this.setExistAliasHCS(false);
                    }
                } else {
                    LOGGER.error(LOG_FUNCTION, LOG_TITLE, "initHttpsURLConnection", "KeyStore is not exist.");
                    this.setExistAliasHCS(false);
                }
            }
            if (this.isExistAliasHCS()) {
                this.setTaretKeyStoreName(SJbaseHCSHttpsManager.getKeyStoreName());
            } else {
                this.setTaretKeyStoreName(SJbaseHCSHttpsManager.getDummyKeyStoreName());
            }
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "initHttpsURLConnection", "isExistAliasHCS():" + this.isExistAliasHCS() + " KeyStore:" + this.getTaretKeyStoreName());
            this.setDefaultHostnameVerifier();
            keyManager = this.getKeyManagerLoadCerts();
            trustManager = this.isExistAliasHCS() ? this.getTrustManagerAllowLoadCerts() : this.getTrustManagerAllowAllCerts();
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(keyManager, trustManager, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "initHttpsURLConnection", "Exception occured.", ex);
            throw ex;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "initHttpsURLConnection", "End.");
    }

    private void setDefaultHostnameVerifier() {
        String LOG_SUBTITLE = "setDefaultHostnameVerifier";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setDefaultHostnameVerifier", "Start.");
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                LOGGER.warn(SJbaseHCSHttpsManager.LOG_FUNCTION, LOG_TITLE, "setDefaultHostnameVerifier", "verify() is call backed. requst host:" + hostname + " peer host:" + sslSession.getPeerHost());
                if (!SJbaseHCSHttpsManager.this.isExistAliasHCS()) {
                    LOGGER.warn(SJbaseHCSHttpsManager.LOG_FUNCTION, LOG_TITLE, "setDefaultHostnameVerifier", "isExistAliasHCS():" + SJbaseHCSHttpsManager.this.isExistAliasHCS());
                    return true;
                }
                Map map = SJbaseHCSHttpsManager.this.getPeerPrincipal(sslSession);
                if (null == map) {
                    LOGGER.error(SJbaseHCSHttpsManager.LOG_FUNCTION, LOG_TITLE, "setDefaultHostnameVerifier", "PeerPrincipal is null.");
                    return false;
                }
                if (((String)map.get(SJbaseHcsPrincipalMapKey.CN.getKey())).equals(hostname)) {
                    return true;
                }
                LOGGER.error(SJbaseHCSHttpsManager.LOG_FUNCTION, LOG_TITLE, "setDefaultHostnameVerifier", "CN:" + (String)map.get(SJbaseHcsPrincipalMapKey.CN.getKey()) + " hostname:" + hostname);
                return false;
            }
        });
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setDefaultHostnameVerifier", "End");
    }

    private Map<String, String> getPeerPrincipal(SSLSession sslSession) {
        String LOG_SUBTITLE = "getPeerPrincipal";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getPeerPrincipal", "Start.");
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Principal principal = sslSession.getPeerPrincipal();
            String issuerDn = principal.toString();
            String[] dns = issuerDn.split(",");
            for (int i = 0; i < dns.length; ++i) {
                String[] item = dns[i].split("=");
                map.put(item[0], item[1]);
            }
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getPeerPrincipal", "Exception occured.", ex);
            return null;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getPeerPrincipal", "End");
        return map;
    }

    private KeyManager[] getKeyManagerLoadCerts() throws Exception {
        String LOG_SUBTITLE = "getKeyManagerLoadCerts";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getKeyManagerLoadCerts", "Start.");
        KeyManager[] keyManager = null;
        String storeName = this.getTaretKeyStoreName();
        char[] storePass = "erotsyekonnomearodotonnak".toCharArray();
        try {
            KeyStore keyStore = SetExAuthKeyStoreUty.readKeyStore((String)storeName);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getKeyManagerLoadCerts", "KeyManagerFactory DefaultAlgorithm:" + KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, storePass);
            keyManager = keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getKeyManagerLoadCerts", "storeName:" + storeName, ex);
            throw ex;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getKeyManagerLoadCerts", "End.");
        return keyManager;
    }

    public TrustManager[] getTrustManagerAllowAllCerts() throws Exception {
        String LOG_SUBTITLE = "getTrustManagerAllowAllCerts";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getTrustManagerAllowAllCerts", "Start.");
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            return trustManagerArray;
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getTrustManagerAllowAllCerts", "Exception occured. ", ex);
            throw ex;
        }
        finally {
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getTrustManagerAllowAllCerts", "End.");
        }
    }

    private TrustManager[] getTrustManagerAllowLoadCerts() throws Exception {
        String LOG_SUBTITLE = "getTrustManagerAllowLoadCerts";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getTrustManagerAllowLoadCerts", "Start.");
        X509TrustManager x509TrustManager = null;
        SJbaseHCSExpirationCheckTrustManager expChkTrustManager = null;
        TrustManager[] trustManager = null;
        String storeName = this.getTaretKeyStoreName();
        try {
            KeyStore keyStore = SetExAuthKeyStoreUty.readKeyStore((String)storeName);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getTrustManagerAllowLoadCerts", "TrustManagerFactory DefaultAlgorithm:" + TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            trustManager = trustManagerFactory.getTrustManagers();
            x509TrustManager = (X509TrustManager)trustManager[0];
            expChkTrustManager = new SJbaseHCSExpirationCheckTrustManager(x509TrustManager);
            trustManager[0] = expChkTrustManager;
        }
        catch (Exception ex) {
            LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getTrustManagerAllowLoadCerts", "storeName:" + storeName, ex);
            throw ex;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getTrustManagerAllowLoadCerts", "End.");
        return trustManager;
    }

    private static String getKeyStoreName() {
        String LOG_SUBTITLE = "getKeyStoreName";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getKeyStoreName", "Start.");
        String storeName = null;
        StringBuilder builder = new StringBuilder();
        builder.append(SJbaseHcsConst.SN_HCS_KEY_STORE_PATH);
        builder.append(File.separator);
        builder.append("HcsExternalAuth.keystore");
        storeName = builder.toString();
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getKeyStoreName", "End. - storeName:" + storeName);
        return storeName;
    }

    private static String getDummyKeyStoreName() {
        String LOG_SUBTITLE = "getDummyKeyStoreName";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getDummyKeyStoreName", "Start.");
        String storeName = null;
        StringBuilder builder = new StringBuilder();
        builder.append(SJbaseHcsConst.SN_HCS_DUMMY_KEY_STORE_PATH);
        builder.append(File.separator);
        builder.append("dummyHcsExternalAuth.keystore");
        storeName = builder.toString();
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getDummyKeyStoreName", "End. - storeName:" + storeName);
        return storeName;
    }

    private String getTaretKeyStoreName() {
        return this.taretKeyStoreName;
    }

    private void setTaretKeyStoreName(String taretKeyStoreName) {
        this.taretKeyStoreName = taretKeyStoreName;
    }

    private boolean isExistAliasHCS() {
        return this.existAliasHCS;
    }

    private void setExistAliasHCS(boolean existAliasHCS) {
        this.existAliasHCS = existAliasHCS;
    }
}

