/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.UUID;
import sanproject.sn2.base.authentication.SJbaseAuthConst;
import sanproject.sn2.base.authentication.exception.SJbaseHICAuthenticationLocalFailedException;
import sanproject.sn2.base.authentication.exception.SJbaseHICAuthenticationMaxUserException;
import sanproject.sn2.base.authentication.exception.SJbaseHICAuthenticationNoKeyException;
import sanproject.sn2.base.authentication.exception.SJbaseHICAuthenticationNoSessionException;
import sanproject.sn2.base.authentication.exception.SJbaseHICAuthenticationSaveUserInfoFailedException;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.base.authentication.plugin.SJbaseGUMAuthentication;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSAuthentication;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSecureUty;

public class SJbaseHICAuthentication
implements SJbaseAuthenticationModulePluginInterface,
SJbaseAuthConst {
    private static final String LOG_FUNCTION = "HIC Authentication";
    private static final String LOG_TITLE = "SJbaseHICAuthentication";
    private String[] groupIDs = null;
    private String[] roleIDs = null;
    private boolean[] rsgIDs = null;
    private boolean allRsg = false;
    private String globalSessionID = null;
    private String userName = null;
    private String password = null;
    private boolean[] roleMap = null;
    private HashMap<String, Object> HicObject = null;
    private static int MAX_HIC_USER_COUNT = -1;
    private static final String DIR_NAME_AUTH = "tmp" + SJcFileUty.sjc_PathSeparator + "base" + SJcFileUty.sjc_PathSeparator + "auth";
    private static final String DIR_NAME_AUTH_HIC = "hic";
    private static final String DIR_NAME_AUTH_HIC_FULL = DIR_NAME_AUTH + SJcFileUty.sjc_PathSeparator + "hic";
    public static final String AUTHNAME_HIC = "HiCommandSSO";
    public static final String KEY_HCS_EXTAUTH = "SN_HCS_EXTAUTH";
    public static final String HIC_KEY_SESSION_ID = "SESSION_ID";
    public static final String HIC_KEY_USER_ID = "USER_ID";
    public static final String HIC_KEY_GROUP_ID = "GROUP_ID";
    public static final String HIC_KEY_ROLE_ID = "ROLE_ID";
    public static final String HIC_KEY_RSG_ID = "RSG_ID";
    public static final String HIC_KEY_ALL_RSG = "ALL_RSG";
    public static final String HIC_KEY_HDVM_USER_ID = "HDVM_USER_ID";
    public static final String HIC_KEY_HDVM_PASSWORD = "HDVM_PASSWORD";
    public static final String HIC_KEY_PASSWORD = "PASSWORD";
    public static final String HIC_KEY_ROLE_MAP = "ROLE_MAP";
    public static final String HIC_KEY_RSG_MAP = "RSG_MAP";
    public static final String HIC_KEY_HDVMTOKEN = "HDVMTOKEN";
    public static final String HIC_KEY_LOCALIZATION_MODE = "LOCALIZATION_MODE";
    public static final String HIC_KEY_IMAGE_URL = "IMAGE_URL";
    public static final String HIC_KEY_DIRECT_LAUNCH_MODE = "DIRECT_LAUNCH_MODE";
    public static final String HIC_KEY_SUB_MENU_DISABLE = "SUB_MENU_DISABLE";
    public static final String HIC_KEY_HELP_URL = "HELP_URL";
    public static final String HIC_KEY_VERSION = "VERSION";
    public static final String HIC_KEY_INITIAL_WINDOW_ID = "INITIAL_WINDOW_ID";
    public static final String HIC_KEY_INITIAL_SELECTED_OBJECT = "INITIAL_SELECTED_OBJECT";
    public static final String HIC_KEY_SINFO_SCREEN_ID = "SCREEN_INFO_SCREEN_ID";
    public static final String HIC_KEY_SINFO_SELECTED_OBJECT = "SCREEN_INFO_SELECTED_OBJECT";

    @Override
    public int authentication(String szUserName, String szPassword) {
        String LOG_SUBTITLE = "authentication";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authentication", "Start. - szUserName:" + szUserName);
        int ret = 6;
        String hashOnetimeKey = SJcSecureUty.getHashValueStringHex(szPassword);
        String[] filenames = SJcFileUty.getFileList(DIR_NAME_AUTH_HIC_FULL);
        String targetFilename = null;
        if (null != filenames) {
            for (int i = 0; i < filenames.length; ++i) {
                if (null == filenames[i] || !filenames[i].startsWith(hashOnetimeKey)) continue;
                targetFilename = filenames[i];
                break;
            }
        }
        if (null != targetFilename) {
            String userId;
            HashMap<String, Object> userInfoMap = SJbaseHICAuthentication.readEncryptedFile(targetFilename);
            if (null != userInfoMap && null != (userId = (String)userInfoMap.get(HIC_KEY_USER_ID)) && userId.equals(szUserName)) {
                ret = 0;
                this.globalSessionID = UUID.randomUUID().toString().replaceAll("-", "");
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authentication", "globalSessionID:" + this.globalSessionID);
                this.groupIDs = (String[])userInfoMap.get(HIC_KEY_GROUP_ID);
                this.userName = (String)userInfoMap.get(HIC_KEY_USER_ID);
                this.password = (String)userInfoMap.get(HIC_KEY_PASSWORD);
                this.roleMap = (boolean[])userInfoMap.get(HIC_KEY_ROLE_MAP);
                this.rsgIDs = (boolean[])userInfoMap.get(HIC_KEY_RSG_MAP);
                Boolean allRsgFlag = (Boolean)userInfoMap.get(HIC_KEY_ALL_RSG);
                if (allRsgFlag != null) {
                    this.allRsg = allRsgFlag;
                }
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "authentication", "GROUP_ID:" + this.groupIDs);
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "authentication", "USER_ID:" + this.userName);
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "authentication", "ROLE_MAP:" + Arrays.toString(this.roleMap));
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "authentication", "RSG_ID:" + Arrays.toString(this.rsgIDs));
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "authentication", "ALL_RSG:" + this.allRsg);
                this.HicObject = userInfoMap;
            }
            SJcFileUty.deleteFile(DIR_NAME_AUTH_HIC_FULL, targetFilename);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authentication", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public String getAuthSystemName(String szSystem) {
        String LOG_SUBTITLE = "getAuthSystemName";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAuthSystemName", "Start. - szSystem:" + szSystem);
        String authSystemName = null;
        InetAddress in = null;
        try {
            in = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (in == null) {
            authSystemName = "HiCommandSSO_";
            return authSystemName;
        }
        String localAddress = in.getHostAddress();
        authSystemName = "HiCommandSSO_" + localAddress;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAuthSystemName", "End. - ret:" + authSystemName);
        return authSystemName;
    }

    @Override
    public String[] getGroupID() {
        String LOG_SUBTITLE = "getGroupID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getGroupID", "Start.");
        String[] ret = this.groupIDs;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getGroupID", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public String getSessionID() {
        String LOG_SUBTITLE = "getSessionID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getSessionID", "Start.");
        String ret = this.globalSessionID;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getSessionID", "End. - ret:" + ret);
        return ret;
    }

    public static String registUserInfo(HashMap<String, Object> obj) throws SJcException {
        int count;
        String LOG_SUBTITLE = "registUserInfo";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "registUserInfo", "Start.");
        String[] filenames = SJcFileUty.getFileList(DIR_NAME_AUTH_HIC_FULL);
        int n = count = null != filenames ? filenames.length : 0;
        if (count >= SJbaseHICAuthentication.getMaxHICUserCount()) {
            throw new SJbaseHICAuthenticationMaxUserException("107094");
        }
        String user = (String)obj.get(HIC_KEY_USER_ID);
        String pass = (String)obj.get(HIC_KEY_PASSWORD);
        String hdvmToken = (String)obj.get(HIC_KEY_HDVMTOKEN);
        if (hdvmToken != null) {
            pass = hdvmToken;
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "registUserInfo", "HDvM Token is specified. Token = " + hdvmToken);
        }
        SJbaseAuthenticationModulePluginInterface authLocal = null;
        boolean authFlg = SJcEnvUty.getProperty2boolean(KEY_HCS_EXTAUTH);
        if (authFlg) {
            authLocal = new SJbaseHCSAuthentication();
        } else {
            int hcsSsoOption = 0;
            if (hdvmToken != null) {
                hcsSsoOption = 1;
            }
            authLocal = new SJbaseGUMAuthentication(hcsSsoOption);
        }
        int authResult = authLocal.authentication(user, pass);
        if (0 != authResult) {
            throw new SJbaseHICAuthenticationLocalFailedException("107095");
        }
        obj.put(HIC_KEY_USER_ID, authLocal.getUserName());
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "registUserInfo", "USER_ID:" + authLocal.getUserName());
        obj.put(HIC_KEY_PASSWORD, authLocal.getPassword());
        boolean[] valRoleMap = authLocal.getRoleMap();
        obj.put(HIC_KEY_ROLE_MAP, valRoleMap);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "registUserInfo", "ROLE_MAP:" + Arrays.toString(valRoleMap));
        boolean[] valResourceGrpMap = authLocal.getResourceGrpMap();
        obj.put(HIC_KEY_RSG_MAP, valResourceGrpMap);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "registUserInfo", "RSG_MAP:" + Arrays.toString(valResourceGrpMap));
        obj.put(HIC_KEY_ALL_RSG, authLocal.isAllRSG());
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "registUserInfo", "ALL_RSG:" + authLocal.isAllRSG());
        obj.put(HIC_KEY_GROUP_ID, authLocal.getGroupID());
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "registUserInfo", "GROUP_ID:" + authLocal.getGroupID());
        obj.remove(HIC_KEY_ROLE_ID);
        obj.remove(HIC_KEY_RSG_ID);
        String onetimeKey = UUID.randomUUID().toString();
        String hashOnetimeKey = SJcSecureUty.getHashValueStringHex(onetimeKey);
        String sessionId = (String)obj.get(HIC_KEY_SESSION_ID);
        String filename = hashOnetimeKey + sessionId;
        try {
            ByteArrayOutputStream boStream = new ByteArrayOutputStream();
            ObjectOutputStream oStream = new ObjectOutputStream(boStream);
            oStream.writeObject(obj);
            byte[] objBytes = boStream.toByteArray();
            byte[] encObjBytes = SJcSecureUty.encryptByte(objBytes);
            SJcFileUty.saveBinary(DIR_NAME_AUTH_HIC_FULL, filename, encObjBytes, 0);
        }
        catch (Exception e) {
            throw new SJbaseHICAuthenticationSaveUserInfoFailedException("107097");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "registUserInfo", "End. - ret:" + onetimeKey);
        return onetimeKey;
    }

    public static HashMap<String, Object> getUserInfo(String key) throws SJcException {
        String LOG_SUBTITLE = "getUserInfo";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getUserInfo", "Start. - key:" + key);
        String hashOnetimeKey = SJcSecureUty.getHashValueStringHex(key);
        String[] filenames = SJcFileUty.getFileList(DIR_NAME_AUTH_HIC_FULL);
        String targetFilename = null;
        if (null != filenames) {
            for (int i = 0; i < filenames.length; ++i) {
                if (null == filenames[i] || !filenames[i].startsWith(hashOnetimeKey)) continue;
                targetFilename = filenames[i];
            }
        }
        if (null == targetFilename) {
            throw new SJbaseHICAuthenticationNoKeyException("107098");
        }
        HashMap<String, Object> ret = SJbaseHICAuthentication.readEncryptedFile(targetFilename);
        if (null == ret) {
            throw new SJbaseHICAuthenticationNoKeyException("107099");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getUserInfo", "End.");
        return ret;
    }

    public static HashMap<String, Object> getScreenInfo(String sessionId) throws SJcException {
        String LOG_SUBTITLE = "getScreenInfo";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getScreenInfo", "Start. - sessionId:" + sessionId);
        String[] filenames = SJcFileUty.getFileList(DIR_NAME_AUTH_HIC_FULL);
        String targetFilename = null;
        if (null != filenames) {
            for (int i = 0; i < filenames.length; ++i) {
                if (null == filenames[i] || !filenames[i].endsWith(sessionId)) continue;
                targetFilename = filenames[i];
            }
        }
        if (null == targetFilename) {
            throw new SJbaseHICAuthenticationNoSessionException("107100");
        }
        HashMap<String, Object> userInfoMap = SJbaseHICAuthentication.readEncryptedFile(targetFilename);
        if (null == userInfoMap) {
            throw new SJbaseHICAuthenticationNoSessionException("107101");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(HIC_KEY_SINFO_SCREEN_ID, (String)userInfoMap.get(HIC_KEY_INITIAL_WINDOW_ID));
        ret.put(HIC_KEY_SINFO_SELECTED_OBJECT, (String)userInfoMap.get(HIC_KEY_INITIAL_SELECTED_OBJECT));
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getScreenInfo", "End.");
        return ret;
    }

    private static HashMap<String, Object> readEncryptedFile(String filename) {
        HashMap ret = null;
        String LOG_SUBTITLE = "readEncryptedFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "readEncryptedFile", "Start. - filename:" + filename);
        try {
            byte[] readBytes = SJcFileUty.loadBinary(DIR_NAME_AUTH_HIC_FULL, filename, 0, -1);
            byte[] decryptBytes = SJcSecureUty.decryptByte(readBytes);
            ByteArrayInputStream biStream = new ByteArrayInputStream(decryptBytes);
            ObjectInputStream iStream = new ObjectInputStream(biStream);
            Object sObj = iStream.readObject();
            ret = (HashMap)sObj;
        }
        catch (Exception e) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "readEncryptedFile", "Failed to read binary file.");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "readEncryptedFile", "End.");
        return ret;
    }

    private static int getMaxHICUserCount() {
        String LOG_SUBTITLE = "getMaxHICUserCount";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getMaxHICUserCount", "Start.");
        if (-1 == MAX_HIC_USER_COUNT) {
            MAX_HIC_USER_COUNT = SJcEnvUty.getProperty2int("SN_Base_MaxHICUser", 1000);
        }
        int ret = MAX_HIC_USER_COUNT;
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getMaxHICUserCount", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public String getUserName() {
        String LOG_SUBTITLE = "getuserName";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getuserName", "Start.");
        String useName = this.userName;
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getuserName", "End. - ret:" + useName);
        return useName;
    }

    @Override
    public HashMap getAuthObject() {
        String LOG_SUBTITLE = "getAuthObject";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getAuthObject", "Start.");
        HashMap<String, Object> retHicObject = this.HicObject;
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getAuthObject", "End.");
        return retHicObject;
    }

    @Override
    public String[] getRoleID() {
        String LOG_SUBTITLE = "getRoleID";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getRoleID", "Start.");
        String[] ret = this.roleIDs;
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getRoleID", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public boolean[] getResourceGrpMap() {
        String LOG_SUBTITLE = "getResouecrGrpMap";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getResouecrGrpMap", "Start.");
        boolean[] ret = this.rsgIDs;
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getResouecrGrpMap", "End. - ret:" + ret);
        return ret;
    }

    @Override
    public boolean isAllRSG() {
        String LOG_SUBTITLE = "isAllRSG";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "isAllRSG", "Start.");
        boolean ret = this.allRsg;
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "isAllRSG", "End. - ret:" + ret);
        return ret;
    }

    private boolean[] bitset2boolean(BitSet bitset) {
        boolean[] result = null;
        if (bitset != null) {
            result = new boolean[1024];
            for (int i = 0; i < 1024; ++i) {
                result[i] = bitset.get(i);
            }
        }
        return result;
    }

    @Override
    public boolean[] getRoleMap() {
        return this.roleMap;
    }

    @Override
    public String getPassword() {
        return this.password;
    }
}

