/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.com.utility.Logger.SJcAuditLogger;
import sanproject.sn2.com.utility.Logger.SJcLogger;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcCustomLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcInstanceCreateUty;

public class SJcLogUty {
    private static final String LOG_FILE_PATH_DEFAULT = "SN_Log.log";
    private static final String LOG_FILE_PATH_CLIENT = "Client.log";
    private static final int SN_LOG_SIZE_DEFAULT = 10;
    private static final int SN_LOG_SIZE_CUSTOM_DEFAULT = 10;
    private static final int SN_LOG_SIZE_CLIENT_DEFAULT = 10;
    private static final int SN_LOG_COUNT_DEFAULT = 12;
    private static final int SN_LOG_COUNT_CUSTOM_DEFAULT = 12;
    private static final int SN_LOG_COUNT_CLIENT_DEFAULT = 12;
    private static final int SLF4J_LOG_COUNT_MAX = 12;
    private static final String LOG_FUNCTION = "SJcLogUty";
    private static final String LOG_TITLE = "SJcLogUty";
    public static final int ERROR = 40000;
    public static final int WARN = 30000;
    public static final int INFO = 20000;
    public static final int DEBUG = 10000;
    public static final int TRACE = 5000;
    public static final String ERROR_STR = "ERROR";
    public static final String WARN_STR = "WARN";
    public static final String INFO_STR = "INFO";
    public static final String DEBUG_STR = "DEBUG";
    public static final String TRACE_STR = "TRACE";

    private SJcLogUty() {
    }

    private static synchronized SJcCustomLoggerInterface getLogger(String path, int logSize, int logCount) {
        SJcLogger logger = new SJcLogger(path, logSize, logCount);
        return logger;
    }

    public static SJcLoggerInterface getLogger() {
        int logCount;
        int logSize = SJcEnvUty.getProperty2int("SN_Log_Size", 10);
        if (logSize < 0) {
            logSize = 10;
        }
        if ((logCount = SJcEnvUty.getProperty2int("SN_Log_Count", 12)) < 0) {
            logCount = 12;
        } else if (12 < logCount) {
            logCount = 12;
        }
        return SJcLogUty.getLogger(LOG_FILE_PATH_DEFAULT, logSize, logCount);
    }

    public static SJcCustomLoggerInterface getLogger(String fileName) {
        int logCount;
        if (fileName == null || fileName.length() == 0) {
            return (SJcCustomLoggerInterface)SJcLogUty.getLogger();
        }
        int logSize = SJcEnvUty.getProperty2int("SN_Log_Size_Custom", 10);
        if (logSize < 0) {
            logSize = 10;
        }
        if ((logCount = SJcEnvUty.getProperty2int("SN_Log_Count_Custom", 12)) < 0) {
            logCount = 12;
        } else if (12 < logCount) {
            logCount = 12;
        }
        return SJcLogUty.getLogger(fileName, logSize, logCount);
    }

    public static SJcCustomLoggerInterface getClientLogger() {
        int logCount;
        int logSize = SJcEnvUty.getProperty2int("SN_Log_Size_Client", 10);
        if (logSize < 0) {
            logSize = 10;
        }
        if ((logCount = SJcEnvUty.getProperty2int("SN_Log_Count_Client", 12)) < 0) {
            logCount = 12;
        } else if (12 < logCount) {
            logCount = 12;
        }
        return SJcLogUty.getLogger(LOG_FILE_PATH_CLIENT, logSize, logCount);
    }

    public static SJcAuditLoggerInterface getAuditLogger() {
        return SJcLogUty.getAuditLoggerObj(null);
    }

    public static SJcAuditLoggerInterface getAuditLogger(SJbaseUserSessionInterfaceInternal us) {
        return SJcLogUty.getAuditLoggerObj(us);
    }

    private static SJcAuditLoggerInterface getAuditLoggerObj(SJbaseUserSessionInterfaceInternal us) {
        String LOG_SUBTITLE = "getAuditLoggerObj";
        SJcAuditLoggerInterface obj = null;
        SJcLogUty.getLogger().trace("SJcLogUty", "SJcLogUty", LOG_SUBTITLE, "Start. -us:" + us);
        String loggerClass = SJcEnvUty.getProperty("SN_Base_AuditLoggerClass");
        if (loggerClass == null) {
            SJcLogUty.getLogger().error("SJcLogUty", "SJcLogUty", LOG_SUBTITLE, "Not Set AuditLoggerClassPath.");
            obj = new SJcAuditLogger();
        } else {
            try {
                Class<?> cla = Class.forName(loggerClass);
                obj = (SJcAuditLoggerInterface)SJcInstanceCreateUty.newInstance(cla);
            }
            catch (ClassNotFoundException cnfe) {
                SJcLogUty.getLogger().error("SJcLogUty", "SJcLogUty", LOG_SUBTITLE, "Not Find AuditLoggerClass. ex:", cnfe);
                obj = new SJcAuditLogger();
            }
            catch (ClassCastException cce) {
                SJcLogUty.getLogger().error("SJcLogUty", "SJcLogUty", LOG_SUBTITLE, "Invalid AuditLoggerClass. ex:", cce);
                obj = new SJcAuditLogger();
            }
        }
        if (us != null) {
            obj.init((SJbaseUserSession)us);
        }
        SJcLogUty.getLogger().trace("SJcLogUty", "SJcLogUty", LOG_SUBTITLE, "End. -return:" + obj);
        return obj;
    }

    public static void putlog(String function, String title, String subtitle, String detail, int level) {
        SJcLoggerInterface logger = SJcLogUty.getLogger();
        logger.putLog(function, title, subtitle, detail, level);
    }

    public static void putlog(String function, String title, String subtitle, String detail, Throwable e, int level) {
        SJcLoggerInterface logger = SJcLogUty.getLogger();
        logger.putLog(function, title, subtitle, detail, e, level);
    }

    public static void trace(String function, String title, String subtitle, String detail) {
        SJcLogUty.putlog(function, title, subtitle, detail, 5000);
    }

    public static void trace(String function, String title, String subtitle, String detail, Throwable ex) {
        SJcLogUty.putlog(function, title, subtitle, detail, ex, 5000);
    }

    public static void debug(String function, String title, String subtitle, String detail) {
        SJcLogUty.putlog(function, title, subtitle, detail, 10000);
    }

    public static void debug(String function, String title, String subtitle, String detail, Throwable ex) {
        SJcLogUty.putlog(function, title, subtitle, detail, ex, 10000);
    }

    public static void info(String function, String title, String subtitle, String detail) {
        SJcLogUty.putlog(function, title, subtitle, detail, 20000);
    }

    public static void info(String function, String title, String subtitle, String detail, Throwable ex) {
        SJcLogUty.putlog(function, title, subtitle, detail, ex, 20000);
    }

    public static void warn(String function, String title, String subtitle, String detail) {
        SJcLogUty.putlog(function, title, subtitle, detail, 30000);
    }

    public static void warn(String function, String title, String subtitle, String detail, Throwable ex) {
        SJcLogUty.putlog(function, title, subtitle, detail, ex, 30000);
    }

    public static void error(String function, String title, String subtitle, String detail) {
        SJcLogUty.putlog(function, title, subtitle, detail, 40000);
    }

    public static void error(String function, String title, String subtitle, String detail, Throwable ex) {
        SJcLogUty.putlog(function, title, subtitle, detail, ex, 40000);
    }

    public static void startLogTask() {
    }

    public static void finishLogTask() {
    }

    public static int getLevel_int(String level) {
        int result = 20000;
        return result;
    }
}

