/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcStringUty {
    private static final String LOG_FUNCTION = "String Utility";
    private static final String LOG_TITLE = "SJcStringUty";
    private static HashMap<Character, String> ESCAPE_LIST = new HashMap();

    public static String byteToHexString(byte[] byteArray) {
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        String LOG_SUBTYTLE = "byteToHexString";
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "byteToHexString", "Start.");
        if (null == byteArray) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "byteToHexString", "Parameter is null.");
            return null;
        }
        if (0 >= byteArray.length) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "byteToHexString", "Parameter length is " + byteArray.length + ".");
            return null;
        }
        String ret = SJcStringUty.byteToStr(byteArray);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "byteToHexString", "End.");
        return ret;
    }

    private static String byteToStr(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sb.append(Integer.toHexString(data[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(data[i] & 0xF));
        }
        return sb.toString();
    }

    public static byte[] hexStringToByte(String hexString) {
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        String LOG_SUBTYTLE = "hexStringToByte";
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "hexStringToByte", "Start.");
        if (null == hexString) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "hexStringToByte", "Parameter is null.");
            return null;
        }
        if (!SJcStringUty.isHexFormat(hexString)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "hexStringToByte", "Parameter is invalid: " + hexString);
            return null;
        }
        byte[] ret = SJcStringUty.strToByte(hexString);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "hexStringToByte", "End.");
        return ret;
    }

    private static byte[] strToByte(String hexString) {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        int radix = 16;
        for (int i = 0; i < hexString.length(); i += 2) {
            int intVal = Integer.parseInt(hexString.substring(i, i + 2), radix);
            byteArray.write(intVal);
        }
        return byteArray.toByteArray();
    }

    private static boolean isHexFormat(String hexString) {
        if (0 >= hexString.length()) {
            return false;
        }
        if (0 != hexString.length() % 2) {
            return false;
        }
        Pattern pattern = Pattern.compile("[^a-fA-F0-9]", 2);
        Matcher matcher = pattern.matcher(hexString);
        return !matcher.find();
    }

    public static String filterEscape(String sourceStr) {
        if (sourceStr == null) {
            SJcLogUty.error(LOG_FUNCTION, LOG_TITLE, "filterEscape", "Parameter is null.");
            return null;
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < sourceStr.length(); ++i) {
            char c = sourceStr.charAt(i);
            String escapedChar = ESCAPE_LIST.get(Character.valueOf(c));
            if (escapedChar == null) {
                ret.append(c);
                continue;
            }
            ret.append(escapedChar);
        }
        return ret.toString();
    }

    static {
        ESCAPE_LIST.put(Character.valueOf('<'), "&lt;");
        ESCAPE_LIST.put(Character.valueOf('>'), "&gt;");
        ESCAPE_LIST.put(Character.valueOf('&'), "&amp;");
        ESCAPE_LIST.put(Character.valueOf('\"'), "&quot;");
        ESCAPE_LIST.put(Character.valueOf('\''), "&#39;");
    }
}

