/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.text.SimpleDateFormat;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcUserUniqIDUty;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.account.SJcAccountFileUserInfo;
import sanproject.sn2.com.utility.account.SJcUserInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcFailDataException;

public class SJcUserInfoUty {
    private static final String LOG_FUNCTION = "SJcUserInfoUty";
    private static final String LOG_TITLE = "SJcUserInfoUty";
    private static String szMsg;

    private SJcUserInfoUty() {
    }

    public static synchronized void createUser(String szUserName, int iAuthPtn, String szPassword, String[] szGrpName, int iEnable, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "createUser";
        try {
            szMsg = "Start. <Key = " + szUserName + ">";
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "createUser", szMsg);
            SJcAccountChkUty.chkUserName(szUserName);
            SJcAccountChkUty.chkAuthPtn(iAuthPtn);
            if (iAuthPtn == SJcAccountConst.INT_AUTHPTN_LOCAL) {
                SJcAccountChkUty.chkPassword(szPassword);
            }
            SJcAccountChkUty.chkGrpName(szGrpName);
            SJcAccountChkUty.chkEnable(iEnable);
            if (iAuthPtn == SJcAccountConst.INT_AUTHPTN_LOCAL) {
                SJcAccountFileUserInfo.createUser(szUserName, iAuthPtn, szPassword, szGrpName, iEnable, lRscLockID);
            } else {
                SJcAccountFileUserInfo.createUser(szUserName, iAuthPtn, null, szGrpName, iEnable, lRscLockID);
            }
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "createUser", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "createUser", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "createUser", "End.");
        }
    }

    public static synchronized void setAuthPattern(String szUserName, int iAuthPtn, String szPassword, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "setAuthPattern";
        try {
            szMsg = "Start. <Key = " + szUserName + ">";
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "setAuthPattern", szMsg);
            SJcAccountChkUty.chkUserName(szUserName);
            SJcAccountChkUty.chkAuthPtn(iAuthPtn);
            if (iAuthPtn == SJcAccountConst.INT_AUTHPTN_LOCAL) {
                SJcAccountChkUty.chkPassword(szPassword);
            }
            if (iAuthPtn == SJcAccountConst.INT_AUTHPTN_LOCAL) {
                SJcAccountFileUserInfo.setAuthPattern(szUserName, iAuthPtn, szPassword, lRscLockID);
            } else {
                SJcAccountFileUserInfo.setAuthPattern(szUserName, iAuthPtn, null, lRscLockID);
            }
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "setAuthPattern", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "setAuthPattern", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "setAuthPattern", "End.");
        }
    }

    public static synchronized void addUserGroup(String[] szUserName, String szGrpName, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "addUserGroup";
        try {
            szMsg = "Start. <Key = " + SJcAccountChkUty.chgArray2Str(szUserName) + ">";
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "addUserGroup", szMsg);
            SJcAccountChkUty.chkEmptyException(szUserName);
            SJcAccountChkUty.chkGrpName(szGrpName);
            SJcAccountFileUserInfo.addUserGroup(szUserName, szGrpName, lRscLockID);
        }
        catch (SJcFailDataException e) {
            Object[] szFail = e.getFailData();
            szMsg = "<Key = " + SJcAccountChkUty.chgArray2Str(szFail) + ">";
            SJcLogUty.getLogger().warn("SJcUserInfoUty", "SJcUserInfoUty", "addUserGroup", szMsg);
            SJcLogUty.getLogger().warn("SJcUserInfoUty", "SJcUserInfoUty", "addUserGroup", "SJcFailDataException.", e);
            throw e;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "addUserGroup", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "addUserGroup", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "addUserGroup", "End.");
        }
    }

    public static synchronized void removeUserGroup(String[] szUserName, String szGrpName, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "removeUserGroup";
        try {
            szMsg = "Start. <Key = " + SJcAccountChkUty.chgArray2Str(szUserName) + ">";
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "removeUserGroup", szMsg);
            SJcAccountChkUty.chkEmptyException(szUserName);
            SJcAccountChkUty.chkGrpName(szGrpName);
            SJcAccountFileUserInfo.removeUserGroup(szUserName, szGrpName, lRscLockID);
        }
        catch (SJcFailDataException e) {
            Object[] szFail = e.getFailData();
            szMsg = "<Key = " + SJcAccountChkUty.chgArray2Str(szFail) + ">";
            SJcLogUty.getLogger().warn("SJcUserInfoUty", "SJcUserInfoUty", "removeUserGroup", szMsg);
            SJcLogUty.getLogger().warn("SJcUserInfoUty", "SJcUserInfoUty", "removeUserGroup", "SJcFailDataException.", e);
            throw e;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "removeUserGroup", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "removeUserGroup", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "removeUserGroup", "End.");
        }
    }

    public static synchronized void setPasswordWithCheck(String szUserName, String szNowPassword, String szNewPassword, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "setPasswordWithCheck";
        try {
            szMsg = "Start. <Key = " + szUserName + ">";
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "setPasswordWithCheck", szMsg);
            SJcAccountChkUty.chkUserName(szUserName);
            SJcAccountChkUty.chkPassword(szNowPassword);
            SJcAccountChkUty.chkPassword(szNewPassword);
            SJcAccountFileUserInfo.setPassword(szUserName, szNowPassword, szNewPassword, lRscLockID);
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "setPasswordWithCheck", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "setPasswordWithCheck", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "setPasswordWithCheck", "End.");
        }
    }

    public static synchronized void setPassword(String szUserName, String szNewPassword, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "setPassword";
        try {
            szMsg = "Start. <Key = " + szUserName + ">";
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "setPassword", szMsg);
            SJcAccountChkUty.chkUserName(szUserName);
            SJcAccountChkUty.chkPassword(szNewPassword);
            SJcAccountFileUserInfo.setPassword(szUserName, null, szNewPassword, lRscLockID);
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "setPassword", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "setPassword", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "setPassword", "End.");
        }
    }

    public static synchronized void setEnableDisable(String[] szUserName, boolean bFlg, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "setEnableDisable";
        try {
            szMsg = "Start. <Key = " + SJcAccountChkUty.chgArray2Str(szUserName) + ">";
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "setEnableDisable", szMsg);
            SJcAccountChkUty.chkEmptyException(szUserName);
            SJcAccountFileUserInfo.setEnableDisable(szUserName, bFlg, lRscLockID);
        }
        catch (SJcFailDataException e) {
            Object[] szFail = e.getFailData();
            szMsg = "<Key = " + SJcAccountChkUty.chgArray2Str(szFail) + ">";
            SJcLogUty.getLogger().warn("SJcUserInfoUty", "SJcUserInfoUty", "setEnableDisable", szMsg);
            SJcLogUty.getLogger().warn("SJcUserInfoUty", "SJcUserInfoUty", "setEnableDisable", "SJcFailDataException.", e);
            throw e;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "setEnableDisable", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "setEnableDisable", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "setEnableDisable", "End.");
        }
    }

    public static synchronized void deleteUser(String[] szUserName, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "deleteUser";
        try {
            szMsg = "Start. <Key = " + SJcAccountChkUty.chgArray2Str(szUserName) + ">";
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "deleteUser", szMsg);
            SJcAccountChkUty.chkEmptyException(szUserName);
            SJcAccountFileUserInfo.deleteUser(szUserName, lRscLockID);
        }
        catch (SJcFailDataException e) {
            Object[] szFail = e.getFailData();
            szMsg = "<Key = " + SJcAccountChkUty.chgArray2Str(szFail) + ">";
            SJcLogUty.getLogger().warn("SJcUserInfoUty", "SJcUserInfoUty", "deleteUser", szMsg);
            SJcLogUty.getLogger().warn("SJcUserInfoUty", "SJcUserInfoUty", "deleteUser", "SJcFailDataException.", e);
            throw e;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "deleteUser", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "deleteUser", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserInfoUty", "SJcUserInfoUty", "deleteUser", "End.");
        }
    }

    public static String[] getAllUser() throws SJcException {
        String LOG_SUBTITLE = "getAllUser";
        try {
            String[] szRet;
            szMsg = "Start.";
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getAllUser", szMsg);
            String[] stringArray = szRet = SJcAccountFileUserInfo.getAllUser();
            return stringArray;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getAllUser", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getAllUser", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getAllUser", "End.");
        }
    }

    public static SJcUserInfoContainer[] getUserInfo(String[] szUserName) throws SJcException {
        String LOG_SUBTITLE = "getUserInfo";
        try {
            szMsg = "Start. <Key = " + SJcAccountChkUty.chgArray2Str(szUserName) + ">";
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getUserInfo", szMsg);
            SJcAccountChkUty.chkEmptyException(szUserName);
            SJcUserInfoContainer[] clsUserInfo = SJcAccountFileUserInfo.getUserInfo(szUserName);
            for (int i = 0; i < szUserName.length; ++i) {
                if (clsUserInfo[i] == null) continue;
                clsUserInfo[i].setLoginTime(SJcUserInfoUty.getLoginTimeData(szUserName[i]));
                clsUserInfo[i].setLogoutTime(SJcUserInfoUty.getLogoutTimeData(szUserName[i]));
            }
            SJcUserInfoContainer[] sJcUserInfoContainerArray = clsUserInfo;
            return sJcUserInfoContainerArray;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getUserInfo", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getUserInfo", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getUserInfo", "End.");
        }
    }

    public static String getLoginTime(String szUserName) throws SJcException {
        String LOG_SUBTITLE = "getLoginTime";
        try {
            String szRet;
            szMsg = "Start. <Key = " + szUserName + ">";
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getLoginTime", szMsg);
            SJcAccountChkUty.chkUserName(szUserName);
            String string = szRet = SJcUserInfoUty.getLoginTimeData(szUserName);
            return string;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getLoginTime", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getLoginTime", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getLoginTime", "End.");
        }
    }

    public static String getLoginTime(String szUserName, String szBaseName) throws SJcException {
        String LOG_SUBTITLE = "getLoginTime";
        try {
            String szRet;
            szMsg = "Start. <Key = " + szUserName + ", " + szBaseName + ">";
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getLoginTime", szMsg);
            SJcAccountChkUty.chkUserName(szUserName);
            SJcAccountChkUty.chkEmptyException(szBaseName);
            String string = szRet = SJcUserInfoUty.getLoginTimeData(szUserName, szBaseName);
            return string;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getLoginTime", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getLoginTime", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getLoginTime", "End.");
        }
    }

    public static String getLogoutTime(String szUserName) throws SJcException {
        String LOG_SUBTITLE = "getLogoutTime";
        try {
            String szRet;
            szMsg = "Start. <Key = " + szUserName + ">";
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getLogoutTime", szMsg);
            SJcAccountChkUty.chkUserName(szUserName);
            String string = szRet = SJcUserInfoUty.getLogoutTimeData(szUserName);
            return string;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getLogoutTime", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getLogoutTime", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getLogoutTime", "End.");
        }
    }

    public static String getLogoutTime(String szUserName, String szBaseName) throws SJcException {
        String LOG_SUBTITLE = "getLogoutTime";
        try {
            String szRet;
            szMsg = "Start. <Key = " + szUserName + ", " + szBaseName + ">";
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getLogoutTime", szMsg);
            SJcAccountChkUty.chkUserName(szUserName);
            SJcAccountChkUty.chkEmptyException(szBaseName);
            String string = szRet = SJcUserInfoUty.getLogoutTimeData(szUserName, szBaseName);
            return string;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getLogoutTime", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "getLogoutTime", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "getLogoutTime", "End.");
        }
    }

    private static String getLoginTimeData(String szUserName) throws SJcException {
        SJbaseUserSessionManager clsSesMgr = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
        if (clsSesMgr == null) {
            return null;
        }
        String szUserID = SJcUserUniqIDUty.getUserUniqID(szUserName, "AuthLocal");
        long lgRet = clsSesMgr.getLastLoginTime(szUserID);
        String szRet = null;
        if (lgRet != -1L) {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMDDhhmmss");
            szRet = format.format(lgRet);
        }
        return szRet;
    }

    private static String getLoginTimeData(String szUserName, String szBaseName) throws SJcException {
        SJbaseUserSessionManager clsSesMgr = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
        if (clsSesMgr == null) {
            return null;
        }
        String szUserID = SJcUserUniqIDUty.getUserUniqID(szUserName, szBaseName);
        long lgRet = clsSesMgr.getLastLoginTime(szUserID);
        String szRet = null;
        if (lgRet != -1L) {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMDDhhmmss");
            szRet = format.format(lgRet);
        }
        return szRet;
    }

    private static String getLogoutTimeData(String szUserName) throws SJcException {
        SJbaseUserSessionManager clsSesMgr = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
        if (clsSesMgr == null) {
            return null;
        }
        String szUserID = SJcUserUniqIDUty.getUserUniqID(szUserName, "AuthLocal");
        long lgRet = clsSesMgr.getLastLogoutTime(szUserID);
        String szRet = null;
        if (lgRet != -1L) {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMDDhhmmss");
            szRet = format.format(lgRet);
        }
        return szRet;
    }

    private static String getLogoutTimeData(String szUserName, String szBaseName) throws SJcException {
        SJbaseUserSessionManager clsSesMgr = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
        if (clsSesMgr == null) {
            return null;
        }
        String szUserID = SJcUserUniqIDUty.getUserUniqID(szUserName, szBaseName);
        long lgRet = clsSesMgr.getLastLogoutTime(szUserID);
        String szRet = null;
        if (lgRet != -1L) {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMDDhhmmss");
            szRet = format.format(lgRet);
        }
        return szRet;
    }

    public static boolean checkPassword(String szUserName, String szPassword) throws SJcException {
        String LOG_SUBTITLE = "checkPassword";
        try {
            boolean bRet;
            szMsg = "Start. <Key = " + szUserName + ">";
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "checkPassword", szMsg);
            SJcAccountChkUty.chkUserName(szUserName);
            SJcAccountChkUty.chkPassword(szPassword);
            boolean bl = bRet = SJcAccountFileUserInfo.checkPassword(szUserName, szPassword);
            return bl;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "checkPassword", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserInfoUty", "SJcUserInfoUty", "checkPassword", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserInfoUty", "SJcUserInfoUty", "checkPassword", "End.");
        }
    }

    @Deprecated
    public static synchronized void createUser(String szUserName, int iAuthPtn, String szPassword, String[] szGrpName, int iEnable) throws SJcException {
    }

    @Deprecated
    public static synchronized void setAuthPattern(String szUserName, int iAuthPtn, String szPassword) throws SJcException {
    }

    @Deprecated
    public static synchronized void setUserGroup(String szUserName, String[] szGrpName) throws SJcException {
    }

    @Deprecated
    public static synchronized void addUserGroup(String[] szUserName, String szGrpName) throws SJcException {
    }

    @Deprecated
    public static synchronized void removeUserGroup(String[] szUserName, String szGrpName) throws SJcException {
    }

    @Deprecated
    public static synchronized void setPasswordWithCheck(String szUserName, String szNowPassword, String szNewPassword) throws SJcException {
    }

    @Deprecated
    public static synchronized void setPassword(String szUserName, String szNewPassword) throws SJcException {
    }

    @Deprecated
    public static synchronized void setEnableDisable(String[] szUserName, boolean bFlg) throws SJcException {
    }

    @Deprecated
    public static synchronized void setEnableDisableEx(String[] szUserName, boolean bFlg) throws SJcException {
    }

    @Deprecated
    public static synchronized void deleteUser(String[] szUserName) throws SJcException {
    }

    @Deprecated
    public static boolean isExistUser(String szUserName) throws SJcException {
        return false;
    }

    @Deprecated
    public static boolean isMaximumUser() throws SJcException {
        return false;
    }

    @Deprecated
    public static boolean isExecuteUpdate(String szUserName, String[] szGrpName) throws SJcException {
        return false;
    }

    @Deprecated
    public static void isExecuteGroupDel(String[] szUserName, String szGrpName) throws SJcException {
    }

    @Deprecated
    public static boolean isExecuteDel(String[] szUserName) throws SJcException {
        return false;
    }

    @Deprecated
    public static boolean isTypeBuildin(String szUserName) throws SJcException {
        return false;
    }

    @Deprecated
    public static boolean isTypeUser(String szUserName) throws SJcException {
        return false;
    }
}

