/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;

public class SJsvlFileUploadServlet
extends HttpServlet {
    static final long serialVersionUID = 0L;
    private static final String ENCODE_UTF8 = "UTF-8";
    private static final String LOG_FUNCTION = "FileUploadUtility";
    private static final String LOG_TITLE = "SJsvlFileUploadServlet";
    private static final String FILENAME_CREATE_SEPARATOR = "_";
    private static final String PARAM_KEY_GLOBALSESSIONID = "GlobalSessionID";
    private static final String PARAM_KEY_USERNAME = "UserName";
    private static final int DEF_FILEUPLOADLIMITSIZE = 0x1400000;
    private static final int DEF_FILEUPLOADLIMITTHRESHOLDSIZE = 1024;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doGet";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doGet", "Start.");
        this.doPost(request, response);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doGet", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG_SUBTITLE = "doPost";
        STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Start.");
        request.setCharacterEncoding("UTF-8");
        factory = new DiskFileItemFactory();
        objDfu = new ServletFileUpload((FileItemFactory)factory);
        fileSize = SJcEnvUty.getProperty2int("SN_SVL_FileUploadLimitSize", 0x1400000);
        objDfu.setFileSizeMax((long)fileSize);
        sizeThreshold = SJcEnvUty.getProperty2int("SN_SVL_FileUploadLimitThresholdSize", 1024);
        factory.setSizeThreshold(sizeThreshold);
        STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "SizeThreshold:" + sizeThreshold);
        objLst = null;
        try {
            objLst = objDfu.parseRequest(request);
        }
        catch (FileUploadException e) {
            STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "It failed in parse of the request.", e);
            response.sendError(404);
            return;
        }
        formParams = this.getFormParams(objLst);
        sessionID = request.getParameter("GlobalSessionID");
        userName = request.getParameter("UserName");
        if (sessionID == null) {
            sessionID = formParams.get("GlobalSessionID");
        }
        if (userName == null) {
            userName = formParams.get("UserName");
        }
        STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "sessionID:" + sessionID + ", userName:" + userName);
        if (sessionID == null || userName == null) {
            STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "sessionID:" + sessionID + "userName:" + userName);
            response.sendError(404);
            return;
        }
        sessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
        userSession = sessionManager.getUserSession(sessionID);
        STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "userSession:" + userSession);
        if (userSession == null) {
            STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "UserSession is null.");
            response.sendError(404);
            return;
        }
        usUserName = userSession.getUserName();
        usSessionID = userSession.getSessionID();
        STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "usUserName:" + usUserName + ", usSessionID:" + usSessionID);
        if (!userName.equals(usUserName) || !sessionID.equals(usSessionID)) {
            STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "userName:" + userName + ", usUserName:" + usUserName + ", sessionID:" + sessionID + ", usSession:" + usSessionID);
            response.sendError(404);
            return;
        }
        response.setCharacterEncoding("UTF-8");
        inStream = null;
        inBuffer = null;
        outStream = null;
        outBuffer = null;
        str = "";
        try {
            for (FileItem item : objLst) {
                block68: {
                    STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "FileItem:" + item);
                    if (item.isFormField()) continue;
                    str1 = item.getName();
                    orgFileName = this.getFileName(str1);
                    randomFileName = UUID.randomUUID();
                    randomName = randomFileName.toString();
                    upFileName = randomName + "_" + orgFileName;
                    STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "upFileName:" + upFileName);
                    dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
                    upLoadDirPath = SJcFileUty.concatFolderPath(dataPath, SJcConst.FILE_UPLOAD_DIRECTORY);
                    path = upLoadDirPath + upFileName;
                    try {
                        fileList = SJcFileUty.getFileList(SJcConst.FILE_UPLOAD_DIRECTORY);
                        i = 0;
lbl68:
                        // 2 sources

                        while (i < fileList.length) {
                            if (upFileName.equals(fileList[i])) {
                                STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "upFileName:" + upFileName + "= fileList[i]:" + fileList[i]);
                                response.sendError(404);
                                return;
                            }
                            ** GOTO lbl-1000
                        }
                        break block68;
                    }
                    catch (Exception ex) {
                        STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Exception:" + ex);
                        response.sendError(404);
                        if (null != outBuffer) {
                            try {
                                outBuffer.close();
                            }
                            catch (Exception e) {
                                STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Failed to outBuffer close.", e);
                            }
                        }
                        if (null != outStream) {
                            try {
                                outStream.close();
                            }
                            catch (Exception e) {
                                STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Failed to outStream close.", e);
                            }
                        }
                        if (null != inBuffer) {
                            try {
                                inBuffer.close();
                            }
                            catch (Exception e) {
                                STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Failed to inBuffer close.", e);
                            }
                        }
                        if (null == inStream) return;
                        try {
                            inStream.close();
                            return;
                        }
                        catch (Exception e) {
                            STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Failed to inStream close.", e);
                        }
                        return;
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++i;
                        ** GOTO lbl68
                    }
                }
                STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "FileUploadDirectory_path:" + path);
                inStream = item.getInputStream();
                inBuffer = new BufferedInputStream(inStream);
                outStream = SJcFileUty.getOutStream(path);
                outBuffer = new BufferedOutputStream(outStream);
                contents = 0;
                while ((contents = inBuffer.read()) != -1) {
                    outBuffer.write(contents);
                }
                str = upFileName;
            }
            STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "FileName:" + str);
            response.getWriter().print(str);
        }
        catch (Exception ex) {
            STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Exception:" + ex);
            response.sendError(404);
            return;
        }
        finally {
            if (null != outBuffer) {
                try {
                    outBuffer.close();
                }
                catch (Exception e) {
                    STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Failed to outBuffer close.", e);
                }
            }
            if (null != outStream) {
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Failed to outStream close.", e);
                }
            }
            if (null != inBuffer) {
                try {
                    inBuffer.close();
                }
                catch (Exception e) {
                    STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Failed to inBuffer close.", e);
                }
            }
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    STD_LOGGER.error("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "Failed to inStream close.", e);
                }
            }
        }
        STD_LOGGER.info("FileUploadUtility", "SJsvlFileUploadServlet", "doPost", "End.");
    }

    private String getFileName(String fileName) {
        int idx = fileName.lastIndexOf(SJcConst.sjc_PathSeparator);
        if (idx == -1) {
            return fileName;
        }
        return fileName.substring(idx + 1, fileName.length());
    }

    private HashMap<String, String> getFormParams(List objLst) {
        HashMap<String, String> formParams = new HashMap<String, String>();
        String LOG_SUBTITLE = "getFormParams";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getFormParams", "Start.");
        if (null != objLst) {
            for (FileItem item : objLst) {
                if (!item.isFormField()) continue;
                formParams.put(item.getFieldName(), item.getString());
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getFormParams", "End.");
        return formParams;
    }
}

