/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SanSSLClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = -9000185163512793691L;
    private static final String TRUSTOSTORE_FILE = "RsdRmiSSLTrustStore";
    private static final char[] TRUSTSTORE_PW = "yekLSSimRrehtnaP".toCharArray();
    private static final String WORK_DIR = ".." + File.separator + "..";
    private static final String MAPPINISET_PATH = WORK_DIR + File.separator + "supervisor" + File.separator + "mappiniset";
    private static final String CONFIG_DIR_PATH = MAPPINISET_PATH + File.separator + "MpSsl" + File.separator + "cnf";
    private static final String DEFAULT_DIR_PATH = MAPPINISET_PATH + File.separator + "MpSsl" + File.separator + "def";
    private static final String SSL_SET_FILE_NAME = "MappSsl.properties";
    private static final String CONFIG_FILE_PATH = MAPPINISET_PATH + File.separator + "MappSsl.properties";
    private static final String DEFAULT_FILE_PATH = MAPPINISET_PATH + File.separator + "MappSsl.properties";
    private static final String KEY_PROTOCOLS = "com.hitachi.sanproject.ssl.protocols";
    private static final String KEY_CIPHERSUITES = "com.hitachi.sanproject.ssl.ciphersuites";

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.getClass().equals(object.getClass());
    }

    private TrustManager[] getTrustManagers() throws IOException, GeneralSecurityException {
        File file = null;
        TrustManager[] trustManagerArray = null;
        file = new File(TRUSTOSTORE_FILE);
        if (file.exists()) {
            KeyStore keyStore = null;
            TrustManagerFactory trustManagerFactory = null;
            FileInputStream fileInputStream = new FileInputStream(TRUSTOSTORE_FILE);
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(fileInputStream, TRUSTSTORE_PW);
            ((InputStream)fileInputStream).close();
            String string = TrustManagerFactory.getDefaultAlgorithm();
            trustManagerFactory = TrustManagerFactory.getInstance(string);
            trustManagerFactory.init(keyStore);
            trustManagerArray = trustManagerFactory.getTrustManagers();
        } else {
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            trustManagerArray = new TrustManager[]{x509TrustManager};
        }
        return trustManagerArray;
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        TrustManager[] trustManagerArray = null;
        SSLContext sSLContext = null;
        SSLSocketFactory sSLSocketFactory = null;
        SSLSocket sSLSocket = null;
        try {
            trustManagerArray = this.getTrustManagers();
            sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, null);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        sSLSocketFactory = sSLContext.getSocketFactory();
        sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
        String[] stringArray = sSLSocket.getSupportedProtocols();
        String[] stringArray2 = this.filter_array(stringArray, new String[]{"SSLv2Hello", "SSLv3"});
        sSLSocket.setEnabledProtocols(stringArray2);
        return sSLSocket;
    }

    private String[] filter_array(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null && stringArray2 != null) {
            for (String string : stringArray) {
                boolean bl = false;
                for (String string2 : stringArray2) {
                    if (!string.equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(string);
            }
        }
        if (!arrayList.isEmpty()) {
            stringArray3 = arrayList.toArray(new String[0]);
        }
        return stringArray3;
    }
}

