/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.jserver.CIMRepository;
import java.lang.reflect.Constructor;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

final class JServerRepositoryAdapterFactory {
    private static final String FILE_NAME = "com.ws.wbem.jserver.JServerRepositoryAdapterFactory";
    private static final String ERROR_REPOSITORY_NAME_NULL = "Repository name can not be null";
    private static final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");

    JServerRepositoryAdapterFactory() {
    }

    public static CIMRepository getAdapter(String repository) throws WBEMException {
        if (repository == null || repository.trim().length() == 0) {
            throw new IllegalArgumentException(ERROR_REPOSITORY_NAME_NULL);
        }
        try {
            PropertyResourceBundle props = (PropertyResourceBundle)ResourceBundle.getBundle(FILE_NAME);
            String clazz = props.getString(repository);
            Class<?> cl = null;
            try {
                cl = Class.forName(clazz);
            }
            catch (Exception ex) {
                mLogger.log(Level.SEVERE, "Class.forName failed!", ex);
                throw new WBEMException(1, ex.getMessage());
            }
            Class[] paramTypes = new Class[]{};
            Object[] paramList = new Object[]{};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            return (CIMRepository)ctr.newInstance(paramList);
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "AuthService.getAdapter failed!", e);
            throw new WBEMException(1);
        }
    }
}

