/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.jserver.AuthService;
import java.lang.reflect.Constructor;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public final class JServerSecurityAdapterFactory {
    private static final String FILE_NAME = "com.ws.wbem.jserver.JServerSecurityAdapterFactory";
    private static final String ERROR_PROTOCOL_NAME_NULL = "Protocol name can not be null";
    private static final String ERROR_SOMA_CLASS_NAME_NOT_FOUND = "Unable to locate factory to create %s SOMA";
    private static final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private static AuthService mAdapter;

    public static AuthService getAdapter() {
        return mAdapter;
    }

    public static AuthService getAdapter(String protocol) throws WBEMException {
        if (protocol == null || protocol.trim().length() == 0) {
            throw new IllegalArgumentException(ERROR_PROTOCOL_NAME_NULL);
        }
        try {
            PropertyResourceBundle props = (PropertyResourceBundle)ResourceBundle.getBundle(FILE_NAME);
            String clazz = props.getString(protocol);
            if (null == clazz) {
                String err = String.format(ERROR_SOMA_CLASS_NAME_NOT_FOUND, protocol);
                mLogger.log(Level.SEVERE, err);
                throw new WBEMException(err);
            }
            Class<?> cl = null;
            try {
                cl = Class.forName(clazz);
            }
            catch (Throwable ex) {
                mLogger.log(Level.SEVERE, "Class.forName failed!", ex);
                throw new WBEMException(1, "ERROR", null, ex);
            }
            Class[] paramTypes = new Class[]{};
            Object[] paramList = new Object[]{};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            mAdapter = (AuthService)ctr.newInstance(paramList);
            return mAdapter;
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "AuthService.getAdapter failed!", e);
            if (e instanceof WBEMException) {
                throw (WBEMException)((Object)e);
            }
            throw new WBEMException(1);
        }
    }
}

