/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.utilities.PropertiesWithComments;
import com.ws.wbem.jserver.JServerProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.logging.Level;

public class JServerTraceProperties {
    private static final PropertiesWithComments mProperties = new PropertiesWithComments();
    private static final String mFilename = "jservertrace.properties";

    public static String getLogFileDirectory() {
        String basedir = JServerProperties.getBasedir();
        Object[] argument = new Object[]{basedir};
        return MessageFormat.format(mProperties.getProperty("com.ws.jserver.logdirectory"), argument);
    }

    public static String getLogFileName() {
        return mProperties.getProperty("com.ws.jserver.log.filename");
    }

    public static String getLogFormat() {
        return mProperties.getProperty("com.ws.jserver.log.format");
    }

    public static Level getLogLevel() {
        return JServerTraceProperties.getLogLevelFromIntString(mProperties.getProperty("com.ws.jserver.loglevel"));
    }

    private static Level getLogLevelFromIntString(String pInt) {
        try {
            Level newLevel;
            switch (new Integer(pInt)) {
                case 0: {
                    newLevel = Level.ALL;
                    break;
                }
                case 300: {
                    newLevel = Level.FINEST;
                    break;
                }
                case 400: {
                    newLevel = Level.FINER;
                    break;
                }
                case 500: {
                    newLevel = Level.FINE;
                    break;
                }
                case 700: {
                    newLevel = Level.CONFIG;
                    break;
                }
                case 800: {
                    newLevel = Level.INFO;
                    break;
                }
                case 900: {
                    newLevel = Level.WARNING;
                    break;
                }
                case 1000: {
                    newLevel = Level.SEVERE;
                    break;
                }
                case 10000: {
                    newLevel = Level.OFF;
                    break;
                }
                default: {
                    newLevel = Level.OFF;
                }
            }
            return newLevel;
        }
        catch (Exception e) {
            return Level.OFF;
        }
    }

    public static String getMaxLogFileSize() {
        return mProperties.getProperty("com.ws.jserver.log.maxfilesize");
    }

    public static String getNumberOfLogs() {
        return mProperties.getProperty("com.ws.jserver.log.numfiles");
    }

    public static void load() throws IOException {
        mProperties.load((InputStream)new FileInputStream(JServerProperties.getBasedir() + File.separator + "bin" + File.separator + mFilename));
    }

    public static void setLogFileDirectoy(String dir) {
        mProperties.setProperty("com.ws.jserver.logdirectory", dir);
    }

    public static void setLogFileName(String filename) {
        mProperties.setProperty("com.ws.jserver.log.filename", filename);
    }

    public static void setLogFormat(String format) {
        mProperties.setProperty("com.ws.jserver.log.format", format);
    }

    public static void setLogLevel(Level level) {
        String l = Integer.toString(level.intValue());
        if (level == Level.OFF) {
            l = "10000";
        } else if (level == Level.ALL) {
            l = "0";
        }
        mProperties.setProperty("com.ws.jserver.loglevel", l);
    }

    public static void setMaxLogFileSize(String size) {
        mProperties.setProperty("com.ws.jserver.log.maxfilesize", size);
    }

    public static void setNumberOfLogs(String numLogs) {
        mProperties.setProperty("com.ws.jserver.log.numfiles", numLogs);
    }

    public JServerTraceProperties() throws IOException {
        JServerTraceProperties.load();
    }

    public void store() throws IOException {
        this.store(mFilename);
    }

    public void store(String filename) throws IOException {
        mProperties.store((OutputStream)new FileOutputStream(filename), "");
    }
}

