/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.OperationInfo;
import com.ws.wbem.jserver.OperationIteratorType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.EnumerateResponse;

class PullOperations {
    private final Map<String, OperationInfo> mObjectMap = new ConcurrentHashMap<String, OperationInfo>();
    private final Timer timer = new Timer(true);
    private static final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private static final long TIMER_DELAY = 10000L;
    private final int MAX_DEFAULT;

    public PullOperations() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                Set keySet = PullOperations.this.mObjectMap.keySet();
                for (String contextID : keySet) {
                    OperationInfo opInfo = (OperationInfo)PullOperations.this.mObjectMap.get(contextID);
                    if (currentTime <= opInfo.getEndTime()) continue;
                    mLogger.log(Level.FINE, "{0} removing context due to time out: {1}", new Object[]{Thread.currentThread().getName(), contextID});
                    PullOperations.this.mObjectMap.remove(contextID);
                    opInfo.close();
                }
            }
        }, 10000L, 10000L);
        this.MAX_DEFAULT = JServerProperties.getMaxObjectsPerPullRequest();
    }

    protected void closeEnumeration(CIMObjectPath target, String pEnumContext) throws WBEMException {
        if (null == pEnumContext) {
            throw WBEMOperationErrors.getInvalidEnumerationContext((CIMObjectPath)target, (WBEMOperation)WBEMOperation.CLOSEENUMERATION);
        }
        OperationInfo opInfo = this.mObjectMap.get(pEnumContext);
        if (null == opInfo) {
            throw WBEMOperationErrors.getInvalidEnumerationContext((CIMObjectPath)target, (WBEMOperation)WBEMOperation.CLOSEENUMERATION);
        }
        opInfo.close();
        this.mObjectMap.remove(pEnumContext);
        opInfo = null;
    }

    private int getMaxNumber(UnsignedInteger32 pMaxObjects) {
        int retVal = this.MAX_DEFAULT;
        if (null != pMaxObjects) {
            long val = pMaxObjects.longValue();
            retVal = (int)Math.min(Integer.MAX_VALUE, val);
        }
        return retVal;
    }

    protected EnumerateResponse<CIMInstance> getMaxObjects(CIMObjectPath target, String pEnumContext, UnsignedInteger32 pMaxObjects, OperationIteratorType pIteratorType) throws WBEMException {
        mLogger.log(Level.INFO, "{0} called for context {1}, maxObjects {2}", new Object[]{pIteratorType == OperationIteratorType.INSTANCEWITHPATH ? WBEMOperation.PULLINSTANCESWITHPATH : WBEMOperation.PULLINSTANCES, pEnumContext, pMaxObjects});
        if (pEnumContext == null) {
            throw WBEMOperationErrors.getInvalidEnumerationContext((CIMObjectPath)target, (WBEMOperation)(pIteratorType == OperationIteratorType.INSTANCEWITHPATH ? WBEMOperation.PULLINSTANCESWITHPATH : WBEMOperation.PULLINSTANCES));
        }
        OperationInfo opInfo = this.mObjectMap.get(pEnumContext);
        if (null == opInfo) {
            mLogger.log(Level.SEVERE, "Enumeration context {0} is not valid", pEnumContext);
            throw WBEMOperationErrors.getInvalidEnumerationContext((CIMObjectPath)target, (WBEMOperation)WBEMOperation.CLOSEENUMERATION);
        }
        if (null != pIteratorType && pIteratorType != opInfo.getIteratorType()) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)"Wrong pull operation called for type!", (WBEMOperation)(pIteratorType == OperationIteratorType.INSTANCEWITHPATH ? WBEMOperation.PULLINSTANCESWITHPATH : WBEMOperation.PULLINSTANCES), null);
        }
        int maxObjects = this.getMaxNumber(pMaxObjects);
        String newContext = null;
        boolean endOfSequence = true;
        List<CIMInstance> maxInstances = opInfo.getInstances(maxObjects);
        if (null != maxInstances) {
            opInfo.refreshTimeout();
            if (!opInfo.isDone() || opInfo.hasNext()) {
                newContext = pEnumContext;
                endOfSequence = false;
                opInfo.refreshTimeout();
            } else {
                mLogger.log(Level.FINE, "{0} removing context, {1}, as iterator is done.", new Object[]{Thread.currentThread().getName(), pEnumContext});
                this.mObjectMap.remove(pEnumContext);
            }
        } else {
            mLogger.log(Level.WARNING, "{0} removing context, {1}, as iterator is null.", new Object[]{Thread.currentThread().getName(), pEnumContext});
            this.mObjectMap.remove(pEnumContext);
        }
        return new EnumerateResponse(newContext, (CloseableIterator)new CloseableAddableIterator(maxInstances), endOfSequence);
    }

    private EnumerateResponse<CIMInstance> openInstanceEnumeration(CloseableIterator<CIMInstance> pIter, UnsignedInteger32 pMaxObjects, OperationIteratorType iteratorType, UnsignedInteger32 pTimeout) throws WBEMException {
        if (null == pIter) {
            throw new WBEMException(1);
        }
        if (null == pTimeout) {
            pTimeout = new UnsignedInteger32(30L);
        }
        String newContext = null;
        boolean endOfSequence = true;
        int maxObjects = this.getMaxNumber(pMaxObjects);
        OperationInfo opInfo = new OperationInfo(pIter, iteratorType, pTimeout.longValue());
        List<CIMInstance> maxInstances = opInfo.getInstances(maxObjects);
        if (null == pIter.getWBEMException() && !pIter.isDone()) {
            newContext = UUID.randomUUID().toString();
            endOfSequence = false;
            this.mObjectMap.put(newContext, opInfo);
        }
        if (null != pIter.getWBEMException()) {
            WBEMException e = pIter.getWBEMException();
            throw e;
        }
        return new EnumerateResponse(newContext, (CloseableIterator)new CloseableAddableIterator(maxInstances), endOfSequence);
    }

    protected EnumerateResponse<CIMInstance> openInstanceEnumeration(CloseableIterator<CIMInstance> pIter, UnsignedInteger32 pMaxObjects, UnsignedInteger32 pTimeout) throws WBEMException {
        return this.openInstanceEnumeration(pIter, pMaxObjects, OperationIteratorType.INSTANCE, pTimeout);
    }

    protected EnumerateResponse<CIMInstance> openInstanceWithPathEnumeration(CloseableIterator<CIMInstance> pIter, UnsignedInteger32 pMaxObjects, UnsignedInteger32 pTimeout) throws WBEMException {
        return this.openInstanceEnumeration(pIter, pMaxObjects, OperationIteratorType.INSTANCEWITHPATH, pTimeout);
    }
}

