/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.dmtf.rolebasedauth;

import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseSingletonInstanceProvider;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class RoleBasedAuthorizationServiceProvider
extends BaseSingletonInstanceProvider {
    private static final String CPV_NAME = JServerProperties.getSchemaName() + " Account Management Service";
    private static final String CPV_SYSTEMCREATIONCLASSNAME = JServerSettings.replaceSchemaClassName("WS_WBEMServerSystem");

    @Override
    public Object invokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        if ("AssignRoles".equalsIgnoreCase(methodName)) {
            return this.assignRoles(target, inArgs, outArgs);
        }
        throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)target, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
    }

    private UnsignedInteger32 assignRoles(CIMObjectPath target, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 retValue = new UnsignedInteger32(2L);
        if (null != inArgs && inArgs.length == 2) {
            CIMObjectPath identity = null;
            CIMObjectPath[] roles = null;
            for (CIMArgument<?> a : inArgs) {
                if (null != a && "Identity".equalsIgnoreCase(a.getName())) {
                    identity = (CIMObjectPath)a.getValue();
                }
                if (null != a && "Roles".equalsIgnoreCase(a.getName())) {
                    roles = (CIMObjectPath[])a.getValue();
                }
                if (null != identity) {
                    ArrayList<String> newRoles = new ArrayList<String>();
                    if (null != roles) {
                        for (CIMObjectPath role : roles) {
                            try {
                                CIMInstance roleInstance = mInternalProvider.getInstance(role, null);
                                newRoles.add((String)roleInstance.getPropertyValue("Name"));
                            }
                            catch (Exception e) {
                                mLogger.log(Level.SEVERE, "Received Exception when trying to get instance of Role", e);
                                return retValue;
                            }
                        }
                    }
                    try {
                        CIMInstance identityInstance = mInternalProvider.getInstance(identity, null);
                        String[] newIdentityRoles = newRoles.toArray(new String[newRoles.size()]);
                        CIMProperty[] props = new CIMProperty[]{new CIMProperty("Roles", CIMDataType.STRING_ARRAY_T, (Object)newIdentityRoles)};
                        identityInstance = identityInstance.deriveInstance(props);
                        mInternalProvider.modifyInstance(identityInstance, null);
                        retValue = new UnsignedInteger32(0L);
                    }
                    catch (Exception e) {
                        mLogger.log(Level.SEVERE, "Received Exception when trying to create instance of Identity", e);
                    }
                    continue;
                }
                mLogger.log(Level.SEVERE, "The Identity Argument was null");
            }
        }
        return retValue;
    }

    @Override
    protected CIMInstance generateInstance(CIMObjectPath target) {
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)CPV_NAME, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)CPV_SYSTEMCREATIONCLASSNAME, true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)this.mClassName, true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), true)};
        CIMProperty[] props = new CIMProperty[]{keyProps[0], keyProps[1], keyProps[2], keyProps[3], new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)CPV_NAME, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(12), false)};
        CIMObjectPath op = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), this.mClassName, keyProps);
        return new CIMInstance(op, props);
    }

    @Override
    public void initialize(ProviderHandle ch) throws WBEMException {
        super.initialize(ch);
        this.mClassName = JServerSettings.replaceSchemaClassName("WS_RoleBasedAuthorizationService");
    }
}

