/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.dmtf.wbemserver;

import com.ws.utilities.NetworkUtils;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.query.fql.FQLParser;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class IPProtocolEndpointProvider
extends BaseInstanceProvider {
    private static final int PROTOCOLIFTYPE_IPV4 = 4096;
    private static final int PROTOCOLIFTYPE_IPV6 = 4097;
    private static final String CPV_NAMEFORMAT_IPV4 = "IPv4";
    private static final String CPV_NAMEFORMAT_IPV6 = "IPv6";

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath target, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        this.checkArguments(target, WBEMOperation.OPENENUMERATEINSTANCES, filterQueryLanguage, filterQuery, continueOnError);
        ArrayList<CIMInstance> instances = new ArrayList<CIMInstance>();
        try {
            List listInetAddresses = NetworkUtils.getActiveIPs();
            FQLParser fqlParser = null;
            if (null != filterQueryLanguage) {
                fqlParser = FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)target, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES);
            }
            for (InetAddress inetAddress : listInetAddresses) {
                CIMInstance inst = this.generateInstance(target, inetAddress);
                if (null != fqlParser) {
                    fqlParser.evaluate(instances, inst, propertyList);
                    continue;
                }
                instances.add(inst.filterProperties(propertyList));
            }
        }
        catch (SocketException se) {
            throw WBEMOperationErrors.getOtherFailureException(null, (Throwable)se, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES, (String)this.mClassName);
        }
        return new CloseableAddableIterator(instances);
    }

    private CIMInstance generateInstance(CIMObjectPath target, InetAddress inetAddress) {
        CIMInstance ret = null;
        if (null != inetAddress) {
            String ipAddress = inetAddress.getHostAddress();
            String cpvNameFormat = CPV_NAMEFORMAT_IPV4;
            String cpnIPAddress = "IPv4Address";
            int protocolIFType = 4096;
            if (inetAddress instanceof Inet6Address) {
                cpnIPAddress = "IPv6Address";
                protocolIFType = 4097;
                ipAddress = "[" + ipAddress + "]";
                cpvNameFormat = CPV_NAMEFORMAT_IPV6;
            }
            CIMProperty<?>[] keyProps = this.getKeyPropertyArray(ipAddress);
            CIMProperty[] props = new CIMProperty[]{keyProps[0], keyProps[1], keyProps[2], keyProps[3], new CIMProperty(cpnIPAddress, CIMDataType.STRING_T, (Object)ipAddress, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("ProtocolIFType", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(protocolIFType), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)ipAddress, false), new CIMProperty("AddressOrigin", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(0), false), new CIMProperty("NameFormat", CIMDataType.STRING_T, (Object)cpvNameFormat, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(12), false)};
            ret = new CIMInstance(this.generateObjectPath(target, ipAddress), props);
        }
        return ret;
    }

    private CIMObjectPath generateObjectPath(CIMObjectPath target, String ipAddress) {
        return new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), this.mClassName, this.getKeyPropertyArray(ipAddress));
    }

    private InetAddress getInetAddress(String ipAddress) {
        InetAddress ret = null;
        if (null != ipAddress) {
            String fixedIPAddress = ipAddress;
            if (fixedIPAddress.endsWith("]")) {
                fixedIPAddress = fixedIPAddress.substring(0, fixedIPAddress.length() - 1);
            }
            if (fixedIPAddress.startsWith("[")) {
                fixedIPAddress = fixedIPAddress.substring(1);
            }
            try {
                List listInetAddresses = NetworkUtils.getActiveIPs();
                for (InetAddress inetAddress : listInetAddresses) {
                    if (!fixedIPAddress.equalsIgnoreCase(inetAddress.getHostAddress())) continue;
                    ret = inetAddress;
                    break;
                }
            }
            catch (SocketException se) {
                Object[] objs = new Object[]{ipAddress, se.getMessage()};
                mLogger.log(Level.SEVERE, "Caught exception when trying to get InetAddress for IP address {0}.\n{1", objs);
            }
        }
        return ret;
    }

    public CIMInstance getInstance(CIMObjectPath target, String[] propertyList) throws WBEMException {
        InetAddress inetAddress;
        String name = (String)target.getKeyValue("Name");
        if (target.equalsModelPath(this.generateObjectPath(target, name)) && null != (inetAddress = this.getInetAddress(name))) {
            return this.generateInstance(target, inetAddress).filterProperties(propertyList);
        }
        throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.GETINSTANCE, null);
    }

    private CIMProperty<?>[] getKeyPropertyArray(String ipAddress) {
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)ipAddress, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)JServerSettings.replaceSchemaClassName("WS_WBEMServerSystem"), true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)this.mClassName, true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), true)};
        return keyProps;
    }

    @Override
    public void initialize(ProviderHandle ch) throws WBEMException {
        super.initialize(ch);
        this.mClassName = JServerSettings.replaceSchemaClassName("CIM_IPProtocolEndpoint");
    }

    public void initialize(WBEMServer pServer, ProviderHandle pClient, Logger pLogger) throws WBEMException {
        super.initialize(pClient);
    }
}

