/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.services;

import com.ws.utilities.CipherUtilities;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.IndicationHandler;
import com.ws.wbem.jserver.JServerClassLoader;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerService;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.ProviderAdapter;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.jserver.services.CIMOMServices;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class ObjectManagerAdapterService
extends BaseInstanceProvider
implements JServerService {
    private static final String ERR_INVALID_OBJECT_PATH = "Invalid objectPath";
    private static final UnsignedInteger16 CPV_ENABLEDSTATE_ENABLED = new UnsignedInteger16(2);
    private static final UnsignedInteger16 CPV_ENABLEDSTATE_DISABLED = new UnsignedInteger16(3);
    private static final UnsignedInteger16 CPV_HEALTHSTATUS_OK = new UnsignedInteger16(5);
    private static final UnsignedInteger16 CPV_HEALTHSTATUS_NRERROR = new UnsignedInteger16(30);
    private static final String[] INDICATION_HANDLER_PROTOCOLS = new String[]{null, null, "IH:CIM-XML", "IH:SM CLP", "IH:WS-Management", "IH:WSDM", "IH:SMTP"};
    private static final List<String> writePropNames = Arrays.asList("EnabledDefault".toLowerCase(), "PortNumber".toLowerCase());
    private static Map<String, ProviderAdapter> ppaMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, IndicationHandler> ihaMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, CIMInstance> adapterInsts = Collections.synchronizedMap(new HashMap());
    private CIMOMServices mJServerService;
    private String mServerName;

    public static IndicationHandler getIHAHandle(int protocol) {
        IndicationHandler ret = null;
        if (protocol < INDICATION_HANDLER_PROTOCOLS.length) {
            String protocolName = INDICATION_HANDLER_PROTOCOLS[protocol];
            mLogger.log(Level.INFO, "Returning IHA Handle: {0}", protocolName);
            if (null != protocolName) {
                ret = ihaMap.get(protocolName);
            }
        }
        return ret;
    }

    public static IndicationHandler[] getIHAHandles() {
        Iterator<IndicationHandler> iterIha = ihaMap.values().iterator();
        HashSet<IndicationHandler> ihaSet = new HashSet<IndicationHandler>();
        while (iterIha.hasNext()) {
            ihaSet.add(iterIha.next());
        }
        Object[] ret = ihaSet.toArray(new IndicationHandler[ihaSet.size()]);
        mLogger.log(Level.INFO, "Returning IHA Handles: {0}", Arrays.toString(ret));
        return ret;
    }

    public static ProviderAdapter getPPAHandle(String name) {
        mLogger.log(Level.INFO, "Returning PPA Handle: {0}", name);
        if (name == null) {
            return null;
        }
        return ppaMap.get(name);
    }

    private CIMInstance checkProperties(CIMInstance cpa, String pProtocol) {
        String propPortLabel;
        String propFile;
        String PORT = "PortNumber";
        if (pProtocol.equals("CIM-XML")) {
            propFile = "cimxmlcpa.properties";
            propPortLabel = "HTTPPort";
        } else if (pProtocol.equals("CIM-XML-TLS")) {
            propFile = "cimxmlscpa.properties";
            propPortLabel = "HTTPSPort";
        } else if (pProtocol.equals("WS-Management")) {
            propFile = "wsmancoma.properties";
            propPortLabel = "WSMANPort";
        } else if (pProtocol.equals("WS-Management-TLS")) {
            propFile = "wsmanscoma.properties";
            propPortLabel = "WSMANSPort";
        } else {
            return cpa;
        }
        try {
            String ciphers;
            mLogger.log(Level.INFO, "starting to process {0}", propFile);
            String basedir = JServerProperties.getPropertiesDirectory();
            Properties props = new Properties();
            FileInputStream inputStream = new FileInputStream(basedir + File.separator + propFile);
            props.load(inputStream);
            inputStream.close();
            String portString = props.getProperty(propPortLabel);
            if (null != portString) {
                try {
                    if (mLogger.isLoggable(Level.INFO)) {
                        mLogger.log(Level.INFO, "Retrieved {0} value {1} from file {2}", new Object[]{propPortLabel, portString, propFile});
                    }
                    int port = Integer.parseInt(portString.trim());
                    CIMProperty[] cpArray = new CIMProperty[]{new CIMProperty("PortNumber", CIMDataType.UINT32_T, (Object)new UnsignedInteger32((long)port), false)};
                    cpa = cpa.deriveInstance(cpArray);
                    String[] propList = new String[]{"PortNumber"};
                    mInternalProvider.modifyInstance(this.generateRepositoryInstance(cpa), propList);
                }
                catch (NumberFormatException nfe) {
                    mLogger.log(Level.SEVERE, "Port value, {0}, was not a valid int value", portString);
                }
            }
            if (null != (ciphers = props.getProperty("Ciphers"))) {
                try {
                    String[] cipherArray = null;
                    if (!"default".equalsIgnoreCase(ciphers)) {
                        cipherArray = ciphers.split("\\s*,\\s*");
                    }
                    String invalidCiphers = CipherUtilities.validateCiphers(cipherArray);
                    if (mLogger.isLoggable(Level.INFO)) {
                        mLogger.log(Level.INFO, "One-time properties file, {0}, contained the following ciphers {1}", new Object[]{propFile, ciphers});
                    }
                    if (null != invalidCiphers) {
                        mLogger.log(Level.SEVERE, "One-time properties file, {0}, contained ciphers but some were invalid. SettingData class will NOT be updated. Invalid ciphers were: {1}", new Object[]{propFile, invalidCiphers});
                    } else {
                        CloseableIterator iter = mHandle.associatorInstances(cpa.getObjectPath(), "CIM_ElementSettingData", "CIM_SettingData", "ManagedElement", "SettingData", null);
                        if (iter.hasNext()) {
                            String CPN_ENABLEDCIPHERSUITES = "EnabledCipherSuites";
                            CIMInstance instSettingData = (CIMInstance)iter.next();
                            CIMProperty[] newProps = new CIMProperty[]{new CIMProperty("EnabledCipherSuites", CIMDataType.STRING_ARRAY_T, (Object)cipherArray, false)};
                            CIMInstance derivedInstance = this.deriveInstance(instSettingData, newProps);
                            mInternalProvider.modifyInstance(derivedInstance, new String[]{"EnabledCipherSuites"});
                            mLogger.info("Modified instance with new ciphers");
                        }
                    }
                }
                catch (WBEMException we) {
                    Throwable t = we.getCause();
                    if (null == t) {
                        t = we;
                    }
                    String msg = String.format("One-time properties file \"%s\" has Ciphers but an exception was caught trying to get the SettingsData instance to modify: %s", propFile, t.getMessage());
                    mLogger.log(Level.SEVERE, msg, t);
                }
            }
            File f = new File(basedir + File.separator + propFile);
            f.delete();
        }
        catch (Throwable e) {
            mLogger.log(Level.INFO, "Caught exception processing " + propFile, e);
        }
        return cpa;
    }

    @Override
    public void close() throws WBEMException {
        IndicationHandler[] adapters;
        super.close();
        try {
            CIMObjectPath op = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), this.mClassName, null);
            CloseableIterator iter = mHandle.enumerateInstances(op, null);
            while (iter.hasNext()) {
                CIMInstance ci = (CIMInstance)iter.next();
                CIMProperty propEnabledDefault = ci.getProperty("EnabledDefault");
                CIMProperty propStarted = ci.getProperty("Started");
                if (propEnabledDefault == null || propStarted == null || propEnabledDefault.getValue() == null || propStarted.getValue() == null || !propEnabledDefault.getValue().equals(CPV_ENABLEDSTATE_DISABLED) || !propStarted.getValue().equals(Boolean.TRUE)) continue;
                CIMProperty[] props = new CIMProperty[]{new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false)};
                ci = ci.deriveInstance(props);
                ci = this.generateRepositoryInstance(ci);
                String[] propList = new String[]{"Started"};
                mInternalProvider.modifyInstance(ci, propList);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        mLogger.info("Stop allprotocol adapters");
        if (this.mJServerService != null) {
            for (int x = 2; x < 5; ++x) {
                try {
                    this.mJServerService.stopProtocolAdapters(x);
                    continue;
                }
                catch (Exception e) {
                    LogRecord record = new LogRecord(Level.SEVERE, "Exception shutting down adpater type {0}");
                    record.setParameters(new Object[]{x});
                    record.setThrown(e);
                    mLogger.log(record);
                }
            }
        }
        for (IndicationHandler a : adapters = ObjectManagerAdapterService.getIHAHandles()) {
            try {
                a.shutdown();
            }
            catch (Exception e) {
                LogRecord record = new LogRecord(Level.SEVERE, "Exception shutting down IHA Adapter");
                record.setThrown(e);
                mLogger.log(record);
            }
        }
    }

    @Override
    public synchronized CIMObjectPath createInstance(CIMInstance ci) throws WBEMException {
        CIMInstance gInst = this.generateRepositoryInstance(ci);
        CIMObjectPath op = gInst.getObjectPath();
        CIMObjectPath retVal = mInternalProvider.createInstance(gInst);
        try {
            this.initializeAdapter(gInst, true, WBEMOperation.CREATEINSTANCE, null);
        }
        catch (WBEMException e) {
            CIMObjectPath lop = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "", gInst.getKeys());
            mInternalProvider.deleteInstance(lop);
            throw e;
        }
        return this.generateObjectPath(retVal);
    }

    @Override
    public synchronized void deleteInstance(CIMObjectPath op) throws WBEMException {
        mInternalProvider.deleteInstance(this.generateObjectPath(op));
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath op, String[] propList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        try {
            CloseableIterator iter = mInternalProvider.enumerateInstances(op, propList, filterQueryLanguage, filterQuery, continueOnError);
            return this.generateInstances((CloseableIterator<CIMInstance>)iter, false);
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Error trying to enumerateInstances of ObjectManagerAdapter!", e);
            return null;
        }
    }

    private CIMInstance generateInstance(CIMInstance pInst) {
        CIMInstance retInst = null;
        if (pInst != null) {
            String adapterName = (String)pInst.getPropertyValue("Name");
            if (adapterName == null || (retInst = adapterInsts.get(adapterName)) == null) {
                boolean isKey = true;
                CIMProperty sNameProp = pInst.getProperty("SystemName");
                String propVal = this.setSystemName(sNameProp);
                if (sNameProp != null) {
                    isKey = sNameProp.isKey();
                }
                CIMObjectPath op = this.generateObjectPath(pInst.getObjectPath());
                CIMProperty[] props = new CIMProperty[]{new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)propVal, isKey)};
                retInst = pInst.deriveInstance(props);
                retInst = retInst.deriveInstance(op);
            } else {
                CIMProperty[] pInstProps;
                ArrayList<CIMProperty> modProps = new ArrayList<CIMProperty>(5);
                ArrayList<String> propList = new ArrayList<String>();
                for (CIMProperty prop : pInstProps = pInst.getProperties()) {
                    String name = prop.getName();
                    propList.add(name);
                    CIMProperty retInstProp = retInst.getProperty(name);
                    if (retInstProp == null) continue;
                    if (name.equalsIgnoreCase("SystemName")) {
                        String systemName = this.setSystemName(prop);
                        prop = new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, prop.isKey());
                        modProps.add(prop);
                        continue;
                    }
                    if (this.isPropertyEqual(retInstProp, prop, false)) continue;
                    modProps.add(prop);
                }
                if (!modProps.isEmpty()) {
                    retInst = pInst.deriveInstance(modProps.toArray(new CIMProperty[modProps.size()]));
                    retInst = retInst.deriveInstance(this.generateObjectPath(pInst.getObjectPath()));
                    adapterInsts.put(adapterName, pInst);
                }
                retInst = retInst.filterProperties(propList.toArray(new String[propList.size()]));
            }
        }
        return retInst;
    }

    private CloseableIterator<CIMInstance> generateInstances(CloseableIterator<CIMInstance> pInstances, boolean localOnly) {
        if (pInstances == null) {
            return null;
        }
        ArrayList<CIMInstance> instList = new ArrayList<CIMInstance>();
        while (pInstances.hasNext()) {
            CIMInstance orig = (CIMInstance)pInstances.next();
            CIMInstance ci = this.generateInstance(orig);
            instList.add(ci);
        }
        return new CloseableAddableIterator(instList.iterator());
    }

    private CIMObjectPath generateObjectPath(CIMObjectPath pOP) {
        CIMObjectPath retOP = null;
        ArrayList<CIMProperty> l = new ArrayList<CIMProperty>();
        if (pOP != null) {
            CIMProperty[] props;
            for (CIMProperty prop : props = pOP.getKeys()) {
                if (prop != null && prop.getName().equalsIgnoreCase("SystemName")) {
                    String propVal = "unknown";
                    if (prop.getValue() != null && ((String)prop.getValue()).equalsIgnoreCase("unknown")) {
                        propVal = this.mServerName;
                    }
                    l.add(new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)propVal, prop.isKey()));
                    continue;
                }
                l.add(prop);
            }
            retOP = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), pOP.getObjectName(), l.toArray(new CIMProperty[l.size()]));
        }
        return retOP;
    }

    private CIMInstance generateRepositoryInstance(CIMInstance pInst) {
        CIMInstance retInst = null;
        if (pInst != null) {
            boolean isKey = true;
            CIMProperty sNameProp = pInst.getProperty("SystemName");
            if (sNameProp != null) {
                isKey = sNameProp.isKey();
            }
            CIMObjectPath op = this.generateRepositoryObjectPath(pInst.getObjectPath());
            CIMProperty[] props = new CIMProperty[]{new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)"unknown", isKey)};
            retInst = pInst.deriveInstance(props);
            retInst = retInst.deriveInstance(op);
        }
        return retInst;
    }

    private CIMObjectPath generateRepositoryObjectPath(CIMObjectPath pOP) {
        CIMObjectPath retOP = null;
        ArrayList<CIMProperty> l = new ArrayList<CIMProperty>();
        if (pOP != null) {
            CIMProperty[] props;
            for (CIMProperty prop : props = pOP.getKeys()) {
                if (prop != null && prop.getName().equalsIgnoreCase("SystemName")) {
                    l.add(new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)"unknown", prop.isKey()));
                    continue;
                }
                l.add(prop);
            }
            retOP = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), pOP.getObjectName(), l.toArray(new CIMProperty[l.size()]));
        }
        return retOP;
    }

    public CIMInstance getInstance(CIMObjectPath op, String[] propList) throws WBEMException {
        return this.generateInstance(mInternalProvider.getInstance(this.generateObjectPath(op), propList));
    }

    private UnsignedInteger16 getType(CIMInstance ci) {
        UnsignedInteger16 pType = null;
        try {
            pType = (UnsignedInteger16)ci.getProperty("AdapterType").getValue();
        }
        catch (Exception ex) {
            return new UnsignedInteger16(0);
        }
        return pType;
    }

    @Override
    public void initialize(ProviderHandle ch) throws WBEMException {
        super.initialize(ch);
        this.mClassName = JServerSettings.replaceSchemaClassName("WS_ObjectManagerAdapter");
        try {
            this.mServerName = this.getHostName();
        }
        catch (Exception e) {
            this.mServerName = "unknown";
        }
    }

    @Override
    public void initialize(WBEMServer pServer, ProviderHandle pClient, Logger pLogger) {
        this.mJServerService = new CIMOMServices(pClient, this);
        int started = this.mJServerService.startProtocolAdapters(3);
        mLogger.log(Level.INFO, "Started {0} PPA's", started);
        started = this.mJServerService.startProtocolAdapters(4);
        mLogger.log(Level.INFO, "Started {0} IHA's", started);
    }

    private CIMInstance initializeAdapter(CIMInstance ci, boolean start, WBEMOperation operation, String classMethodName) throws WBEMException {
        String protocolType;
        try {
            protocolType = (String)ci.getProperty("Name").getValue();
        }
        catch (NullPointerException ex) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)"The Name property shall not be null", (WBEMOperation)operation, (String)classMethodName);
        }
        mLogger.log(Level.INFO, "Initializing protocol adapter: {0}", protocolType);
        ci = this.checkProperties(ci, protocolType);
        ProviderAdapter ppAdapter = null;
        IndicationHandler ihAdapter = null;
        try {
            CIMProperty cpClassPath = ci.getProperty("classPath");
            String[] path = null;
            if (cpClassPath != null) {
                path = (String[])cpClassPath.getValue();
            }
            JServerClassLoader dcl = new JServerClassLoader(JServerProperties.getBasedir(), path, this.getClass().getClassLoader());
            CIMProperty cp = ci.getProperty("Handle");
            String className = (String)cp.getValue();
            Class cl = dcl.loadClass(className);
            if (protocolType.trim().length() == 0) {
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)"Name proeprty shall not be null", (WBEMOperation)operation, (String)classMethodName);
            }
            UnsignedInteger16 cvEnabledDefault = CPV_ENABLEDSTATE_DISABLED;
            try {
                cvEnabledDefault = (UnsignedInteger16)ci.getProperty("EnabledDefault").getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.getType(ci).equals((Object)new UnsignedInteger16(4))) {
                ihAdapter = (IndicationHandler)cl.newInstance();
                ihaMap.put(protocolType, ihAdapter);
                ihAdapter.initialize(mHandle);
                if (start && cvEnabledDefault.equals((Object)CPV_ENABLEDSTATE_ENABLED)) {
                    ihAdapter.start(ci);
                }
            } else if (this.getType(ci).equals((Object)new UnsignedInteger16(3))) {
                ppAdapter = (ProviderAdapter)cl.newInstance();
                ppAdapter.initialize(mHandle);
                if (start && cvEnabledDefault.equals((Object)CPV_ENABLEDSTATE_ENABLED)) {
                    ppAdapter.start(ci);
                }
                ppaMap.put(protocolType, ppAdapter);
            }
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                e = e.getCause();
            }
            this.updateStatus(7, ci);
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (Throwable)e, (WBEMOperation)operation, (String)classMethodName);
        }
        this.updateStatus(2, ci);
        return ci;
    }

    public UnsignedInteger32 invokeMethod(CIMObjectPath op, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        UnsignedInteger16 ppaType;
        UnsignedInteger16 cpaType;
        UnsignedInteger16 ihaType;
        UnsignedInteger16 pType;
        String name;
        CIMInstance ci;
        IndicationHandler ihAdapter;
        ProviderAdapter ppAdapter;
        block26: {
            ppAdapter = null;
            ihAdapter = null;
            ci = this.getInstance(op, null);
            try {
                name = (String)ci.getProperty("Name").getValue();
            }
            catch (NullPointerException e) {
                return new UnsignedInteger32(2L);
            }
            pType = this.getType(ci);
            ihaType = new UnsignedInteger16(4);
            cpaType = new UnsignedInteger16(2);
            ppaType = new UnsignedInteger16(3);
            try {
                if (pType.equals((Object)ppaType)) {
                    ppAdapter = ppaMap.get(name);
                    if (ppAdapter == null) {
                        mLogger.log(Level.INFO, "{0} POMA not initialized.", name);
                        this.initializeAdapter(ci, false, WBEMOperation.INVOKEMETHOD, op.getObjectName() + "." + methodName);
                        ppAdapter = ppaMap.get(name);
                    }
                    break block26;
                }
                if (pType.equals((Object)ihaType)) {
                    ihAdapter = ihaMap.get(name);
                    if (ihAdapter == null) {
                        mLogger.log(Level.INFO, "{0} IHOMA not initialized", name);
                        this.initializeAdapter(ci, false, WBEMOperation.INVOKEMETHOD, op.getObjectName() + "." + methodName);
                        ihAdapter = ihaMap.get(name);
                    }
                    break block26;
                }
                throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)op, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
            }
            catch (Throwable e) {
                mLogger.log(Level.WARNING, "Unexpected exception occurred, ", e);
                return new UnsignedInteger32(3L);
            }
        }
        if (methodName.equalsIgnoreCase("StartService")) {
            if (pType.equals((Object)cpaType)) {
                mLogger.log(Level.INFO, "Start the {0} CPA Service!", name);
            } else if (pType.equals((Object)ppaType)) {
                mLogger.log(Level.INFO, "Start the {0} PPA Service!", name);
                if (null != ppAdapter) {
                    ppAdapter.start(ci);
                }
            } else if (pType.equals((Object)ihaType)) {
                mLogger.log(Level.INFO, "Start the {0} IHA Service!", name);
                if (null != ihAdapter) {
                    ihAdapter.start(ci);
                }
            }
            this.updateStatus(2, ci);
        } else if (methodName.equalsIgnoreCase("StopService")) {
            if (pType.equals((Object)cpaType)) {
                mLogger.log(Level.INFO, "Stop the {0} CPA Service!", name);
            } else if (pType.equals((Object)ppaType)) {
                mLogger.log(Level.INFO, "Stop the {0} PPA Service!", name);
                if (null != ppAdapter) {
                    ppAdapter.stop();
                }
            } else if (pType.equals((Object)ihaType)) {
                mLogger.log(Level.INFO, "Stop the {0} IHA Service!", name);
                if (null != ihAdapter) {
                    ihAdapter.stop();
                }
            }
            this.updateStatus(10, ci);
        } else {
            throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)op, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
        }
        CIMInstance newci = adapterInsts.get(name);
        mInternalProvider.modifyInstance(this.generateRepositoryInstance(newci), null);
        return new UnsignedInteger32(0L);
    }

    @Override
    public synchronized void modifyInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        CIMInstance gInst;
        CIMObjectPath op;
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "ObjectManagerAdapter.ModifyInstance called!");
            mLogger.log(Level.FINE, "Instance: {0}, propertyList: {1}", new Object[]{ci.toString(), Arrays.toString(propertyList)});
        }
        if ((op = (gInst = this.generateInstance(ci)).getObjectPath()) == null || op.getKeys() == null) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)ERR_INVALID_OBJECT_PATH, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, null);
        }
        CIMInstance original = mInternalProvider.getInstance(op, null);
        String[] pList = propertyList;
        if (pList == null) {
            pList = this.getListofChanges(original, gInst);
        }
        if (pList != null) {
            for (String name : pList) {
                if (writePropNames.contains(name.toLowerCase())) continue;
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)("The propertyList contains a property name that can not be changed for this instance: " + name), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, null);
            }
        } else {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)"No changes were detected in the instance!", (WBEMOperation)WBEMOperation.MODIFYINSTANCE, null);
        }
        CIMProperty cp = op.getKey("Name");
        if (cp == null || cp.getValue() == null) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)"Invalid 'name' property", (WBEMOperation)WBEMOperation.MODIFYINSTANCE, null);
        }
        String className = (String)cp.getValue();
        CIMInstance newci = adapterInsts.get(className);
        mInternalProvider.modifyInstance(this.generateRepositoryInstance(newci), null);
    }

    private String setSystemName(CIMProperty<?> pNameProp) {
        String propVal = "unknown";
        if (pNameProp != null && ((String)pNameProp.getValue()).equalsIgnoreCase("unknown")) {
            propVal = this.mServerName;
        }
        return propVal;
    }

    private void updateStatus(int status, CIMInstance ci) {
        try {
            UnsignedInteger16[] statusValueArray = new UnsignedInteger16[]{new UnsignedInteger16(status)};
            UnsignedInteger16 cvHealthStatus = CPV_HEALTHSTATUS_OK;
            boolean started = false;
            UnsignedInteger16 cvEnabledState = CPV_ENABLEDSTATE_DISABLED;
            switch (status) {
                case 2: {
                    started = true;
                    cvEnabledState = CPV_ENABLEDSTATE_ENABLED;
                    break;
                }
                case 7: {
                    cvHealthStatus = CPV_HEALTHSTATUS_NRERROR;
                }
            }
            CIMProperty cpOperationalStatus = new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)statusValueArray, false);
            CIMProperty cpHealthState = new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)cvHealthStatus, false);
            CIMProperty cpStarted = new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)started, false);
            CIMProperty cpEnabledState = new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)cvEnabledState, false);
            CIMProperty[] pList = new CIMProperty[]{cpEnabledState, cpStarted, cpHealthState, cpOperationalStatus};
            String[] pstrList = new String[]{"OperationalStatus", "HealthState", "EnabledState", "Started"};
            ArrayList<CIMProperty> newPropList = new ArrayList<CIMProperty>();
            for (CIMProperty prop : pList) {
                CIMProperty p = ci.getProperty(prop.getName());
                if (p == null) {
                    newPropList.add(prop);
                    continue;
                }
                newPropList.add(prop);
            }
            String adapterName = null;
            for (CIMProperty p : ci.getProperties()) {
                if (Arrays.asList(pstrList).contains(p.getName())) continue;
                newPropList.add(p);
                if (!p.getName().equalsIgnoreCase("Name")) continue;
                adapterName = (String)p.getValue();
            }
            ci = new CIMInstance(ci.getObjectPath(), newPropList.toArray(new CIMProperty[newPropList.size()]));
            ci = this.generateInstance(ci);
            if (adapterName != null) {
                adapterInsts.put(adapterName, ci);
            }
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Could not update the status values of the Object Manager Adapter instance!", e);
        }
    }

    @Override
    public void reset() throws WBEMException {
    }
}

