/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.services;

import com.ws.logging.FailSafeLog;
import com.ws.utilities.WSIStandardMessages;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.IndicationManager;
import com.ws.wbem.IndicationType;
import com.ws.wbem.jserver.JServerService;
import com.ws.wbem.jserver.JServerServiceAdapterFactory;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.embed.EndPoint;
import com.ws.wbem.jserver.embed.JWBEMServerProtocolData;
import com.ws.wbem.jserver.embed.Protocol;
import com.ws.wbem.jserver.profiles.common.EnabledDefault;
import com.ws.wbem.jserver.profiles.common.EnabledState;
import com.ws.wbem.jserver.profiles.common.ProtocolIFType;
import com.ws.wbem.jserver.profiles.common.StateChange;
import com.ws.wbem.jserver.profiles.common.WSBaseProvider;
import com.ws.wbem.jserver.profiles.dmtf.wbemserver.ProtocolServiceProvider;
import com.ws.wbem.jserver.profiles.dmtf.wbemserver.TCPProtocolEndpointProvider;
import com.ws.wbem.jserver.services.JServerProtocolData;
import com.ws.wbem.query.fql.FQLParser;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class ProtocolServiceService
extends WSBaseProvider
implements JServerService {
    static final String IPADDRESS = "ipaddress";
    private static ProtocolServiceService mService = null;
    static final String SERVICE_SLP = "SLP";
    JWBEMServerProtocolData mEmbeddedData;
    public final ConcurrentHashMap<String, EndPoint> mEndpointMap;
    public final ConcurrentHashMap<String, Protocol> mProtocolMap;
    public final ConcurrentHashMap<String, IndicationManager> mIndicationFactoryMap;
    public final Set<String> mRunningEndpoints = new HashSet<String>();
    public final Set<String> mRunningProtocols = new HashSet<String>();

    public static synchronized ProtocolServiceService getService() {
        if (null == mService) {
            mService = new ProtocolServiceService();
        }
        return mService;
    }

    private static void setProtocolServiceService(ProtocolServiceService service) {
        mService = service;
    }

    public ProtocolServiceService() {
        this.mEndpointMap = new ConcurrentHashMap();
        this.mProtocolMap = new ConcurrentHashMap();
        this.mIndicationFactoryMap = new ConcurrentHashMap();
        ProtocolServiceService.setProtocolServiceService(this);
    }

    public void addIndicationFactory(String classname, IndicationManager indicationFactory) {
        this.mIndicationFactoryMap.put(classname, indicationFactory);
    }

    public boolean canDisableProtocolService(CIMObjectPath opProtocolService) {
        String protocolName;
        boolean ret = false;
        if (null != opProtocolService && null != (protocolName = this.getProtocolName((String)opProtocolService.getKeyValue("Name")))) {
            Iterator<String> iterRunningProtocols = this.mRunningProtocols.iterator();
            block0: while (iterRunningProtocols.hasNext() && !ret) {
                EndPoint[] endpoints;
                String nameRunningProtocol = iterRunningProtocols.next();
                if (protocolName.equals(nameRunningProtocol)) continue;
                Protocol runningProtocol = this.mProtocolMap.get(nameRunningProtocol);
                for (EndPoint endpoint : endpoints = runningProtocol.getEndPoints()) {
                    if (!this.mRunningEndpoints.contains(endpoint.getName())) continue;
                    ret = true;
                    continue block0;
                }
            }
        }
        return ret;
    }

    @Override
    public void close() throws WBEMException {
        Logger logger = Logger.getLogger("com.ws.wbem.jserver");
        if (null != this.mRunningProtocols) {
            for (String protocolName : this.mRunningProtocols) {
                Protocol srvc = this.mProtocolMap.get(protocolName);
                try {
                    srvc.close();
                }
                catch (Throwable t) {
                    LogRecord rec = new LogRecord(Level.WARNING, "Error closing protocol service {0}");
                    rec.setParameters(new Object[]{srvc});
                    rec.setThrown(t);
                    logger.log(rec);
                }
            }
        }
    }

    public CIMInstance createTCPProtocolEndpoint(CIMObjectPath op, String protocolName, int port, String protocolIFType, InetAddress boundedAddress, EnabledDefault enabledDefault, EnabledState enabledState) throws WBEMException {
        EndPoint endpoint2;
        Protocol protocol = this.mProtocolMap.get(protocolName);
        if (null == protocol) {
            Object[] objs = new Object[]{protocolName};
            mLogger.log(Level.WARNING, "Could not find ProtocolService for specified protocol: {0}", objs);
            throw new WBEMException(1);
        }
        for (EndPoint endpoint2 : this.mEndpointMap.values()) {
            if (endpoint2.getPort() != port) continue;
            CIMObjectPath opEndpoint = TCPProtocolEndpointProvider.generateTCPProtocolEndpointObjectPath(op, protocolName, endpoint2.getName());
            Object[] objs = new Object[]{port, opEndpoint};
            MessageFormat msgFormat = new MessageFormat("Cannot create TCPProtocolEndpoint because one already exists with port {0}: {1}");
            String err = msgFormat.format(objs);
            mLogger.log(Level.INFO, err);
            throw new WBEMException(1, err);
        }
        endpoint2 = protocol.startEndpoint(port, protocolIFType, boundedAddress);
        this.mEndpointMap.put(endpoint2.getName(), endpoint2);
        if (EnabledState.Disabled == enabledState) {
            protocol.stopEndpoint(port);
        } else {
            this.mRunningEndpoints.add(endpoint2.getName());
        }
        CIMInstance ret = TCPProtocolEndpointProvider.generateTCPProtocolEndpointInstance(op, protocol, endpoint2, enabledState);
        IndicationManager indicationFactory = this.mIndicationFactoryMap.get(ret.getClassName().toLowerCase());
        if (null != indicationFactory && indicationFactory.hasActiveSubscriptions(IndicationType.InstanceCreation)) {
            indicationFactory.deliverInstanceIndication(IndicationType.InstanceCreation, ret, null);
        }
        return ret;
    }

    private EndPoint getEndpoint(CIMObjectPath opTCPProtocolEndpoint) throws WBEMException {
        String cpvName;
        EndPoint endpoint = null;
        if (null != opTCPProtocolEndpoint && null != (cpvName = (String)opTCPProtocolEndpoint.getKeyValue("Name"))) {
            endpoint = this.mEndpointMap.get(cpvName);
        }
        if (null == endpoint) {
            Object[] objs = new Object[]{opTCPProtocolEndpoint};
            mLogger.log(Level.INFO, "Cannot find Endpoint using TCPProtocolEndpoint ObjectPath: {0}", objs);
            throw new WBEMException(6, "Cannot find Endpoint using TCPProtocolEndpoint " + opTCPProtocolEndpoint);
        }
        return endpoint;
    }

    private Protocol getProtocol(CIMObjectPath opProtocolService) throws WBEMException {
        String protocolName;
        Protocol protocol = null;
        if (null != opProtocolService && null != (protocolName = this.getProtocolName((String)opProtocolService.getKeyValue("Name")))) {
            protocol = this.mProtocolMap.get(protocolName);
        }
        if (null == protocol) {
            Object[] objs = new Object[]{opProtocolService};
            mLogger.log(Level.INFO, "Cannot find Protocol for ProtocolService: {0}", objs);
            throw new WBEMException(6, "Cannot find Protocol for ProtocolService: " + opProtocolService);
        }
        return protocol;
    }

    private Protocol getProtocol(EndPoint endpoint) {
        Protocol ret = null;
        Enumeration<Protocol> enumProtocols = this.mProtocolMap.elements();
        block0: while (enumProtocols.hasMoreElements() && null == ret) {
            EndPoint[] endpoints;
            Protocol protocol = enumProtocols.nextElement();
            for (EndPoint endpt : endpoints = protocol.getEndPoints()) {
                if (!endpt.getName().equals(endpoint.getName())) continue;
                ret = protocol;
                continue block0;
            }
        }
        return ret;
    }

    public EnabledState getProtocolEnabledState(Protocol protocol) {
        EnabledState enabledState = EnabledState.Disabled;
        String protocolName = protocol.getProtocolName();
        if (this.mRunningProtocols.contains(protocolName)) {
            enabledState = EnabledState.Enabled;
        }
        return enabledState;
    }

    public CloseableIterator<CIMInstance> getProtocolEndpointInstances(CIMObjectPath op, String protocolName, FQLParser fqlParser, String[] propertyList) throws WBEMException {
        List listInstances;
        Protocol protocol = this.mProtocolMap.get(protocolName);
        if (null != protocol) {
            EndPoint[] endpoints = protocol.getEndPoints();
            listInstances = new ArrayList(endpoints.length);
            for (EndPoint endpoint : endpoints) {
                EnabledState enabledState = EnabledState.getEnabledState(this.mRunningEndpoints.contains(endpoint.getName()));
                CIMInstance instEndpoint = TCPProtocolEndpointProvider.generateTCPProtocolEndpointInstance(op, protocol, endpoint, enabledState);
                if (null != fqlParser && !fqlParser.evaluate(instEndpoint)) continue;
                listInstances.add(instEndpoint.filterProperties(propertyList));
            }
        } else {
            listInstances = Collections.emptyList();
        }
        return new CloseableAddableIterator(listInstances);
    }

    final String getProtocolName(String name) {
        String ret = name;
        if (null != name) {
            StringTokenizer tokenizer = new StringTokenizer(name, " ");
            ret = tokenizer.nextToken();
            if (null == ret || ret.length() == 0) {
                ret = name;
            }
            return ret;
        }
        return ret;
    }

    public CIMInstance getProtocolServiceInstance(CIMObjectPath opProtocolService) throws WBEMException {
        return this.getProtocolServiceInstance(opProtocolService, this.getProtocol(opProtocolService));
    }

    public CIMInstance getProtocolServiceInstance(CIMObjectPath op, Protocol protocol) throws WBEMException {
        return ProtocolServiceProvider.generateProtocolServiceInstance(op, protocol, this.getProtocolEnabledState(protocol));
    }

    public CloseableIterator<CIMInstance> getProtocolServiceInstances(CIMObjectPath op, String protocolName, FQLParser fqlParser, String[] propertyList) throws WBEMException {
        ArrayList<CIMInstance> listInstances = new ArrayList<CIMInstance>();
        Protocol protocol = this.mProtocolMap.get(protocolName);
        if (null != protocol) {
            CIMInstance instProtocol = ProtocolServiceProvider.generateProtocolServiceInstance(op, protocol, this.getProtocolEnabledState(protocol));
            if (null == fqlParser || fqlParser.evaluate(instProtocol)) {
                listInstances.add(instProtocol.filterProperties(propertyList));
            }
        }
        return new CloseableAddableIterator(listInstances);
    }

    public CIMInstance getTCPProtocolEndpointInstance(CIMObjectPath opTCPProtocolEndpoint) throws WBEMException {
        return this.getTCPProtocolEndpointInstance(opTCPProtocolEndpoint, this.getEndpoint(opTCPProtocolEndpoint));
    }

    public CIMInstance getTCPProtocolEndpointInstance(CIMObjectPath op, EndPoint endpoint) throws WBEMException {
        Protocol protocol = this.getProtocol(endpoint);
        if (null == protocol || null == endpoint) {
            throw new WBEMException(6);
        }
        EnabledState enabledState = EnabledState.getEnabledState(this.mRunningEndpoints.contains(endpoint.getName()));
        return TCPProtocolEndpointProvider.generateTCPProtocolEndpointInstance(op, protocol, endpoint, enabledState);
    }

    @Override
    public void initialize(WBEMServer pServer, ProviderHandle pClient, Logger pLogger) {
        ProtocolServiceService.setProtocolServiceService(this);
        try {
            Protocol[] protocols;
            super.initialize(pClient);
            this.mEmbeddedData = JServerSettings.getEmbeddedData();
            if (null == this.mEmbeddedData) {
                this.mEmbeddedData = new JServerProtocolData(pClient, pServer);
            }
            for (Protocol protocol : protocols = this.mEmbeddedData.getSupportedProtocols()) {
                EndPoint[] endpoints;
                String protocolName = protocol.getProtocolName();
                this.mProtocolMap.put(protocolName, protocol);
                if (protocol.getEnabledDefault()) {
                    this.mRunningProtocols.add(protocolName);
                }
                for (EndPoint endpoint : endpoints = protocol.getEndPoints()) {
                    this.mEndpointMap.put(endpoint.getName(), endpoint);
                    if (!endpoint.getEnabledDefault()) continue;
                    this.mRunningEndpoints.add(endpoint.getName());
                }
            }
        }
        catch (Throwable th) {
            mLogger.log(Level.SEVERE, th.getMessage());
        }
        if (this.mRunningEndpoints.isEmpty()) {
            FailSafeLog.failSafe((String)WSIStandardMessages.getMessage((String)"ERROR_NO_TCPPROTOCOLENDPOINT_STARTED", null), (Object[])null);
            System.exit(-1);
        }
    }

    public CIMInstance listenOnPortIF(CIMObjectPath op, String protocolName, int port, String protocolIFType, CIMObjectPath opIPEndpoint) throws WBEMException {
        InetAddress boundedAddress = null;
        if (null != opIPEndpoint) {
            CIMInstance instIPProtocolEndpoint = mHandle.getInstance(opIPEndpoint, null);
            String ipAddress = (String)instIPProtocolEndpoint.getPropertyValue("IPv4Address");
            if (null == ipAddress) {
                ipAddress = (String)instIPProtocolEndpoint.getPropertyValue("IPv6Address");
            }
            if (null == ipAddress) {
                Object[] objs = new Object[]{opIPEndpoint};
                mLogger.log(Level.WARNING, "Cannot create new TCPProtocolEndpoint that is bounded to IPProtocolEndpoint, {0} because this IPProtocolEndpoint doesn't have an IPv4 or IPv6 address", objs);
                throw new WBEMException(1);
            }
            try {
                boundedAddress = InetAddress.getByName(ipAddress);
            }
            catch (UnknownHostException uhe) {
                Object[] objs = new Object[]{ipAddress};
                mLogger.log(Level.WARNING, "Cannot create new TCPProtocolEndpoint that is bounded to IPAddress {0} because this IPAddress is not available on this system", objs);
                throw new WBEMException(1);
            }
        }
        return this.createTCPProtocolEndpoint(op, protocolName, port, protocolIFType, boundedAddress, EnabledDefault.Disabled, EnabledState.Enabled);
    }

    public void modifyProtocolServiceInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        CIMObjectPath opProtocolService = ci.getObjectPath();
        try {
            IndicationManager indicationFactory;
            String protocolName = this.getProtocolName((String)ci.getPropertyValue("Name"));
            if (null == protocolName) {
                throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)opProtocolService, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)ci.getClassName());
            }
            Protocol protocol = this.mProtocolMap.get(protocolName);
            if (null == protocol) {
                throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)opProtocolService, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)ci.getClassName());
            }
            EnabledState currentEnabledState = EnabledState.getEnabledState(this.mRunningProtocols.contains(protocolName));
            EnabledDefault currentEnabledDefault = EnabledDefault.getEnabledDefault(protocol.getEnabledDefault());
            CIMInstance originalInstance = ProtocolServiceProvider.generateProtocolServiceInstance(ci.getObjectPath(), protocol, currentEnabledState);
            String errMsg = null;
            EnabledState newEnabledState = null;
            EnabledDefault newEnabledDefault = null;
            if (null != propertyList) {
                for (String propertyName : propertyList) {
                    Object[] objs;
                    if (!"EnabledDefault".equalsIgnoreCase(propertyName) && !"EnabledState".equalsIgnoreCase(propertyName)) {
                        Object[] objs2 = new Object[]{ci.getClassName(), propertyName};
                        MessageFormat msgFormat = new MessageFormat("{0} does not support modifying property {1}");
                        errMsg = msgFormat.format(objs2);
                        continue;
                    }
                    if ("EnabledState".equalsIgnoreCase(propertyName)) {
                        UnsignedInteger16 cpvNewEnabledState = (UnsignedInteger16)ci.getPropertyValue("EnabledState");
                        EnabledState enabledState = newEnabledState = null != cpvNewEnabledState ? EnabledState.getEnabledState(cpvNewEnabledState.intValue()) : EnabledState.Enabled;
                        if (null != newEnabledState && (newEnabledState == EnabledState.Enabled || newEnabledState == EnabledState.Disabled)) continue;
                        objs = new Object[]{"EnabledState", null == newEnabledState ? "null" : Integer.valueOf(newEnabledState.getValue()), EnabledState.Enabled.getValue(), EnabledState.Disabled.getValue()};
                        MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                        errMsg = msgFormat.format(objs);
                    } else {
                        if (!"EnabledDefault".equalsIgnoreCase(propertyName)) continue;
                        UnsignedInteger16 cpvNewEnabledDefault = (UnsignedInteger16)ci.getPropertyValue("EnabledDefault");
                        EnabledDefault enabledDefault = newEnabledDefault = null != cpvNewEnabledDefault ? EnabledDefault.getEnabledDefault(cpvNewEnabledDefault.intValue()) : EnabledDefault.Enabled;
                        if (null != newEnabledDefault && (newEnabledDefault == EnabledDefault.Enabled || newEnabledDefault == EnabledDefault.Disabled)) continue;
                        objs = new Object[]{"EnabledDefault", newEnabledDefault, EnabledDefault.Enabled.getValue(), EnabledDefault.Disabled.getValue()};
                        MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                        errMsg = msgFormat.format(objs);
                    }
                    break;
                }
            } else {
                UnsignedInteger16 cpvNewEnabledDefault;
                UnsignedInteger16 cpvNewEnabledState = (UnsignedInteger16)ci.getPropertyValue("EnabledState");
                EnabledState enabledState = newEnabledState = null != cpvNewEnabledState ? EnabledState.getEnabledState(cpvNewEnabledState.intValue()) : EnabledState.Enabled;
                if (null != cpvNewEnabledState && newEnabledState != EnabledState.Enabled && newEnabledState != EnabledState.Disabled) {
                    Object[] objs = new Object[]{"EnabledState", newEnabledState.getValue(), EnabledState.Enabled.getValue(), EnabledState.Disabled.getValue()};
                    MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                    errMsg = msgFormat.format(objs);
                }
                EnabledDefault enabledDefault = newEnabledDefault = null != (cpvNewEnabledDefault = (UnsignedInteger16)ci.getPropertyValue("EnabledDefault")) ? EnabledDefault.getEnabledDefault(cpvNewEnabledDefault.intValue()) : EnabledDefault.Enabled;
                if (null != cpvNewEnabledDefault && newEnabledDefault != EnabledDefault.Enabled && newEnabledDefault != EnabledDefault.Disabled) {
                    Object[] objs = new Object[]{"EnabledDefault", cpvNewEnabledDefault, EnabledDefault.Enabled.getValue(), EnabledDefault.Disabled.getValue()};
                    MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                    errMsg = msgFormat.format(objs);
                }
            }
            if (null != errMsg) {
                mLogger.info(errMsg);
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)opProtocolService, errMsg, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)ci.getClassName());
            }
            if (null != newEnabledDefault && newEnabledDefault != currentEnabledDefault) {
                protocol.setEnabledDefault(EnabledDefault.Enabled == newEnabledDefault);
            }
            if (null != newEnabledState && newEnabledState != currentEnabledState) {
                StateChange stateChange = newEnabledState == EnabledState.Enabled ? StateChange.Enabled : StateChange.Disabled;
                this.setProtocolServiceEnabledState(opProtocolService, stateChange);
            }
            if (null != (indicationFactory = this.mIndicationFactoryMap.get(ci.getClassName().toLowerCase())) && indicationFactory.hasActiveSubscriptions(IndicationType.InstanceModification)) {
                try {
                    EnabledState enabledState = EnabledState.getEnabledState(this.mRunningEndpoints.contains(protocolName));
                    CIMInstance sourceInstance = ProtocolServiceProvider.generateProtocolServiceInstance(ci.getObjectPath(), protocol, enabledState);
                    indicationFactory.deliverInstanceIndication(IndicationType.InstanceModification, sourceInstance, originalInstance);
                }
                catch (WBEMException we) {
                    Object[] objs = new Object[]{opProtocolService};
                    mLogger.log(Level.WARNING, "ModifyInstance: Cannot handle Indication of CIM_InstModification because an exception was thrown getting updated instance of {0}", objs);
                }
            }
        }
        catch (WBEMException we) {
            WBEMException exc = we;
            exc = we.getID() == 6 ? WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)opProtocolService, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)opProtocolService.getObjectName()) : (we.getID() == 7 ? WBEMOperationErrors.getOperationNotSupportedByProviderException((CIMObjectPath)opProtocolService, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)opProtocolService.getObjectName()) : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)opProtocolService, (Throwable)we, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)opProtocolService.getObjectName()));
            throw exc;
        }
    }

    public void modifyTCPProtocolEndpoint(CIMInstance ci, String[] propertyList) throws WBEMException {
        CIMObjectPath opEndpoint = ci.getObjectPath();
        try {
            IndicationManager indicationFactory;
            EndPoint endpoint = this.getEndpoint(opEndpoint);
            Protocol protocol = this.getProtocol(endpoint);
            if (null == protocol) {
                throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)opEndpoint, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)ci.getClassName());
            }
            EnabledState currentEnabledState = EnabledState.getEnabledState(this.mRunningEndpoints.contains(endpoint.getName()));
            EnabledDefault currentEnabledDefault = EnabledDefault.getEnabledDefault(endpoint.getEnabledDefault());
            CIMInstance originalInstance = TCPProtocolEndpointProvider.generateTCPProtocolEndpointInstance(ci.getObjectPath(), protocol, endpoint, currentEnabledState);
            String errMsg = null;
            EnabledState newEnabledState = null;
            EnabledDefault newEnabledDefault = null;
            if (null != propertyList) {
                for (String propertyName : propertyList) {
                    Object[] objs;
                    if (!"EnabledDefault".equalsIgnoreCase(propertyName) && !"EnabledState".equalsIgnoreCase(propertyName)) {
                        Object[] objs2 = new Object[]{ci.getClassName(), propertyName};
                        MessageFormat msgFormat = new MessageFormat("{0} does not support modifying property {1}");
                        errMsg = msgFormat.format(objs2);
                        continue;
                    }
                    if ("EnabledState".equalsIgnoreCase(propertyName)) {
                        UnsignedInteger16 cpvNewEnabledState = (UnsignedInteger16)ci.getPropertyValue("EnabledState");
                        EnabledState enabledState = newEnabledState = null != cpvNewEnabledState ? EnabledState.getEnabledState(cpvNewEnabledState.intValue()) : EnabledState.Enabled;
                        if (null != newEnabledState && (newEnabledState == EnabledState.Enabled || newEnabledState == EnabledState.Disabled)) continue;
                        objs = new Object[]{"EnabledState", null == newEnabledState ? "null" : Integer.valueOf(newEnabledState.getValue()), EnabledState.Enabled.getValue(), EnabledState.Disabled.getValue()};
                        MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                        errMsg = msgFormat.format(objs);
                    } else {
                        if (!"EnabledDefault".equalsIgnoreCase(propertyName)) continue;
                        UnsignedInteger16 cpvNewEnabledDefault = (UnsignedInteger16)ci.getPropertyValue("EnabledDefault");
                        EnabledDefault enabledDefault = newEnabledDefault = null != cpvNewEnabledDefault ? EnabledDefault.getEnabledDefault(cpvNewEnabledDefault.intValue()) : EnabledDefault.Enabled;
                        if (null != newEnabledDefault && (newEnabledDefault == EnabledDefault.Enabled || newEnabledDefault == EnabledDefault.Disabled)) continue;
                        objs = new Object[]{"EnabledDefault", newEnabledDefault, EnabledDefault.Enabled.getValue(), EnabledDefault.Disabled.getValue()};
                        MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                        errMsg = msgFormat.format(objs);
                    }
                    break;
                }
            } else {
                UnsignedInteger16 cpvNewEnabledDefault;
                UnsignedInteger16 cpvNewEnabledState = (UnsignedInteger16)ci.getPropertyValue("EnabledState");
                EnabledState enabledState = newEnabledState = null != cpvNewEnabledState ? EnabledState.getEnabledState(cpvNewEnabledState.intValue()) : EnabledState.Enabled;
                if (null != cpvNewEnabledState && newEnabledState != EnabledState.Enabled && newEnabledState != EnabledState.Disabled) {
                    Object[] objs = new Object[]{"EnabledState", newEnabledState.getValue(), EnabledState.Enabled.getValue(), EnabledState.Disabled.getValue()};
                    MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                    errMsg = msgFormat.format(objs);
                }
                EnabledDefault enabledDefault = newEnabledDefault = null != (cpvNewEnabledDefault = (UnsignedInteger16)ci.getPropertyValue("EnabledDefault")) ? EnabledDefault.getEnabledDefault(cpvNewEnabledDefault.intValue()) : EnabledDefault.Enabled;
                if (null != cpvNewEnabledDefault && newEnabledDefault != EnabledDefault.Enabled && newEnabledDefault != EnabledDefault.Disabled) {
                    Object[] objs = new Object[]{"EnabledDefault", cpvNewEnabledDefault, EnabledDefault.Enabled.getValue(), EnabledDefault.Disabled.getValue()};
                    MessageFormat msgFormat = new MessageFormat("The specified {0} value of {1} is invalid. The only support values are {2} and {3}");
                    errMsg = msgFormat.format(objs);
                }
            }
            if (null != errMsg) {
                mLogger.info(errMsg);
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)opEndpoint, errMsg, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)ci.getClassName());
            }
            if (null != newEnabledDefault && newEnabledDefault != currentEnabledDefault) {
                this.setProtocolEndpointEnabledDefault(opEndpoint, newEnabledDefault == EnabledDefault.Enabled);
            }
            if (null != newEnabledState && newEnabledState != currentEnabledState) {
                StateChange stateChange = newEnabledState == EnabledState.Enabled ? StateChange.Enabled : StateChange.Disabled;
                this.setProtocolEndpointEnabledState(opEndpoint, stateChange, true);
            }
            if (null != (indicationFactory = this.mIndicationFactoryMap.get(ci.getClassName().toLowerCase())) && indicationFactory.hasActiveSubscriptions(IndicationType.InstanceModification)) {
                try {
                    EnabledState enabledState = EnabledState.getEnabledState(this.mRunningEndpoints.contains(endpoint.getName()));
                    CIMInstance sourceInstance = TCPProtocolEndpointProvider.generateTCPProtocolEndpointInstance(ci.getObjectPath(), protocol, endpoint, enabledState);
                    indicationFactory.deliverInstanceIndication(IndicationType.InstanceModification, sourceInstance, originalInstance);
                }
                catch (WBEMException we) {
                    Object[] objs = new Object[]{opEndpoint};
                    mLogger.log(Level.WARNING, "ModifyInstance: Cannot handle Indication of CIM_InstModification because an exception was thrown getting updated instance of {0}", objs);
                }
            }
        }
        catch (WBEMException we) {
            WBEMException exc = we;
            exc = we.getID() == 6 ? WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)opEndpoint, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)opEndpoint.getObjectName()) : (we.getID() == 7 ? WBEMOperationErrors.getOperationNotSupportedByProviderException((CIMObjectPath)opEndpoint, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)opEndpoint.getObjectName()) : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)opEndpoint, (Throwable)we, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)opEndpoint.getObjectName()));
            throw exc;
        }
    }

    public void removeTCPProtocolEndpoint(CIMObjectPath opTCPProtocolEndpoint) throws WBEMException {
        EndPoint endpoint;
        IndicationManager indicationFactory = this.mIndicationFactoryMap.get(opTCPProtocolEndpoint.getObjectName().toLowerCase());
        CIMInstance sourceInstance = null;
        if (null != indicationFactory && indicationFactory.hasActiveSubscriptions(IndicationType.InstanceDeletion)) {
            sourceInstance = this.getTCPProtocolEndpointInstance(opTCPProtocolEndpoint);
        }
        if (null == (endpoint = this.getEndpoint(opTCPProtocolEndpoint))) {
            throw new WBEMException(6);
        }
        Protocol protocol = this.getProtocol(endpoint);
        if (null == protocol) {
            throw new WBEMException(6);
        }
        try {
            String name = endpoint.getName();
            protocol.removeEndpoint(endpoint);
            this.mEndpointMap.remove(name);
            this.mRunningEndpoints.remove(name);
            if (null != indicationFactory && indicationFactory.hasActiveSubscriptions(IndicationType.InstanceDeletion)) {
                indicationFactory.deliverInstanceIndication(IndicationType.InstanceDeletion, sourceInstance, null);
            }
            this.resetSLP();
        }
        catch (WBEMException we) {
            WBEMException exc = we;
            exc = we.getID() == 6 ? WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)opTCPProtocolEndpoint, (WBEMOperation)WBEMOperation.DELETEINSTANCE, (String)opTCPProtocolEndpoint.getObjectName()) : (we.getID() == 7 ? WBEMOperationErrors.getOperationNotSupportedByProviderException((CIMObjectPath)opTCPProtocolEndpoint, (WBEMOperation)WBEMOperation.DELETEINSTANCE, (String)opTCPProtocolEndpoint.getObjectName()) : WBEMOperationErrors.getOtherFailureException((CIMObjectPath)opTCPProtocolEndpoint, (Throwable)we, (WBEMOperation)WBEMOperation.DELETEINSTANCE, (String)opTCPProtocolEndpoint.getObjectName()));
            throw exc;
        }
    }

    @Override
    public void reset() throws WBEMException {
    }

    public void resetSLP() {
        try {
            JServerService service = JServerServiceAdapterFactory.getService(SERVICE_SLP);
            if (null != service) {
                service.reset();
            } else {
                mLogger.log(Level.SEVERE, "Could not reset SLP Service because the SLP Service could not be found");
            }
        }
        catch (WBEMException we) {
            Object[] objs = new Object[]{we.getMessage()};
            mLogger.log(Level.SEVERE, "Caught exception trying to reset SLP Service: {0}", objs);
        }
    }

    public void setProtocolEndpointEnabledDefault(CIMObjectPath opTCPProtocolEndpoint, boolean enabled) throws WBEMException {
        EndPoint endPoint = this.getEndpoint(opTCPProtocolEndpoint);
        endPoint.setEnabledDefault(enabled);
    }

    public void setProtocolEndpointEnabledState(CIMObjectPath opTCPProtocolEndpoint, StateChange requestedState, boolean ignoreIndicationDelivery) throws WBEMException {
        this.setProtocolEndpointEnabledState(opTCPProtocolEndpoint, requestedState, false, ignoreIndicationDelivery);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProtocolEndpointEnabledState(CIMObjectPath opTCPProtocolEndpoint, StateChange requestedState, boolean force, boolean ignoreIndicationDelivery) throws WBEMException {
        if (null == opTCPProtocolEndpoint) throw new WBEMException(6);
        EndPoint endpoint = this.mEndpointMap.get(opTCPProtocolEndpoint.getKeyValue("Name"));
        if (null == endpoint) throw new WBEMException(6);
        Protocol protocol = this.getProtocol(endpoint);
        if (null == protocol) {
            Object[] objs = new Object[]{endpoint};
            mLogger.log(Level.WARNING, "Could not find ProtocolService for specified endpoint: {0}", objs);
            throw new WBEMException(1);
        }
        IndicationManager indicationFactory = this.mIndicationFactoryMap.get(opTCPProtocolEndpoint.getObjectName().toLowerCase());
        CIMInstance instPrevious = null;
        if (!ignoreIndicationDelivery && null != indicationFactory && indicationFactory.hasActiveSubscriptions(IndicationType.InstanceModification)) {
            instPrevious = this.getTCPProtocolEndpointInstance(opTCPProtocolEndpoint, endpoint);
        }
        boolean madeChanges = false;
        boolean currentlyEnabled = this.mRunningEndpoints.contains(endpoint.getName());
        if (StateChange.Enabled == requestedState && !currentlyEnabled) {
            protocol.startEndpoint(endpoint.getPort(), endpoint.getScheme(), endpoint.getBoundToAddress());
            this.mRunningEndpoints.add(endpoint.getName());
            madeChanges = true;
        } else if (StateChange.Disabled == requestedState && currentlyEnabled) {
            if (this.mRunningEndpoints.size() > 1 || force) {
                protocol.stopEndpoint(endpoint.getPort());
                this.mRunningEndpoints.remove(endpoint.getName());
                madeChanges = true;
            } else {
                mLogger.log(Level.WARNING, "Cannot disable TCPProtocolEndpoint {0} because it is the only one running");
                throw new WBEMException(1);
            }
        }
        if (!madeChanges) return;
        this.resetSLP();
        if (ignoreIndicationDelivery || null == indicationFactory || !indicationFactory.hasActiveSubscriptions(IndicationType.InstanceModification)) return;
        indicationFactory.deliverInstanceIndication(IndicationType.InstanceModification, this.getTCPProtocolEndpointInstance(opTCPProtocolEndpoint, endpoint), instPrevious);
    }

    public void setProtocolServiceEnabledDefault(CIMObjectPath opProtocolService, boolean enabled) throws WBEMException {
        Protocol protocol = this.getProtocol(opProtocolService);
        protocol.setEnabledDefault(enabled);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setProtocolServiceEnabledState(CIMObjectPath opProtocolService, StateChange requestedState) throws WBEMException {
        if (null == opProtocolService) {
            mLogger.log(Level.WARNING, "Cannot start null ProtocolService");
            throw new WBEMException(6);
        }
        boolean slpNeedsReset = false;
        String protocolName = this.getProtocolName((String)opProtocolService.getKeyValue("Name"));
        if (null == protocolName) {
            Object[] objs = new Object[]{opProtocolService};
            mLogger.log(Level.INFO, "Cannot find Protocol Type for ProtocolService: {0}", objs);
            throw new WBEMException(6, opProtocolService.toString());
        }
        Protocol protocol = this.mProtocolMap.get(protocolName);
        if (null == protocol) {
            Object[] objs = new Object[]{opProtocolService};
            mLogger.log(Level.INFO, "Cannot find Protocol for ProtocolService: {0}", objs);
            throw new WBEMException(6, opProtocolService.toString());
        }
        boolean currentlyEnabled = this.mRunningProtocols.contains(protocolName);
        if (StateChange.Enabled == requestedState && !currentlyEnabled) {
            EndPoint[] endpoints;
            this.mRunningProtocols.add(protocolName);
            EndPoint[] arr$ = endpoints = protocol.getEndPoints();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                EndPoint endpoint = arr$[i$];
                if (endpoint.getEnabledDefault()) {
                    protocol.startEndpoint(endpoint.getPort(), endpoint.getScheme(), endpoint.getBoundToAddress());
                    this.mRunningEndpoints.add(endpoint.getName());
                    slpNeedsReset = true;
                }
                ++i$;
            }
            return;
        }
        if (StateChange.Disabled != requestedState) return;
        if (!currentlyEnabled) return;
        if (this.canDisableProtocolService(opProtocolService)) {
            EndPoint[] endpoints;
            for (EndPoint endpoint : endpoints = protocol.getEndPoints()) {
                if (!this.mRunningEndpoints.contains(endpoint.getName())) continue;
                protocol.stopEndpoint(endpoint.getPort());
                this.mRunningEndpoints.remove(endpoint.getName());
                slpNeedsReset = true;
            }
        }
        if (!slpNeedsReset) return;
        this.resetSLP();
    }

    public void setTCPProtocolEndpointBindToAddress(CIMObjectPath opTCPProtocolEndpoint, CIMObjectPath opIPEndpoint) throws WBEMException {
        CIMInstance instIPProtocolEndpoint = mHandle.getInstance(opIPEndpoint, null);
        String ipAddress = (String)instIPProtocolEndpoint.getPropertyValue("IPv4Address");
        if (null == ipAddress) {
            ipAddress = (String)instIPProtocolEndpoint.getPropertyValue("IPv6Address");
        }
        if (null == ipAddress) {
            Object[] objs = new Object[]{opTCPProtocolEndpoint, opIPEndpoint};
            mLogger.log(Level.WARNING, "Cannot bind TCPProtocolEndpoint, {0}, to new IPAddress because the specified IPProtocolEndpoint, {1}, doesn't have an IPv4 or IPv6 address", objs);
            throw new WBEMException(1);
        }
        EndPoint endpoint = this.getEndpoint(opTCPProtocolEndpoint);
        if (null == endpoint) {
            throw new WBEMException(6);
        }
        CIMInstance previousInstance = this.getTCPProtocolEndpointInstance(opTCPProtocolEndpoint);
        String currentIPaddress = (String)previousInstance.getPropertyValue("BindToAddress");
        if (!ipAddress.equals(currentIPaddress)) {
            InetAddress boundedAddress = null;
            try {
                boundedAddress = InetAddress.getByName(ipAddress);
            }
            catch (UnknownHostException uhe) {
                Object[] objs = new Object[]{opTCPProtocolEndpoint, ipAddress};
                mLogger.log(Level.WARNING, "Cannot bind TCPProtocolEndpoint, {0}, to IPAddress, {1} because it doesn't exist on this  system.", objs);
                throw new WBEMException(1);
            }
            Protocol protocol = this.getProtocol(endpoint);
            if (null == protocol) {
                Object[] objs = new Object[]{endpoint};
                mLogger.log(Level.WARNING, "Could not find ProtocolService for specified endpoint: {0}", objs);
                throw new WBEMException(1);
            }
            ProtocolIFType protocolIFType = ProtocolIFType.getProtocolIFType(protocol.getProtocolName());
            if (null == protocolIFType) {
                Object[] objs = new Object[]{protocol.getProtocolName()};
                mLogger.log(Level.WARNING, "invalid protocol type: {0}", objs);
                throw new WBEMException(1);
            }
            int port = endpoint.getPort();
            protocol.startEndpoint(port, protocolIFType.getName(), boundedAddress);
            IndicationManager indicationFactory = this.mIndicationFactoryMap.get(opTCPProtocolEndpoint.getObjectName().toLowerCase());
            if (null != indicationFactory && indicationFactory.hasActiveSubscriptions(IndicationType.InstanceModification)) {
                CIMInstance sourceInstance = this.getTCPProtocolEndpointInstance(opTCPProtocolEndpoint, endpoint);
                indicationFactory.deliverInstanceIndication(IndicationType.InstanceModification, sourceInstance, previousInstance);
            }
        }
    }
}

