/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.utils;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.DaemonThreadFactory;
import com.ws.wbem.jserver.JServerProperties;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WBEMExecutor
implements Runnable {
    private static AtomicInteger sequence = new AtomicInteger();
    private final ExecutorService mExecuter;
    private final ExecutorService mProviderPool;
    private final ExecutorCompletionService<Boolean> mCompletionService;
    private final CloseableAddableIterator<?> mCAIterator;
    private final ArrayList<Callable<Boolean>> mCallableList;
    private final LinkedList<Future<Boolean>> mFutureList;
    private final int mSeqNum;
    private int mNumberSubmitted;

    public WBEMExecutor(ExecutorService pExecuter, ArrayList<Callable<Boolean>> pCallableList, CloseableAddableIterator<?> pCAIterator) {
        int numThreads;
        this.mExecuter = pExecuter;
        this.mCallableList = pCallableList;
        this.mNumberSubmitted = pCallableList.size();
        this.mCAIterator = pCAIterator;
        this.mFutureList = new LinkedList();
        this.mSeqNum = sequence.addAndGet(1);
        try {
            numThreads = Integer.parseInt(JServerProperties.getNumberProviderThreads());
        }
        catch (NumberFormatException nfe) {
            numThreads = 10;
        }
        this.mProviderPool = Executors.newFixedThreadPool(this.mNumberSubmitted < numThreads ? this.mNumberSubmitted : numThreads, new DaemonThreadFactory());
        ((ThreadPoolExecutor)this.mProviderPool).setKeepAliveTime(1L, TimeUnit.SECONDS);
        ((ThreadPoolExecutor)this.mProviderPool).allowCoreThreadTimeOut(true);
        ((ThreadPoolExecutor)this.mProviderPool).setCorePoolSize(0);
        this.mCompletionService = new ExecutorCompletionService(this.mProviderPool);
    }

    private int checkFutureList() {
        Future<Boolean> future;
        while (null != (future = this.mFutureList.poll())) {
            try {
                future.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException to) {
                this.mFutureList.offer(future);
                break;
            }
            catch (Throwable t) {
                this.mFutureList.offer(future);
                break;
            }
        }
        return this.mFutureList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCompleted() {
        boolean ret = false;
        int removed = 0;
        try {
            if (this.checkFutureList() == 0) {
                for (int i = 0; i < this.mNumberSubmitted; ++i) {
                    Future<Boolean> future = null;
                    try {
                        future = this.mCompletionService.poll(500L, TimeUnit.MILLISECONDS);
                        if (null == future) continue;
                        ++removed;
                        future.get(500L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    catch (ExecutionException e) {
                        Logger logger = Logger.getLogger("com.ws.wbem.jserver");
                        logger.log(Level.SEVERE, "Exception getting results", e);
                        continue;
                    }
                    catch (TimeoutException to) {
                        this.mFutureList.offer(future);
                    }
                }
            }
        }
        catch (Throwable t) {
            Logger logger = Logger.getLogger("com.ws.wbem.jserver");
            logger.log(Level.SEVERE, "Unexpected exception getting results", t);
        }
        finally {
            this.mNumberSubmitted -= removed;
            if (0 >= this.mNumberSubmitted && this.mFutureList.isEmpty()) {
                ret = true;
                this.mCAIterator.done();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        StringBuilder tgName = new StringBuilder(thread.getThreadGroup().getName());
        tgName = tgName.append(":WBEMExecutor - ");
        tgName = tgName.append(this.mSeqNum);
        thread.setName(tgName.toString());
        try {
            if (!this.mCallableList.isEmpty()) {
                this.submitThreads();
                this.mProviderPool.shutdown();
            }
            if (!this.isCompleted()) {
                this.mExecuter.execute(this);
            }
        }
        catch (Throwable t) {
            Logger logger = Logger.getLogger("com.ws.wbem.jserver");
            logger.log(Level.SEVERE, "An error occurred processing call list: " + this.mFutureList, t);
        }
        finally {
            thread.setName(tgName.append(" - idle").toString());
        }
    }

    private void submitThreads() {
        try {
            for (Callable<Boolean> callable : this.mCallableList) {
                this.mCompletionService.submit(callable);
            }
            this.mCallableList.clear();
        }
        catch (Throwable t) {
            Logger logger = Logger.getLogger("com.ws.wbem.jserver");
            logger.log(Level.SEVERE, "Unexpected exception getting results", t);
        }
    }
}

