/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;

public class PropertiesWithComments
extends Properties {
    private static final long serialVersionUID = 913717062283307384L;
    private final ArrayList<String> lineData = new ArrayList(1);
    private final ArrayList<String> keyData = new ArrayList(1);

    public void add(String key, String value, String comment) {
        this.put(key, value);
        this.lineData.add(comment);
        this.keyData.add(key);
    }

    private void formatForOutput(String str, StringBuffer buffer, boolean key) {
        if (key) {
            buffer.setLength(0);
            buffer.ensureCapacity(str.length());
        } else {
            buffer.ensureCapacity(buffer.length() + str.length());
        }
        boolean head = true;
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case ' ': {
                    buffer.append(head ? "\\ " : " ");
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    buffer.append('\\').append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String hex = Integer.toHexString(c);
                        buffer.append("\\u0000".substring(0, 6 - hex.length()));
                        buffer.append(hex);
                        break;
                    }
                    buffer.append(c);
                }
            }
            if (c == ' ') continue;
            head = key;
        }
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "ISO-8859-1"));
        this.lineData.clear();
        this.keyData.clear();
        while ((line = reader.readLine()) != null) {
            boolean isDelim;
            int pos;
            char c = '\u0000';
            for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
            }
            if (line.length() - pos == 0 || line.charAt(pos) == '#' || line.charAt(pos) == '!') {
                this.lineData.add(line);
                this.keyData.add("");
                continue;
            }
            int start = pos;
            boolean needsEscape = line.indexOf(92, pos) != -1;
            StringBuffer key = new StringBuffer();
            block14: while (pos < line.length() && !Character.isWhitespace(c = line.charAt(pos++)) && c != '=' && c != ':') {
                if (needsEscape && c == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        if (line == null) {
                            line = "";
                        }
                        for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            key.append('\n');
                            continue block14;
                        }
                        case 't': {
                            key.append('\t');
                            continue block14;
                        }
                        case 'r': {
                            key.append('\r');
                            continue block14;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block14;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            key.append(uni);
                            pos += 4;
                            continue block14;
                        }
                    }
                    key.append(c);
                    continue;
                }
                if (!needsEscape) continue;
                key.append(c);
            }
            boolean bl = isDelim = c == ':' || c == '=';
            String keyString = needsEscape ? key.toString() : (isDelim || Character.isWhitespace(c) ? line.substring(start, pos - 1) : line.substring(start, pos));
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (!(isDelim || c != ':' && c != '=')) {
                ++pos;
                while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                    ++pos;
                }
            }
            if (!needsEscape) {
                this.put(keyString, line.substring(pos));
                this.lineData.add("");
                this.keyData.add(keyString);
                continue;
            }
            StringBuffer element = new StringBuffer(line.length() - pos);
            block18: while (pos < line.length()) {
                if ((c = line.charAt(pos++)) == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        if (line == null) break;
                        for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        element.ensureCapacity(line.length() - pos + element.length());
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            element.append('\n');
                            continue block18;
                        }
                        case 't': {
                            element.append('\t');
                            continue block18;
                        }
                        case 'r': {
                            element.append('\r');
                            continue block18;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block18;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            element.append(uni);
                            pos += 4;
                            continue block18;
                        }
                    }
                    element.append(c);
                    continue;
                }
                element.append(c);
            }
            this.put(keyString, element.toString());
            this.lineData.add("");
            this.keyData.add(keyString);
        }
    }

    @Override
    public void store(OutputStream out, String header) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, "ISO-8859-1"));
        if (null == header || !header.isEmpty()) {
            throw new IllegalArgumentException("header shall be null or empty string");
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.lineData.size(); ++i) {
            String line = this.lineData.get(i);
            String key = this.keyData.get(i);
            if (key.length() > 0) {
                this.formatForOutput(key, s, true);
                s.append('=');
                this.formatForOutput((String)this.get(key), s, false);
                writer.println(s);
                continue;
            }
            writer.println(line);
        }
        writer.flush();
    }
}

