/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Resources {
    private static final String ERROR_NO_RESOURCE_BUNDLE = "CRITICAL ERROR: Could not load resource bundle ";
    private final Locale mLocale = Locale.getDefault();
    private final String mResourceBundle;

    public Resources(String pName) {
        this.mResourceBundle = pName;
    }

    public String getResourceBundle() {
        return this.mResourceBundle;
    }

    public String loadString(String pID) {
        return this.loadString(pID, this.mLocale);
    }

    public String loadString(String pID, Locale pLocale) throws MissingResourceException {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(this.mResourceBundle, pLocale);
        }
        catch (MissingResourceException e) {
            bundle = ResourceBundle.getBundle(this.mResourceBundle, Locale.ENGLISH);
        }
        if (bundle == null) {
            System.err.println(ERROR_NO_RESOURCE_BUNDLE + this.mResourceBundle);
            return null;
        }
        return bundle.getString(pID);
    }

    private ResourceBundle getBundle(Locale[] pLocale) {
        ResourceBundle bundle = null;
        if (pLocale != null) {
            for (int i = 0; i < pLocale.length; ++i) {
                try {
                    bundle = ResourceBundle.getBundle(this.mResourceBundle, pLocale[i]);
                    return bundle;
                }
                catch (MissingResourceException e) {
                    bundle = null;
                    continue;
                }
            }
        }
        bundle = ResourceBundle.getBundle(this.mResourceBundle, Locale.ENGLISH);
        return bundle;
    }

    public String loadString(String pID, Locale[] pLocale) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle(pLocale);
        if (bundle == null) {
            System.err.println(ERROR_NO_RESOURCE_BUNDLE + this.mResourceBundle);
            return null;
        }
        return bundle.getString(pID);
    }
}

