/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities.cli;

import com.ws.utilities.cli.CLICommand;
import com.ws.utilities.cli.CLIOption;
import java.util.ArrayList;

public class CommandLine {
    private String mProgram;
    private String mCopyright;
    private final ArrayList<CLIOption> mOptions = new ArrayList();
    private final ArrayList<CLICommand> mCommands = new ArrayList();
    private final ArrayList<String> mExamples = new ArrayList();

    public CommandLine() {
    }

    public CommandLine(String name) {
        this();
        this.mProgram = name;
    }

    public String getProgramName() {
        return this.mProgram;
    }

    public void addCommand(CLICommand command) {
        this.mCommands.add(command);
    }

    public void setCommandValue(int index, String value) {
        CLICommand cli = this.mCommands.get(index);
        cli.setValue(value);
        cli.setSelected(true);
    }

    public boolean isCommandRequired(int index) {
        return index >= this.mCommands.size() ? false : this.mCommands.get(index).isRequired();
    }

    public boolean isCommandSet(int index) {
        return index >= this.mCommands.size() ? false : this.mCommands.get(index).isSelected();
    }

    public int numCommands() {
        return this.mCommands.size();
    }

    public void addOption(CLIOption option) {
        this.mOptions.add(option);
    }

    public String getOptionValue(String opt) {
        for (int c = 0; c < this.mOptions.size(); ++c) {
            CLIOption o = this.mOptions.get(c);
            if (!o.getOption().equals(opt)) continue;
            return (String)o.getValue();
        }
        return null;
    }

    public void setOptionValue(String pOpt, String pValue) {
        for (int c = 0; c < this.mOptions.size(); ++c) {
            CLIOption o = this.mOptions.get(c);
            if (!o.getOption().equals(pOpt)) continue;
            o.setValue(pValue);
        }
    }

    public boolean isOptionSelected(String opt) {
        for (int c = 0; c < this.mOptions.size(); ++c) {
            CLIOption o = this.mOptions.get(c);
            if (!o.getOption().equals(opt)) continue;
            return o.isSelected();
        }
        return false;
    }

    public String getCommandValue(String opt) {
        for (int c = 0; c < this.mCommands.size(); ++c) {
            CLICommand o = this.mCommands.get(c);
            if (!o.getOption().equals(opt)) continue;
            return (String)o.getValue();
        }
        return null;
    }

    public void addExample(String example) {
        this.mExamples.add(example);
    }

    public void setCopyright(String copyright) {
        this.mCopyright = copyright;
    }

    public void displayHelp() {
        CLICommand cmd;
        int c;
        System.out.print(this.mProgram + " [options] ");
        for (c = 0; c < this.mCommands.size(); ++c) {
            cmd = this.mCommands.get(c);
            if (!cmd.isRequired()) {
                System.out.print("[");
            }
            System.out.print(cmd.getOption());
            if (!cmd.isRequired()) {
                System.out.print("]");
            }
            System.out.print(" ");
        }
        System.out.println();
        System.out.println(this.mCopyright != null ? this.mCopyright : "");
        if (this.mOptions.size() > 0) {
            System.out.println("Options:");
            for (c = 0; c < this.mOptions.size(); ++c) {
                CLIOption opt = this.mOptions.get(c);
                System.out.println("  -" + opt.getOption() + "\t" + opt.getDescription());
            }
        }
        System.out.println();
        if (this.numCommands() > 0) {
            System.out.println("Commands:");
            for (c = 0; c < this.numCommands(); ++c) {
                cmd = this.mCommands.get(c);
                System.out.println("  " + cmd.getOption() + "\t\t" + cmd.getDescription());
            }
        }
        System.out.println();
        if (this.mExamples.size() > 0) {
            System.out.println("Examples:");
            for (c = 0; c < this.mExamples.size(); ++c) {
                System.out.println("  " + this.mExamples.get(c));
            }
        }
        System.out.println();
    }

    public void parse(String[] args) {
        int i = -1;
        int index = -1;
        if (this.mCommands.size() > 0 && args.length == 0) {
            this.displayHelp();
            System.exit(0);
        }
        while (i + 1 < args.length) {
            if (args[++i].startsWith("-")) {
                for (int c = 0; c < this.mOptions.size(); ++c) {
                    CLIOption opt = this.mOptions.get(c);
                    if (!args[i].equals("-" + opt.getOption())) continue;
                    if (opt.hasArg()) {
                        if (++i >= args.length) {
                            this.displayHelp();
                            System.exit(1);
                        }
                        opt.setValue(args[i]);
                    }
                    opt.setSelected(true);
                }
                continue;
            }
            if (this.numCommands() >= ++index + 1) {
                this.setCommandValue(index, args[i]);
                continue;
            }
            this.displayHelp();
            System.exit(1);
            break;
        }
    }
}

