/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities.commandgenerator;

import com.ws.utilities.Resources;
import com.ws.utilities.commandgenerator.CommandGenerator;
import com.ws.utilities.commandgenerator.WBEMArguments;
import com.ws.utilities.commandgenerator.WBEMOperation;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifier;

public class JavaCommandGenerator
implements CommandGenerator {
    private static final String BUNDLE = "com.ws.utilities.commandgenerator.JavaCommandGenerator";
    private static final String ASSOCIATORS = "ASSOCIATORS";
    private static final String ASSOCIATOR_NAMES = "ASSOCIATOR_NAMES";
    private static final String REFERENCES = "REFERENCES";
    private static final String REFERENCE_NAMES = "REFERENCE_NAMES";
    private static final String ENUMERATE_INSTANCES = "ENUMERATE_INSTANCES";
    private static final String ENUMERATE_CLASSES = "ENUMERATE_CLASSES";
    private static final String ENUMERATE_CLASS_NAMES = "ENUMERATE_CLASS_NAMES";
    private static final String EXECUTE_QUERY = "EXECUTE_QUERY";
    private static final String GET_CLASS = "GET_CLASS";
    private static final String GET_INSTANCE = "GET_INSTANCE";
    private static final String MODIFY_INSTANCE = "MODIFY_INSTANCE";
    private static final String CREATE_INSTANCE = "CREATE_INSTANCE";
    private static final String INVOKE_METHOD = "INVOKE_METHOD";
    private static final String OBJECTPATH = "OBJECTPATH";
    private static final String OBJPATH = "OBJPATH";
    private static final String JAVACODE = "JAVACODE";
    private static final String TRYCATHBODY = "TRYCATHBODY";
    private static final String NEWPROPS = "NEWPROPS";
    private static final String PROPKEY = "PROPKEY";
    private static final String PROPERTIES = "PROPERTIES";
    private static final String CIMDATATYPE = "CIMDATATYPE";
    private static final String CIMDATATYPE_ARRAY = "CIMDATATYPE_ARRAY";
    private static final String PROP_VALUE_ARRAY = "PROP_VALUE_ARRAY";
    private static final String UINT = "UINT";
    private static final String SINT = "SINT";
    private static final String DATETIME = "DATETIME";
    private static final String CHARACTER = "CHARACTER";
    private static final String REFERENCE = "REFERENCE";
    private static final String OBJECT = "OBJECT";
    private static final String CLASS = "CLASS";
    private static final String QUALIFIER = "QUALIFIER";
    private static final String NEW_QUALIFIER = "NEW_QUALIFIER";
    private static final String CLASSPROP = "CLASSPROP";
    private static final String NEW_CLASSPROP = "NEW_CLASSPROP";
    private static final String PARAMETER = "PARAMETER";
    private static final String NEW_PARAMETER = "NEW_PARAMETER";
    private static final String NEW_ARGUMENT = "NEW_ARGUMENT";
    private static final String METHOD = "METHOD";
    private static final String NEW_METHOD = "NEW_METHOD";
    private static final String ITERATOR = "ITERATOR";
    private static final String CCLASS = "CCLASS";
    private static final String CINSTANCE = "CINSTANCE";
    private static final String COBJPATH = "COBJPATH";
    private static final String CQUALTYPE = "CQUALTYPE";
    private static final String OBJ = "OBJ";
    private static final String COMMA_SPACE = ", ";
    private static final String NEWLINE = "\n";
    private static final String TAB = "\t";
    private static final String DOUBLE_QUOT = "\"";
    private static final String NULL = "null";
    private static final String DOT = ".";
    private static final String OPEN_CURLYBRACE = "{";
    private static final String CLOSE_CURLYBRACE = "}";
    private static final String VAR_NAME = "c";
    private static final String VALUE = "Value";
    private static final String OPATH = "ObjPath";
    private static final String EIGHT = "8";
    private static final String SIXTEEN = "16";
    private static final String THIRTYTWO = "32";
    private static final String SIXTYFOUR = "64";
    private static final String BYTE = "Byte";
    private static final String SHORT = "Short";
    private static final String INTEGER = "Integer";
    private static final String LONG = "Long";
    private static final String FLOAT = "Float";
    private static final String DOUBLE = "Double";
    private static final String BOOLEAN = "Boolean";
    private final Resources mResourceBundleHandle = new Resources("com.ws.utilities.commandgenerator.JavaCommandGenerator");

    @Override
    public String getCommand(WBEMArguments pArguments) {
        String argumentResult = "";
        String commandResult = "";
        String[] strResult = null;
        ArrayList<String> argumentList = new ArrayList<String>();
        String viewOutput = this.mResourceBundleHandle.loadString(ITERATOR);
        switch (pArguments.getOperation()) {
            case ASSOCIATORS: {
                argumentList.clear();
                commandResult = this.generateAssociatorCommand(pArguments, argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                break;
            }
            case ASSOCIATOR_NAMES: {
                argumentList.clear();
                commandResult = this.generateAssociatorNamesCommand(argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                break;
            }
            case REFERENCES: {
                argumentList.clear();
                commandResult = this.generateReferencesCommand(pArguments, argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                break;
            }
            case REFERENCE_NAMES: {
                argumentList.clear();
                commandResult = this.generateReferenceNamesCommand(argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                break;
            }
            case ENUMERATE_INSTANCES: {
                argumentList.clear();
                commandResult = this.generateEnumerateInstancesCommand(pArguments, argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                break;
            }
            case ENUMERATE_CLASSES: {
                argumentList.clear();
                commandResult = this.generateEnumerateClassesCommand(pArguments, argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                break;
            }
            case ENUMERATE_CLASS_NAMES: {
                argumentList.clear();
                commandResult = this.generateEnumerateClassNamesCommand(pArguments, argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                break;
            }
            case ENUMERATE_QUALIFIER_TYPES: {
                strResult = this.generateQualifierTypeCommand(pArguments.getOperation().toString(), pArguments);
                argumentResult = strResult[0];
                commandResult = strResult[1];
                break;
            }
            case EXECUTE_QUERY: {
                argumentList.clear();
                commandResult = this.generateExecQueryCommand(argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                break;
            }
            case GET_CLASS: {
                argumentList.clear();
                commandResult = this.generateGetClassCommand(pArguments, argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                viewOutput = this.mResourceBundleHandle.loadString(CCLASS);
                break;
            }
            case GET_INSTANCE: {
                argumentList.clear();
                commandResult = this.generateGetInstanceCommand(pArguments, argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                viewOutput = this.mResourceBundleHandle.loadString(CINSTANCE);
                break;
            }
            case MODIFY_INSTANCE: {
                argumentList.clear();
                commandResult = this.generateModifyInstanceCommand(argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                viewOutput = "";
                break;
            }
            case GET_QUALIFIER_TYPE: {
                strResult = this.generateQualifierTypeCommand(pArguments.getOperation().toString(), pArguments);
                argumentResult = strResult[0];
                commandResult = strResult[1];
                viewOutput = this.mResourceBundleHandle.loadString(CQUALTYPE);
                break;
            }
            case DELETE_QUALIFIER_TYPE: {
                strResult = this.generateQualifierTypeCommand(pArguments.getOperation().toString(), pArguments);
                argumentResult = strResult[0];
                commandResult = strResult[1];
                viewOutput = "";
                break;
            }
            case CREATE_INSTANCE: {
                argumentList.clear();
                commandResult = this.generateCreateInstanceCommand(argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                viewOutput = this.mResourceBundleHandle.loadString(COBJPATH);
                break;
            }
            case INVOKE_METHOD: {
                argumentList.clear();
                commandResult = this.generateInvokeMethodCommand(pArguments, argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
                viewOutput = this.mResourceBundleHandle.loadString(OBJ);
                break;
            }
            default: {
                argumentList.clear();
                viewOutput = pArguments.getOperation().equals((Object)WBEMOperation.ENUMERATE_QUALIFIER_TYPES) || pArguments.getOperation().equals((Object)WBEMOperation.ENUMERATE_INSTANCE_NAMES) ? this.mResourceBundleHandle.loadString(ITERATOR) : "";
                commandResult = this.generateCommand(pArguments.getOperation().toString(), argumentList);
                argumentResult = this.getArguments(pArguments, argumentList);
            }
        }
        StringBuilder codeResult = new StringBuilder();
        String host = this.evaluateValue((String)pArguments.getArgument("SERVER"));
        String pricipal = this.evaluateValue((String)pArguments.getArgument("PRINCIPAL"));
        String credential = this.evaluateValue((String)pArguments.getArgument("CREDENTIAL"));
        codeResult.append(this.generateCode(argumentResult, commandResult, host, pricipal, credential, viewOutput));
        return codeResult.toString();
    }

    private String generateAssociatorCommand(WBEMArguments pArgs, ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("ASSOCIATION_CLASS");
        pArgsList.add("RESULT_CLASS");
        pArgsList.add("ROLE");
        pArgsList.add("RESULT_ROLE");
        pArgsList.add("PROPERTY_LIST");
        Object incldQual = pArgs.getArgument("INCLUDE_QUALIFIERS");
        Object incldClsOrgn = pArgs.getArgument("INCLUDE_CLASS_ORIGIN");
        return MessageFormat.format(this.mResourceBundleHandle.loadString(ASSOCIATORS), incldQual, incldClsOrgn);
    }

    private String generateAssociatorNamesCommand(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("ASSOCIATION_CLASS");
        pArgsList.add("RESULT_CLASS");
        pArgsList.add("ROLE");
        pArgsList.add("RESULT_ROLE");
        return this.mResourceBundleHandle.loadString(ASSOCIATOR_NAMES);
    }

    private String generateReferencesCommand(WBEMArguments pArgs, ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("RESULT_CLASS");
        pArgsList.add("ROLE");
        pArgsList.add("PROPERTY_LIST");
        Object incldQual = pArgs.getArgument("INCLUDE_QUALIFIERS");
        Object incldClsOrgn = pArgs.getArgument("INCLUDE_CLASS_ORIGIN");
        return MessageFormat.format(this.mResourceBundleHandle.loadString(REFERENCES), incldQual, incldClsOrgn);
    }

    private String generateReferenceNamesCommand(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("RESULT_CLASS");
        pArgsList.add("ROLE");
        return this.mResourceBundleHandle.loadString(REFERENCE_NAMES);
    }

    private String generateEnumerateInstancesCommand(WBEMArguments pArgs, ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("PROPERTY_LIST");
        Object deep = pArgs.getArgument("DEEP_INHERITANCE");
        Object lclOnly = pArgs.getArgument("LOCALONLY");
        Object incldClsOrgn = pArgs.getArgument("INCLUDE_CLASS_ORIGIN");
        return MessageFormat.format(this.mResourceBundleHandle.loadString(ENUMERATE_INSTANCES), deep, lclOnly, incldClsOrgn);
    }

    private String generateEnumerateClassesCommand(WBEMArguments pArgs, ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        Object deep = pArgs.getArgument("DEEP_INHERITANCE");
        Object lclOnly = pArgs.getArgument("LOCALONLY");
        Object incldQual = pArgs.getArgument("INCLUDE_QUALIFIERS");
        Object incldClsOrgn = pArgs.getArgument("INCLUDE_CLASS_ORIGIN");
        return MessageFormat.format(this.mResourceBundleHandle.loadString(ENUMERATE_CLASSES), deep, lclOnly, incldQual, incldClsOrgn);
    }

    private String generateEnumerateClassNamesCommand(WBEMArguments pArgs, ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        Object deep = pArgs.getArgument("DEEP_INHERITANCE");
        return MessageFormat.format(this.mResourceBundleHandle.loadString(ENUMERATE_CLASS_NAMES), deep);
    }

    private String generateExecQueryCommand(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("QUERY");
        pArgsList.add("QUERY_LANGUAGE");
        return this.mResourceBundleHandle.loadString(EXECUTE_QUERY);
    }

    private String generateGetClassCommand(WBEMArguments pArgs, ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("PROPERTY_LIST");
        Object lclOnly = pArgs.getArgument("LOCALONLY");
        Object incldQual = pArgs.getArgument("INCLUDE_QUALIFIERS");
        Object incldClsOrgn = pArgs.getArgument("INCLUDE_CLASS_ORIGIN");
        return MessageFormat.format(this.mResourceBundleHandle.loadString(GET_CLASS), lclOnly, incldQual, incldClsOrgn);
    }

    private String generateGetInstanceCommand(WBEMArguments pArgs, ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("PROPERTY_LIST");
        Object lclOnly = pArgs.getArgument("LOCALONLY");
        Object incldClsOrgn = pArgs.getArgument("INCLUDE_CLASS_ORIGIN");
        return MessageFormat.format(this.mResourceBundleHandle.loadString(GET_INSTANCE), lclOnly, incldClsOrgn);
    }

    private String generateModifyInstanceCommand(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_INSTANCE");
        pArgsList.add("PROPERTY_LIST");
        return this.mResourceBundleHandle.loadString(MODIFY_INSTANCE);
    }

    private String[] generateQualifierTypeCommand(String pOperation, WBEMArguments pArgs) {
        CIMObjectPath objPath = (CIMObjectPath)pArgs.getArgument("CIM_OBJECTPATH");
        String qualTypeName = this.evaluateValue(objPath.getObjectName());
        String nameSpace = this.evaluateValue(objPath.getNamespace());
        String qualPath = MessageFormat.format(this.mResourceBundleHandle.loadString(OBJPATH), qualTypeName, nameSpace);
        String argsResult = MessageFormat.format(this.mResourceBundleHandle.loadString("CIM_OBJECTPATH"), VAR_NAME, qualPath);
        String cmdResult = this.mResourceBundleHandle.loadString(pOperation);
        String[] strResult = new String[]{argsResult, cmdResult};
        return strResult;
    }

    private String generateCreateInstanceCommand(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_INSTANCE");
        return this.mResourceBundleHandle.loadString(CREATE_INSTANCE);
    }

    private String generateInvokeMethodCommand(WBEMArguments pArgs, ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("METHOD_NAME");
        pArgsList.add("INPUT_ARGUMENT");
        pArgsList.add("OUTPUT_ARGUMENT");
        return this.mResourceBundleHandle.loadString(INVOKE_METHOD);
    }

    private String generateCommand(String pOperation, ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        return this.mResourceBundleHandle.loadString(pOperation);
    }

    private String getArguments(WBEMArguments pArguments, ArrayList<String> pArgsList) {
        StringBuilder argumentString = new StringBuilder();
        for (String key : pArgsList) {
            Object objValue = pArguments.getArgument(key);
            if (objValue != null) {
                if (key.equals("PROPERTY_LIST") && objValue != null) {
                    String[] strObj = (String[])objValue;
                    StringBuilder PropList = new StringBuilder();
                    PropList.append(OPEN_CURLYBRACE);
                    for (int index = 0; index < strObj.length; ++index) {
                        PropList.append(DOUBLE_QUOT + strObj[index] + DOUBLE_QUOT);
                        if (index >= strObj.length - 1) continue;
                        PropList.append(COMMA_SPACE);
                    }
                    PropList.append(CLOSE_CURLYBRACE);
                    objValue = PropList.toString();
                    argumentString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(key), objValue));
                    continue;
                }
                if (key.equals("CIM_OBJECTPATH") || key.equals("CIM_INSTANCE")) {
                    CIMObjectPath refObjPath;
                    CIMObjectPath objPath = null;
                    CIMInstance inst = null;
                    if (key.equals("CIM_OBJECTPATH")) {
                        objPath = (CIMObjectPath)pArguments.getArgument(key);
                    } else {
                        inst = (CIMInstance)pArguments.getArgument(key);
                        objPath = inst.getObjectPath();
                    }
                    if (objPath != null) {
                        CIMProperty[] keyProps;
                        for (CIMProperty kProp : keyProps = objPath.getKeys()) {
                            int keyDataType = kProp.getDataType().getType();
                            if (14 != keyDataType || (refObjPath = (CIMObjectPath)kProp.getValue()) == null) continue;
                            this.appendRefObjPathDeclaration(refObjPath, argumentString, kProp.getName());
                        }
                        this.appendPropArrayDeclaration(objPath.getKeys(), argumentString, PROPKEY, VAR_NAME);
                        this.appendObjPathDeclaration(objPath, argumentString, VAR_NAME);
                    }
                    if (!key.equals("CIM_INSTANCE") || null == inst) continue;
                    CIMProperty[] propArray = inst.getProperties();
                    for (CIMProperty prop : propArray) {
                        CIMClass cdtClass;
                        if (prop.isKey()) continue;
                        int propDataType = prop.getDataType().getType();
                        if (prop.getDataType().isArray()) {
                            argumentString.append(this.getArrayDec(prop));
                            continue;
                        }
                        if (14 == propDataType) {
                            refObjPath = (CIMObjectPath)prop.getValue();
                            if (refObjPath == null) continue;
                            this.appendRefObjPathDeclaration(refObjPath, argumentString, prop.getName());
                            continue;
                        }
                        if (15 == propDataType) {
                            CIMInstance objTypeInst = (CIMInstance)prop.getValue();
                            if (objTypeInst == null) continue;
                            this.appendPropArrayDeclaration(objTypeInst.getKeys(), argumentString, PROPKEY, prop.getName());
                            this.appendObjPathDeclaration(objTypeInst.getObjectPath(), argumentString, prop.getName());
                            this.appendPropArrayDeclaration(objTypeInst.getProperties(), argumentString, PROPERTIES, prop.getName());
                            continue;
                        }
                        if (17 != propDataType || (cdtClass = (CIMClass)prop.getValue()) == null) continue;
                        this.appendQualifierArrayDeclaration(cdtClass.getQualifiers(), argumentString, prop.getName());
                        this.appendClassPropArrayDeclaration(cdtClass.getProperties(), argumentString, prop.getName());
                        this.appendClassMethodArrayDeclaration(cdtClass.getMethods(), argumentString, prop.getName());
                    }
                    this.appendPropArrayDeclaration(propArray, argumentString, PROPERTIES, VAR_NAME);
                    argumentString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(key), VAR_NAME));
                    continue;
                }
                if (key.equals("INPUT_ARGUMENT")) {
                    this.appendArgumentArrayDeclaration((CIMArgument[])objValue, argumentString, "INPUT_ARGUMENT");
                    continue;
                }
                if (key.equals("OUTPUT_ARGUMENT")) {
                    this.appendArgumentArrayDeclaration((CIMArgument[])objValue, argumentString, "OUTPUT_ARGUMENT");
                    continue;
                }
                argumentString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(key), DOUBLE_QUOT + (null != objValue ? objValue.toString() : "") + DOUBLE_QUOT));
                continue;
            }
            argumentString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(key), NULL));
        }
        return argumentString.toString();
    }

    private String getArrayDec(CIMProperty<?> pProp) {
        Object[] objArray = (Object[])pProp.getValue();
        StringBuilder commaSeparatedStr = new StringBuilder();
        int index = 0;
        for (Object obj : objArray) {
            commaSeparatedStr.append(this.propValueInstantiation(pProp.getDataType().getType(), obj));
            if (index >= objArray.length - 1) continue;
            commaSeparatedStr.append(", \n\t");
            ++index;
        }
        String dataType = this.mResourceBundleHandle.loadString(pProp.getDataType().toString());
        String resultStr = MessageFormat.format(this.mResourceBundleHandle.loadString(PROP_VALUE_ARRAY), dataType, pProp.getName(), commaSeparatedStr);
        return resultStr;
    }

    private String generateCode(String pArgResult, String pCmdResult, String pHost, String pPricipal, String pCredential, String pView) {
        StringBuilder cResult = new StringBuilder();
        String tryCatchBody = MessageFormat.format(this.mResourceBundleHandle.loadString(TRYCATHBODY), pArgResult, "", pCmdResult, pView);
        cResult.append(MessageFormat.format(this.mResourceBundleHandle.loadString(JAVACODE), pHost, pPricipal, pCredential, tryCatchBody));
        return cResult.toString();
    }

    private String processProps(CIMProperty<?>[] pProps) {
        StringBuilder strProps = new StringBuilder("");
        int index = 0;
        if (pProps != null) {
            strProps.append(OPEN_CURLYBRACE);
            if (pProps.length > 0) {
                for (CIMProperty<?> prop : pProps) {
                    strProps.append(this.createNewProp(prop));
                    if (index >= pProps.length - 1) continue;
                    strProps.append(COMMA_SPACE);
                    ++index;
                }
            }
            strProps.append(CLOSE_CURLYBRACE);
            return strProps.toString();
        }
        return null;
    }

    private String createNewProp(CIMProperty<?> pProp) {
        int dType;
        String strMap = CIMDATATYPE;
        String dataType = "";
        if (pProp.getDataType().isArray()) {
            strMap = CIMDATATYPE_ARRAY;
        }
        if (14 == (dType = pProp.getDataType().getType())) {
            String refClassName = pProp.getName();
            dataType = MessageFormat.format(this.mResourceBundleHandle.loadString(REFERENCE), refClassName);
        } else {
            dataType = 15 == dType ? MessageFormat.format(this.mResourceBundleHandle.loadString(strMap), OBJECT) : (17 == dType ? MessageFormat.format(this.mResourceBundleHandle.loadString(strMap), CLASS) : MessageFormat.format(this.mResourceBundleHandle.loadString(strMap), pProp.getDataType().toString().toUpperCase()));
        }
        String value = "";
        if (pProp.getDataType().isArray()) {
            value = pProp.getName() + VALUE;
        } else if (14 == dType) {
            value = pProp.getName() + OPATH;
        } else if (15 == dType) {
            value = MessageFormat.format(this.mResourceBundleHandle.loadString(OBJECT), pProp.getName(), pProp.getName());
        } else if (17 == dType) {
            CIMClass cClass = (CIMClass)pProp.getValue();
            value = MessageFormat.format(this.mResourceBundleHandle.loadString(CLASS), cClass.getName(), cClass.getSuperClassName(), pProp.getName());
        } else {
            value = this.propValueInstantiation(dType, pProp.getValue());
        }
        return MessageFormat.format(this.mResourceBundleHandle.loadString(NEWPROPS), pProp.getName(), dataType, value);
    }

    private String propValueInstantiation(int pDataType, Object pValue) {
        switch (pDataType) {
            case 0: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(UINT), EIGHT, pValue);
            }
            case 1: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(SINT), BYTE, pValue);
            }
            case 2: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(UINT), SIXTEEN, pValue);
            }
            case 3: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(SINT), SHORT, pValue);
            }
            case 4: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(UINT), THIRTYTWO, pValue);
            }
            case 5: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(SINT), INTEGER, pValue);
            }
            case 6: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(UINT), SIXTYFOUR, pValue);
            }
            case 7: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(SINT), LONG, pValue);
            }
            case 8: {
                return DOUBLE_QUOT + pValue + DOUBLE_QUOT;
            }
            case 9: {
                return "Boolean." + pValue.toString().toUpperCase();
            }
            case 10: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(SINT), FLOAT, pValue);
            }
            case 11: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(SINT), DOUBLE, pValue);
            }
            case 12: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(DATETIME), pValue);
            }
            case 13: {
                return MessageFormat.format(this.mResourceBundleHandle.loadString(CHARACTER), pValue);
            }
        }
        return "";
    }

    private void appendPropArrayDeclaration(CIMProperty<?>[] pProps, StringBuilder pArgsString, String type, String pVarName) {
        String props = this.processProps(pProps);
        pArgsString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(type), pVarName, props));
    }

    private void appendObjPathDeclaration(CIMObjectPath pObjPath, StringBuilder pArgsString, String pVarName) {
        String schema = this.evaluateValue(pObjPath.getScheme());
        String hostName = this.evaluateValue(pObjPath.getHost());
        String port = this.evaluateValue(pObjPath.getPort());
        String nameSpace = this.evaluateValue(pObjPath.getNamespace());
        String objName = this.evaluateValue(pObjPath.getObjectName());
        String objValue = MessageFormat.format(this.mResourceBundleHandle.loadString(OBJECTPATH), schema, hostName, port, nameSpace, objName, pVarName);
        pArgsString.append(MessageFormat.format(this.mResourceBundleHandle.loadString("CIM_OBJECTPATH"), pVarName, objValue));
    }

    private String evaluateValue(String pStr) {
        if (pStr != null && pStr.length() > 0) {
            return DOUBLE_QUOT + pStr + DOUBLE_QUOT;
        }
        return NULL;
    }

    private void appendRefObjPathDeclaration(CIMObjectPath pObjPath, StringBuilder pArgsString, String pVarName) {
        String refObjName = this.evaluateValue(pObjPath.getObjectName());
        String refNameSpace = this.evaluateValue(pObjPath.getNamespace());
        String refValue = MessageFormat.format(this.mResourceBundleHandle.loadString(OBJPATH), refObjName, refNameSpace);
        pArgsString.append(MessageFormat.format(this.mResourceBundleHandle.loadString("CIM_OBJECTPATH"), pVarName, refValue));
    }

    private void appendQualifierArrayDeclaration(CIMQualifier<?>[] pQuals, StringBuilder pArgsString, String pVarName) {
        StringBuilder newQualsStr = new StringBuilder();
        int index = 0;
        for (CIMQualifier<?> qual : pQuals) {
            String name = qual.getName();
            String dataType = this.translateDataType(qual.getDataType());
            String value = this.propValueInstantiation(qual.getDataType().getType(), qual.getValue());
            String flavor = this.translateFlavor(qual.getFlavor());
            newQualsStr.append(MessageFormat.format(this.mResourceBundleHandle.loadString(NEW_QUALIFIER), name, dataType, value, flavor));
            if (index >= pQuals.length - 1) continue;
            newQualsStr.append(COMMA_SPACE);
            ++index;
        }
        pArgsString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(QUALIFIER), pVarName, newQualsStr));
    }

    private void appendClassPropArrayDeclaration(CIMClassProperty<?>[] pClassProps, StringBuilder pArgsString, String pVarName) {
        StringBuilder newClassPropStr = new StringBuilder();
        int index = 0;
        for (CIMClassProperty<?> cprop : pClassProps) {
            this.appendQualifierArrayDeclaration(cprop.getQualifiers(), pArgsString, cprop.getName());
            String name = cprop.getName();
            String dataType = this.translateDataType(cprop.getDataType());
            String value = this.propValueInstantiation(cprop.getDataType().getType(), cprop.getValue());
            Boolean isKey = cprop.isKey();
            Boolean isPropagated = cprop.isPropagated();
            newClassPropStr.append(MessageFormat.format(this.mResourceBundleHandle.loadString(NEW_CLASSPROP), name, dataType, value, cprop.getName(), isKey, isPropagated, null));
            if (index >= pClassProps.length - 1) continue;
            newClassPropStr.append(COMMA_SPACE);
            ++index;
        }
        pArgsString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(CLASSPROP), pVarName, newClassPropStr));
    }

    private void appendParameterArrayDeclaration(CIMParameter<?>[] pParameters, StringBuilder pArgsString, String pVarName) {
        StringBuilder newParameterStr = new StringBuilder();
        int index = 0;
        for (CIMParameter<?> param : pParameters) {
            this.appendQualifierArrayDeclaration(param.getQualifiers(), pArgsString, pVarName + param.getName());
            String name = param.getName();
            String dataType = this.translateDataType(param.getDataType());
            newParameterStr.append(MessageFormat.format(this.mResourceBundleHandle.loadString(NEW_PARAMETER), name, dataType, pVarName + param.getName()));
            if (index >= pParameters.length - 1) continue;
            newParameterStr.append(COMMA_SPACE);
            ++index;
        }
        pArgsString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(PARAMETER), pVarName, newParameterStr));
    }

    private void appendArgumentArrayDeclaration(CIMArgument<?>[] pArgsArr, StringBuilder pArgsString, String pArgsType) {
        if (pArgsArr != null) {
            StringBuilder newArgs = new StringBuilder();
            if (pArgsArr.length > 0) {
                int index = 0;
                newArgs.append(OPEN_CURLYBRACE);
                for (CIMArgument<?> arg : pArgsArr) {
                    String name = this.evaluateValue(arg.getName());
                    String dataType = this.translateDataType(arg.getDataType());
                    String value = this.propValueInstantiation(arg.getDataType().getType(), arg.getValue());
                    newArgs.append(MessageFormat.format(this.mResourceBundleHandle.loadString(NEW_ARGUMENT), name, dataType, value));
                    if (index >= pArgsArr.length - 1) continue;
                    newArgs.append(COMMA_SPACE);
                    ++index;
                }
                newArgs.append(CLOSE_CURLYBRACE);
            }
            pArgsString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(pArgsType), newArgs));
        }
    }

    private void appendClassMethodArrayDeclaration(CIMMethod<?>[] pClassMethods, StringBuilder pArgsString, String pVarName) {
        StringBuilder newMethodStr = new StringBuilder();
        int index = 0;
        for (CIMMethod<?> method : pClassMethods) {
            this.appendQualifierArrayDeclaration(method.getQualifiers(), pArgsString, method.getName());
            this.appendParameterArrayDeclaration(method.getParameters(), pArgsString, method.getName());
            String name = method.getName();
            String dataType = this.translateDataType(method.getDataType());
            Boolean isPropagated = method.isPropagated();
            newMethodStr.append(MessageFormat.format(this.mResourceBundleHandle.loadString(NEW_METHOD), name, dataType, isPropagated));
            if (index >= pClassMethods.length - 1) continue;
            newMethodStr.append(COMMA_SPACE);
            ++index;
        }
        pArgsString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(METHOD), pVarName, newMethodStr));
    }

    private String translateFlavor(int pFlavor) {
        String flavor = "" + pFlavor;
        switch (pFlavor) {
            case 1: 
            case 2: 
            case 4: {
                return this.mResourceBundleHandle.loadString(flavor);
            }
        }
        return flavor;
    }

    private String translateDataType(CIMDataType pDataType) {
        String strMap = CIMDATATYPE;
        if (pDataType.isArray()) {
            strMap = CIMDATATYPE_ARRAY;
        }
        return MessageFormat.format(this.mResourceBundleHandle.loadString(strMap), pDataType.toString().toUpperCase());
    }
}

