/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities.commandgenerator;

import com.ws.utilities.Resources;
import com.ws.utilities.commandgenerator.CommandGenerator;
import com.ws.utilities.commandgenerator.WBEMArguments;
import com.ws.utilities.commandgenerator.WBEMOperation;
import java.text.MessageFormat;
import java.util.Set;
import javax.cim.CIMArgument;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;

public class WBEMMethodCommandGenerator
implements CommandGenerator {
    private static final String BUNDLE = "com.ws.utilities.commandgenerator.WBEMMethodCommandGenerator";
    private static final String ERROR_OPERATION = "ERROR_OPERATION";
    private static final String COMMAND_FORMAT = "COMMAND_FORMAT";
    private static final String EQUAL_OPERATOR = "=";
    private static final String DOT = ".";
    private static final String NULL = "null";
    private static final String COMMA = ",";
    private static final String OPEN_CURLY_BRACE = "{";
    private static final String CLOSE_CURLY_BRACE = "}";
    private static final String SEMICOLON = ";";
    private final Resources mResourceBundleHandle = new Resources("com.ws.utilities.commandgenerator.WBEMMethodCommandGenerator");

    @Override
    public String getCommand(WBEMArguments pArguments) {
        if (pArguments.getOperation() == WBEMOperation.INVOKE_METHOD) {
            return this.generateEquivalent(pArguments);
        }
        throw new IllegalArgumentException(MessageFormat.format(this.mResourceBundleHandle.loadString(ERROR_OPERATION), pArguments.getOperation().toString()));
    }

    private String generateEquivalent(WBEMArguments pArgs) {
        CIMObjectPath objPath = (CIMObjectPath)pArgs.getArgument("CIM_OBJECTPATH");
        String options = this.arrangeOptions(pArgs);
        String modelPath = "";
        String methodName = (String)pArgs.getArgument("METHOD_NAME");
        if (methodName == null) {
            methodName = "";
        }
        if (objPath != null) {
            modelPath = this.getModelPath(objPath);
        }
        return MessageFormat.format(this.mResourceBundleHandle.loadString(COMMAND_FORMAT), options, modelPath, methodName);
    }

    private String arrangeOptions(WBEMArguments pArgs) {
        StringBuilder optionsStr = new StringBuilder();
        String server = this.retrieveOptionValue("SERVER", pArgs);
        String pricipal = this.retrieveOptionValue("PRINCIPAL", pArgs);
        String credential = this.retrieveOptionValue("CREDENTIAL", pArgs);
        String inputArgs = this.retrieveOptionValue("INPUT_ARGUMENT", pArgs);
        String outputArgs = this.retrieveOptionValue("OUTPUT_ARGUMENT", pArgs);
        String otherOptions = this.getOtherOptions(pArgs);
        optionsStr.append(server);
        optionsStr.append(pricipal);
        optionsStr.append(credential);
        optionsStr.append(inputArgs);
        optionsStr.append(outputArgs);
        optionsStr.append(otherOptions);
        return optionsStr.toString();
    }

    private String getOtherOptions(WBEMArguments pArgs) {
        StringBuilder otherOptions = new StringBuilder();
        Set<String> keys = pArgs.getArgumentKeys();
        for (String key : keys) {
            if (!this.isOptionValid(key).booleanValue()) continue;
            String option = "";
            if ("DISPLAY_XML_DEBUG_INFO".equals(key) || "PRINT_USAGE_STATEMENT".equals(key) || "PRINT_VERSION".equals(key)) {
                if (((Boolean)pArgs.getArgument(key)).booleanValue()) {
                    option = this.mResourceBundleHandle.loadString(key);
                }
            } else {
                option = MessageFormat.format(this.mResourceBundleHandle.loadString(key), pArgs.getArgument(key));
            }
            otherOptions.append(option);
        }
        return otherOptions.toString();
    }

    private String retrieveOptionValue(String pKey, WBEMArguments pArgs) {
        Object result = pArgs.getArgument(pKey);
        if (result != null) {
            if ("INPUT_ARGUMENT".equals(pKey) || "OUTPUT_ARGUMENT".equals(pKey)) {
                String value = this.translateCIMArguments((CIMArgument[])result, pKey);
                return MessageFormat.format(this.mResourceBundleHandle.loadString(pKey), value);
            }
            return MessageFormat.format(this.mResourceBundleHandle.loadString(pKey), result);
        }
        return "";
    }

    private String translateCIMArguments(CIMArgument<?>[] pCIMArgumentArray, String pArgsType) {
        StringBuilder strCIMArguments = new StringBuilder();
        int index = 0;
        if ("INPUT_ARGUMENT".equals(pArgsType)) {
            for (CIMArgument<?> cimArg : pCIMArgumentArray) {
                strCIMArguments.append(cimArg.getName() + EQUAL_OPERATOR + cimArg.getValue());
                if (index >= pCIMArgumentArray.length - 1) continue;
                strCIMArguments.append(COMMA);
                ++index;
            }
        } else {
            for (CIMArgument<?> cimArg : pCIMArgumentArray) {
                strCIMArguments.append(cimArg.getName());
                if (index >= pCIMArgumentArray.length - 1) continue;
                strCIMArguments.append(COMMA);
                ++index;
            }
        }
        return strCIMArguments.toString();
    }

    private String getModelPath(CIMObjectPath pObjPath) {
        StringBuilder strKeyProps = new StringBuilder("");
        CIMProperty[] keyProps = pObjPath.getKeys();
        int index = 0;
        if (keyProps.length > 0 && keyProps != null) {
            for (CIMProperty kProp : keyProps) {
                strKeyProps.append(kProp.getName());
                strKeyProps.append(EQUAL_OPERATOR);
                if (kProp.getValue() != null) {
                    if (kProp.getDataType().getType() == 14) {
                        strKeyProps.append(kProp.getDataType().getRefClassName());
                    } else if (kProp.getDataType().isArray()) {
                        Object[] arr = (Object[])kProp.getValue();
                        strKeyProps.append(OPEN_CURLY_BRACE);
                        for (int j = 0; j < arr.length; ++j) {
                            strKeyProps.append(arr[j].toString());
                            if (j >= arr.length - 1) continue;
                            strKeyProps.append(SEMICOLON);
                        }
                        strKeyProps.append(CLOSE_CURLY_BRACE);
                    } else {
                        strKeyProps.append(kProp.getValue().toString());
                    }
                } else {
                    strKeyProps.append(NULL);
                }
                if (index >= keyProps.length - 1) continue;
                strKeyProps.append(COMMA);
                ++index;
            }
            return pObjPath.getObjectName() + DOT + strKeyProps.toString();
        }
        return pObjPath.getObjectName();
    }

    private Boolean isOptionValid(String pOption) {
        if ("DISPLAY_XML_DEBUG_INFO".equalsIgnoreCase(pOption) || "PRINT_USAGE_STATEMENT".equalsIgnoreCase(pOption) || "KEYSTORE_FILE".equals(pOption) || "KEYSTORE_PASSWORD".equals(pOption) || "KEYSTORE_PASSWORD".equals(pOption) || "LOCALE_LIST".equals(pOption) || "HTTP_PROXY_HOST".equals(pOption) || "HTTP_PROXY_PORT".equals(pOption) || "WBEM_SERVER_ROLE_CREDENTIAL".equals(pOption) || "WBEM_SERVER_ROLE_PRINCIPAL".equals(pOption) || "TRUSTSTRORE_FILE".equals(pOption) || "PRINT_VERSION".equals(pOption) || "WBEM_PROTOCOL".equals(pOption)) {
            return true;
        }
        return false;
    }
}

