/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import javax.cim.CIMInstance;
import javax.wbem.WBEMException;

class CloseableLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = -2192733405560638583L;
    private boolean mClose;
    private boolean mDone;
    protected WBEMException mException;

    public CloseableLinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public CloseableLinkedBlockingQueue(Collection<? extends E> c) {
        super(c);
        this.mDone = true;
    }

    public CloseableLinkedBlockingQueue(int capacity) {
        super(capacity);
        this.mException = null;
        this.mDone = false;
        this.mClose = false;
    }

    public void close() {
        this.mClose = true;
        this.mDone = true;
    }

    public void done() {
        this.mDone = true;
    }

    public WBEMException getException() {
        return this.mException;
    }

    public boolean isClosed() {
        return this.mClose;
    }

    public boolean isDone() {
        return this.mDone;
    }

    public void setException(WBEMException pException) {
        if (pException != null) {
            this.close();
            if (this.mException == null) {
                this.mException = pException;
            } else {
                CIMInstance[] newErrors;
                ArrayList<CIMInstance> updatedErrors = new ArrayList<CIMInstance>();
                CIMInstance[] currentErrors = this.mException.getCIMErrors();
                if (currentErrors != null) {
                    for (CIMInstance error : currentErrors) {
                        updatedErrors.add(error);
                    }
                }
                if ((newErrors = pException.getCIMErrors()) != null) {
                    for (CIMInstance error : newErrors) {
                        updatedErrors.add(error);
                    }
                }
                int numErrors = updatedErrors.size();
                this.mException = new WBEMException(this.mException.getID(), this.mException.getMessage(), 0 == numErrors ? null : updatedErrors.toArray(new CIMInstance[numErrors]));
            }
        }
    }
}

