/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.apps.common;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;

public class ClassList {
    private final String mFileName;
    private final ArrayList<String> mClassList;

    public ClassList(String fileName) {
        this.mFileName = fileName;
        this.mClassList = new ArrayList();
        this.readList();
    }

    public boolean contains(String className) {
        if (null == className) {
            throw new IllegalArgumentException("className shall not be null!");
        }
        return this.mClassList.contains(className.toLowerCase());
    }

    public void remove(String className) {
        if (null != className) {
            this.mClassList.remove(className.toLowerCase());
        }
    }

    public void readList() {
        if (this.mFileName == null || this.mFileName.length() == 0) {
            return;
        }
        try {
            String line;
            FileInputStream fis = new FileInputStream(this.mFileName);
            InputStreamReader isr = new InputStreamReader(fis);
            LineNumberReader lnr = new LineNumberReader(isr);
            while ((line = lnr.readLine()) != null) {
                if (line.startsWith("//")) continue;
                this.mClassList.add(line.toLowerCase().trim());
            }
            fis.close();
        }
        catch (Throwable e) {
            System.err.println(e);
            System.exit(-1);
        }
    }

    public ArrayList<String> checkMissing() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.mClassList.isEmpty()) {
            for (String p : this.mClassList) {
                list.add(p);
            }
        }
        return list;
    }
}

