/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.common;

import com.ws.utilities.commandgenerator.CommandGenerator;
import com.ws.utilities.commandgenerator.CommandGeneratorFactory;
import com.ws.utilities.commandgenerator.WBEMArguments;
import com.ws.utilities.commandgenerator.WBEMArgumentsLib;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import javax.cim.UnsignedInteger32;
import javax.security.auth.Subject;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.client.WBEMClient;

public class WBEMClientLogger
implements WBEMClient {
    private static final Level MIN_ARG_LOG_LEVEL = Level.FINER;
    private final Logger mLogger = Logger.getLogger("com.ws.wbem.client");
    private final CommandGenerator mCmdGen;
    private final WBEMArgumentsLib mArgumentsLib = new WBEMArgumentsLib();

    public WBEMClientLogger() {
        this.mCmdGen = CommandGeneratorFactory.getGenerator("text");
    }

    public CloseableIterator<CIMClass> associatorClasses(CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createAssociatorsArguments(target, assocClass, resultClass, role, resultRole, includeQualifiers, null);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public CloseableIterator<CIMInstance> associatorInstances(CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, String[] propertyList) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createAssociatorsArguments(target, assocClass, resultClass, role, resultRole, false, propertyList);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public EnumerateResponse<CIMInstance> associators(CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createAssociatorsArguments(target, assocClass, resultClass, role, resultRole, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public void close() {
    }

    public void closeEnumeration(CIMObjectPath target, String context) throws WBEMException {
    }

    public void createClass(CIMClass clazz) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createCreateClassArguments(clazz);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public CIMObjectPath createInstance(CIMInstance instance) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createCreateInstanceArguments(instance);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void deleteClass(CIMObjectPath target) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createDeleteClassArguments(target);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void deleteInstance(CIMObjectPath target) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createDeleteInstanceArguments(target);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void deleteQualifierType(CIMObjectPath target) throws WBEMException {
    }

    public CloseableIterator<CIMClass> enumerateClasses(CIMObjectPath target, boolean deep, boolean localOnly, boolean includeQualifiers) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createEnumerateClassesArguments(target, deep, localOnly, includeQualifiers);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath target, String[] propertyList) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createEnumerateInstancesArguments(target, true, propertyList);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public EnumerateResponse<CIMInstance> enumerateInstances(CIMObjectPath target, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createEnumerateInstancesArguments(target, true, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public CloseableIterator<CIMQualifierType<?>> enumerateQualifierTypes(CIMObjectPath target) throws WBEMException {
        return null;
    }

    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath target, String query, String queryLanguage) throws WBEMException {
        return null;
    }

    public EnumerateResponse<CIMInstance> execQueryInstances(CIMObjectPath target, String filterQuery, String filterQueryLanguage, boolean returnQueryResultClass, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects, CIMClass queryResultClass) throws WBEMException {
        return null;
    }

    public CIMClass getClass(CIMObjectPath target, boolean localOnly, boolean includeQualifiers) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createGetClassArguments(target, localOnly, includeQualifiers, null);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public CIMInstance getInstance(CIMObjectPath target, String[] propertyList) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createGetInstanceArguments(target, propertyList);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public EnumerateResponse<CIMInstance> getInstances(CIMObjectPath target, String context, UnsignedInteger32 maxObjects) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createGetInstancesArguments(target, context, maxObjects);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public EnumerateResponse<CIMInstance> getInstancesWithPath(CIMObjectPath target, String context, UnsignedInteger32 maxObjects) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createGetInstancesWithPathArguments(target, context, maxObjects);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public String getProperty(String name) {
        return null;
    }

    public CIMQualifierType<?> getQualifierType(CIMObjectPath target) throws WBEMException {
        return null;
    }

    public void initialize(CIMObjectPath name, Subject subject, Locale[] locales) throws WBEMException {
    }

    public Object invokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createInvokeMethodArguments(target, methodName, inArgs, outArgs);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public void modifyClass(CIMClass clazz) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createCreateClassArguments(clazz);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void modifyInstance(CIMInstance instance, String[] propertyList) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createModifyInstanceArguments(instance, propertyList);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public CloseableIterator<CIMClass> referenceClasses(CIMObjectPath target, String resultClass, String role, boolean includeQualifiers) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createReferencesArguments(target, resultClass, role, includeQualifiers, null);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public CloseableIterator<CIMInstance> referenceInstances(CIMObjectPath target, String resultClass, String role, String[] propertyList) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createReferencesArguments(target, resultClass, role, false, propertyList);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public EnumerateResponse<CIMInstance> references(CIMObjectPath target, String resultClass, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        try {
            if (null != this.mLogger && this.mLogger.isLoggable(MIN_ARG_LOG_LEVEL) && null != this.mArgumentsLib && null != this.mCmdGen) {
                WBEMArguments args = this.mArgumentsLib.createReferencesArguments(target, resultClass, role, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
                this.mLogger.log(MIN_ARG_LOG_LEVEL, this.mCmdGen.getCommand(args));
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return null;
    }

    public void setLocales(Locale[] pLocales) {
    }

    public void setProperty(String name, String value) {
    }

    public void createQualifierType(CIMQualifierType<?> qualifierType) throws WBEMException {
    }

    public void modifyQualifierType(CIMQualifierType<?> qualifierType) throws WBEMException {
    }
}

