/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.query.fql;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.query.fql.ArrayOperator;
import com.ws.wbem.query.fql.FQLAndExpression;
import com.ws.wbem.query.fql.FQLExpression;
import com.ws.wbem.query.fql.FQLOperator;
import com.ws.wbem.query.fql.FQLOperatorExpression;
import com.ws.wbem.query.fql.FQLOrExpression;
import com.ws.wbem.query.fql.FQLPropertyCompareExpression;
import com.ws.wbem.query.fql.ScalarOperator;
import java.util.ArrayList;
import java.util.Iterator;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;

public class FQLParser {
    private static final String ANY = "ANY";
    private static final String EVERY = "EVERY";
    private static final String LIKE = "LIKE";
    private static final String NOT = "NOT";
    private static final String OPEN_PARANS = "(";
    private static final String CLOSED_PARANS = ")";
    private static final String NULL = "NULL";
    private final FQLExpression mFQLExpression;
    private static final String FQL = "DMTF:FQL";
    private boolean mCanEvaluate = false;

    @Deprecated
    public static CloseableIterator<CIMInstance> evaluate(CIMInstance inst, String filterQueryLanguage, String filterQuery, String[] propertyList, String genericOperation) throws WBEMException {
        return FQLParser.evaluate(inst, filterQueryLanguage, filterQuery, propertyList, WBEMOperation.getWBEMOperation((String)genericOperation));
    }

    public static CloseableIterator<CIMInstance> evaluate(CIMInstance inst, String filterQueryLanguage, String filterQuery, String[] propertyList, WBEMOperation genericOperation) throws WBEMException {
        ArrayList<CIMInstance> listInstances = new ArrayList<CIMInstance>(1);
        FQLParser.evaluate(listInstances, inst, filterQueryLanguage, filterQuery, propertyList, genericOperation);
        return new CloseableAddableIterator<CIMInstance>(listInstances);
    }

    public void evaluate(ArrayList<CIMInstance> listInstances, CIMInstance inst, String[] propertyList) {
        if (null != listInstances && null != inst && this.evaluate(inst)) {
            listInstances.add(inst.filterProperties(propertyList));
        }
    }

    @Deprecated
    public static void evaluate(ArrayList<CIMInstance> listInstances, CIMInstance inst, String filterQueryLanguage, String filterQuery, String[] propertyList, String genericOperation) throws WBEMException {
        FQLParser.evaluate(listInstances, inst, filterQueryLanguage, filterQuery, propertyList, WBEMOperation.getWBEMOperation((String)genericOperation));
    }

    public static void evaluate(ArrayList<CIMInstance> listInstances, CIMInstance inst, String filterQueryLanguage, String filterQuery, String[] propertyList, WBEMOperation genericOperation) throws WBEMException {
        if (null != listInstances && null != inst) {
            FQLParser fqlParser = FQLParser.getFQLParser(filterQueryLanguage, filterQuery, inst.getObjectPath(), genericOperation);
            fqlParser.evaluate(listInstances, inst, propertyList);
        }
    }

    @Deprecated
    public static FQLParser getFQLParser(String filterQueryLanguage, String filterQuery, CIMObjectPath op, String genericOperation) throws WBEMException {
        return FQLParser.getFQLParser(filterQueryLanguage, filterQuery, op, WBEMOperation.getWBEMOperation((String)genericOperation));
    }

    public static FQLParser getFQLParser(String filterQueryLanguage, String filterQuery, CIMObjectPath op, WBEMOperation operation) throws WBEMException {
        String query = null;
        if (null != filterQueryLanguage) {
            if (!FQL.equalsIgnoreCase(filterQueryLanguage)) {
                throw WBEMOperationErrors.getUnknownQueryLanguageException((CIMObjectPath)op, (String)filterQueryLanguage, (String)op.getObjectName(), (WBEMOperation)operation);
            }
            if (null == filterQuery || filterQuery.length() == 0) {
                throw WBEMOperationErrors.getInvalidQueryException((CIMObjectPath)op, (String)filterQueryLanguage, (String)filterQuery, (WBEMOperation)operation, (String)op.getObjectName());
            }
            query = filterQuery;
        }
        return new FQLParser(query);
    }

    private FQLParser(String queryString) throws WBEMException {
        if (null != queryString) {
            this.mFQLExpression = this.parseQueryString(queryString);
            this.mCanEvaluate = true;
        } else {
            this.mFQLExpression = null;
        }
    }

    public boolean canEvaluate() {
        return this.mCanEvaluate;
    }

    private FQLExpression parseQueryString(String queryString) throws WBEMException {
        StringBuilder query = new StringBuilder(queryString);
        try {
            return this.getFQLExpression(query, false);
        }
        catch (IllegalArgumentException e) {
            throw new WBEMException(15, e.getMessage());
        }
    }

    private FQLExpression getFQLExpression(StringBuilder query, boolean openParam) throws IllegalArgumentException {
        ArrayList<FQLExpression> listFQLExpressions = new ArrayList<FQLExpression>();
        ArrayList<FQLOperator> listFQLOperators = new ArrayList<FQLOperator>();
        if (null == query) {
            throw new IllegalArgumentException("query can not be null!");
        }
        if (query.toString().trim().length() == 0) {
            return null;
        }
        Object lastFQLItem = null;
        String nextToken = null;
        while (query.length() > 0 && !CLOSED_PARANS.equals(nextToken)) {
            nextToken = this.nextToken(query);
            if (nextToken == null) {
                if (null != lastFQLItem) continue;
                throw new IllegalArgumentException("Empty expression");
            }
            if (OPEN_PARANS.equals(nextToken)) {
                FQLExpression expression = this.getFQLExpression(query, true);
                listFQLExpressions.add(expression);
                lastFQLItem = expression;
                continue;
            }
            if (CLOSED_PARANS.equals(nextToken)) {
                if (null != lastFQLItem) continue;
                throw new IllegalArgumentException("Empty expression between params");
            }
            FQLOperator fqlOperator = FQLOperator.getFQLOperator(nextToken);
            if (null != fqlOperator) {
                if (null == lastFQLItem || lastFQLItem instanceof FQLOperator) {
                    throw new IllegalArgumentException("Found value \"" + fqlOperator.getOperatorString() + "\" where an FQL expression was expected");
                }
                lastFQLItem = fqlOperator;
                listFQLOperators.add(fqlOperator);
                continue;
            }
            if (null != lastFQLItem && !(lastFQLItem instanceof FQLOperator)) {
                throw new IllegalArgumentException("Missing OR or AND operator before " + nextToken);
            }
            boolean not = false;
            boolean like = false;
            ArrayOperator arrayOperator = null;
            ScalarOperator scalarOperator = null;
            String value = null;
            String propertyName = null;
            if (NOT.equalsIgnoreCase(nextToken)) {
                not = true;
                arrayOperator = ArrayOperator.getArrayOperator(this.nextToken(query));
                if (null == arrayOperator) {
                    throw new IllegalArgumentException("Expecting ANY or EVERY");
                }
                nextToken = this.nextToken(query);
            } else if (ANY.equalsIgnoreCase(nextToken) || EVERY.equalsIgnoreCase(nextToken)) {
                arrayOperator = ArrayOperator.getArrayOperator(nextToken);
                nextToken = this.nextToken(query);
            }
            propertyName = nextToken;
            if (!this.tokenIsPropertyName(propertyName)) {
                throw new IllegalArgumentException();
            }
            nextToken = this.nextToken(query);
            if (NOT.equalsIgnoreCase(nextToken)) {
                nextToken = this.nextToken(query);
                if (!LIKE.equalsIgnoreCase(nextToken)) {
                    throw new IllegalArgumentException("Misplaced \"NOT\" operator");
                }
                not = true;
                like = true;
            } else if (LIKE.equalsIgnoreCase(nextToken)) {
                like = true;
            } else {
                scalarOperator = ScalarOperator.getScalarOperator(nextToken);
                if (scalarOperator == null) {
                    throw new IllegalArgumentException("Found \"" + nextToken + "\" where" + "a scalar operator was expected");
                }
            }
            value = this.nextToken(query);
            FQLPropertyCompareExpression expression = new FQLPropertyCompareExpression(propertyName, value, scalarOperator, arrayOperator, like, not);
            lastFQLItem = expression;
            listFQLExpressions.add(expression);
        }
        FQLExpression ret = this.combinedExpressions(listFQLExpressions, listFQLOperators);
        return ret;
    }

    private FQLExpression combinedExpressions(ArrayList<FQLExpression> listFQLExpressions, ArrayList<FQLOperator> listFQLOperators) throws IllegalArgumentException {
        if (listFQLOperators.size() == listFQLExpressions.size()) {
            FQLOperator lastOperator = listFQLOperators.get(listFQLOperators.size() - 1);
            throw new IllegalArgumentException(lastOperator.getOperatorString() + " operator without corresponding FQLExpression");
        }
        FQLExpression ret = null;
        Iterator<FQLOperator> iterOperators = listFQLOperators.iterator();
        Iterator<FQLExpression> iterExpressions = listFQLExpressions.iterator();
        if (!iterOperators.hasNext()) {
            ret = iterExpressions.next();
        } else {
            FQLOperatorExpression operatorExpression = null;
            FQLOperator firstOperator = iterOperators.next();
            FQLExpression expression1 = iterExpressions.next();
            FQLExpression expression2 = iterExpressions.next();
            operatorExpression = firstOperator == FQLOperator.OR ? new FQLOrExpression(expression1, expression2) : new FQLAndExpression(expression1, expression2);
            while (iterOperators.hasNext()) {
                FQLOperatorExpression newExpression;
                FQLOperator nextOperator = iterOperators.next();
                FQLExpression nextExpression = iterExpressions.next();
                if (nextOperator == FQLOperator.OR) {
                    if (operatorExpression instanceof FQLOrExpression) {
                        operatorExpression.addExpression(nextExpression);
                        continue;
                    }
                    newExpression = new FQLOrExpression(operatorExpression, nextExpression);
                    operatorExpression = newExpression;
                    continue;
                }
                if (operatorExpression instanceof FQLAndExpression) {
                    operatorExpression.addExpression(nextExpression);
                    continue;
                }
                newExpression = new FQLAndExpression(operatorExpression, nextExpression);
                operatorExpression = newExpression;
            }
            ret = operatorExpression;
        }
        return ret;
    }

    public CloseableIterator<CIMInstance> evaluate(CloseableIterator<CIMInstance> iterInstances) throws WBEMException {
        if (null != this.mFQLExpression) {
            ArrayList<CIMInstance> listInstances = new ArrayList<CIMInstance>();
            if (null != iterInstances) {
                while (iterInstances.hasNext()) {
                    CIMInstance instNext = (CIMInstance)iterInstances.next();
                    if (!this.mFQLExpression.evaluate(instNext)) continue;
                    listInstances.add(instNext);
                }
            }
            return new CloseableAddableIterator<CIMInstance>(listInstances);
        }
        return iterInstances;
    }

    public boolean evaluate(CIMInstance instance) {
        return null != this.mFQLExpression ? this.mFQLExpression.evaluate(instance) : true;
    }

    private boolean tokenIsPropertyName(String token) {
        char startChar = token.trim().charAt(0);
        return !token.equalsIgnoreCase(NULL) && !Character.isDigit(startChar) && startChar != '\"' && startChar != '\'' && startChar != '{';
    }

    private String nextToken(StringBuilder query) {
        StringBuilder buf;
        block7: {
            char ch;
            block9: {
                ScalarOperator scalarOperator;
                block10: {
                    block8: {
                        Character endChar;
                        block6: {
                            buf = new StringBuilder();
                            String newString = query.toString();
                            newString = newString.trim();
                            query.replace(0, query.length(), newString);
                            ch = query.charAt(0);
                            endChar = this.getEndTokenChar(ch);
                            if (ch != '(' && ch != ')') break block6;
                            buf.append(ch);
                            break block7;
                        }
                        if (null == endChar) break block8;
                        boolean backslash = false;
                        boolean foundEndstring = false;
                        for (int i = 0; i < query.length(); ++i) {
                            ch = query.charAt(i);
                            if (ch == '\\') {
                                backslash = !backslash;
                                buf.append(ch);
                                continue;
                            }
                            if (i != 0 && ch == endChar.charValue() && !backslash) {
                                foundEndstring = true;
                                buf.append(ch);
                                break;
                            }
                            buf.append(ch);
                            backslash = false;
                        }
                        if (!foundEndstring) {
                            throw new IllegalArgumentException();
                        }
                        break block7;
                    }
                    scalarOperator = ScalarOperator.getScalarOperator(String.valueOf(ch));
                    if (null == scalarOperator) break block9;
                    buf.append(ch);
                    if (scalarOperator != ScalarOperator.LessThen) break block10;
                    if (query.charAt(1) == '>' || query.charAt(1) == '=') {
                        buf.append(query.charAt(1));
                    }
                    break block7;
                }
                if (scalarOperator != ScalarOperator.GreaterThen || query.charAt(1) != '=') break block7;
                buf.append(query.charAt(1));
                break block7;
            }
            buf.append(ch);
            for (int i = 1; i < query.length() && !Character.isWhitespace(ch = query.charAt(i)) && !this.isScalarOperator(ch) && ch != ')'; ++i) {
                buf.append(ch);
            }
        }
        String newQuery = query.substring(buf.length(), query.length()).trim();
        query.replace(0, query.length(), newQuery);
        return buf.toString();
    }

    private Character getEndTokenChar(char startChar) {
        Character ret = null;
        if (startChar == '{') {
            ret = Character.valueOf('}');
        } else if (startChar == '\'') {
            ret = Character.valueOf('\'');
        } else if (startChar == '\"') {
            ret = Character.valueOf('\"');
        }
        return ret;
    }

    private boolean isScalarOperator(char ch) {
        return null != ScalarOperator.getScalarOperator(String.valueOf(ch));
    }
}

