/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.Timer;

public class RJComFileOutputStream
extends FileOutputStream {
    private PrintStream defaultPrintStream = null;
    private URL url = null;
    private String secret = null;
    private String[] flashKeyWords = new String[]{"Exception", "FlashRJComFileOutputStream"};
    private String traceFileName = null;
    private Timer outputTimer = new Timer(1000, null);
    String user = null;
    boolean urgent = false;

    public RJComFileOutputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public RJComFileOutputStream(File file, boolean bl) throws FileNotFoundException {
        super(file, bl);
    }

    public RJComFileOutputStream(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    public RJComFileOutputStream(String string) throws FileNotFoundException {
        super(string);
    }

    public RJComFileOutputStream(String string, boolean bl) throws FileNotFoundException {
        super(string, bl);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.urgent) {
            super.write(byArray, n, n2);
        }
        String string = new String(byArray, n, n2);
        this.defaultPrintStream.print(string);
        if (this.checkFlashConditions(string)) {
            this.outputTimer.start();
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (this.urgent) {
            super.write(byArray);
        }
        String string = new String(byArray);
        this.defaultPrintStream.print(byArray);
        if (this.checkFlashConditions(string)) {
            this.outputTimer.start();
        }
    }

    public void write(int n) throws IOException {
        if (this.urgent) {
            super.write(n);
        }
        this.defaultPrintStream.print(n);
    }

    public PrintStream getDefaultPrintStream() {
        return this.defaultPrintStream;
    }

    public void setDefaultPrintStream(PrintStream printStream) {
        this.defaultPrintStream = printStream;
    }

    public void init(URL uRL, String string, String string2, String string3) {
        this.url = uRL;
        this.secret = string;
        this.user = string2;
        this.traceFileName = string3;
        if (this.traceFileName.indexOf("XXX_YY") != -1) {
            this.urgent = true;
        }
        this.outputTimer.setRepeats(false);
        this.outputTimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJComFileOutputStream.this.doOutput();
            }
        });
    }

    public void doOutput() {
        boolean bl = this.flash();
    }

    public boolean flash() {
        boolean bl = true;
        try {
            URLConnection uRLConnection = this.url.openConnection();
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            StringBuffer stringBuffer = new StringBuffer(this.secret + this.user);
            stringBuffer.append(URLEncoder.encode(this.readFileData().toString()));
            PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
            printWriter.print(stringBuffer);
            printWriter.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string = "";
            String string2 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + string + "\n";
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("..........Can't send trace data.");
        }
        return bl;
    }

    private StringBuffer readFileData() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            FileReader fileReader = new FileReader(this.traceFileName);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            stringBuffer = new StringBuffer("File reading failure");
            stringBuffer.append(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            stringBuffer = new StringBuffer("File reading failure");
            stringBuffer.append(iOException.toString());
        }
        return stringBuffer;
    }

    private boolean checkFlashConditions(String string) {
        boolean bl = false;
        for (int i = 0; i < this.flashKeyWords.length; ++i) {
            if (string.indexOf(this.flashKeyWords[i]) == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String[] getFlashKeyWords() {
        return this.flashKeyWords;
    }

    public String getSecret() {
        return this.secret;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setFlashKeyWords(String[] stringArray) {
        this.flashKeyWords = stringArray;
    }

    public void setSecret(String string) {
        this.secret = string;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public String getTraceFileName() {
        return this.traceFileName;
    }

    public void setTraceFileName(String string) {
        this.traceFileName = string;
    }
}

