/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcEventAdapter;
import sanproject.client.com.RJcGuide;

public class RJcID
extends RJcEventAdapter
implements RJcConst {
    protected String name;
    protected String panelName = null;
    protected JMenuItem menuItem = null;
    protected RJcID parentID = null;
    protected RJcID selectedID = null;
    protected RJcID preSelectedID = null;
    protected boolean blockade = false;
    protected ItemListener listener = null;
    protected ArrayList children = new ArrayList(4);
    protected ArrayList childList = new ArrayList(4);
    protected boolean error = false;

    public RJcID() {
        this(null);
    }

    public RJcID(String string) {
        this.name = string;
    }

    public String getID() {
        return this.name;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public void doClick() {
        if (this.menuItem != null) {
            this.menuItem.doClick();
        }
    }

    public void restoreSelection() {
        this.selectedID = this.preSelectedID;
        if (this.selectedID != null) {
            this.selectedID.restoreSelection();
        }
    }

    public void setBlockade(boolean bl) {
        this.blockade = bl;
        this.getMenuItem().setVisible(!bl);
    }

    public boolean isBlockade() {
        return this.blockade;
    }

    public void reflectVisibleMenu() {
        this.childList.clear();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RJcID rJcID = (RJcID)iterator.next();
            rJcID.reflectVisibleMenu();
            if (rJcID.isBlockade() || !rJcID.isVisible()) continue;
            this.childList.add(rJcID);
        }
        if (this.menuItem != null) {
            this.menuItem.setVisible(!this.isBlockade() && this.isVisible());
        }
    }

    public void reflectEnabledMenu() {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RJcID rJcID = (RJcID)iterator.next();
            rJcID.reflectEnabledMenu();
        }
        if (this.menuItem != null) {
            this.menuItem.setEnabled(this.isEnabled());
        }
    }

    public void setItemListener(ItemListener itemListener) {
        this.listener = itemListener;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RJcID rJcID = (RJcID)iterator.next();
            rJcID.setItemListener(this);
        }
    }

    public RJcID searchEnabledID() {
        RJcID rJcID = null;
        Iterator iterator = this.childList.iterator();
        while (iterator.hasNext()) {
            RJcID rJcID2 = (RJcID)iterator.next();
            if (rJcID2.isBlockade() || !rJcID2.isEnabled()) continue;
            rJcID = rJcID2.searchEnabledID();
            break;
        }
        return rJcID;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.putLog("[RJID]", "[ItemEvent]", "apear");
        if (this.listener != null) {
            ItemEvent itemEvent2 = new ItemEvent(itemEvent.getItemSelectable(), itemEvent.getID(), this, itemEvent.getStateChange());
            this.listener.itemStateChanged(itemEvent2);
        }
    }

    public void setParentID(RJcID rJcID) {
        this.parentID = rJcID;
    }

    public RJcID getParentID() {
        return this.parentID;
    }

    public void addChildID(RJcID rJcID) {
        this.children.add(rJcID);
        rJcID.setParentID(this);
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public ArrayList getChildList() {
        return this.childList;
    }

    protected String getText(String string, String string2) {
        String string3 = RJcGuide.text(string, string2);
        return string3;
    }

    protected String getText(String string) {
        String string2 = RJcGuide.text(string);
        return string2;
    }

    protected Color getColor(String string, String string2) {
        Color color = RJcGuide.color(string, string2);
        return color;
    }

    protected Color getColor(String string) {
        Color color = RJcGuide.color(string);
        return color;
    }

    protected Icon getMenuIcon(String string) {
        String string2 = this.getText(string, "FuncIcon");
        ImageIcon imageIcon = (ImageIcon)RJCom.createImgIcon(string2);
        MenuIcon menuIcon = null;
        menuIcon = new MenuIcon(imageIcon.getImage());
        return menuIcon;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJcID) {
            bl = this.name.equals(((RJcID)object).getID());
        }
        return bl;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        return n;
    }

    public String toString() {
        return this.name;
    }

    public void putLog(String string, String string2, String string3) {
        RJCom.putLog(string, string2, string3, 0);
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setErrorStatus(boolean bl) {
        this.error = bl;
    }

    public boolean isErrorStatus() {
        return this.error;
    }

    public void reflectErrorStatus(boolean bl) {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RJcID rJcID = (RJcID)iterator.next();
            rJcID.reflectErrorStatus(bl);
        }
        if (this.menuItem != null) {
            this.setErrorStatus(bl);
        }
    }

    protected class MenuIcon
    extends ImageIcon {
        private static final int w = 18;
        private static final int h = 18;

        public MenuIcon(Image image) {
            super(image);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.drawImage(this.getImage(), n, n2, 18, 18, component);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }
}

