/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.email;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcModify;
import sanproject.client.com.RJcTablePanel;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.com.abs.RJaTableDataModel;
import sanproject.client.data.RJDataMsg;
import sanproject.client.email.RJEmailAddressElement;
import sanproject.client.email.RJEmailApplyData;
import sanproject.client.email.RJEmailApplyItem;
import sanproject.client.email.RJEmailComboBox;
import sanproject.client.email.RJEmailDataSupplier;
import sanproject.client.email.RJEmailEnvElement;
import sanproject.client.email.RJEmailGuideDef;
import sanproject.client.email.RJEmailTextField;
import sanproject.client.email.RJEmailToAddrTableModel;

public class RJEmailToAddrTablePanel
extends RJcTablePanel
implements RJEmailGuideDef {
    protected RJEmailDataSupplier supplier;
    private JLabel nowCntField = new JLabel();
    private JLabel maxCntField = new JLabel();
    private RJcButton updButton = null;
    private RJcButton delButton = null;
    private RJEmailTextField addrTextField = null;
    private RJEmailComboBox attrComboBox = null;
    private RJEmailEnvElement mailEnvElement = null;
    private RJEmailToAddrTableModel saveModel = null;

    public RJEmailToAddrTablePanel() {
        this((RJEmailDataSupplier)null);
    }

    public RJEmailToAddrTablePanel(RJEmailDataSupplier rJEmailDataSupplier) {
        this.supplier = rJEmailDataSupplier;
        this.add((Component)this.createSouthPanel(), "South");
    }

    public void init() {
        super.init();
        this.createTable(null);
        this.showToaddrList();
    }

    public void showToaddrList() {
        RJEmailToAddrTableModel rJEmailToAddrTableModel = this.createTableModel();
        this.createTable(rJEmailToAddrTableModel);
        this.completedTable();
        rJEmailToAddrTableModel.sortNumber();
        rJEmailToAddrTableModel.clearSelection();
    }

    private RJEmailToAddrTableModel createTableModel() {
        RJEmailToAddrTableModel rJEmailToAddrTableModel = null;
        rJEmailToAddrTableModel = new RJEmailToAddrTableModel(this.supplier);
        this.createToaddrList(rJEmailToAddrTableModel);
        return rJEmailToAddrTableModel;
    }

    private void createToaddrList(RJEmailToAddrTableModel rJEmailToAddrTableModel) {
        this.supplier.putLog("[EMail]", "[ToAddrTable]", "createToaddrList()");
        RJEmailEnvElement rJEmailEnvElement = this.supplier.getMailEnvElement();
        if (rJEmailEnvElement != null) {
            rJEmailToAddrTableModel.beginSetting();
            RJEmailAddressElement[] rJEmailAddressElementArray = rJEmailEnvElement.getToAddrInfo();
            for (int i = 0; i < rJEmailEnvElement.getToAddrCntMax(); ++i) {
                rJEmailToAddrTableModel.addRow(rJEmailAddressElementArray[i]);
            }
            rJEmailToAddrTableModel.completeSetting();
        }
    }

    public void createTable(RJaTableDataModel rJaTableDataModel) {
        if (rJaTableDataModel == null) {
            rJaTableDataModel = new RJEmailToAddrTableModel(this.supplier);
        }
        super.createTable(rJaTableDataModel);
        this.setSelCountLabel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.model.getSelectedRows();
        switch (nArray.length) {
            case 0: {
                this.addrTextField.setText("", true);
                this.addrTextField.setEnabled(false);
                this.addrTextField.setEditable(false);
                this.attrComboBox.setEnabled(false);
                this.attrComboBox.setSelectedIndex(0);
                this.updButton.setEnabled(false);
                this.delButton.setEnabled(false);
                break;
            }
            case 1: {
                RJaDataModelEntry rJaDataModelEntry = this.model.getRow(nArray[0]);
                RJEmailAddressElement rJEmailAddressElement = (RJEmailAddressElement)rJaDataModelEntry.get("NUMBER");
                this.addrTextField.setText(rJEmailAddressElement.getToAddress(), true);
                this.addrTextField.setEnabled(true & this.supplier.isModify());
                this.addrTextField.setEditable(true & this.supplier.isModify());
                this.attrComboBox.setEnabled(true & this.supplier.isModify());
                if (rJEmailAddressElement.getToAttribute() == 0) {
                    this.attrComboBox.setSelectedIndex(0);
                    this.updButton.setEnabled(false);
                } else {
                    this.attrComboBox.setSelectedIndex(rJEmailAddressElement.getToAttribute() - 1);
                    this.updButton.setEnabled(true & this.supplier.isModify());
                }
                this.delButton.setEnabled(true & this.supplier.isModify());
                break;
            }
            default: {
                this.addrTextField.setText("", true);
                this.addrTextField.setEnabled(false);
                this.addrTextField.setEditable(false);
                this.attrComboBox.setEnabled(false);
                this.attrComboBox.setSelectedIndex(0);
                this.updButton.setEnabled(false);
                this.delButton.setEnabled(true & this.supplier.isModify());
            }
        }
        this.setSelCountLabel();
    }

    private void setSelCountLabel() {
        int n = 0;
        int n2 = 0;
        this.mailEnvElement = this.supplier.getMailEnvElement();
        if (this.mailEnvElement != null) {
            n = this.mailEnvElement.getToAddrCnt();
            n2 = this.mailEnvElement.getToAddrCntMax();
        }
        this.nowCntField.setText(String.valueOf(n));
        this.maxCntField.setText(String.valueOf(n2));
        this.setButtonEnabled();
    }

    public void setButtonEnabled() {
        if (this.updButton != null) {
            this.updButton.setEnabled(this.isUpdActionEnable());
        }
        if (this.delButton != null) {
            this.delButton.setEnabled(this.isDelActionEnable());
        }
    }

    private boolean isUpdActionEnable() {
        boolean bl = false;
        int n = this.model.getSelectedRows().length;
        bl = n == 1 && this.supplier.isModify();
        return bl;
    }

    private boolean isDelActionEnable() {
        boolean bl = false;
        int n = this.model.getSelectedRows().length;
        bl = n >= 1 && this.supplier.isModify();
        return bl;
    }

    private int getSelectedCount() {
        int[] nArray = this.model.getSelectedRows();
        int n = nArray.length;
        return n;
    }

    public boolean updAddress(String string, int n) {
        boolean bl = false;
        if (!string.equals("")) {
            int n2;
            int n3 = this.model.getSelectedRow();
            RJEmailAddressElement rJEmailAddressElement = (RJEmailAddressElement)this.model.getValueAt(n3, "NUMBER");
            bl = true;
            for (n2 = 0; n2 < 32; ++n2) {
                RJEmailAddressElement rJEmailAddressElement2 = (RJEmailAddressElement)this.model.getValueAt(n2, "NUMBER");
                if (n2 == n3 || rJEmailAddressElement2.getToAddress().equals("") || !rJEmailAddressElement2.getToAddress().equals(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                n2 = rJEmailAddressElement.getToNumber() - 1;
                this.mailEnvElement = this.supplier.getMailEnvElement();
                RJEmailAddressElement rJEmailAddressElement3 = this.mailEnvElement.getToAddrInfo()[n2];
                if (rJEmailAddressElement3.getToAddress().equals("")) {
                    this.mailEnvElement.setToAddrCnt(this.mailEnvElement.getToAddrCnt() + 1);
                }
                rJEmailAddressElement3.setToAddress(string);
                rJEmailAddressElement3.setToAttribute(n);
                this.model.setValueAt(n3, "ADDRESS", (Object)rJEmailAddressElement3.getToAddress());
                this.model.setValueAt(n3, "ATTRBUTE", (Object)rJEmailAddressElement3.getToAttrString());
                this.model.setValueAt(n3, "COLOR", (Object)rJEmailAddressElement3.getModify());
                this.model.clearSelection();
                this.refresh();
                RJEmailApplyData rJEmailApplyData = this.supplier.getApplyData();
                this.supplier.setMailEnvElement(this.mailEnvElement);
                if (this.mailEnvElement.isModify()) {
                    RJEmailApplyItem rJEmailApplyItem = new RJEmailApplyItem();
                    rJEmailApplyItem.setEnvElement(this.mailEnvElement);
                    rJEmailApplyData.updEmailInfo(rJEmailApplyItem);
                } else {
                    rJEmailApplyData.clearEnvApplyData();
                }
                bl = true;
            } else {
                Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                int n4 = 861065765;
                RJDataMsg rJDataMsg = this.supplier.getMessage(n4);
                this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            }
        } else {
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            int n5 = 861065763;
            RJDataMsg rJDataMsg = this.supplier.getMessage(n5);
            this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        }
        return bl;
    }

    public void delAddress() {
        Comparable comparable;
        int[] nArray = this.model.getSelectedRows();
        this.mailEnvElement = this.supplier.getMailEnvElement();
        for (int i = 0; i < nArray.length; ++i) {
            comparable = (RJEmailAddressElement)this.model.getValueAt(nArray[i], "NUMBER");
            int n = ((RJEmailAddressElement)comparable).getToNumber() - 1;
            RJEmailAddressElement rJEmailAddressElement = this.mailEnvElement.getToAddrInfo()[n];
            if (!rJEmailAddressElement.getToAddress().equals("")) {
                this.mailEnvElement.setToAddrCnt(this.mailEnvElement.getToAddrCnt() - 1);
            }
            rJEmailAddressElement.setToAddress("");
            rJEmailAddressElement.setToAttribute(1);
            this.model.setValueAt(nArray[i], "ADDRESS", (Object)rJEmailAddressElement.getToAddress());
            this.model.setValueAt(nArray[i], "ATTRBUTE", (Object)rJEmailAddressElement.getToAttrString());
            this.model.setValueAt(nArray[i], "COLOR", (Object)new RJcModify());
        }
        RJEmailApplyData rJEmailApplyData = this.supplier.getApplyData();
        this.supplier.setMailEnvElement(this.mailEnvElement);
        if (this.mailEnvElement.isModify()) {
            comparable = new RJEmailApplyItem();
            ((RJEmailApplyItem)comparable).setEnvElement(this.mailEnvElement);
            rJEmailApplyData.updEmailInfo((RJEmailApplyItem)comparable);
        } else {
            rJEmailApplyData.clearEnvApplyData();
        }
        this.model.clearSelection();
        this.refresh();
    }

    public void setToAddrTextField(RJEmailTextField rJEmailTextField) {
        this.addrTextField = rJEmailTextField;
    }

    public void setToAttrComboBox(RJEmailComboBox rJEmailComboBox) {
        this.attrComboBox = rJEmailComboBox;
    }

    public void setUpdButton(RJcButton rJcButton) {
        this.updButton = rJcButton;
    }

    public void setDelButton(RJcButton rJcButton) {
        this.delButton = rJcButton;
    }

    private JPanel createSouthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(200, 16));
        jPanel.setMinimumSize(new Dimension(200, 16));
        jPanel.setBackground(RJcGuide.color("Email/ToAddrTableMarginBgClr"));
        JLabel jLabel = new JLabel(RJcGuide.text("Email/ToAddrTableNowCntLbl"));
        jLabel.setForeground(RJcGuide.color("Email/ToAddrTableNowCntLbl"));
        jLabel.setHorizontalAlignment(4);
        jLabel.setFont(RJcConst.boldFont);
        this.nowCntField.setForeground(RJcGuide.color("Email/ToAddrTableNowCntField"));
        this.nowCntField.setPreferredSize(new Dimension(32, 14));
        this.nowCntField.setMinimumSize(new Dimension(32, 14));
        this.nowCntField.setFont(RJcConst.boldFont);
        this.nowCntField.setHorizontalAlignment(0);
        JLabel jLabel2 = new JLabel(RJcGuide.text("Email/ToAddrTableMaxCntLbl"));
        jLabel2.setForeground(RJcGuide.color("Email/ToAddrTableMaxCntLbl"));
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setFont(RJcConst.boldFont);
        this.maxCntField.setForeground(RJcGuide.color("Email/ToAddrTableMaxCntField"));
        this.maxCntField.setPreferredSize(new Dimension(32, 14));
        this.maxCntField.setMinimumSize(new Dimension(32, 14));
        this.maxCntField.setFont(RJcConst.boldFont);
        this.maxCntField.setHorizontalAlignment(0);
        JLabel jLabel3 = new JLabel();
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.nowCntField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.maxCntField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 8), 0, 0));
        return jPanel;
    }
}

