/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import sanproject.client.exdevice.data.ModifyTaker;
import sanproject.client.exdevice.data.PresetData;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.ProductManager;
import sanproject.client.exdevice.data.TargetPortInfo;
import sanproject.client.exdevice.data.TargetPortInfo_Fibre;
import sanproject.serverux.dataimpl.EXDSetData;
import sanproject.serverux.dataimpl.EXDTargetPort;
import sanproject.serverux.dataimpl.EXDTargetPort_Fiber;

public class ChangeTargetPortParamData
extends PresetData {
    public static final int OP_CHG_TPRM = 1;
    public static final int QDEPTH_MIN = 2;
    public static final int QDEPTH_MAX = 128;
    public static final int QDEPTH_DEFAULT = 8;
    public static final int IOTOV_MIN = 5;
    public static final int IOTOV_MAX = 240;
    public static final int IOTOV_DEFAULT = 15;
    public static final int PBW_MIN = 5;
    public static final int PBW_MAX = 180;
    public static final int PBW_DEFAULT = 10;
    private int mOperation;
    private TargetPortInfo mTargetPortInfo = null;
    private EXDTargetPort mBackupTargetPort = null;

    ChangeTargetPortParamData(TargetPortInfo_Fibre targetPortInfo_Fibre, int n) {
        this.mTargetPortInfo = targetPortInfo_Fibre;
        this.mOperation = n;
        EXDTargetPort_Fiber eXDTargetPort_Fiber = (EXDTargetPort_Fiber)targetPortInfo_Fibre.getEXDTargetPort();
        EXDTargetPort_Fiber eXDTargetPort_Fiber2 = new EXDTargetPort_Fiber(eXDTargetPort_Fiber);
        this.mBackupTargetPort = eXDTargetPort_Fiber;
        targetPortInfo_Fibre.setEXDTargetPortInfo(eXDTargetPort_Fiber2);
    }

    Object getApplyData() {
        return this.mTargetPortInfo.getEXDTargetPort();
    }

    protected int setApplyResult(Object object) {
        EXDSetData eXDSetData = (EXDSetData)object;
        int n = eXDSetData.getResult();
        if (n == 0) {
            this.setModify(false);
        }
        return n;
    }

    void enterPreset() {
        this.setModify(true);
    }

    void removePreset() {
        boolean bl = ((ModifyTaker)((Object)this.mTargetPortInfo)).isModify();
        if (bl) {
            if (this.mTargetPortInfo instanceof TargetPortInfo_Fibre) {
                TargetPortInfo_Fibre targetPortInfo_Fibre = (TargetPortInfo_Fibre)this.mTargetPortInfo;
                EXDTargetPort_Fiber eXDTargetPort_Fiber = (EXDTargetPort_Fiber)this.mBackupTargetPort;
                targetPortInfo_Fibre.setEXDTargetPortInfo(eXDTargetPort_Fiber);
            }
            this.setModify(false);
        }
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof ChangeTargetPortParamData) {
            n = ((ChangeTargetPortParamData)object).getTargetPortInfo().getId();
        } else if (object instanceof EXDTargetPort) {
            n = ((EXDTargetPort)object).getId();
        } else {
            throw new ClassCastException();
        }
        int n2 = this.mTargetPortInfo.getId();
        return n2 - n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.mTargetPortInfo.getId();
    }

    public String toString() {
        return this.mTargetPortInfo.toString();
    }

    private void setModify(boolean bl) {
        if (this.mTargetPortInfo instanceof ModifyTaker) {
            ((ModifyTaker)((Object)this.mTargetPortInfo)).setModify(bl);
        }
        int n = this.mTargetPortInfo.referSubsystemId();
        ProductInfo productInfo = ProductManager.getInstance().getProductInfo(n);
        productInfo.setModify(bl);
    }

    public TargetPortInfo getTargetPortInfo() {
        return this.mTargetPortInfo;
    }

    public static boolean canChangeParam(TargetPortInfo[] targetPortInfoArray) {
        boolean bl = true;
        for (int i = 0; i < targetPortInfoArray.length; ++i) {
            bl &= ChangeTargetPortParamData.canChangeParam(targetPortInfoArray[i]);
        }
        return bl;
    }

    public static boolean canChangeParam(TargetPortInfo targetPortInfo) {
        boolean bl = true;
        return bl;
    }

    public static void changeParam(TargetPortInfo_Fibre[] targetPortInfo_FibreArray, int n, int n2, int n3) {
        PresetManager presetManager = PresetManager.getInstance();
        for (int i = 0; i < targetPortInfo_FibreArray.length; ++i) {
            if (targetPortInfo_FibreArray[i].getIoTov() == n && targetPortInfo_FibreArray[i].getQDepth() == n2 && targetPortInfo_FibreArray[i].getPathWatch() == n3) continue;
            if (targetPortInfo_FibreArray[i].isModify()) {
                targetPortInfo_FibreArray[i].setPhysicalPathParam(n, n2, n3);
                continue;
            }
            ChangeTargetPortParamData changeTargetPortParamData = new ChangeTargetPortParamData(targetPortInfo_FibreArray[i], 1);
            if (!presetManager.add(changeTargetPortParamData, changeTargetPortParamData.mOperation)) continue;
            targetPortInfo_FibreArray[i].setPhysicalPathParam(n, n2, n3);
        }
    }

    public static boolean chkQDepth(int n) {
        boolean bl = false;
        if (2 <= n && n <= 128) {
            bl = true;
        }
        return bl;
    }

    public static boolean chkIoTov(int n) {
        boolean bl = false;
        if (5 <= n && n <= 240) {
            bl = true;
        }
        return bl;
    }

    public static boolean chkPathWatch(int n) {
        boolean bl = false;
        if (5 <= n && n <= 180) {
            bl = true;
        }
        return bl;
    }
}

