/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.math.BigInteger;
import java.nio.ByteBuffer;

public class VmaInfo {
    static int VMA_SIZE = 64;
    static int FMT_EYECAT = 0;
    static int FMT_FMTREV = 8;
    static int FMT_VMACVINFO = 16;
    static int FMT_VMATYPE = 20;
    static int FMT_VOLORG = 24;
    static int FMT_EXTFLG = 25;
    static int FMT_VOLOLGRTM = 28;
    static int FMT_OLGRTMSETDATE = 32;
    static int FMT_EXTCAPACITY = 40;
    static int VMACV_VMAVALID = Integer.MIN_VALUE;
    public static byte VOLOLG_FLG_RSV = (byte)8;
    public static byte VOLOLG_FLG_INV = (byte)16;
    public static byte VOLOLG_FLG_ZER = (byte)32;
    public static byte VOLOLG_FLG_SVOLDIS = (byte)64;
    public static byte VOLOLG_ATR_RW = (byte)-128;
    public static byte VOLOLG_ATR_RO = (byte)-126;
    public static byte VOLOLG_ATR_PRO = (byte)-127;
    static byte VOLOLG_ATR_MASK = (byte)(VOLOLG_ATR_RW | VOLOLG_ATR_RO | VOLOLG_ATR_PRO);
    public static int RTERM_UNLIMITED = -1;
    public static byte EXT_FLG_DEFINED = (byte)-128;
    static int EXTCAPACITY_SIZE = 8;
    boolean mflgValid = false;
    ByteBuffer mVma = null;

    public VmaInfo() {
    }

    public VmaInfo(byte[] byArray) {
        this();
        this.setVma(byArray);
    }

    public boolean setVma(byte[] byArray) {
        this.mflgValid = VmaInfo.isValid(byArray);
        if (this.mflgValid) {
            this.mVma = ByteBuffer.wrap(byArray);
        }
        return this.mflgValid;
    }

    public boolean isValid() {
        return this.mflgValid;
    }

    public byte[] toByteArray() {
        return this.isValid() ? this.mVma.array() : new byte[VMA_SIZE];
    }

    public byte getGuardStatus() {
        byte by = 0;
        if (this.isValid()) {
            by = this.mVma.get(FMT_VOLORG);
        }
        return (byte)(by & VOLOLG_ATR_MASK);
    }

    public byte getOriginalGuardStatus() {
        byte by = 0;
        if (this.isValid()) {
            by = this.mVma.get(FMT_VOLORG);
        }
        return by;
    }

    public boolean chkVolFlag(byte by) {
        byte by2 = 0;
        if (this.isValid()) {
            by2 = this.mVma.get(FMT_VOLORG);
        }
        return (by2 & by) == by;
    }

    public int getRetentionTerm() {
        int n = 0;
        if (this.isValid()) {
            n = this.mVma.getInt(FMT_VOLOLGRTM);
        }
        return n;
    }

    public boolean chkExtentFlag(byte by) {
        boolean bl = false;
        if (this.isValid()) {
            byte by2 = this.mVma.get(FMT_EXTFLG);
            bl = (by2 & by) == by;
        }
        return bl;
    }

    public BigInteger getExtentCapacity() {
        BigInteger bigInteger = BigInteger.ZERO;
        if (this.chkExtentFlag(EXT_FLG_DEFINED)) {
            byte[] byArray = new byte[EXTCAPACITY_SIZE];
            this.mVma.position(FMT_EXTCAPACITY);
            this.mVma.get(byArray);
            bigInteger = new BigInteger(1, byArray);
        }
        return bigInteger;
    }

    public static boolean isValid(byte[] byArray) {
        boolean bl = VmaInfo.chkSize(byArray);
        if (bl) {
            int n = ByteBuffer.wrap(byArray).getInt(FMT_VMACVINFO);
            bl = (n & VMACV_VMAVALID) != 0;
        }
        return bl;
    }

    public static boolean chkSize(byte[] byArray) {
        return byArray != null && byArray.length >= VMA_SIZE;
    }
}

