/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sanproject.client.applet.RJStartupController;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComSpringUtilities;
import sanproject.client.com.RJcCushionPanel;
import sanproject.client.com.RJcDlgMainTitlePanel;
import sanproject.client.com.RJcLabelPanel;
import sanproject.client.com.RJcListPanel;
import sanproject.client.com.RJcMainTitlePanel;
import sanproject.client.com.abs.RJaTableDataModel;
import sanproject.client.exdevice.com.AbstractTableDataModel;
import sanproject.client.exdevice.com.Button;
import sanproject.client.exdevice.com.CheckBox;
import sanproject.client.exdevice.com.DefaultTablePanel;
import sanproject.client.exdevice.com.DialogContentsPanel;
import sanproject.client.exdevice.com.RadioButton;
import sanproject.client.exdevice.data.EmulationTypeInfo;
import sanproject.client.exdevice.data.EmulationTypeManager;
import sanproject.client.exdevice.data.LprManager;
import sanproject.client.exdevice.data.PolicyManager;
import sanproject.client.exdevice.luoperation.AddLUPolicyElement;
import sanproject.client.exdevice.luoperation.AddLUPolicyFileFilter;
import sanproject.client.exdevice.luoperation.AddLUPolicyProviderElement;
import sanproject.client.exdevice.luoperation.LocalGuidance;
import sanproject.client.exdevice.utility.Debug;

public class AddLUPolicyEditorPanel
extends DialogContentsPanel {
    private static final String KEY_NAME = "PolicyEditor";
    private boolean policyEditable;
    private AddLUPolicyProviderElement provider;
    private DefaultTablePanel policyListTable;
    private JComboBox clprCombo;
    private JLabel slprLabel;
    private RadioButton enableCacheMode;
    private RadioButton disableCacheMode;
    private RadioButton enableInflowControl;
    private RadioButton disableInflowControl;
    private JComboBox emulationCombo;
    private ItemListener emulationComboChangeListener;
    private CheckBox emulationCheckBox;
    private ItemListener emulationCheckChangeListener;
    private JComboBox ldevCountCombo;
    private RadioButton enableAutoDiscovery;
    private RadioButton disableAutoDiscovery;
    private Button importButton;
    private Button exportButton;
    private Button applyButton;
    private Button cancelButton;
    private boolean policyChanging;

    public AddLUPolicyEditorPanel(AddLUPolicyProviderElement addLUPolicyProviderElement) {
        this(addLUPolicyProviderElement, false);
    }

    public AddLUPolicyEditorPanel(AddLUPolicyProviderElement addLUPolicyProviderElement, boolean bl) {
        this.provider = addLUPolicyProviderElement;
        this.policyListTable = null;
        this.clprCombo = null;
        this.slprLabel = null;
        this.enableCacheMode = null;
        this.disableCacheMode = null;
        this.enableInflowControl = null;
        this.disableInflowControl = null;
        this.emulationCombo = null;
        this.ldevCountCombo = null;
        this.enableAutoDiscovery = null;
        this.disableAutoDiscovery = null;
        this.importButton = null;
        this.exportButton = null;
        this.applyButton = null;
        this.cancelButton = null;
        this.policyChanging = false;
        this.putLog(KEY_NAME, "create [PolicyEditor].");
        this.initializePanel();
        this.buildPanelLayout();
        AddLUPolicyElement addLUPolicyElement = this.getCurrentPolicy();
        if (addLUPolicyElement != null) {
            this.setPolicyEditable(bl);
            this.updateDetail(addLUPolicyElement);
        } else {
            this.updateDetail(null);
            this.setPolicyEditable(bl);
        }
        this.updateButtonsStatus();
        if (!AddLUPolicyEditorPanel.isSupportPolicyIO()) {
            this.importButton.setVisible(false);
            this.exportButton.setVisible(false);
        }
    }

    public void addNotify() {
        Object object;
        super.addNotify();
        final Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            object = new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] opened.");
                }

                public void windowClosed(WindowEvent windowEvent) {
                    if (AddLUPolicyEditorPanel.this.provider != null) {
                        AddLUPolicyEditorPanel.this.provider.removeChildElements();
                    }
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] closed.");
                    window.removeWindowListener(this);
                }
            };
            window.addWindowListener((WindowListener)object);
        }
        if ((object = this.getWindowRootPane()) != null) {
            ((JRootPane)object).setDefaultButton(this.applyButton);
        }
    }

    public String getWindowName() {
        String string = "ExDevice_LU";
        return string;
    }

    public synchronized void setPolicyEditable(boolean bl) {
        this.policyEditable = bl;
        this.putLog(KEY_NAME, "[PolicyEditor] PolicyEditable = " + bl + ".");
    }

    public synchronized boolean isPolicyEditable() {
        boolean bl = this.policyEditable;
        return bl;
    }

    private void initializePanel() {
        Object object = new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] Policy Change.");
                    try {
                        AddLUPolicyEditorPanel.this.setWaitCursor();
                        AddLUPolicyEditorPanel.this.policyChanging = true;
                        AddLUPolicyElement addLUPolicyElement = AddLUPolicyEditorPanel.this.getCurrentPolicy();
                        AddLUPolicyEditorPanel.this.updateDetail(addLUPolicyElement);
                        AddLUPolicyEditorPanel.this.updateButtonsStatus();
                        AddLUPolicyEditorPanel.this.policyChanging = false;
                    }
                    finally {
                        AddLUPolicyEditorPanel.this.setDefaultCursor();
                    }
                }
            }
        };
        Object object2 = this.provider.getTableModel();
        this.policyListTable = new DefaultTablePanel();
        this.policyListTable.createTable((RJaTableDataModel)object2);
        this.policyListTable.completedTable();
        JComponent jComponent = this.policyListTable.getTable();
        ((JTable)jComponent).setSelectionMode(0);
        int n = ((JTable)jComponent).getRowCount();
        if (n > 0) {
            ((JTable)jComponent).setRowSelectionInterval(0, 0);
        }
        ((JTable)jComponent).setShowGrid(false);
        ((JTable)jComponent).setShowHorizontalLines(false);
        ((JTable)jComponent).setShowVerticalLines(false);
        ((JTable)jComponent).setTableHeader(null);
        ListSelectionModel listSelectionModel = ((JTable)jComponent).getSelectionModel();
        listSelectionModel.addListSelectionListener((ListSelectionListener)object);
        Dimension dimension = jComponent.getPreferredSize();
        JScrollPane jScrollPane = this.policyListTable.getScrollPane();
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setVerticalScrollBarPolicy(22);
        Color color = jComponent.getBackground();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setOpaque(true);
        jViewport.setBackground(color);
        object = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n;
                if (AddLUPolicyEditorPanel.this.isNotPolicyChanging() && (n = itemEvent.getStateChange()) == 1) {
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] CLPR/SLPR Change.");
                    AddLUPolicyEditorPanel.this.onChangeCLPR();
                }
            }
        };
        object2 = new DefaultComboBoxModel();
        jComponent = new DefaultListCellRenderer();
        ((JLabel)jComponent).setHorizontalAlignment(4);
        this.clprCombo = new JComboBox(object2);
        this.clprCombo.addItemListener((ItemListener)object);
        this.clprCombo.setRenderer(jComponent);
        this.slprLabel = new JLabel();
        this.slprLabel.setFont(RJComFont.labelFont);
        object = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n;
                if (AddLUPolicyEditorPanel.this.isNotPolicyChanging() && (n = itemEvent.getStateChange()) == 1) {
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] Cache Mode Change.");
                    boolean bl = AddLUPolicyEditorPanel.this.enableCacheMode.isSelected();
                    AddLUPolicyElement addLUPolicyElement = AddLUPolicyEditorPanel.this.getCurrentPolicy();
                    if (addLUPolicyElement != null) {
                        addLUPolicyElement.setCacheMode(bl);
                    }
                }
            }
        };
        object2 = LocalGuidance.BUTTON_ENABLE.getText();
        this.enableCacheMode = new RadioButton((String)object2);
        this.enableCacheMode.addItemListener((ItemListener)object);
        this.enableCacheMode.setFont(RJComFont.labelFont);
        this.enableCacheMode.setOpaque(false);
        object2 = LocalGuidance.BUTTON_DISABLE.getText();
        this.disableCacheMode = new RadioButton((String)object2);
        this.disableCacheMode.addItemListener((ItemListener)object);
        this.disableCacheMode.setFont(RJComFont.labelFont);
        this.disableCacheMode.setOpaque(false);
        object2 = new ButtonGroup();
        ((ButtonGroup)object2).add(this.enableCacheMode);
        ((ButtonGroup)object2).add(this.disableCacheMode);
        object = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n;
                if (AddLUPolicyEditorPanel.this.isNotPolicyChanging() && (n = itemEvent.getStateChange()) == 1) {
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] Inflow Control Change.");
                    boolean bl = AddLUPolicyEditorPanel.this.enableInflowControl.isSelected();
                    AddLUPolicyElement addLUPolicyElement = AddLUPolicyEditorPanel.this.getCurrentPolicy();
                    if (addLUPolicyElement != null) {
                        addLUPolicyElement.setInflowControl(bl);
                    }
                }
            }
        };
        object2 = LocalGuidance.BUTTON_ENABLE.getText();
        this.enableInflowControl = new RadioButton((String)object2);
        this.enableInflowControl.addItemListener((ItemListener)object);
        this.enableInflowControl.setFont(RJComFont.labelFont);
        this.enableInflowControl.setOpaque(false);
        object2 = LocalGuidance.BUTTON_DISABLE.getText();
        this.disableInflowControl = new RadioButton((String)object2);
        this.disableInflowControl.addItemListener((ItemListener)object);
        this.disableInflowControl.setFont(RJComFont.labelFont);
        this.disableInflowControl.setOpaque(false);
        object2 = new ButtonGroup();
        ((ButtonGroup)object2).add(this.enableInflowControl);
        ((ButtonGroup)object2).add(this.disableInflowControl);
        this.emulationCheckChangeListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (AddLUPolicyEditorPanel.this.isNotPolicyChanging()) {
                    boolean bl = AddLUPolicyEditorPanel.this.emulationCheckBox.isSelected();
                    AddLUPolicyElement addLUPolicyElement = AddLUPolicyEditorPanel.this.getCurrentPolicy();
                    if (addLUPolicyElement != null) {
                        addLUPolicyElement.setExceptOPENV(bl);
                    }
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] onChange ExceptOPEN-V.->" + bl + "");
                    AddLUPolicyEditorPanel.this.onChangeEmulationCheck(bl);
                    AddLUPolicyEditorPanel.this.onChangeEmulation();
                }
            }
        };
        object = LocalGuidance.TEXT_EXCEPT_OPENV.getText();
        this.emulationCheckBox = new CheckBox((String)object);
        this.emulationCheckBox.addItemListener(this.emulationCheckChangeListener);
        this.emulationCheckBox.setOpaque(false);
        this.emulationCheckBox.setFont(RJComFont.buttonFont);
        this.emulationCheckBox.setSelected(false);
        this.emulationComboChangeListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n;
                if (AddLUPolicyEditorPanel.this.isNotPolicyChanging() && (n = itemEvent.getStateChange()) == 1) {
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] Emulation Type Change.");
                    AddLUPolicyEditorPanel.this.onChangeEmulation();
                }
            }
        };
        this.emulationCombo = new JComboBox();
        this.emulationCombo.addItemListener(this.emulationComboChangeListener);
        object = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n;
                if (AddLUPolicyEditorPanel.this.isNotPolicyChanging() && (n = itemEvent.getStateChange()) == 1) {
                    int n2;
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] LDEV Count Change.");
                    Object object = AddLUPolicyEditorPanel.this.ldevCountCombo.getSelectedItem();
                    try {
                        String string = object.toString();
                        n2 = Integer.parseInt(string);
                    }
                    catch (Throwable throwable) {
                        n2 = -1;
                    }
                    object = AddLUPolicyEditorPanel.this.getCurrentPolicy();
                    if (object != null) {
                        ((AddLUPolicyElement)object).setLDEVCount(n2);
                    }
                }
            }
        };
        object2 = new DefaultComboBoxModel<Integer>();
        for (int i = 0; i <= 2048; ++i) {
            Integer n2 = new Integer(i);
            ((DefaultComboBoxModel)object2).addElement(n2);
        }
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
        defaultListCellRenderer.setHorizontalAlignment(4);
        this.ldevCountCombo = new JComboBox(object2);
        this.ldevCountCombo.addItemListener((ItemListener)object);
        this.ldevCountCombo.setRenderer(defaultListCellRenderer);
        object = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n;
                if (AddLUPolicyEditorPanel.this.isNotPolicyChanging() && (n = itemEvent.getStateChange()) == 1) {
                    AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] Auto Discovery Change.");
                    boolean bl = AddLUPolicyEditorPanel.this.enableAutoDiscovery.isSelected();
                    AddLUPolicyElement addLUPolicyElement = AddLUPolicyEditorPanel.this.getCurrentPolicy();
                    if (addLUPolicyElement != null) {
                        addLUPolicyElement.setAutoDiscovery(bl);
                    }
                }
            }
        };
        object2 = LocalGuidance.BUTTON_ENABLE.getText();
        this.enableAutoDiscovery = new RadioButton((String)object2);
        this.enableAutoDiscovery.addItemListener((ItemListener)object);
        this.enableAutoDiscovery.setFont(RJComFont.labelFont);
        this.enableAutoDiscovery.setOpaque(false);
        object2 = LocalGuidance.BUTTON_DISABLE.getText();
        this.disableAutoDiscovery = new RadioButton((String)object2);
        this.disableAutoDiscovery.addItemListener((ItemListener)object);
        this.disableAutoDiscovery.setFont(RJComFont.labelFont);
        this.disableAutoDiscovery.setOpaque(false);
        object2 = new ButtonGroup();
        ((ButtonGroup)object2).add(this.enableAutoDiscovery);
        ((ButtonGroup)object2).add(this.disableAutoDiscovery);
        object = LocalGuidance.BUTTON_IMPORT.getItemID();
        object2 = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] onClick Import.");
                AddLUPolicyEditorPanel.this.onClickImport();
            }
        };
        this.importButton = new Button((String)object);
        this.importButton.setAction((Action)object2);
        object = LocalGuidance.BUTTON_EXPORT.getItemID();
        object2 = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] onClick Export.");
                AddLUPolicyEditorPanel.this.onClickExport();
            }
        };
        this.exportButton = new Button((String)object);
        this.exportButton.setAction((Action)object2);
        object = LocalGuidance.BUTTON_CLOSE.getItemID();
        object2 = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] onClick Close.");
                AddLUPolicyEditorPanel.this.onClickApply();
            }
        };
        this.applyButton = new Button((String)object);
        this.applyButton.setAction((Action)object2);
        object = LocalGuidance.BUTTON_CANCEL.getItemID();
        object2 = new AbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                AddLUPolicyEditorPanel.this.putLog(AddLUPolicyEditorPanel.KEY_NAME, "[PolicyEditor] onClick Cancel.");
                AddLUPolicyEditorPanel.this.onClickCancel();
            }
        };
        this.cancelButton = new Button((String)object);
        this.cancelButton.setAction((Action)object2);
        this.updateCLPRList();
    }

    private void buildPanelLayout() {
        Object object = LocalGuidance.TITLE_ADDLUPOLICY.getItemID();
        JComponent jComponent = new RJcDlgMainTitlePanel();
        ((RJcMainTitlePanel)jComponent).setMainTitle((String)object);
        RJcDlgMainTitlePanel rJcDlgMainTitlePanel = jComponent;
        Object object2 = LocalGuidance.TEXT_PATTERN.getText();
        Serializable serializable = new RJcLabelPanel((String)object2);
        object2 = new RJcCushionPanel((JComponent)this.policyListTable, 1);
        Object object3 = new BorderLayout(4, 4);
        Serializable serializable2 = new JPanel();
        ((Container)serializable2).setLayout((LayoutManager)object3);
        ((JComponent)serializable2).setOpaque(false);
        ((Container)serializable2).add((Component)serializable, "North");
        ((Container)serializable2).add((Component)object2, "Center");
        object3 = LocalGuidance.TEXT_POLICY.getText();
        object2 = new RJcLabelPanel((String)object3);
        Object object4 = new RJcListPanel();
        Object object5 = LocalGuidance.TEXT_EMULATIONTYPE.getText();
        Serializable serializable3 = Box.createVerticalStrut(1);
        Serializable serializable4 = Box.createHorizontalStrut(128);
        SpringLayout springLayout = new SpringLayout();
        Serializable serializable5 = new JPanel();
        ((Container)serializable5).setLayout(springLayout);
        ((JComponent)serializable5).setOpaque(false);
        ((Container)serializable5).add((Component)serializable3);
        ((Container)serializable5).add(this.emulationCombo);
        ((Container)serializable5).add((Component)serializable4);
        RJComSpringUtilities.makeCompactGrid((Container)serializable5, 3, 1, 0, 0, 0, 0);
        serializable3 = Box.createHorizontalStrut(128);
        serializable4 = new BorderLayout(4, 4);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable4));
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable5, "West");
        jPanel.add((Component)this.emulationCheckBox, "Center");
        jPanel.add((Component)serializable3, "East");
        ((RJcListPanel)object4).addEntry((String)object5, jPanel);
        object5 = LocalGuidance.TEXT_CLPR.getText();
        serializable3 = Box.createVerticalStrut(1);
        serializable4 = Box.createHorizontalStrut(48);
        springLayout = new SpringLayout();
        serializable5 = new JPanel();
        ((Container)serializable5).setLayout(springLayout);
        ((JComponent)serializable5).setOpaque(false);
        ((Container)serializable5).add((Component)serializable3);
        ((Container)serializable5).add(this.clprCombo);
        ((Container)serializable5).add((Component)serializable4);
        RJComSpringUtilities.makeCompactGrid((Container)serializable5, 3, 1, 0, 0, 0, 0);
        serializable3 = new BorderLayout(4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable3));
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable5, "West");
        ((RJcListPanel)object4).addEntry((String)object5, jPanel);
        object5 = LocalGuidance.TEXT_SLPR.getText();
        serializable5 = new BorderLayout(4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable5));
        jPanel.setOpaque(false);
        jPanel.add((Component)this.slprLabel, "West");
        ((RJcListPanel)object4).addEntry((String)object5, jPanel);
        object5 = LocalGuidance.TEXT_USECACHE.getText();
        serializable3 = new GridLayout(1, 0, 4, 4);
        serializable5 = new JPanel();
        ((Container)serializable5).setLayout((LayoutManager)((Object)serializable3));
        ((JComponent)serializable5).setOpaque(false);
        ((Container)serializable5).add(this.enableCacheMode);
        ((Container)serializable5).add(this.disableCacheMode);
        serializable3 = new BorderLayout(4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable3));
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable5, "West");
        ((RJcListPanel)object4).addEntry((String)object5, jPanel);
        object5 = LocalGuidance.TEXT_INFLOWCONTROL.getText();
        serializable3 = new GridLayout(1, 0, 4, 4);
        serializable5 = new JPanel();
        ((Container)serializable5).setLayout((LayoutManager)((Object)serializable3));
        ((JComponent)serializable5).setOpaque(false);
        ((Container)serializable5).add(this.enableInflowControl);
        ((Container)serializable5).add(this.disableInflowControl);
        serializable3 = new BorderLayout(4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable3));
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable5, "West");
        ((RJcListPanel)object4).addEntry((String)object5, jPanel);
        object5 = LocalGuidance.TEXT_LDEVVPG.getText();
        serializable3 = Box.createVerticalStrut(1);
        serializable4 = Box.createHorizontalStrut(60);
        springLayout = new SpringLayout();
        serializable5 = new JPanel();
        ((Container)serializable5).setLayout(springLayout);
        ((JComponent)serializable5).setOpaque(false);
        ((Container)serializable5).add((Component)serializable3);
        ((Container)serializable5).add(this.ldevCountCombo);
        ((Container)serializable5).add((Component)serializable4);
        RJComSpringUtilities.makeCompactGrid((Container)serializable5, 3, 1, 0, 0, 0, 0);
        serializable3 = new BorderLayout(4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable3));
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable5, "West");
        ((RJcListPanel)object4).addEntry((String)object5, jPanel);
        object5 = LocalGuidance.TEXT_AUTODISCOVERYPORT.getText();
        serializable3 = new GridLayout(1, 0, 4, 4);
        serializable5 = new JPanel();
        ((Container)serializable5).setLayout((LayoutManager)((Object)serializable3));
        ((JComponent)serializable5).setOpaque(false);
        ((Container)serializable5).add(this.enableAutoDiscovery);
        ((Container)serializable5).add(this.disableAutoDiscovery);
        serializable3 = new BorderLayout(4, 4);
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable3));
        jPanel.setOpaque(false);
        jPanel.add((Component)serializable5, "West");
        ((RJcListPanel)object4).addEntry((String)object5, jPanel);
        object5 = new BorderLayout();
        object3 = new JPanel();
        ((Container)object3).setLayout((LayoutManager)object5);
        ((JComponent)object3).setOpaque(false);
        ((Container)object3).add((Component)object4, "North");
        object4 = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        object5 = new BorderLayout(4, 4);
        serializable = new JPanel();
        serializable.setLayout((LayoutManager)object5);
        serializable.setOpaque(false);
        serializable.setBorder((Border)object4);
        serializable.add((Component)object2, "North");
        serializable.add((Component)object3, "Center");
        object2 = BorderFactory.createEmptyBorder();
        jComponent = new JSplitPane();
        jComponent.setBorder((Border)object2);
        ((JSplitPane)jComponent).setContinuousLayout(false);
        ((JSplitPane)jComponent).setDividerSize(1);
        jComponent.setOpaque(false);
        jComponent.add((Component)serializable2, "left");
        jComponent.add((Component)serializable, "right");
        serializable2 = new BorderLayout(4, 4);
        object = new JPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)jComponent, "Center");
        serializable = new GridLayout(1, 0, 4, 4);
        serializable2 = new JPanel();
        ((Container)serializable2).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)serializable2).setOpaque(false);
        ((Container)serializable2).add(this.importButton);
        ((Container)serializable2).add(this.exportButton);
        ((Container)serializable2).add(this.applyButton);
        serializable = new BorderLayout(4, 4);
        object2 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jComponent = new JPanel();
        jComponent.setLayout((LayoutManager)((Object)serializable));
        jComponent.setOpaque(false);
        jComponent.setBorder((Border)object2);
        jComponent.add((Component)serializable2, "East");
        serializable2 = new BorderLayout(4, 4);
        this.setLayout((LayoutManager)((Object)serializable2));
        this.add((Component)rJcDlgMainTitlePanel, "North");
        this.add((Component)object, "Center");
        this.add((Component)jComponent, "South");
    }

    private AddLUPolicyElement getCurrentPolicy() {
        AddLUPolicyElement addLUPolicyElement = null;
        if (this.policyListTable != null) {
            AbstractTableDataModel abstractTableDataModel = (AbstractTableDataModel)this.policyListTable.getDataModel();
            int n = abstractTableDataModel.getSelectedRow();
            addLUPolicyElement = (AddLUPolicyElement)abstractTableDataModel.getElementAt(n);
        }
        return addLUPolicyElement;
    }

    private boolean isNotPolicyChanging() {
        boolean bl = !this.policyChanging;
        return bl;
    }

    private void updateCLPRList() {
        DefaultComboBoxModel<Object> defaultComboBoxModel;
        Object object = this.clprCombo.getSelectedItem();
        EmulationTypeInfo emulationTypeInfo = (EmulationTypeInfo)this.emulationCombo.getSelectedItem();
        LprManager lprManager = LprManager.getInstance();
        Collection collection = lprManager.getClprList(emulationTypeInfo);
        if (collection != null) {
            Integer[] integerArray = new Integer[]{};
            integerArray = collection.toArray(integerArray);
            defaultComboBoxModel = new DefaultComboBoxModel<Integer>(integerArray);
        } else {
            defaultComboBoxModel = new DefaultComboBoxModel();
        }
        this.clprCombo.setModel(defaultComboBoxModel);
        this.clprCombo.setSelectedItem(object);
        if (this.clprCombo.getSelectedItem() != null) {
            this.onChangeCLPR();
        }
    }

    private void updateDetail(AddLUPolicyElement addLUPolicyElement) {
        boolean bl;
        boolean bl2 = addLUPolicyElement != null;
        boolean bl3 = bl = this.policyEditable && bl2;
        if (bl2) {
            int n = addLUPolicyElement.getCLPRNumber();
            Integer n2 = new Integer(n);
            int n3 = addLUPolicyElement.getSLPRNumber();
            String string = String.valueOf(n3);
            this.clprCombo.setSelectedItem(n2);
            this.slprLabel.setText(string);
        } else {
            this.clprCombo.setSelectedItem(null);
            this.slprLabel.setText(null);
        }
        this.clprCombo.setEnabled(bl);
        this.slprLabel.setEnabled(bl);
        if (bl2) {
            boolean bl4 = addLUPolicyElement.isEnableCacheMode();
            this.enableCacheMode.setSelected(bl4);
            this.disableCacheMode.setSelected(!bl4);
        } else {
            this.enableCacheMode.setSelected(false);
            this.disableCacheMode.setSelected(false);
        }
        this.enableCacheMode.setEnabled(bl);
        this.disableCacheMode.setEnabled(bl);
        if (bl2) {
            boolean bl5 = addLUPolicyElement.isEnableInflowControl();
            this.enableInflowControl.setSelected(bl5);
            this.disableInflowControl.setSelected(!bl5);
        } else {
            this.enableInflowControl.setSelected(false);
            this.disableInflowControl.setSelected(false);
        }
        this.enableInflowControl.setEnabled(bl);
        this.disableInflowControl.setEnabled(bl);
        if (bl2) {
            this.emulationCheckBox.setSelected(addLUPolicyElement.isEnableExceptOpenV());
        } else {
            this.emulationCheckBox.setSelected(false);
        }
        this.onChangeEmulationCheck(this.emulationCheckBox.isSelected());
        this.emulationCheckBox.setEnabled(bl);
        if (bl2) {
            EmulationTypeInfo emulationTypeInfo = addLUPolicyElement.getEmulationType();
            this.emulationCombo.setSelectedItem(emulationTypeInfo);
        } else {
            this.emulationCombo.setSelectedItem(null);
        }
        this.emulationCombo.setEnabled(bl);
        if (bl2) {
            int n = addLUPolicyElement.getLDEVCount();
            Integer n4 = new Integer(n);
            this.ldevCountCombo.setSelectedItem(n4);
        } else {
            this.ldevCountCombo.setSelectedItem(null);
        }
        this.ldevCountCombo.setEnabled(bl);
        if (bl2) {
            boolean bl6 = addLUPolicyElement.isEnableAutoDiscovery();
            this.enableAutoDiscovery.setSelected(bl6);
            this.disableAutoDiscovery.setSelected(!bl6);
        } else {
            this.enableAutoDiscovery.setSelected(false);
            this.disableAutoDiscovery.setSelected(false);
        }
        this.enableAutoDiscovery.setEnabled(bl);
        this.disableAutoDiscovery.setEnabled(bl);
        this.updateCLPRList();
    }

    private void updateButtonsStatus() {
        boolean bl = AddLUPolicyEditorPanel.isEditable(13, 1);
        AddLUPolicyElement addLUPolicyElement = this.getCurrentPolicy();
        boolean bl2 = addLUPolicyElement != null;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        this.importButton.setEnabled(bl3);
        this.exportButton.setEnabled(bl4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClickImport() {
        block18: {
            Debug.println(this.getClass().getName() + ".onClickImport()");
            try {
                Object object;
                File file;
                Object object2;
                this.setWaitCursor();
                boolean bl = true;
                if (!bl) break block18;
                String string = "External.last_loaded_file";
                Object object3 = RJStartupController.getProperty(string);
                if (object3 != null) {
                    object2 = new File((String)object3);
                    file = ((File)object2).getParentFile();
                } else {
                    object2 = System.getProperty("user.home") + File.separator + ".webconsole";
                    file = new File((String)object2);
                }
                object3 = AddLUPolicyEditorPanel.createPolicyFileChooser();
                ((JFileChooser)object3).setDialogType(0);
                ((JFileChooser)object3).setCurrentDirectory(file);
                int n = ((JFileChooser)object3).showOpenDialog(this);
                if (n != 0) break block18;
                File file2 = ((JFileChooser)object3).getSelectedFile();
                AddLUPolicyElement addLUPolicyElement = null;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file2);
                    object = new Properties();
                    ((Properties)object).load(fileInputStream);
                    addLUPolicyElement = AddLUPolicyElement.readProperties((Properties)object);
                    String string2 = file2.getPath();
                    RJStartupController.setProperty(string, string2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                        }
                    }
                }
                if (addLUPolicyElement != null) {
                    this.provider.addPolicy(addLUPolicyElement);
                    object = this.provider.getTableModel();
                    this.policyListTable.setModel((RJaTableDataModel)object);
                }
            }
            finally {
                this.setDefaultCursor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClickExport() {
        block18: {
            Debug.println(this.getClass().getName() + ".onClickExport()");
            try {
                File file;
                Object object;
                this.setWaitCursor();
                AddLUPolicyElement addLUPolicyElement = this.getCurrentPolicy();
                if (addLUPolicyElement == null) break block18;
                String string = "External.last_saved_file";
                Object object2 = RJStartupController.getProperty(string);
                if (object2 != null) {
                    object = new File((String)object2);
                    file = ((File)object).getParentFile();
                } else {
                    object = System.getProperty("user.home") + File.separator + ".webconsole";
                    file = new File((String)object);
                }
                object = addLUPolicyElement.getName();
                String string2 = (String)object + "." + "avp";
                object2 = new File(file, string2);
                object = AddLUPolicyEditorPanel.createPolicyFileChooser();
                ((JFileChooser)object).setDialogType(0);
                ((JFileChooser)object).setCurrentDirectory(file);
                ((JFileChooser)object).setSelectedFile((File)object2);
                int n = ((JFileChooser)object).showSaveDialog(this);
                if (n != 0) break block18;
                File file2 = ((JFileChooser)object).getSelectedFile();
                String string3 = file2.getPath();
                if (!string3.endsWith(".avp")) {
                    string3 = string3 + ".avp";
                }
                Properties properties = addLUPolicyElement.toProperties();
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(string3);
                    String string4 = LocalGuidance.TITLE_ADDLUPOLICY.getText();
                    properties.store(fileOutputStream, string4);
                    RJStartupController.setProperty(string, string3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.flush();
                            fileOutputStream.close();
                            fileOutputStream = null;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                        }
                    }
                }
            }
            finally {
                this.setDefaultCursor();
            }
        }
    }

    private void onClickApply() {
        Debug.println(this.getClass().getName() + ".onClickApply()");
        PolicyManager policyManager = PolicyManager.getInstance();
        policyManager.updateResume();
        this.closeContentDialog();
    }

    private void onClickCancel() {
        Debug.println(this.getClass().getName() + ".onClickCancel()");
        this.closeContentDialog();
    }

    private void onChangeEmulationCheck(boolean bl) {
        Object object = EmulationTypeManager.getInstance();
        Object object2 = ((EmulationTypeManager)object).getSelectionList(bl);
        Object[] objectArray = new EmulationTypeInfo[]{};
        objectArray = object2.toArray(objectArray);
        Arrays.sort(objectArray);
        object = this.emulationCombo.getSelectedItem();
        this.emulationCombo.removeAllItems();
        this.emulationCombo.removeItemListener(this.emulationComboChangeListener);
        object2 = this.getCurrentPolicy();
        EmulationTypeInfo emulationTypeInfo = object2 != null ? ((AddLUPolicyElement)object2).getEmulationType() : null;
        boolean bl2 = false;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object3 = objectArray[i];
            this.emulationCombo.addItem(object3);
            if (!objectArray[i].equals(emulationTypeInfo)) continue;
            bl2 = true;
        }
        if (bl2) {
            object = emulationTypeInfo;
        }
        this.emulationCombo.setSelectedItem(object);
        this.emulationCombo.addItemListener(this.emulationComboChangeListener);
    }

    private void onChangeEmulation() {
        Object object = this.emulationCombo.getSelectedItem();
        String string = object != null ? object.toString() : null;
        object = this.getCurrentPolicy();
        if (object != null) {
            EmulationTypeManager emulationTypeManager = EmulationTypeManager.getInstance();
            ((AddLUPolicyElement)object).setEmulationType(emulationTypeManager.getEmulationTypeInfo(string));
            this.updateCLPRList();
        }
    }

    private void onChangeCLPR() {
        int n;
        String string;
        Object object = this.clprCombo.getSelectedItem();
        try {
            string = object.toString();
            n = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            n = 0;
        }
        object = this.getCurrentPolicy();
        if (object != null) {
            ((AddLUPolicyElement)object).setCLPRNumber(n);
            string = String.valueOf(((AddLUPolicyElement)object).getSLPRNumber());
            this.slprLabel.setText(string);
        }
    }

    public static boolean isSupportPolicyIO() {
        String string = "External.policyIO";
        Properties properties = System.getProperties();
        String string2 = properties.containsKey(string) ? properties.getProperty(string) : RJStartupController.getProperty(string);
        Boolean bl = Boolean.valueOf(string2);
        boolean bl2 = bl;
        return bl2;
    }

    public static boolean isSupportPolicyOperation() {
        String string = "External.policyOperation";
        Properties properties = System.getProperties();
        String string2 = properties.containsKey(string) ? properties.getProperty(string) : RJStartupController.getProperty(string);
        Boolean bl = Boolean.valueOf(string2);
        boolean bl2 = bl;
        return bl2;
    }

    private static JFileChooser createPolicyFileChooser() {
        AddLUPolicyFileFilter addLUPolicyFileFilter = new AddLUPolicyFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(addLUPolicyFileFilter);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        return jFileChooser;
    }
}

